/*
 * File:   avrnacl-20130514/highspeed/include/fe25519.h
 * Author: Michael Hutter, Peter Schwabe
 * Public Domain
 */

#ifndef FE25519_H
#define FE25519_H

typedef struct
{
  unsigned char v[32];
}
fe25519;

void fe25519_freeze(fe25519 *r);

void fe25519_unpack(fe25519 *r, const unsigned char x[32]);

void fe25519_pack(unsigned char r[32], const fe25519 *x);

int fe25519_iszero(const fe25519 *x);

int fe25519_iseq_vartime(const fe25519 *x, const fe25519 *y);

void fe25519_cmov(fe25519 *r, const fe25519 *x, unsigned char b);

void fe25519_setone(fe25519 *r);

void fe25519_setzero(fe25519 *r);

void fe25519_neg(fe25519 *r, const fe25519 *x);

unsigned char fe25519_getparity(const fe25519 *x);

void fe25519_mul(fe25519 *r, const fe25519 *x, const fe25519 *y);

void fe25519_square(fe25519 *r, const fe25519 *x);

void fe25519_invert(fe25519 *r, const fe25519 *x);

void fe25519_pow2523(fe25519 *r, const fe25519 *x);

//Assembler Routines
extern void fe25519_add(fe25519 *r, const fe25519 *x, const fe25519 *y);

extern void fe25519_sub(fe25519 *r, const fe25519 *x, const fe25519 *y);

extern void fe25519_red(fe25519 *r, unsigned char *C);


#endif
