/*
 * File:   avrnacl-20130514/smallrom/shared/crypto_verify_16.c
 * Author: Michael Hutter, Peter Schwabe
 * Public Domain
 */

#include "crypto_verify_16.h"

int crypto_verify_16(const unsigned char *x,const unsigned char *y)
{
  unsigned int differentbits = 0;
#define F(i) differentbits |= x[i] ^ y[i];
  F(0)
  F(1)
  F(2)
  F(3)
  F(4)
  F(5)
  F(6)
  F(7)
  F(8)
  F(9)
  F(10)
  F(11)
  F(12)
  F(13)
  F(14)
  F(15)
  return (1 & ((differentbits - 1) >> 8)) - 1;
}
