/*
 * bn256-20080525/curve.c 
 * Peter Schwabe
 * Public domain
*/

#include "curve.h"
#include "parameters.h"

void curve_init()
{
	/* Curve parameters */
	mpz_init_set_str(x, BN_X, 10);
	mpz_init_set_str(n, BN_N, 10);
	mpz_init_set_str(trace, BN_TRACE,10);
	mpz_init_set_str(chi, BN_CHI, 10); // (p^k - 1) / n
	mpz_init_set_str(chicomp, BN_CHICOMP, 10);
	mpz_init_set_str(looplength_eta, BN_LOOPLENGTH_ETA, 10);
	mpz_init_set_str(b, BN_B, 10);
}

void curve_clear()
{
	mpz_clear(n);
	mpz_clear(trace);
	mpz_clear(chicomp);
	mpz_clear(chi);
	mpz_clear(x);
	mpz_clear(b);
	mpz_clear(looplength_eta);
}
