/*
 * bn256-20080525/curve.h 
 * Peter Schwabe
 * Public domain
*/

#ifndef CURVE_H
#define CURVE_H

#include <gmp.h>

mpz_t b; /* parameter b in the curve equation y^2 = x^3 + b */
mpz_t n; /* order of the curve */
mpz_t x;  
mpz_t trace; /* trace of Frobenius */
mpz_t chi; /* p^12 / n */
mpz_t chicomp; 
mpz_t looplength_eta; 

/* Initialize Curve paramesters */
void curve_init(void);

/* Free memory used by curve parameters */
void curve_clear(void);

#endif /* ifdef CURVE_H */
