/*
 * bn256-20080525/fp.c 
 * Peter Schwabe
 * Public domain
*/

#include "fp.h"
#include "parameters.h"

void fp_init()
{
	mpz_init_set_str(p, BN_P, 10);

	// Set the value m', used in Montgomery reduction, see HAC, alg. 14.32
#if(GMP_LIMB_BITS == 32)
	p_inv = BN_PINV32;
#elif(GMP_LIMB_BITS == 64)
	p_inv = BN_PINV64;
#else
#error "Only 32 and 64 Bit architectures are supported"
#endif
}

void fp_clear()
{
	mpz_clear(p);
}
