/*
 * bn256-20080525/parameters.h 
 * Peter Schwabe
 * Public domain
*/

#include <gmp.h>

// Parameters used in fp.c
#define BN_P "82434016654300679721217353503190038836571781811386228921167322412819029493183"
#define BN_PINV32 4192343489UL
#define BN_PINV64 14730289922982417857UL

// Parameters used in fpe.c

#if(GMP_LIMB_BITS == 32)
#define N_LIMBS 8
#elif(GMP_LIMB_BITS == 64)
#define N_LIMBS 4
#else
#error "Only 32 and 64 bit architectures are supported"
#endif

// Parameters used in fp2.c
#define ALPHA (-2) // constant coefficient in the irreducible polynomial x^2 - alpha, used to construct F_{p^2}

// Parameters used in fp6.c
#define BN_XI "1", "1"
#define BN_YPMINUS1 "58218003500903600357625264234292989477935184013976377803379043379990513611334", "26288856584553239150834106295213109733170772302989655986730925339013803127666"
#define BN_ZETA "5958342662886596505216018177552825854576057147370867553330"
#define BN_XI2 "2", "82434016654300679721217353503190038836571781811386228921167322412819029493182"
#define BN_1O27XI3 "33584229007307684330866329205003349155640355552786982153068168390407752756482", "79380904926363617509320414484553370731513567670223775998161125286418324697139"
#define BN_1O3XI3 "54956011102867119814144902335460025891047854540924152614111548275212686328789", "54956011102867119814144902335460025891047854540924152614111548275212686328787"
#define BN_1O3XI "54956011102867119814144902335460025891047854540924152614111548275212686328789", "54956011102867119814144902335460025891047854540924152614111548275212686328789"
#define BN_1O3MODP "54956011102867119814144902335460025891047854540924152614111548275212686328789"
#define BN_COMETA_C0_CONST "82434016654300679717245125061265641166427769693017678351449950981238451124296"
#define BN_COMETA_C1_CONST "82434016654300679719231239282227840001499775752201953636308636697028740308739"

// Parameters used in fp12.c
#define BN_TAU "0", "0", "0", "1", "0", "0" // constant tau used to construct F_p^12 as F_p^6[Z]/ (Z^2 - tau)
#define BN_ZPMINUS1 "56591613210034336671768069300567745343090470721508699612907758494087266915999", "8151674858040474603082263872746642797519072844079438446757658431600919538185" // Z^(p-1)
#define BN_ZPMINUS1INV "16664399093237715933911902173291824865135557508817972186165572841237392240398", "80230987376282538953239279322325535591602771678144871210569992544851954063250" // Z^(1-p)

// Parameters used in curve.c
#define BN_X "6917529027641089837" // parameter x used to generate the curve (see "Pairing-Friendly Elliptic Curves of Prime Order")
#define BN_N "82434016654300679721217353503190038836284668564296686430114510052556401373769" // prime order of E(F_p)
#define BN_TRACE "287113247089542491052812360262628119415" // trace of Frobenius of the curve
#define BN_CHI "1194458535516712696617215684417624257030666067240995530739989845741099828184808045812676871691350143622814961863857773132424482094537445009010868364905329475952468280063652444489821109532139390264709695335860793910425342433575735069323405841687561063024994400628664553215353435760722989078898251407419402247808499909280746379875725289212217012702226622857832645189461706430174895107087213658428058993109042366769257992607327945724517833626182446630118382398741490471673207917676536121877458679494141432659879148773761631097881935530150704252360233040678259785011038361825754014829846445352865867168990611182985694796026875346359128391415471663605963714512918697891431453354985338626546912529078714232526052412652263727800637424674871891769013049427162670429595810069240578680572440695968919901414853005710542714187307687895455094601680687073002240" // exponent of final exponentiation
#define BN_CHICOMP "560169404838696232357056645449876352982160355741045729238356103537505929443608386408569742458511103733336876593838432319207912979028941305055706044190307030642152225405672930668086933610791936427274683600439499924717813785715163257" // exponent of final exponentiation for compressed pairing
#define BN_LOOPLENGTH_ETA "11916685325773193009570696613837024235910666865622157670373"
#define BN_B "24" // parameter b in the curve equation x^2 = y^3 + b

// Parameters used in points.c
#define BN_CURVEGEN "17813601848253033635698781672015468536630294081954948396510129954996309182771", "32952084653957203951573828884064840686196769247059424207939710944223386035556", "1"
#define BN_TWISTGEN_X "621974397985525318194063125170198577902540556498747469157675653746576620880", "6251805185683980258298929625871846172079392273578387836099945035602364239135"
#define BN_TWISTGEN_Y "49990908316789968724860573235913273901071484323829192314337721068681689250452", "19258290530482130955008764894053126575339703184772660063788583927864324464626"

// Parameters used for OptAte computation in ate_optate.c
#define BN_ZETA2 "82434016654300679715259010840303442331355763633833403066591265265448161939852" // zeta^2
#define BN_Z2P "58218003500903600357625264234292989477935184013976377803379043379990513611334", "26288856584553239150834106295213109733170772302989655986730925339013803127666" // Z^(2p)
#define BN_Z3P "36850984595653579060793000368378943551009490063938417941824057646362957363077", "73701969191307158121586000736757887102018980127876835883648115292725914726154" // Z^(3p)
