/*
 * bn256-20080525/points.c 
 * Peter Schwabe
 * Public domain
*/

#include "points.h"
#include "fp2e.h"
#include "curvepoint_fp.h"
#include "twistpoint_fp2.h"
#include "parameters.h"

void points_init()
{
	fp2e_t twistgen_x;
	fp2e_t twistgen_y;
	fp2e_set_str(twistgen_x, BN_TWISTGEN_X);
	fp2e_set_str(twistgen_y, BN_TWISTGEN_Y);
	curvepoint_fp_set_str(curve_gen, BN_CURVEGEN);
	twistpoint_fp2_affineset_fp2e(twist_gen, twistgen_x, twistgen_y);
}

void points_clear()
{
	;
}
