# File:   dclxvi-notsecure/fp2e_square.s
# Author: Ruben Niederhagen, Peter Schwabe
# Public Domain


# qhasm: enter fp2e_square_qhasm
.text
.p2align 5
.globl _fp2e_square_qhasm
.globl fp2e_square_qhasm
_fp2e_square_qhasm:
fp2e_square_qhasm:
mov %rsp,%r11
and $31,%r11
add $768,%r11
sub %r11,%rsp

# qhasm: int64 0rop

# qhasm: int64 0op

# qhasm: input 0rop

# qhasm: input 0op

# qhasm: int6464 0r0

# qhasm: int6464 0r1

# qhasm: int6464 0r2

# qhasm: int6464 0r3

# qhasm: int6464 0r4

# qhasm: int6464 0r5

# qhasm: int6464 0r6

# qhasm: int6464 0r7

# qhasm: int6464 0r8

# qhasm: int6464 0r9

# qhasm: int6464 0r10

# qhasm: int6464 0r11

# qhasm: stack6144 0mystack

# qhasm: int64 0myp

# qhasm: 0r0  = *(int128 *)(0op +   0)
# asm 1: movdqa 0(<0op=int64#2),>0r0=int6464#1
# asm 2: movdqa 0(<0op=%rsi),>0r0=%xmm0
movdqa 0(%rsi),%xmm0

# qhasm: 0r1  = *(int128 *)(0op +  16)
# asm 1: movdqa 16(<0op=int64#2),>0r1=int6464#2
# asm 2: movdqa 16(<0op=%rsi),>0r1=%xmm1
movdqa 16(%rsi),%xmm1

# qhasm: 0r2  = *(int128 *)(0op +  32)
# asm 1: movdqa 32(<0op=int64#2),>0r2=int6464#3
# asm 2: movdqa 32(<0op=%rsi),>0r2=%xmm2
movdqa 32(%rsi),%xmm2

# qhasm: 0r3  = *(int128 *)(0op +  48)
# asm 1: movdqa 48(<0op=int64#2),>0r3=int6464#4
# asm 2: movdqa 48(<0op=%rsi),>0r3=%xmm3
movdqa 48(%rsi),%xmm3

# qhasm: 0r4  = *(int128 *)(0op +  64)
# asm 1: movdqa 64(<0op=int64#2),>0r4=int6464#5
# asm 2: movdqa 64(<0op=%rsi),>0r4=%xmm4
movdqa 64(%rsi),%xmm4

# qhasm: 0r5  = *(int128 *)(0op +  80)
# asm 1: movdqa 80(<0op=int64#2),>0r5=int6464#6
# asm 2: movdqa 80(<0op=%rsi),>0r5=%xmm5
movdqa 80(%rsi),%xmm5

# qhasm: 0r6  = *(int128 *)(0op +  96)
# asm 1: movdqa 96(<0op=int64#2),>0r6=int6464#7
# asm 2: movdqa 96(<0op=%rsi),>0r6=%xmm6
movdqa 96(%rsi),%xmm6

# qhasm: 0r7  = *(int128 *)(0op + 112)
# asm 1: movdqa 112(<0op=int64#2),>0r7=int6464#8
# asm 2: movdqa 112(<0op=%rsi),>0r7=%xmm7
movdqa 112(%rsi),%xmm7

# qhasm: 0r8  = *(int128 *)(0op + 128)
# asm 1: movdqa 128(<0op=int64#2),>0r8=int6464#9
# asm 2: movdqa 128(<0op=%rsi),>0r8=%xmm8
movdqa 128(%rsi),%xmm8

# qhasm: 0r9  = *(int128 *)(0op + 144)
# asm 1: movdqa 144(<0op=int64#2),>0r9=int6464#10
# asm 2: movdqa 144(<0op=%rsi),>0r9=%xmm9
movdqa 144(%rsi),%xmm9

# qhasm: 0r10 = *(int128 *)(0op + 160)
# asm 1: movdqa 160(<0op=int64#2),>0r10=int6464#11
# asm 2: movdqa 160(<0op=%rsi),>0r10=%xmm10
movdqa 160(%rsi),%xmm10

# qhasm: 0r11 = *(int128 *)(0op + 176)
# asm 1: movdqa 176(<0op=int64#2),>0r11=int6464#12
# asm 2: movdqa 176(<0op=%rsi),>0r11=%xmm11
movdqa 176(%rsi),%xmm11

# qhasm: 0myp = &0mystack
# asm 1: leaq <0mystack=stack6144#1,>0myp=int64#3
# asm 2: leaq <0mystack=0(%rsp),>0myp=%rdx
leaq 0(%rsp),%rdx

# qhasm: int6464 0tmp0

# qhasm: int6464 0tmp1

# qhasm: int6464 0tmp2

# qhasm: int6464 0tmp3

# qhasm: int6464 0tmp4

# qhasm: int6464 0tmp5

# qhasm: int6464 0tmp6

# qhasm: int6464 0tmp7

# qhasm: int6464 0tmp8

# qhasm: int6464 0tmp9

# qhasm: int6464 0tmp10

# qhasm: int6464 0tmp11

# qhasm: 0r0 = shuffle float64 of 0r0 and 0r0 by 0x1
# asm 1: shufpd $0x1,<0r0=int6464#1,<0r0=int6464#1
# asm 2: shufpd $0x1,<0r0=%xmm0,<0r0=%xmm0
shufpd $0x1,%xmm0,%xmm0

# qhasm: 0r1 = shuffle float64 of 0r1 and 0r1 by 0x1
# asm 1: shufpd $0x1,<0r1=int6464#2,<0r1=int6464#2
# asm 2: shufpd $0x1,<0r1=%xmm1,<0r1=%xmm1
shufpd $0x1,%xmm1,%xmm1

# qhasm: 0r2 = shuffle float64 of 0r2 and 0r2 by 0x1
# asm 1: shufpd $0x1,<0r2=int6464#3,<0r2=int6464#3
# asm 2: shufpd $0x1,<0r2=%xmm2,<0r2=%xmm2
shufpd $0x1,%xmm2,%xmm2

# qhasm: 0r3 = shuffle float64 of 0r3 and 0r3 by 0x1
# asm 1: shufpd $0x1,<0r3=int6464#4,<0r3=int6464#4
# asm 2: shufpd $0x1,<0r3=%xmm3,<0r3=%xmm3
shufpd $0x1,%xmm3,%xmm3

# qhasm: 0r4 = shuffle float64 of 0r4 and 0r4 by 0x1
# asm 1: shufpd $0x1,<0r4=int6464#5,<0r4=int6464#5
# asm 2: shufpd $0x1,<0r4=%xmm4,<0r4=%xmm4
shufpd $0x1,%xmm4,%xmm4

# qhasm: 0r5 = shuffle float64 of 0r5 and 0r5 by 0x1
# asm 1: shufpd $0x1,<0r5=int6464#6,<0r5=int6464#6
# asm 2: shufpd $0x1,<0r5=%xmm5,<0r5=%xmm5
shufpd $0x1,%xmm5,%xmm5

# qhasm: 0r6 = shuffle float64 of 0r6 and 0r6 by 0x1
# asm 1: shufpd $0x1,<0r6=int6464#7,<0r6=int6464#7
# asm 2: shufpd $0x1,<0r6=%xmm6,<0r6=%xmm6
shufpd $0x1,%xmm6,%xmm6

# qhasm: 0r7 = shuffle float64 of 0r7 and 0r7 by 0x1
# asm 1: shufpd $0x1,<0r7=int6464#8,<0r7=int6464#8
# asm 2: shufpd $0x1,<0r7=%xmm7,<0r7=%xmm7
shufpd $0x1,%xmm7,%xmm7

# qhasm: 0r8 = shuffle float64 of 0r8 and 0r8 by 0x1
# asm 1: shufpd $0x1,<0r8=int6464#9,<0r8=int6464#9
# asm 2: shufpd $0x1,<0r8=%xmm8,<0r8=%xmm8
shufpd $0x1,%xmm8,%xmm8

# qhasm: 0r9 = shuffle float64 of 0r9 and 0r9 by 0x1
# asm 1: shufpd $0x1,<0r9=int6464#10,<0r9=int6464#10
# asm 2: shufpd $0x1,<0r9=%xmm9,<0r9=%xmm9
shufpd $0x1,%xmm9,%xmm9

# qhasm: 0r10 = shuffle float64 of 0r10 and 0r10 by 0x1
# asm 1: shufpd $0x1,<0r10=int6464#11,<0r10=int6464#11
# asm 2: shufpd $0x1,<0r10=%xmm10,<0r10=%xmm10
shufpd $0x1,%xmm10,%xmm10

# qhasm: 0r11 = shuffle float64 of 0r11 and 0r11 by 0x1
# asm 1: shufpd $0x1,<0r11=int6464#12,<0r11=int6464#12
# asm 2: shufpd $0x1,<0r11=%xmm11,<0r11=%xmm11
shufpd $0x1,%xmm11,%xmm11

# qhasm: *(int128 *)(0myp + 0) = 0r0
# asm 1: movdqa <0r0=int6464#1,0(<0myp=int64#3)
# asm 2: movdqa <0r0=%xmm0,0(<0myp=%rdx)
movdqa %xmm0,0(%rdx)

# qhasm: *(int128 *)(0myp + 16) = 0r1
# asm 1: movdqa <0r1=int6464#2,16(<0myp=int64#3)
# asm 2: movdqa <0r1=%xmm1,16(<0myp=%rdx)
movdqa %xmm1,16(%rdx)

# qhasm: *(int128 *)(0myp + 32) = 0r2
# asm 1: movdqa <0r2=int6464#3,32(<0myp=int64#3)
# asm 2: movdqa <0r2=%xmm2,32(<0myp=%rdx)
movdqa %xmm2,32(%rdx)

# qhasm: *(int128 *)(0myp + 48) = 0r3
# asm 1: movdqa <0r3=int6464#4,48(<0myp=int64#3)
# asm 2: movdqa <0r3=%xmm3,48(<0myp=%rdx)
movdqa %xmm3,48(%rdx)

# qhasm: *(int128 *)(0myp + 64) = 0r4
# asm 1: movdqa <0r4=int6464#5,64(<0myp=int64#3)
# asm 2: movdqa <0r4=%xmm4,64(<0myp=%rdx)
movdqa %xmm4,64(%rdx)

# qhasm: *(int128 *)(0myp + 80) = 0r5
# asm 1: movdqa <0r5=int6464#6,80(<0myp=int64#3)
# asm 2: movdqa <0r5=%xmm5,80(<0myp=%rdx)
movdqa %xmm5,80(%rdx)

# qhasm: *(int128 *)(0myp + 96) = 0r6
# asm 1: movdqa <0r6=int6464#7,96(<0myp=int64#3)
# asm 2: movdqa <0r6=%xmm6,96(<0myp=%rdx)
movdqa %xmm6,96(%rdx)

# qhasm: *(int128 *)(0myp + 112) = 0r7
# asm 1: movdqa <0r7=int6464#8,112(<0myp=int64#3)
# asm 2: movdqa <0r7=%xmm7,112(<0myp=%rdx)
movdqa %xmm7,112(%rdx)

# qhasm: *(int128 *)(0myp + 128) = 0r8
# asm 1: movdqa <0r8=int6464#9,128(<0myp=int64#3)
# asm 2: movdqa <0r8=%xmm8,128(<0myp=%rdx)
movdqa %xmm8,128(%rdx)

# qhasm: *(int128 *)(0myp + 144) = 0r9
# asm 1: movdqa <0r9=int6464#10,144(<0myp=int64#3)
# asm 2: movdqa <0r9=%xmm9,144(<0myp=%rdx)
movdqa %xmm9,144(%rdx)

# qhasm: *(int128 *)(0myp + 160) = 0r10
# asm 1: movdqa <0r10=int6464#11,160(<0myp=int64#3)
# asm 2: movdqa <0r10=%xmm10,160(<0myp=%rdx)
movdqa %xmm10,160(%rdx)

# qhasm: *(int128 *)(0myp + 176) = 0r11
# asm 1: movdqa <0r11=int6464#12,176(<0myp=int64#3)
# asm 2: movdqa <0r11=%xmm11,176(<0myp=%rdx)
movdqa %xmm11,176(%rdx)

# qhasm: float6464 0r0[0] += *(float64 *)(0op + 0)
# asm 1: addsd 0(<0op=int64#2),<0r0=int6464#1
# asm 2: addsd 0(<0op=%rsi),<0r0=%xmm0
addsd 0(%rsi),%xmm0

# qhasm: float6464 0r1[0] += *(float64 *)(0op + 16)
# asm 1: addsd 16(<0op=int64#2),<0r1=int6464#2
# asm 2: addsd 16(<0op=%rsi),<0r1=%xmm1
addsd 16(%rsi),%xmm1

# qhasm: float6464 0r2[0] += *(float64 *)(0op + 32)
# asm 1: addsd 32(<0op=int64#2),<0r2=int6464#3
# asm 2: addsd 32(<0op=%rsi),<0r2=%xmm2
addsd 32(%rsi),%xmm2

# qhasm: float6464 0r3[0] += *(float64 *)(0op + 48)
# asm 1: addsd 48(<0op=int64#2),<0r3=int6464#4
# asm 2: addsd 48(<0op=%rsi),<0r3=%xmm3
addsd 48(%rsi),%xmm3

# qhasm: float6464 0r4[0] += *(float64 *)(0op + 64)
# asm 1: addsd 64(<0op=int64#2),<0r4=int6464#5
# asm 2: addsd 64(<0op=%rsi),<0r4=%xmm4
addsd 64(%rsi),%xmm4

# qhasm: float6464 0r5[0] += *(float64 *)(0op + 80)
# asm 1: addsd 80(<0op=int64#2),<0r5=int6464#6
# asm 2: addsd 80(<0op=%rsi),<0r5=%xmm5
addsd 80(%rsi),%xmm5

# qhasm: float6464 0r6[0] += *(float64 *)(0op + 96)
# asm 1: addsd 96(<0op=int64#2),<0r6=int6464#7
# asm 2: addsd 96(<0op=%rsi),<0r6=%xmm6
addsd 96(%rsi),%xmm6

# qhasm: float6464 0r7[0] += *(float64 *)(0op + 112)
# asm 1: addsd 112(<0op=int64#2),<0r7=int6464#8
# asm 2: addsd 112(<0op=%rsi),<0r7=%xmm7
addsd 112(%rsi),%xmm7

# qhasm: float6464 0r8[0] += *(float64 *)(0op + 128)
# asm 1: addsd 128(<0op=int64#2),<0r8=int6464#9
# asm 2: addsd 128(<0op=%rsi),<0r8=%xmm8
addsd 128(%rsi),%xmm8

# qhasm: float6464 0r9[0] += *(float64 *)(0op + 144)
# asm 1: addsd 144(<0op=int64#2),<0r9=int6464#10
# asm 2: addsd 144(<0op=%rsi),<0r9=%xmm9
addsd 144(%rsi),%xmm9

# qhasm: float6464 0r10[0] += *(float64 *)(0op + 160)
# asm 1: addsd 160(<0op=int64#2),<0r10=int6464#11
# asm 2: addsd 160(<0op=%rsi),<0r10=%xmm10
addsd 160(%rsi),%xmm10

# qhasm: float6464 0r11[0] += *(float64 *)(0op + 176)
# asm 1: addsd 176(<0op=int64#2),<0r11=int6464#12
# asm 2: addsd 176(<0op=%rsi),<0r11=%xmm11
addsd 176(%rsi),%xmm11

# qhasm: 0tmp0 = *(int128 *)(0myp + 0)
# asm 1: movdqa 0(<0myp=int64#3),>0tmp0=int6464#13
# asm 2: movdqa 0(<0myp=%rdx),>0tmp0=%xmm12
movdqa 0(%rdx),%xmm12

# qhasm: *(int128 *)(0myp + 192) = 0r0
# asm 1: movdqa <0r0=int6464#1,192(<0myp=int64#3)
# asm 2: movdqa <0r0=%xmm0,192(<0myp=%rdx)
movdqa %xmm0,192(%rdx)

# qhasm: 0tmp1 = *(int128 *)(0myp + 16)
# asm 1: movdqa 16(<0myp=int64#3),>0tmp1=int6464#1
# asm 2: movdqa 16(<0myp=%rdx),>0tmp1=%xmm0
movdqa 16(%rdx),%xmm0

# qhasm: *(int128 *)(0myp + 208) = 0r1
# asm 1: movdqa <0r1=int6464#2,208(<0myp=int64#3)
# asm 2: movdqa <0r1=%xmm1,208(<0myp=%rdx)
movdqa %xmm1,208(%rdx)

# qhasm: 0tmp2 = *(int128 *)(0myp + 32)
# asm 1: movdqa 32(<0myp=int64#3),>0tmp2=int6464#2
# asm 2: movdqa 32(<0myp=%rdx),>0tmp2=%xmm1
movdqa 32(%rdx),%xmm1

# qhasm: *(int128 *)(0myp + 224) = 0r2
# asm 1: movdqa <0r2=int6464#3,224(<0myp=int64#3)
# asm 2: movdqa <0r2=%xmm2,224(<0myp=%rdx)
movdqa %xmm2,224(%rdx)

# qhasm: 0tmp3 = *(int128 *)(0myp + 48)
# asm 1: movdqa 48(<0myp=int64#3),>0tmp3=int6464#3
# asm 2: movdqa 48(<0myp=%rdx),>0tmp3=%xmm2
movdqa 48(%rdx),%xmm2

# qhasm: *(int128 *)(0myp + 240) = 0r3
# asm 1: movdqa <0r3=int6464#4,240(<0myp=int64#3)
# asm 2: movdqa <0r3=%xmm3,240(<0myp=%rdx)
movdqa %xmm3,240(%rdx)

# qhasm: 0tmp4 = *(int128 *)(0myp + 64)
# asm 1: movdqa 64(<0myp=int64#3),>0tmp4=int6464#4
# asm 2: movdqa 64(<0myp=%rdx),>0tmp4=%xmm3
movdqa 64(%rdx),%xmm3

# qhasm: *(int128 *)(0myp + 256) = 0r4
# asm 1: movdqa <0r4=int6464#5,256(<0myp=int64#3)
# asm 2: movdqa <0r4=%xmm4,256(<0myp=%rdx)
movdqa %xmm4,256(%rdx)

# qhasm: 0tmp5 = *(int128 *)(0myp + 80)
# asm 1: movdqa 80(<0myp=int64#3),>0tmp5=int6464#5
# asm 2: movdqa 80(<0myp=%rdx),>0tmp5=%xmm4
movdqa 80(%rdx),%xmm4

# qhasm: *(int128 *)(0myp + 272) = 0r5
# asm 1: movdqa <0r5=int6464#6,272(<0myp=int64#3)
# asm 2: movdqa <0r5=%xmm5,272(<0myp=%rdx)
movdqa %xmm5,272(%rdx)

# qhasm: 0tmp6 = *(int128 *)(0myp + 96)
# asm 1: movdqa 96(<0myp=int64#3),>0tmp6=int6464#6
# asm 2: movdqa 96(<0myp=%rdx),>0tmp6=%xmm5
movdqa 96(%rdx),%xmm5

# qhasm: *(int128 *)(0myp + 288) = 0r6
# asm 1: movdqa <0r6=int6464#7,288(<0myp=int64#3)
# asm 2: movdqa <0r6=%xmm6,288(<0myp=%rdx)
movdqa %xmm6,288(%rdx)

# qhasm: 0tmp7 = *(int128 *)(0myp + 112)
# asm 1: movdqa 112(<0myp=int64#3),>0tmp7=int6464#7
# asm 2: movdqa 112(<0myp=%rdx),>0tmp7=%xmm6
movdqa 112(%rdx),%xmm6

# qhasm: *(int128 *)(0myp + 304) = 0r7
# asm 1: movdqa <0r7=int6464#8,304(<0myp=int64#3)
# asm 2: movdqa <0r7=%xmm7,304(<0myp=%rdx)
movdqa %xmm7,304(%rdx)

# qhasm: 0tmp8 = *(int128 *)(0myp + 128)
# asm 1: movdqa 128(<0myp=int64#3),>0tmp8=int6464#8
# asm 2: movdqa 128(<0myp=%rdx),>0tmp8=%xmm7
movdqa 128(%rdx),%xmm7

# qhasm: *(int128 *)(0myp + 320) = 0r8
# asm 1: movdqa <0r8=int6464#9,320(<0myp=int64#3)
# asm 2: movdqa <0r8=%xmm8,320(<0myp=%rdx)
movdqa %xmm8,320(%rdx)

# qhasm: 0tmp9 = *(int128 *)(0myp + 144)
# asm 1: movdqa 144(<0myp=int64#3),>0tmp9=int6464#9
# asm 2: movdqa 144(<0myp=%rdx),>0tmp9=%xmm8
movdqa 144(%rdx),%xmm8

# qhasm: *(int128 *)(0myp + 336) = 0r9
# asm 1: movdqa <0r9=int6464#10,336(<0myp=int64#3)
# asm 2: movdqa <0r9=%xmm9,336(<0myp=%rdx)
movdqa %xmm9,336(%rdx)

# qhasm: 0tmp10 = *(int128 *)(0myp + 160)
# asm 1: movdqa 160(<0myp=int64#3),>0tmp10=int6464#10
# asm 2: movdqa 160(<0myp=%rdx),>0tmp10=%xmm9
movdqa 160(%rdx),%xmm9

# qhasm: *(int128 *)(0myp + 352) = 0r10
# asm 1: movdqa <0r10=int6464#11,352(<0myp=int64#3)
# asm 2: movdqa <0r10=%xmm10,352(<0myp=%rdx)
movdqa %xmm10,352(%rdx)

# qhasm: 0tmp11 = *(int128 *)(0myp + 176)
# asm 1: movdqa 176(<0myp=int64#3),>0tmp11=int6464#11
# asm 2: movdqa 176(<0myp=%rdx),>0tmp11=%xmm10
movdqa 176(%rdx),%xmm10

# qhasm: *(int128 *)(0myp + 368) = 0r11
# asm 1: movdqa <0r11=int6464#12,368(<0myp=int64#3)
# asm 2: movdqa <0r11=%xmm11,368(<0myp=%rdx)
movdqa %xmm11,368(%rdx)

# qhasm: float6464 0tmp0 *= MINUSSEVEN_ONE
# asm 1: mulpd MINUSSEVEN_ONE,<0tmp0=int6464#13
# asm 2: mulpd MINUSSEVEN_ONE,<0tmp0=%xmm12
mulpd MINUSSEVEN_ONE,%xmm12

# qhasm: float6464 0tmp1 *= MINUSSEVEN_ONE
# asm 1: mulpd MINUSSEVEN_ONE,<0tmp1=int6464#1
# asm 2: mulpd MINUSSEVEN_ONE,<0tmp1=%xmm0
mulpd MINUSSEVEN_ONE,%xmm0

# qhasm: float6464 0tmp2 *= MINUSSEVEN_ONE
# asm 1: mulpd MINUSSEVEN_ONE,<0tmp2=int6464#2
# asm 2: mulpd MINUSSEVEN_ONE,<0tmp2=%xmm1
mulpd MINUSSEVEN_ONE,%xmm1

# qhasm: float6464 0tmp3 *= MINUSSEVEN_ONE
# asm 1: mulpd MINUSSEVEN_ONE,<0tmp3=int6464#3
# asm 2: mulpd MINUSSEVEN_ONE,<0tmp3=%xmm2
mulpd MINUSSEVEN_ONE,%xmm2

# qhasm: float6464 0tmp4 *= MINUSSEVEN_ONE
# asm 1: mulpd MINUSSEVEN_ONE,<0tmp4=int6464#4
# asm 2: mulpd MINUSSEVEN_ONE,<0tmp4=%xmm3
mulpd MINUSSEVEN_ONE,%xmm3

# qhasm: float6464 0tmp5 *= MINUSSEVEN_ONE
# asm 1: mulpd MINUSSEVEN_ONE,<0tmp5=int6464#5
# asm 2: mulpd MINUSSEVEN_ONE,<0tmp5=%xmm4
mulpd MINUSSEVEN_ONE,%xmm4

# qhasm: float6464 0tmp6 *= MINUSSEVEN_ONE
# asm 1: mulpd MINUSSEVEN_ONE,<0tmp6=int6464#6
# asm 2: mulpd MINUSSEVEN_ONE,<0tmp6=%xmm5
mulpd MINUSSEVEN_ONE,%xmm5

# qhasm: float6464 0tmp7 *= MINUSSEVEN_ONE
# asm 1: mulpd MINUSSEVEN_ONE,<0tmp7=int6464#7
# asm 2: mulpd MINUSSEVEN_ONE,<0tmp7=%xmm6
mulpd MINUSSEVEN_ONE,%xmm6

# qhasm: float6464 0tmp8 *= MINUSSEVEN_ONE
# asm 1: mulpd MINUSSEVEN_ONE,<0tmp8=int6464#8
# asm 2: mulpd MINUSSEVEN_ONE,<0tmp8=%xmm7
mulpd MINUSSEVEN_ONE,%xmm7

# qhasm: float6464 0tmp9 *= MINUSSEVEN_ONE
# asm 1: mulpd MINUSSEVEN_ONE,<0tmp9=int6464#9
# asm 2: mulpd MINUSSEVEN_ONE,<0tmp9=%xmm8
mulpd MINUSSEVEN_ONE,%xmm8

# qhasm: float6464 0tmp10 *= MINUSSEVEN_ONE
# asm 1: mulpd MINUSSEVEN_ONE,<0tmp10=int6464#10
# asm 2: mulpd MINUSSEVEN_ONE,<0tmp10=%xmm9
mulpd MINUSSEVEN_ONE,%xmm9

# qhasm: float6464 0tmp11 *= MINUSSEVEN_ONE
# asm 1: mulpd MINUSSEVEN_ONE,<0tmp11=int6464#11
# asm 2: mulpd MINUSSEVEN_ONE,<0tmp11=%xmm10
mulpd MINUSSEVEN_ONE,%xmm10

# qhasm: int6464 0stmp

# qhasm: 0stmp = *(int128 *)(0op + 0)
# asm 1: movdqa 0(<0op=int64#2),>0stmp=int6464#12
# asm 2: movdqa 0(<0op=%rsi),>0stmp=%xmm11
movdqa 0(%rsi),%xmm11

# qhasm: float6464 0stmp[0] += 0tmp0[0]
# asm 1: addsd <0tmp0=int6464#13,<0stmp=int6464#12
# asm 2: addsd <0tmp0=%xmm12,<0stmp=%xmm11
addsd %xmm12,%xmm11

# qhasm: *(int128 *)(0myp + 0) = 0stmp
# asm 1: movdqa <0stmp=int6464#12,0(<0myp=int64#3)
# asm 2: movdqa <0stmp=%xmm11,0(<0myp=%rdx)
movdqa %xmm11,0(%rdx)

# qhasm: 0stmp = *(int128 *)(0op + 16)
# asm 1: movdqa 16(<0op=int64#2),>0stmp=int6464#12
# asm 2: movdqa 16(<0op=%rsi),>0stmp=%xmm11
movdqa 16(%rsi),%xmm11

# qhasm: float6464 0stmp[0] += 0tmp1[0]
# asm 1: addsd <0tmp1=int6464#1,<0stmp=int6464#12
# asm 2: addsd <0tmp1=%xmm0,<0stmp=%xmm11
addsd %xmm0,%xmm11

# qhasm: *(int128 *)(0myp + 16) = 0stmp
# asm 1: movdqa <0stmp=int6464#12,16(<0myp=int64#3)
# asm 2: movdqa <0stmp=%xmm11,16(<0myp=%rdx)
movdqa %xmm11,16(%rdx)

# qhasm: 0stmp = *(int128 *)(0op + 32)
# asm 1: movdqa 32(<0op=int64#2),>0stmp=int6464#1
# asm 2: movdqa 32(<0op=%rsi),>0stmp=%xmm0
movdqa 32(%rsi),%xmm0

# qhasm: float6464 0stmp[0] += 0tmp2[0]
# asm 1: addsd <0tmp2=int6464#2,<0stmp=int6464#1
# asm 2: addsd <0tmp2=%xmm1,<0stmp=%xmm0
addsd %xmm1,%xmm0

# qhasm: *(int128 *)(0myp + 32) = 0stmp
# asm 1: movdqa <0stmp=int6464#1,32(<0myp=int64#3)
# asm 2: movdqa <0stmp=%xmm0,32(<0myp=%rdx)
movdqa %xmm0,32(%rdx)

# qhasm: 0stmp = *(int128 *)(0op + 48)
# asm 1: movdqa 48(<0op=int64#2),>0stmp=int6464#1
# asm 2: movdqa 48(<0op=%rsi),>0stmp=%xmm0
movdqa 48(%rsi),%xmm0

# qhasm: float6464 0stmp[0] += 0tmp3[0]
# asm 1: addsd <0tmp3=int6464#3,<0stmp=int6464#1
# asm 2: addsd <0tmp3=%xmm2,<0stmp=%xmm0
addsd %xmm2,%xmm0

# qhasm: *(int128 *)(0myp + 48) = 0stmp
# asm 1: movdqa <0stmp=int6464#1,48(<0myp=int64#3)
# asm 2: movdqa <0stmp=%xmm0,48(<0myp=%rdx)
movdqa %xmm0,48(%rdx)

# qhasm: 0stmp = *(int128 *)(0op + 64)
# asm 1: movdqa 64(<0op=int64#2),>0stmp=int6464#1
# asm 2: movdqa 64(<0op=%rsi),>0stmp=%xmm0
movdqa 64(%rsi),%xmm0

# qhasm: float6464 0stmp[0] += 0tmp4[0]
# asm 1: addsd <0tmp4=int6464#4,<0stmp=int6464#1
# asm 2: addsd <0tmp4=%xmm3,<0stmp=%xmm0
addsd %xmm3,%xmm0

# qhasm: *(int128 *)(0myp + 64) = 0stmp
# asm 1: movdqa <0stmp=int6464#1,64(<0myp=int64#3)
# asm 2: movdqa <0stmp=%xmm0,64(<0myp=%rdx)
movdqa %xmm0,64(%rdx)

# qhasm: 0stmp = *(int128 *)(0op + 80)
# asm 1: movdqa 80(<0op=int64#2),>0stmp=int6464#1
# asm 2: movdqa 80(<0op=%rsi),>0stmp=%xmm0
movdqa 80(%rsi),%xmm0

# qhasm: float6464 0stmp[0] += 0tmp5[0]
# asm 1: addsd <0tmp5=int6464#5,<0stmp=int6464#1
# asm 2: addsd <0tmp5=%xmm4,<0stmp=%xmm0
addsd %xmm4,%xmm0

# qhasm: *(int128 *)(0myp + 80) = 0stmp
# asm 1: movdqa <0stmp=int6464#1,80(<0myp=int64#3)
# asm 2: movdqa <0stmp=%xmm0,80(<0myp=%rdx)
movdqa %xmm0,80(%rdx)

# qhasm: 0stmp = *(int128 *)(0op + 96)
# asm 1: movdqa 96(<0op=int64#2),>0stmp=int6464#1
# asm 2: movdqa 96(<0op=%rsi),>0stmp=%xmm0
movdqa 96(%rsi),%xmm0

# qhasm: float6464 0stmp[0] += 0tmp6[0]
# asm 1: addsd <0tmp6=int6464#6,<0stmp=int6464#1
# asm 2: addsd <0tmp6=%xmm5,<0stmp=%xmm0
addsd %xmm5,%xmm0

# qhasm: *(int128 *)(0myp + 96) = 0stmp
# asm 1: movdqa <0stmp=int6464#1,96(<0myp=int64#3)
# asm 2: movdqa <0stmp=%xmm0,96(<0myp=%rdx)
movdqa %xmm0,96(%rdx)

# qhasm: 0stmp = *(int128 *)(0op + 112)
# asm 1: movdqa 112(<0op=int64#2),>0stmp=int6464#1
# asm 2: movdqa 112(<0op=%rsi),>0stmp=%xmm0
movdqa 112(%rsi),%xmm0

# qhasm: float6464 0stmp[0] += 0tmp7[0]
# asm 1: addsd <0tmp7=int6464#7,<0stmp=int6464#1
# asm 2: addsd <0tmp7=%xmm6,<0stmp=%xmm0
addsd %xmm6,%xmm0

# qhasm: *(int128 *)(0myp + 112) = 0stmp
# asm 1: movdqa <0stmp=int6464#1,112(<0myp=int64#3)
# asm 2: movdqa <0stmp=%xmm0,112(<0myp=%rdx)
movdqa %xmm0,112(%rdx)

# qhasm: 0stmp = *(int128 *)(0op + 128)
# asm 1: movdqa 128(<0op=int64#2),>0stmp=int6464#1
# asm 2: movdqa 128(<0op=%rsi),>0stmp=%xmm0
movdqa 128(%rsi),%xmm0

# qhasm: float6464 0stmp[0] += 0tmp8[0]
# asm 1: addsd <0tmp8=int6464#8,<0stmp=int6464#1
# asm 2: addsd <0tmp8=%xmm7,<0stmp=%xmm0
addsd %xmm7,%xmm0

# qhasm: *(int128 *)(0myp + 128) = 0stmp
# asm 1: movdqa <0stmp=int6464#1,128(<0myp=int64#3)
# asm 2: movdqa <0stmp=%xmm0,128(<0myp=%rdx)
movdqa %xmm0,128(%rdx)

# qhasm: 0stmp = *(int128 *)(0op + 144)
# asm 1: movdqa 144(<0op=int64#2),>0stmp=int6464#1
# asm 2: movdqa 144(<0op=%rsi),>0stmp=%xmm0
movdqa 144(%rsi),%xmm0

# qhasm: float6464 0stmp[0] += 0tmp9[0]
# asm 1: addsd <0tmp9=int6464#9,<0stmp=int6464#1
# asm 2: addsd <0tmp9=%xmm8,<0stmp=%xmm0
addsd %xmm8,%xmm0

# qhasm: *(int128 *)(0myp + 144) = 0stmp
# asm 1: movdqa <0stmp=int6464#1,144(<0myp=int64#3)
# asm 2: movdqa <0stmp=%xmm0,144(<0myp=%rdx)
movdqa %xmm0,144(%rdx)

# qhasm: 0stmp = *(int128 *)(0op + 160)
# asm 1: movdqa 160(<0op=int64#2),>0stmp=int6464#1
# asm 2: movdqa 160(<0op=%rsi),>0stmp=%xmm0
movdqa 160(%rsi),%xmm0

# qhasm: float6464 0stmp[0] += 0tmp10[0]
# asm 1: addsd <0tmp10=int6464#10,<0stmp=int6464#1
# asm 2: addsd <0tmp10=%xmm9,<0stmp=%xmm0
addsd %xmm9,%xmm0

# qhasm: *(int128 *)(0myp + 160) = 0stmp
# asm 1: movdqa <0stmp=int6464#1,160(<0myp=int64#3)
# asm 2: movdqa <0stmp=%xmm0,160(<0myp=%rdx)
movdqa %xmm0,160(%rdx)

# qhasm: 0stmp = *(int128 *)(0op + 176)
# asm 1: movdqa 176(<0op=int64#2),>0stmp=int6464#1
# asm 2: movdqa 176(<0op=%rsi),>0stmp=%xmm0
movdqa 176(%rsi),%xmm0

# qhasm: float6464 0stmp[0] += 0tmp11[0]
# asm 1: addsd <0tmp11=int6464#11,<0stmp=int6464#1
# asm 2: addsd <0tmp11=%xmm10,<0stmp=%xmm0
addsd %xmm10,%xmm0

# qhasm: *(int128 *)(0myp + 176) = 0stmp
# asm 1: movdqa <0stmp=int6464#1,176(<0myp=int64#3)
# asm 2: movdqa <0stmp=%xmm0,176(<0myp=%rdx)
movdqa %xmm0,176(%rdx)

# qhasm: int64 0t1p

# qhasm: int64 0t2p

# qhasm: int64 0resp

# qhasm: int6464 0res0

# qhasm: int6464 0res1

# qhasm: int6464 0res2

# qhasm: int6464 0res3

# qhasm: int6464 0res4

# qhasm: int6464 0res5

# qhasm: int6464 0res6

# qhasm: int6464 0res7

# qhasm: int6464 0res8

# qhasm: int6464 0res9

# qhasm: int6464 0res10

# qhasm: int6464 0res11

# qhasm: int6464 0res12

# qhasm: int6464 0res13

# qhasm: int6464 0res14

# qhasm: int6464 0res15

# qhasm: int6464 0res16

# qhasm: int6464 0res17

# qhasm: int6464 0res18

# qhasm: int6464 0res19

# qhasm: int6464 0res20

# qhasm: int6464 0res21

# qhasm: int6464 0res22

# qhasm: 0t1p  = 0myp
# asm 1: mov  <0myp=int64#3,>0t1p=int64#2
# asm 2: mov  <0myp=%rdx,>0t1p=%rsi
mov  %rdx,%rsi

# qhasm: 0t2p  = 0myp + 192
# asm 1: lea  192(<0myp=int64#3),>0t2p=int64#4
# asm 2: lea  192(<0myp=%rdx),>0t2p=%rcx
lea  192(%rdx),%rcx

# qhasm: 0resp = 0myp + 384
# asm 1: lea  384(<0myp=int64#3),>0resp=int64#5
# asm 2: lea  384(<0myp=%rdx),>0resp=%r8
lea  384(%rdx),%r8

# qhasm: int6464 0yoff

# qhasm: int6464 1r0

# qhasm: int6464 1r1

# qhasm: int6464 1r2

# qhasm: int6464 1r3

# qhasm: int6464 1r4

# qhasm: int6464 1r5

# qhasm: int6464 1r6

# qhasm: int6464 1r7

# qhasm: int6464 1r8

# qhasm: int6464 1r9

# qhasm: int6464 1r10

# qhasm: int6464 1r11

# qhasm: int6464 0t0

# qhasm: int6464 0t1

# qhasm: int6464 0t2

# qhasm: int6464 0t3

# qhasm: int6464 0t4

# qhasm: int6464 0t5

# qhasm: int6464 0t6

# qhasm: int6464 0t7

# qhasm: int6464 0t8

# qhasm: int6464 0t9

# qhasm: int6464 0t10

# qhasm: int6464 0t11

# qhasm: int6464 0t12

# qhasm: int6464 0t13

# qhasm: int6464 0t14

# qhasm: int6464 0t15

# qhasm: int6464 0t16

# qhasm: int6464 0t17

# qhasm: int6464 0t18

# qhasm: int6464 0t19

# qhasm: int6464 0t20

# qhasm: int6464 0t21

# qhasm: int6464 0t22

# qhasm: int6464 0ab0

# qhasm: int6464 0ab1

# qhasm: int6464 0ab2

# qhasm: int6464 0ab3

# qhasm: int6464 0ab4

# qhasm: int6464 0ab5

# qhasm: int6464 0ab6

# qhasm: int6464 0ab7

# qhasm: int6464 0ab8

# qhasm: int6464 0ab9

# qhasm: int6464 0ab10

# qhasm: int6464 0ab11

# qhasm: int6464 0ab0six

# qhasm: int6464 0ab1six

# qhasm: int6464 0ab2six

# qhasm: int6464 0ab3six

# qhasm: int6464 0ab4six

# qhasm: int6464 0ab5six

# qhasm: int6464 0ab6six

# qhasm: int6464 0ab7six

# qhasm: int6464 0ab8six

# qhasm: int6464 0ab9six

# qhasm: int6464 0ab10six

# qhasm: int6464 0ab11six

# qhasm: 0ab0 = *(int128 *)(0t1p + 0)
# asm 1: movdqa 0(<0t1p=int64#2),>0ab0=int6464#1
# asm 2: movdqa 0(<0t1p=%rsi),>0ab0=%xmm0
movdqa 0(%rsi),%xmm0

# qhasm: 0t0 = 0ab0
# asm 1: movdqa <0ab0=int6464#1,>0t0=int6464#2
# asm 2: movdqa <0ab0=%xmm0,>0t0=%xmm1
movdqa %xmm0,%xmm1

# qhasm: float6464 0t0 *= *(int128 *)(0t2p + 0)
# asm 1: mulpd 0(<0t2p=int64#4),<0t0=int6464#2
# asm 2: mulpd 0(<0t2p=%rcx),<0t0=%xmm1
mulpd 0(%rcx),%xmm1

# qhasm: 1r0 =0t0
# asm 1: movdqa <0t0=int6464#2,>1r0=int6464#2
# asm 2: movdqa <0t0=%xmm1,>1r0=%xmm1
movdqa %xmm1,%xmm1

# qhasm: 0t1 = 0ab0
# asm 1: movdqa <0ab0=int6464#1,>0t1=int6464#3
# asm 2: movdqa <0ab0=%xmm0,>0t1=%xmm2
movdqa %xmm0,%xmm2

# qhasm: float6464 0t1 *= *(int128 *)(0t2p + 16)
# asm 1: mulpd 16(<0t2p=int64#4),<0t1=int6464#3
# asm 2: mulpd 16(<0t2p=%rcx),<0t1=%xmm2
mulpd 16(%rcx),%xmm2

# qhasm: 1r1 =0t1
# asm 1: movdqa <0t1=int6464#3,>1r1=int6464#3
# asm 2: movdqa <0t1=%xmm2,>1r1=%xmm2
movdqa %xmm2,%xmm2

# qhasm: 0t2 = 0ab0
# asm 1: movdqa <0ab0=int6464#1,>0t2=int6464#4
# asm 2: movdqa <0ab0=%xmm0,>0t2=%xmm3
movdqa %xmm0,%xmm3

# qhasm: float6464 0t2 *= *(int128 *)(0t2p + 32)
# asm 1: mulpd 32(<0t2p=int64#4),<0t2=int6464#4
# asm 2: mulpd 32(<0t2p=%rcx),<0t2=%xmm3
mulpd 32(%rcx),%xmm3

# qhasm: 1r2 =0t2
# asm 1: movdqa <0t2=int6464#4,>1r2=int6464#4
# asm 2: movdqa <0t2=%xmm3,>1r2=%xmm3
movdqa %xmm3,%xmm3

# qhasm: 0t3 = 0ab0
# asm 1: movdqa <0ab0=int6464#1,>0t3=int6464#5
# asm 2: movdqa <0ab0=%xmm0,>0t3=%xmm4
movdqa %xmm0,%xmm4

# qhasm: float6464 0t3 *= *(int128 *)(0t2p + 48)
# asm 1: mulpd 48(<0t2p=int64#4),<0t3=int6464#5
# asm 2: mulpd 48(<0t2p=%rcx),<0t3=%xmm4
mulpd 48(%rcx),%xmm4

# qhasm: 1r3 =0t3
# asm 1: movdqa <0t3=int6464#5,>1r3=int6464#5
# asm 2: movdqa <0t3=%xmm4,>1r3=%xmm4
movdqa %xmm4,%xmm4

# qhasm: 0t4 = 0ab0
# asm 1: movdqa <0ab0=int6464#1,>0t4=int6464#6
# asm 2: movdqa <0ab0=%xmm0,>0t4=%xmm5
movdqa %xmm0,%xmm5

# qhasm: float6464 0t4 *= *(int128 *)(0t2p + 64)
# asm 1: mulpd 64(<0t2p=int64#4),<0t4=int6464#6
# asm 2: mulpd 64(<0t2p=%rcx),<0t4=%xmm5
mulpd 64(%rcx),%xmm5

# qhasm: 1r4 =0t4
# asm 1: movdqa <0t4=int6464#6,>1r4=int6464#6
# asm 2: movdqa <0t4=%xmm5,>1r4=%xmm5
movdqa %xmm5,%xmm5

# qhasm: 0t5 = 0ab0
# asm 1: movdqa <0ab0=int6464#1,>0t5=int6464#7
# asm 2: movdqa <0ab0=%xmm0,>0t5=%xmm6
movdqa %xmm0,%xmm6

# qhasm: float6464 0t5 *= *(int128 *)(0t2p + 80)
# asm 1: mulpd 80(<0t2p=int64#4),<0t5=int6464#7
# asm 2: mulpd 80(<0t2p=%rcx),<0t5=%xmm6
mulpd 80(%rcx),%xmm6

# qhasm: 1r5 =0t5
# asm 1: movdqa <0t5=int6464#7,>1r5=int6464#7
# asm 2: movdqa <0t5=%xmm6,>1r5=%xmm6
movdqa %xmm6,%xmm6

# qhasm: 0t6 = 0ab0
# asm 1: movdqa <0ab0=int6464#1,>0t6=int6464#8
# asm 2: movdqa <0ab0=%xmm0,>0t6=%xmm7
movdqa %xmm0,%xmm7

# qhasm: float6464 0t6 *= *(int128 *)(0t2p + 96)
# asm 1: mulpd 96(<0t2p=int64#4),<0t6=int6464#8
# asm 2: mulpd 96(<0t2p=%rcx),<0t6=%xmm7
mulpd 96(%rcx),%xmm7

# qhasm: 1r6 =0t6
# asm 1: movdqa <0t6=int6464#8,>1r6=int6464#8
# asm 2: movdqa <0t6=%xmm7,>1r6=%xmm7
movdqa %xmm7,%xmm7

# qhasm: 0t7 = 0ab0
# asm 1: movdqa <0ab0=int6464#1,>0t7=int6464#9
# asm 2: movdqa <0ab0=%xmm0,>0t7=%xmm8
movdqa %xmm0,%xmm8

# qhasm: float6464 0t7 *= *(int128 *)(0t2p + 112)
# asm 1: mulpd 112(<0t2p=int64#4),<0t7=int6464#9
# asm 2: mulpd 112(<0t2p=%rcx),<0t7=%xmm8
mulpd 112(%rcx),%xmm8

# qhasm: 1r7 =0t7
# asm 1: movdqa <0t7=int6464#9,>1r7=int6464#9
# asm 2: movdqa <0t7=%xmm8,>1r7=%xmm8
movdqa %xmm8,%xmm8

# qhasm: 0t8 = 0ab0
# asm 1: movdqa <0ab0=int6464#1,>0t8=int6464#10
# asm 2: movdqa <0ab0=%xmm0,>0t8=%xmm9
movdqa %xmm0,%xmm9

# qhasm: float6464 0t8 *= *(int128 *)(0t2p + 128)
# asm 1: mulpd 128(<0t2p=int64#4),<0t8=int6464#10
# asm 2: mulpd 128(<0t2p=%rcx),<0t8=%xmm9
mulpd 128(%rcx),%xmm9

# qhasm: 1r8 =0t8
# asm 1: movdqa <0t8=int6464#10,>1r8=int6464#10
# asm 2: movdqa <0t8=%xmm9,>1r8=%xmm9
movdqa %xmm9,%xmm9

# qhasm: 0t9 = 0ab0
# asm 1: movdqa <0ab0=int6464#1,>0t9=int6464#11
# asm 2: movdqa <0ab0=%xmm0,>0t9=%xmm10
movdqa %xmm0,%xmm10

# qhasm: float6464 0t9 *= *(int128 *)(0t2p + 144)
# asm 1: mulpd 144(<0t2p=int64#4),<0t9=int6464#11
# asm 2: mulpd 144(<0t2p=%rcx),<0t9=%xmm10
mulpd 144(%rcx),%xmm10

# qhasm: 1r9 =0t9
# asm 1: movdqa <0t9=int6464#11,>1r9=int6464#11
# asm 2: movdqa <0t9=%xmm10,>1r9=%xmm10
movdqa %xmm10,%xmm10

# qhasm: 0t10 = 0ab0
# asm 1: movdqa <0ab0=int6464#1,>0t10=int6464#12
# asm 2: movdqa <0ab0=%xmm0,>0t10=%xmm11
movdqa %xmm0,%xmm11

# qhasm: float6464 0t10 *= *(int128 *)(0t2p + 160)
# asm 1: mulpd 160(<0t2p=int64#4),<0t10=int6464#12
# asm 2: mulpd 160(<0t2p=%rcx),<0t10=%xmm11
mulpd 160(%rcx),%xmm11

# qhasm: 1r10 =0t10
# asm 1: movdqa <0t10=int6464#12,>1r10=int6464#12
# asm 2: movdqa <0t10=%xmm11,>1r10=%xmm11
movdqa %xmm11,%xmm11

# qhasm: 0t11 = 0ab0
# asm 1: movdqa <0ab0=int6464#1,>0t11=int6464#1
# asm 2: movdqa <0ab0=%xmm0,>0t11=%xmm0
movdqa %xmm0,%xmm0

# qhasm: float6464 0t11 *= *(int128 *)(0t2p + 176)
# asm 1: mulpd 176(<0t2p=int64#4),<0t11=int6464#1
# asm 2: mulpd 176(<0t2p=%rcx),<0t11=%xmm0
mulpd 176(%rcx),%xmm0

# qhasm: 1r11 =0t11
# asm 1: movdqa <0t11=int6464#1,>1r11=int6464#1
# asm 2: movdqa <0t11=%xmm0,>1r11=%xmm0
movdqa %xmm0,%xmm0

# qhasm: *(int128 *)(0resp + 0) = 1r0
# asm 1: movdqa <1r0=int6464#2,0(<0resp=int64#5)
# asm 2: movdqa <1r0=%xmm1,0(<0resp=%r8)
movdqa %xmm1,0(%r8)

# qhasm: 0ab1 = *(int128 *)(0t1p + 16)
# asm 1: movdqa 16(<0t1p=int64#2),>0ab1=int6464#2
# asm 2: movdqa 16(<0t1p=%rsi),>0ab1=%xmm1
movdqa 16(%rsi),%xmm1

# qhasm: 0ab1six = 0ab1
# asm 1: movdqa <0ab1=int6464#2,>0ab1six=int6464#13
# asm 2: movdqa <0ab1=%xmm1,>0ab1six=%xmm12
movdqa %xmm1,%xmm12

# qhasm: float6464 0ab1six *= SIX_SIX
# asm 1: mulpd SIX_SIX,<0ab1six=int6464#13
# asm 2: mulpd SIX_SIX,<0ab1six=%xmm12
mulpd SIX_SIX,%xmm12

# qhasm: 0t1 = 0ab1
# asm 1: movdqa <0ab1=int6464#2,>0t1=int6464#14
# asm 2: movdqa <0ab1=%xmm1,>0t1=%xmm13
movdqa %xmm1,%xmm13

# qhasm: float6464 0t1 *= *(int128 *)(0t2p + 0)
# asm 1: mulpd 0(<0t2p=int64#4),<0t1=int6464#14
# asm 2: mulpd 0(<0t2p=%rcx),<0t1=%xmm13
mulpd 0(%rcx),%xmm13

# qhasm: float6464 1r1 +=0t1
# asm 1: addpd <0t1=int6464#14,<1r1=int6464#3
# asm 2: addpd <0t1=%xmm13,<1r1=%xmm2
addpd %xmm13,%xmm2

# qhasm: 0t7 = 0ab1
# asm 1: movdqa <0ab1=int6464#2,>0t7=int6464#2
# asm 2: movdqa <0ab1=%xmm1,>0t7=%xmm1
movdqa %xmm1,%xmm1

# qhasm: float6464 0t7 *= *(int128 *)(0t2p + 96)
# asm 1: mulpd 96(<0t2p=int64#4),<0t7=int6464#2
# asm 2: mulpd 96(<0t2p=%rcx),<0t7=%xmm1
mulpd 96(%rcx),%xmm1

# qhasm: float6464 1r7 +=0t7
# asm 1: addpd <0t7=int6464#2,<1r7=int6464#9
# asm 2: addpd <0t7=%xmm1,<1r7=%xmm8
addpd %xmm1,%xmm8

# qhasm: 0t2 = 0ab1six
# asm 1: movdqa <0ab1six=int6464#13,>0t2=int6464#2
# asm 2: movdqa <0ab1six=%xmm12,>0t2=%xmm1
movdqa %xmm12,%xmm1

# qhasm: float6464 0t2 *= *(int128 *)(0t2p + 16)
# asm 1: mulpd 16(<0t2p=int64#4),<0t2=int6464#2
# asm 2: mulpd 16(<0t2p=%rcx),<0t2=%xmm1
mulpd 16(%rcx),%xmm1

# qhasm: float6464 1r2 +=0t2
# asm 1: addpd <0t2=int6464#2,<1r2=int6464#4
# asm 2: addpd <0t2=%xmm1,<1r2=%xmm3
addpd %xmm1,%xmm3

# qhasm: 0t3 = 0ab1six
# asm 1: movdqa <0ab1six=int6464#13,>0t3=int6464#2
# asm 2: movdqa <0ab1six=%xmm12,>0t3=%xmm1
movdqa %xmm12,%xmm1

# qhasm: float6464 0t3 *= *(int128 *)(0t2p + 32)
# asm 1: mulpd 32(<0t2p=int64#4),<0t3=int6464#2
# asm 2: mulpd 32(<0t2p=%rcx),<0t3=%xmm1
mulpd 32(%rcx),%xmm1

# qhasm: float6464 1r3 +=0t3
# asm 1: addpd <0t3=int6464#2,<1r3=int6464#5
# asm 2: addpd <0t3=%xmm1,<1r3=%xmm4
addpd %xmm1,%xmm4

# qhasm: 0t4 = 0ab1six
# asm 1: movdqa <0ab1six=int6464#13,>0t4=int6464#2
# asm 2: movdqa <0ab1six=%xmm12,>0t4=%xmm1
movdqa %xmm12,%xmm1

# qhasm: float6464 0t4 *= *(int128 *)(0t2p + 48)
# asm 1: mulpd 48(<0t2p=int64#4),<0t4=int6464#2
# asm 2: mulpd 48(<0t2p=%rcx),<0t4=%xmm1
mulpd 48(%rcx),%xmm1

# qhasm: float6464 1r4 +=0t4
# asm 1: addpd <0t4=int6464#2,<1r4=int6464#6
# asm 2: addpd <0t4=%xmm1,<1r4=%xmm5
addpd %xmm1,%xmm5

# qhasm: 0t5 = 0ab1six
# asm 1: movdqa <0ab1six=int6464#13,>0t5=int6464#2
# asm 2: movdqa <0ab1six=%xmm12,>0t5=%xmm1
movdqa %xmm12,%xmm1

# qhasm: float6464 0t5 *= *(int128 *)(0t2p + 64)
# asm 1: mulpd 64(<0t2p=int64#4),<0t5=int6464#2
# asm 2: mulpd 64(<0t2p=%rcx),<0t5=%xmm1
mulpd 64(%rcx),%xmm1

# qhasm: float6464 1r5 +=0t5
# asm 1: addpd <0t5=int6464#2,<1r5=int6464#7
# asm 2: addpd <0t5=%xmm1,<1r5=%xmm6
addpd %xmm1,%xmm6

# qhasm: 0t6 = 0ab1six
# asm 1: movdqa <0ab1six=int6464#13,>0t6=int6464#2
# asm 2: movdqa <0ab1six=%xmm12,>0t6=%xmm1
movdqa %xmm12,%xmm1

# qhasm: float6464 0t6 *= *(int128 *)(0t2p + 80)
# asm 1: mulpd 80(<0t2p=int64#4),<0t6=int6464#2
# asm 2: mulpd 80(<0t2p=%rcx),<0t6=%xmm1
mulpd 80(%rcx),%xmm1

# qhasm: float6464 1r6 +=0t6
# asm 1: addpd <0t6=int6464#2,<1r6=int6464#8
# asm 2: addpd <0t6=%xmm1,<1r6=%xmm7
addpd %xmm1,%xmm7

# qhasm: 0t8 = 0ab1six
# asm 1: movdqa <0ab1six=int6464#13,>0t8=int6464#2
# asm 2: movdqa <0ab1six=%xmm12,>0t8=%xmm1
movdqa %xmm12,%xmm1

# qhasm: float6464 0t8 *= *(int128 *)(0t2p + 112)
# asm 1: mulpd 112(<0t2p=int64#4),<0t8=int6464#2
# asm 2: mulpd 112(<0t2p=%rcx),<0t8=%xmm1
mulpd 112(%rcx),%xmm1

# qhasm: float6464 1r8 +=0t8
# asm 1: addpd <0t8=int6464#2,<1r8=int6464#10
# asm 2: addpd <0t8=%xmm1,<1r8=%xmm9
addpd %xmm1,%xmm9

# qhasm: 0t9 = 0ab1six
# asm 1: movdqa <0ab1six=int6464#13,>0t9=int6464#2
# asm 2: movdqa <0ab1six=%xmm12,>0t9=%xmm1
movdqa %xmm12,%xmm1

# qhasm: float6464 0t9 *= *(int128 *)(0t2p + 128)
# asm 1: mulpd 128(<0t2p=int64#4),<0t9=int6464#2
# asm 2: mulpd 128(<0t2p=%rcx),<0t9=%xmm1
mulpd 128(%rcx),%xmm1

# qhasm: float6464 1r9 +=0t9
# asm 1: addpd <0t9=int6464#2,<1r9=int6464#11
# asm 2: addpd <0t9=%xmm1,<1r9=%xmm10
addpd %xmm1,%xmm10

# qhasm: 0t10 = 0ab1six
# asm 1: movdqa <0ab1six=int6464#13,>0t10=int6464#2
# asm 2: movdqa <0ab1six=%xmm12,>0t10=%xmm1
movdqa %xmm12,%xmm1

# qhasm: float6464 0t10 *= *(int128 *)(0t2p + 144)
# asm 1: mulpd 144(<0t2p=int64#4),<0t10=int6464#2
# asm 2: mulpd 144(<0t2p=%rcx),<0t10=%xmm1
mulpd 144(%rcx),%xmm1

# qhasm: float6464 1r10 +=0t10
# asm 1: addpd <0t10=int6464#2,<1r10=int6464#12
# asm 2: addpd <0t10=%xmm1,<1r10=%xmm11
addpd %xmm1,%xmm11

# qhasm: 0t11 = 0ab1six
# asm 1: movdqa <0ab1six=int6464#13,>0t11=int6464#2
# asm 2: movdqa <0ab1six=%xmm12,>0t11=%xmm1
movdqa %xmm12,%xmm1

# qhasm: float6464 0t11 *= *(int128 *)(0t2p + 160)
# asm 1: mulpd 160(<0t2p=int64#4),<0t11=int6464#2
# asm 2: mulpd 160(<0t2p=%rcx),<0t11=%xmm1
mulpd 160(%rcx),%xmm1

# qhasm: float6464 1r11 +=0t11
# asm 1: addpd <0t11=int6464#2,<1r11=int6464#1
# asm 2: addpd <0t11=%xmm1,<1r11=%xmm0
addpd %xmm1,%xmm0

# qhasm: 0t12 = 0ab1six
# asm 1: movdqa <0ab1six=int6464#13,>0t12=int6464#2
# asm 2: movdqa <0ab1six=%xmm12,>0t12=%xmm1
movdqa %xmm12,%xmm1

# qhasm: float6464 0t12 *= *(int128 *)(0t2p + 176)
# asm 1: mulpd 176(<0t2p=int64#4),<0t12=int6464#2
# asm 2: mulpd 176(<0t2p=%rcx),<0t12=%xmm1
mulpd 176(%rcx),%xmm1

# qhasm: 0res12 =0t12
# asm 1: movdqa <0t12=int6464#2,>0res12=int6464#2
# asm 2: movdqa <0t12=%xmm1,>0res12=%xmm1
movdqa %xmm1,%xmm1

# qhasm: *(int128 *)(0resp + 16) = 1r1
# asm 1: movdqa <1r1=int6464#3,16(<0resp=int64#5)
# asm 2: movdqa <1r1=%xmm2,16(<0resp=%r8)
movdqa %xmm2,16(%r8)

# qhasm: 0ab2 = *(int128 *)(0t1p + 32)
# asm 1: movdqa 32(<0t1p=int64#2),>0ab2=int6464#3
# asm 2: movdqa 32(<0t1p=%rsi),>0ab2=%xmm2
movdqa 32(%rsi),%xmm2

# qhasm: 0ab2six = 0ab2
# asm 1: movdqa <0ab2=int6464#3,>0ab2six=int6464#13
# asm 2: movdqa <0ab2=%xmm2,>0ab2six=%xmm12
movdqa %xmm2,%xmm12

# qhasm: float6464 0ab2six *= SIX_SIX
# asm 1: mulpd SIX_SIX,<0ab2six=int6464#13
# asm 2: mulpd SIX_SIX,<0ab2six=%xmm12
mulpd SIX_SIX,%xmm12

# qhasm: 0t2 = 0ab2
# asm 1: movdqa <0ab2=int6464#3,>0t2=int6464#14
# asm 2: movdqa <0ab2=%xmm2,>0t2=%xmm13
movdqa %xmm2,%xmm13

# qhasm: float6464 0t2 *= *(int128 *)(0t2p + 0)
# asm 1: mulpd 0(<0t2p=int64#4),<0t2=int6464#14
# asm 2: mulpd 0(<0t2p=%rcx),<0t2=%xmm13
mulpd 0(%rcx),%xmm13

# qhasm: float6464 1r2 +=0t2
# asm 1: addpd <0t2=int6464#14,<1r2=int6464#4
# asm 2: addpd <0t2=%xmm13,<1r2=%xmm3
addpd %xmm13,%xmm3

# qhasm: 0t7 = 0ab2
# asm 1: movdqa <0ab2=int6464#3,>0t7=int6464#14
# asm 2: movdqa <0ab2=%xmm2,>0t7=%xmm13
movdqa %xmm2,%xmm13

# qhasm: float6464 0t7 *= *(int128 *)(0t2p + 80)
# asm 1: mulpd 80(<0t2p=int64#4),<0t7=int6464#14
# asm 2: mulpd 80(<0t2p=%rcx),<0t7=%xmm13
mulpd 80(%rcx),%xmm13

# qhasm: float6464 1r7 +=0t7
# asm 1: addpd <0t7=int6464#14,<1r7=int6464#9
# asm 2: addpd <0t7=%xmm13,<1r7=%xmm8
addpd %xmm13,%xmm8

# qhasm: 0t8 = 0ab2
# asm 1: movdqa <0ab2=int6464#3,>0t8=int6464#14
# asm 2: movdqa <0ab2=%xmm2,>0t8=%xmm13
movdqa %xmm2,%xmm13

# qhasm: float6464 0t8 *= *(int128 *)(0t2p + 96)
# asm 1: mulpd 96(<0t2p=int64#4),<0t8=int6464#14
# asm 2: mulpd 96(<0t2p=%rcx),<0t8=%xmm13
mulpd 96(%rcx),%xmm13

# qhasm: float6464 1r8 +=0t8
# asm 1: addpd <0t8=int6464#14,<1r8=int6464#10
# asm 2: addpd <0t8=%xmm13,<1r8=%xmm9
addpd %xmm13,%xmm9

# qhasm: 0t13 = 0ab2
# asm 1: movdqa <0ab2=int6464#3,>0t13=int6464#3
# asm 2: movdqa <0ab2=%xmm2,>0t13=%xmm2
movdqa %xmm2,%xmm2

# qhasm: float6464 0t13 *= *(int128 *)(0t2p + 176)
# asm 1: mulpd 176(<0t2p=int64#4),<0t13=int6464#3
# asm 2: mulpd 176(<0t2p=%rcx),<0t13=%xmm2
mulpd 176(%rcx),%xmm2

# qhasm: 0res13 =0t13
# asm 1: movdqa <0t13=int6464#3,>0res13=int6464#3
# asm 2: movdqa <0t13=%xmm2,>0res13=%xmm2
movdqa %xmm2,%xmm2

# qhasm: 0t3 = 0ab2six
# asm 1: movdqa <0ab2six=int6464#13,>0t3=int6464#14
# asm 2: movdqa <0ab2six=%xmm12,>0t3=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t3 *= *(int128 *)(0t2p + 16)
# asm 1: mulpd 16(<0t2p=int64#4),<0t3=int6464#14
# asm 2: mulpd 16(<0t2p=%rcx),<0t3=%xmm13
mulpd 16(%rcx),%xmm13

# qhasm: float6464 1r3 +=0t3
# asm 1: addpd <0t3=int6464#14,<1r3=int6464#5
# asm 2: addpd <0t3=%xmm13,<1r3=%xmm4
addpd %xmm13,%xmm4

# qhasm: 0t4 = 0ab2six
# asm 1: movdqa <0ab2six=int6464#13,>0t4=int6464#14
# asm 2: movdqa <0ab2six=%xmm12,>0t4=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t4 *= *(int128 *)(0t2p + 32)
# asm 1: mulpd 32(<0t2p=int64#4),<0t4=int6464#14
# asm 2: mulpd 32(<0t2p=%rcx),<0t4=%xmm13
mulpd 32(%rcx),%xmm13

# qhasm: float6464 1r4 +=0t4
# asm 1: addpd <0t4=int6464#14,<1r4=int6464#6
# asm 2: addpd <0t4=%xmm13,<1r4=%xmm5
addpd %xmm13,%xmm5

# qhasm: 0t5 = 0ab2six
# asm 1: movdqa <0ab2six=int6464#13,>0t5=int6464#14
# asm 2: movdqa <0ab2six=%xmm12,>0t5=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t5 *= *(int128 *)(0t2p + 48)
# asm 1: mulpd 48(<0t2p=int64#4),<0t5=int6464#14
# asm 2: mulpd 48(<0t2p=%rcx),<0t5=%xmm13
mulpd 48(%rcx),%xmm13

# qhasm: float6464 1r5 +=0t5
# asm 1: addpd <0t5=int6464#14,<1r5=int6464#7
# asm 2: addpd <0t5=%xmm13,<1r5=%xmm6
addpd %xmm13,%xmm6

# qhasm: 0t6 = 0ab2six
# asm 1: movdqa <0ab2six=int6464#13,>0t6=int6464#14
# asm 2: movdqa <0ab2six=%xmm12,>0t6=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t6 *= *(int128 *)(0t2p + 64)
# asm 1: mulpd 64(<0t2p=int64#4),<0t6=int6464#14
# asm 2: mulpd 64(<0t2p=%rcx),<0t6=%xmm13
mulpd 64(%rcx),%xmm13

# qhasm: float6464 1r6 +=0t6
# asm 1: addpd <0t6=int6464#14,<1r6=int6464#8
# asm 2: addpd <0t6=%xmm13,<1r6=%xmm7
addpd %xmm13,%xmm7

# qhasm: 0t9 = 0ab2six
# asm 1: movdqa <0ab2six=int6464#13,>0t9=int6464#14
# asm 2: movdqa <0ab2six=%xmm12,>0t9=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t9 *= *(int128 *)(0t2p + 112)
# asm 1: mulpd 112(<0t2p=int64#4),<0t9=int6464#14
# asm 2: mulpd 112(<0t2p=%rcx),<0t9=%xmm13
mulpd 112(%rcx),%xmm13

# qhasm: float6464 1r9 +=0t9
# asm 1: addpd <0t9=int6464#14,<1r9=int6464#11
# asm 2: addpd <0t9=%xmm13,<1r9=%xmm10
addpd %xmm13,%xmm10

# qhasm: 0t10 = 0ab2six
# asm 1: movdqa <0ab2six=int6464#13,>0t10=int6464#14
# asm 2: movdqa <0ab2six=%xmm12,>0t10=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t10 *= *(int128 *)(0t2p + 128)
# asm 1: mulpd 128(<0t2p=int64#4),<0t10=int6464#14
# asm 2: mulpd 128(<0t2p=%rcx),<0t10=%xmm13
mulpd 128(%rcx),%xmm13

# qhasm: float6464 1r10 +=0t10
# asm 1: addpd <0t10=int6464#14,<1r10=int6464#12
# asm 2: addpd <0t10=%xmm13,<1r10=%xmm11
addpd %xmm13,%xmm11

# qhasm: 0t11 = 0ab2six
# asm 1: movdqa <0ab2six=int6464#13,>0t11=int6464#14
# asm 2: movdqa <0ab2six=%xmm12,>0t11=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t11 *= *(int128 *)(0t2p + 144)
# asm 1: mulpd 144(<0t2p=int64#4),<0t11=int6464#14
# asm 2: mulpd 144(<0t2p=%rcx),<0t11=%xmm13
mulpd 144(%rcx),%xmm13

# qhasm: float6464 1r11 +=0t11
# asm 1: addpd <0t11=int6464#14,<1r11=int6464#1
# asm 2: addpd <0t11=%xmm13,<1r11=%xmm0
addpd %xmm13,%xmm0

# qhasm: 0t12 = 0ab2six
# asm 1: movdqa <0ab2six=int6464#13,>0t12=int6464#13
# asm 2: movdqa <0ab2six=%xmm12,>0t12=%xmm12
movdqa %xmm12,%xmm12

# qhasm: float6464 0t12 *= *(int128 *)(0t2p + 160)
# asm 1: mulpd 160(<0t2p=int64#4),<0t12=int6464#13
# asm 2: mulpd 160(<0t2p=%rcx),<0t12=%xmm12
mulpd 160(%rcx),%xmm12

# qhasm: float6464 0res12 +=0t12
# asm 1: addpd <0t12=int6464#13,<0res12=int6464#2
# asm 2: addpd <0t12=%xmm12,<0res12=%xmm1
addpd %xmm12,%xmm1

# qhasm: *(int128 *)(0resp + 32) = 1r2
# asm 1: movdqa <1r2=int6464#4,32(<0resp=int64#5)
# asm 2: movdqa <1r2=%xmm3,32(<0resp=%r8)
movdqa %xmm3,32(%r8)

# qhasm: 0ab3 = *(int128 *)(0t1p + 48)
# asm 1: movdqa 48(<0t1p=int64#2),>0ab3=int6464#4
# asm 2: movdqa 48(<0t1p=%rsi),>0ab3=%xmm3
movdqa 48(%rsi),%xmm3

# qhasm: 0ab3six = 0ab3
# asm 1: movdqa <0ab3=int6464#4,>0ab3six=int6464#13
# asm 2: movdqa <0ab3=%xmm3,>0ab3six=%xmm12
movdqa %xmm3,%xmm12

# qhasm: float6464 0ab3six *= SIX_SIX
# asm 1: mulpd SIX_SIX,<0ab3six=int6464#13
# asm 2: mulpd SIX_SIX,<0ab3six=%xmm12
mulpd SIX_SIX,%xmm12

# qhasm: 0t3 = 0ab3
# asm 1: movdqa <0ab3=int6464#4,>0t3=int6464#14
# asm 2: movdqa <0ab3=%xmm3,>0t3=%xmm13
movdqa %xmm3,%xmm13

# qhasm: float6464 0t3 *= *(int128 *)(0t2p + 0)
# asm 1: mulpd 0(<0t2p=int64#4),<0t3=int6464#14
# asm 2: mulpd 0(<0t2p=%rcx),<0t3=%xmm13
mulpd 0(%rcx),%xmm13

# qhasm: float6464 1r3 +=0t3
# asm 1: addpd <0t3=int6464#14,<1r3=int6464#5
# asm 2: addpd <0t3=%xmm13,<1r3=%xmm4
addpd %xmm13,%xmm4

# qhasm: 0t7 = 0ab3
# asm 1: movdqa <0ab3=int6464#4,>0t7=int6464#14
# asm 2: movdqa <0ab3=%xmm3,>0t7=%xmm13
movdqa %xmm3,%xmm13

# qhasm: float6464 0t7 *= *(int128 *)(0t2p + 64)
# asm 1: mulpd 64(<0t2p=int64#4),<0t7=int6464#14
# asm 2: mulpd 64(<0t2p=%rcx),<0t7=%xmm13
mulpd 64(%rcx),%xmm13

# qhasm: float6464 1r7 +=0t7
# asm 1: addpd <0t7=int6464#14,<1r7=int6464#9
# asm 2: addpd <0t7=%xmm13,<1r7=%xmm8
addpd %xmm13,%xmm8

# qhasm: 0t8 = 0ab3
# asm 1: movdqa <0ab3=int6464#4,>0t8=int6464#14
# asm 2: movdqa <0ab3=%xmm3,>0t8=%xmm13
movdqa %xmm3,%xmm13

# qhasm: float6464 0t8 *= *(int128 *)(0t2p + 80)
# asm 1: mulpd 80(<0t2p=int64#4),<0t8=int6464#14
# asm 2: mulpd 80(<0t2p=%rcx),<0t8=%xmm13
mulpd 80(%rcx),%xmm13

# qhasm: float6464 1r8 +=0t8
# asm 1: addpd <0t8=int6464#14,<1r8=int6464#10
# asm 2: addpd <0t8=%xmm13,<1r8=%xmm9
addpd %xmm13,%xmm9

# qhasm: 0t9 = 0ab3
# asm 1: movdqa <0ab3=int6464#4,>0t9=int6464#14
# asm 2: movdqa <0ab3=%xmm3,>0t9=%xmm13
movdqa %xmm3,%xmm13

# qhasm: float6464 0t9 *= *(int128 *)(0t2p + 96)
# asm 1: mulpd 96(<0t2p=int64#4),<0t9=int6464#14
# asm 2: mulpd 96(<0t2p=%rcx),<0t9=%xmm13
mulpd 96(%rcx),%xmm13

# qhasm: float6464 1r9 +=0t9
# asm 1: addpd <0t9=int6464#14,<1r9=int6464#11
# asm 2: addpd <0t9=%xmm13,<1r9=%xmm10
addpd %xmm13,%xmm10

# qhasm: 0t13 = 0ab3
# asm 1: movdqa <0ab3=int6464#4,>0t13=int6464#14
# asm 2: movdqa <0ab3=%xmm3,>0t13=%xmm13
movdqa %xmm3,%xmm13

# qhasm: float6464 0t13 *= *(int128 *)(0t2p + 160)
# asm 1: mulpd 160(<0t2p=int64#4),<0t13=int6464#14
# asm 2: mulpd 160(<0t2p=%rcx),<0t13=%xmm13
mulpd 160(%rcx),%xmm13

# qhasm: float6464 0res13 +=0t13
# asm 1: addpd <0t13=int6464#14,<0res13=int6464#3
# asm 2: addpd <0t13=%xmm13,<0res13=%xmm2
addpd %xmm13,%xmm2

# qhasm: 0t14 = 0ab3
# asm 1: movdqa <0ab3=int6464#4,>0t14=int6464#4
# asm 2: movdqa <0ab3=%xmm3,>0t14=%xmm3
movdqa %xmm3,%xmm3

# qhasm: float6464 0t14 *= *(int128 *)(0t2p + 176)
# asm 1: mulpd 176(<0t2p=int64#4),<0t14=int6464#4
# asm 2: mulpd 176(<0t2p=%rcx),<0t14=%xmm3
mulpd 176(%rcx),%xmm3

# qhasm: 0res14 =0t14
# asm 1: movdqa <0t14=int6464#4,>0res14=int6464#4
# asm 2: movdqa <0t14=%xmm3,>0res14=%xmm3
movdqa %xmm3,%xmm3

# qhasm: 0t4 = 0ab3six
# asm 1: movdqa <0ab3six=int6464#13,>0t4=int6464#14
# asm 2: movdqa <0ab3six=%xmm12,>0t4=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t4 *= *(int128 *)(0t2p + 16)
# asm 1: mulpd 16(<0t2p=int64#4),<0t4=int6464#14
# asm 2: mulpd 16(<0t2p=%rcx),<0t4=%xmm13
mulpd 16(%rcx),%xmm13

# qhasm: float6464 1r4 +=0t4
# asm 1: addpd <0t4=int6464#14,<1r4=int6464#6
# asm 2: addpd <0t4=%xmm13,<1r4=%xmm5
addpd %xmm13,%xmm5

# qhasm: 0t5 = 0ab3six
# asm 1: movdqa <0ab3six=int6464#13,>0t5=int6464#14
# asm 2: movdqa <0ab3six=%xmm12,>0t5=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t5 *= *(int128 *)(0t2p + 32)
# asm 1: mulpd 32(<0t2p=int64#4),<0t5=int6464#14
# asm 2: mulpd 32(<0t2p=%rcx),<0t5=%xmm13
mulpd 32(%rcx),%xmm13

# qhasm: float6464 1r5 +=0t5
# asm 1: addpd <0t5=int6464#14,<1r5=int6464#7
# asm 2: addpd <0t5=%xmm13,<1r5=%xmm6
addpd %xmm13,%xmm6

# qhasm: 0t6 = 0ab3six
# asm 1: movdqa <0ab3six=int6464#13,>0t6=int6464#14
# asm 2: movdqa <0ab3six=%xmm12,>0t6=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t6 *= *(int128 *)(0t2p + 48)
# asm 1: mulpd 48(<0t2p=int64#4),<0t6=int6464#14
# asm 2: mulpd 48(<0t2p=%rcx),<0t6=%xmm13
mulpd 48(%rcx),%xmm13

# qhasm: float6464 1r6 +=0t6
# asm 1: addpd <0t6=int6464#14,<1r6=int6464#8
# asm 2: addpd <0t6=%xmm13,<1r6=%xmm7
addpd %xmm13,%xmm7

# qhasm: 0t10 = 0ab3six
# asm 1: movdqa <0ab3six=int6464#13,>0t10=int6464#14
# asm 2: movdqa <0ab3six=%xmm12,>0t10=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t10 *= *(int128 *)(0t2p + 112)
# asm 1: mulpd 112(<0t2p=int64#4),<0t10=int6464#14
# asm 2: mulpd 112(<0t2p=%rcx),<0t10=%xmm13
mulpd 112(%rcx),%xmm13

# qhasm: float6464 1r10 +=0t10
# asm 1: addpd <0t10=int6464#14,<1r10=int6464#12
# asm 2: addpd <0t10=%xmm13,<1r10=%xmm11
addpd %xmm13,%xmm11

# qhasm: 0t11 = 0ab3six
# asm 1: movdqa <0ab3six=int6464#13,>0t11=int6464#14
# asm 2: movdqa <0ab3six=%xmm12,>0t11=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t11 *= *(int128 *)(0t2p + 128)
# asm 1: mulpd 128(<0t2p=int64#4),<0t11=int6464#14
# asm 2: mulpd 128(<0t2p=%rcx),<0t11=%xmm13
mulpd 128(%rcx),%xmm13

# qhasm: float6464 1r11 +=0t11
# asm 1: addpd <0t11=int6464#14,<1r11=int6464#1
# asm 2: addpd <0t11=%xmm13,<1r11=%xmm0
addpd %xmm13,%xmm0

# qhasm: 0t12 = 0ab3six
# asm 1: movdqa <0ab3six=int6464#13,>0t12=int6464#13
# asm 2: movdqa <0ab3six=%xmm12,>0t12=%xmm12
movdqa %xmm12,%xmm12

# qhasm: float6464 0t12 *= *(int128 *)(0t2p + 144)
# asm 1: mulpd 144(<0t2p=int64#4),<0t12=int6464#13
# asm 2: mulpd 144(<0t2p=%rcx),<0t12=%xmm12
mulpd 144(%rcx),%xmm12

# qhasm: float6464 0res12 +=0t12
# asm 1: addpd <0t12=int6464#13,<0res12=int6464#2
# asm 2: addpd <0t12=%xmm12,<0res12=%xmm1
addpd %xmm12,%xmm1

# qhasm: *(int128 *)(0resp + 48) = 1r3
# asm 1: movdqa <1r3=int6464#5,48(<0resp=int64#5)
# asm 2: movdqa <1r3=%xmm4,48(<0resp=%r8)
movdqa %xmm4,48(%r8)

# qhasm: 0ab4 = *(int128 *)(0t1p + 64)
# asm 1: movdqa 64(<0t1p=int64#2),>0ab4=int6464#5
# asm 2: movdqa 64(<0t1p=%rsi),>0ab4=%xmm4
movdqa 64(%rsi),%xmm4

# qhasm: 0ab4six = 0ab4
# asm 1: movdqa <0ab4=int6464#5,>0ab4six=int6464#13
# asm 2: movdqa <0ab4=%xmm4,>0ab4six=%xmm12
movdqa %xmm4,%xmm12

# qhasm: float6464 0ab4six *= SIX_SIX
# asm 1: mulpd SIX_SIX,<0ab4six=int6464#13
# asm 2: mulpd SIX_SIX,<0ab4six=%xmm12
mulpd SIX_SIX,%xmm12

# qhasm: 0t4 = 0ab4
# asm 1: movdqa <0ab4=int6464#5,>0t4=int6464#14
# asm 2: movdqa <0ab4=%xmm4,>0t4=%xmm13
movdqa %xmm4,%xmm13

# qhasm: float6464 0t4 *= *(int128 *)(0t2p + 0)
# asm 1: mulpd 0(<0t2p=int64#4),<0t4=int6464#14
# asm 2: mulpd 0(<0t2p=%rcx),<0t4=%xmm13
mulpd 0(%rcx),%xmm13

# qhasm: float6464 1r4 +=0t4
# asm 1: addpd <0t4=int6464#14,<1r4=int6464#6
# asm 2: addpd <0t4=%xmm13,<1r4=%xmm5
addpd %xmm13,%xmm5

# qhasm: 0t7 = 0ab4
# asm 1: movdqa <0ab4=int6464#5,>0t7=int6464#14
# asm 2: movdqa <0ab4=%xmm4,>0t7=%xmm13
movdqa %xmm4,%xmm13

# qhasm: float6464 0t7 *= *(int128 *)(0t2p + 48)
# asm 1: mulpd 48(<0t2p=int64#4),<0t7=int6464#14
# asm 2: mulpd 48(<0t2p=%rcx),<0t7=%xmm13
mulpd 48(%rcx),%xmm13

# qhasm: float6464 1r7 +=0t7
# asm 1: addpd <0t7=int6464#14,<1r7=int6464#9
# asm 2: addpd <0t7=%xmm13,<1r7=%xmm8
addpd %xmm13,%xmm8

# qhasm: 0t8 = 0ab4
# asm 1: movdqa <0ab4=int6464#5,>0t8=int6464#14
# asm 2: movdqa <0ab4=%xmm4,>0t8=%xmm13
movdqa %xmm4,%xmm13

# qhasm: float6464 0t8 *= *(int128 *)(0t2p + 64)
# asm 1: mulpd 64(<0t2p=int64#4),<0t8=int6464#14
# asm 2: mulpd 64(<0t2p=%rcx),<0t8=%xmm13
mulpd 64(%rcx),%xmm13

# qhasm: float6464 1r8 +=0t8
# asm 1: addpd <0t8=int6464#14,<1r8=int6464#10
# asm 2: addpd <0t8=%xmm13,<1r8=%xmm9
addpd %xmm13,%xmm9

# qhasm: 0t9 = 0ab4
# asm 1: movdqa <0ab4=int6464#5,>0t9=int6464#14
# asm 2: movdqa <0ab4=%xmm4,>0t9=%xmm13
movdqa %xmm4,%xmm13

# qhasm: float6464 0t9 *= *(int128 *)(0t2p + 80)
# asm 1: mulpd 80(<0t2p=int64#4),<0t9=int6464#14
# asm 2: mulpd 80(<0t2p=%rcx),<0t9=%xmm13
mulpd 80(%rcx),%xmm13

# qhasm: float6464 1r9 +=0t9
# asm 1: addpd <0t9=int6464#14,<1r9=int6464#11
# asm 2: addpd <0t9=%xmm13,<1r9=%xmm10
addpd %xmm13,%xmm10

# qhasm: 0t10 = 0ab4
# asm 1: movdqa <0ab4=int6464#5,>0t10=int6464#14
# asm 2: movdqa <0ab4=%xmm4,>0t10=%xmm13
movdqa %xmm4,%xmm13

# qhasm: float6464 0t10 *= *(int128 *)(0t2p + 96)
# asm 1: mulpd 96(<0t2p=int64#4),<0t10=int6464#14
# asm 2: mulpd 96(<0t2p=%rcx),<0t10=%xmm13
mulpd 96(%rcx),%xmm13

# qhasm: float6464 1r10 +=0t10
# asm 1: addpd <0t10=int6464#14,<1r10=int6464#12
# asm 2: addpd <0t10=%xmm13,<1r10=%xmm11
addpd %xmm13,%xmm11

# qhasm: 0t13 = 0ab4
# asm 1: movdqa <0ab4=int6464#5,>0t13=int6464#14
# asm 2: movdqa <0ab4=%xmm4,>0t13=%xmm13
movdqa %xmm4,%xmm13

# qhasm: float6464 0t13 *= *(int128 *)(0t2p + 144)
# asm 1: mulpd 144(<0t2p=int64#4),<0t13=int6464#14
# asm 2: mulpd 144(<0t2p=%rcx),<0t13=%xmm13
mulpd 144(%rcx),%xmm13

# qhasm: float6464 0res13 +=0t13
# asm 1: addpd <0t13=int6464#14,<0res13=int6464#3
# asm 2: addpd <0t13=%xmm13,<0res13=%xmm2
addpd %xmm13,%xmm2

# qhasm: 0t14 = 0ab4
# asm 1: movdqa <0ab4=int6464#5,>0t14=int6464#14
# asm 2: movdqa <0ab4=%xmm4,>0t14=%xmm13
movdqa %xmm4,%xmm13

# qhasm: float6464 0t14 *= *(int128 *)(0t2p + 160)
# asm 1: mulpd 160(<0t2p=int64#4),<0t14=int6464#14
# asm 2: mulpd 160(<0t2p=%rcx),<0t14=%xmm13
mulpd 160(%rcx),%xmm13

# qhasm: float6464 0res14 +=0t14
# asm 1: addpd <0t14=int6464#14,<0res14=int6464#4
# asm 2: addpd <0t14=%xmm13,<0res14=%xmm3
addpd %xmm13,%xmm3

# qhasm: 0t15 = 0ab4
# asm 1: movdqa <0ab4=int6464#5,>0t15=int6464#5
# asm 2: movdqa <0ab4=%xmm4,>0t15=%xmm4
movdqa %xmm4,%xmm4

# qhasm: float6464 0t15 *= *(int128 *)(0t2p + 176)
# asm 1: mulpd 176(<0t2p=int64#4),<0t15=int6464#5
# asm 2: mulpd 176(<0t2p=%rcx),<0t15=%xmm4
mulpd 176(%rcx),%xmm4

# qhasm: 0res15 =0t15
# asm 1: movdqa <0t15=int6464#5,>0res15=int6464#5
# asm 2: movdqa <0t15=%xmm4,>0res15=%xmm4
movdqa %xmm4,%xmm4

# qhasm: 0t5 = 0ab4six
# asm 1: movdqa <0ab4six=int6464#13,>0t5=int6464#14
# asm 2: movdqa <0ab4six=%xmm12,>0t5=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t5 *= *(int128 *)(0t2p + 16)
# asm 1: mulpd 16(<0t2p=int64#4),<0t5=int6464#14
# asm 2: mulpd 16(<0t2p=%rcx),<0t5=%xmm13
mulpd 16(%rcx),%xmm13

# qhasm: float6464 1r5 +=0t5
# asm 1: addpd <0t5=int6464#14,<1r5=int6464#7
# asm 2: addpd <0t5=%xmm13,<1r5=%xmm6
addpd %xmm13,%xmm6

# qhasm: 0t6 = 0ab4six
# asm 1: movdqa <0ab4six=int6464#13,>0t6=int6464#14
# asm 2: movdqa <0ab4six=%xmm12,>0t6=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t6 *= *(int128 *)(0t2p + 32)
# asm 1: mulpd 32(<0t2p=int64#4),<0t6=int6464#14
# asm 2: mulpd 32(<0t2p=%rcx),<0t6=%xmm13
mulpd 32(%rcx),%xmm13

# qhasm: float6464 1r6 +=0t6
# asm 1: addpd <0t6=int6464#14,<1r6=int6464#8
# asm 2: addpd <0t6=%xmm13,<1r6=%xmm7
addpd %xmm13,%xmm7

# qhasm: 0t11 = 0ab4six
# asm 1: movdqa <0ab4six=int6464#13,>0t11=int6464#14
# asm 2: movdqa <0ab4six=%xmm12,>0t11=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t11 *= *(int128 *)(0t2p + 112)
# asm 1: mulpd 112(<0t2p=int64#4),<0t11=int6464#14
# asm 2: mulpd 112(<0t2p=%rcx),<0t11=%xmm13
mulpd 112(%rcx),%xmm13

# qhasm: float6464 1r11 +=0t11
# asm 1: addpd <0t11=int6464#14,<1r11=int6464#1
# asm 2: addpd <0t11=%xmm13,<1r11=%xmm0
addpd %xmm13,%xmm0

# qhasm: 0t12 = 0ab4six
# asm 1: movdqa <0ab4six=int6464#13,>0t12=int6464#13
# asm 2: movdqa <0ab4six=%xmm12,>0t12=%xmm12
movdqa %xmm12,%xmm12

# qhasm: float6464 0t12 *= *(int128 *)(0t2p + 128)
# asm 1: mulpd 128(<0t2p=int64#4),<0t12=int6464#13
# asm 2: mulpd 128(<0t2p=%rcx),<0t12=%xmm12
mulpd 128(%rcx),%xmm12

# qhasm: float6464 0res12 +=0t12
# asm 1: addpd <0t12=int6464#13,<0res12=int6464#2
# asm 2: addpd <0t12=%xmm12,<0res12=%xmm1
addpd %xmm12,%xmm1

# qhasm: *(int128 *)(0resp + 64) = 1r4
# asm 1: movdqa <1r4=int6464#6,64(<0resp=int64#5)
# asm 2: movdqa <1r4=%xmm5,64(<0resp=%r8)
movdqa %xmm5,64(%r8)

# qhasm: 0ab5 = *(int128 *)(0t1p + 80)
# asm 1: movdqa 80(<0t1p=int64#2),>0ab5=int6464#6
# asm 2: movdqa 80(<0t1p=%rsi),>0ab5=%xmm5
movdqa 80(%rsi),%xmm5

# qhasm: 0ab5six = 0ab5
# asm 1: movdqa <0ab5=int6464#6,>0ab5six=int6464#13
# asm 2: movdqa <0ab5=%xmm5,>0ab5six=%xmm12
movdqa %xmm5,%xmm12

# qhasm: float6464 0ab5six *= SIX_SIX
# asm 1: mulpd SIX_SIX,<0ab5six=int6464#13
# asm 2: mulpd SIX_SIX,<0ab5six=%xmm12
mulpd SIX_SIX,%xmm12

# qhasm: 0t5 = 0ab5
# asm 1: movdqa <0ab5=int6464#6,>0t5=int6464#14
# asm 2: movdqa <0ab5=%xmm5,>0t5=%xmm13
movdqa %xmm5,%xmm13

# qhasm: float6464 0t5 *= *(int128 *)(0t2p + 0)
# asm 1: mulpd 0(<0t2p=int64#4),<0t5=int6464#14
# asm 2: mulpd 0(<0t2p=%rcx),<0t5=%xmm13
mulpd 0(%rcx),%xmm13

# qhasm: float6464 1r5 +=0t5
# asm 1: addpd <0t5=int6464#14,<1r5=int6464#7
# asm 2: addpd <0t5=%xmm13,<1r5=%xmm6
addpd %xmm13,%xmm6

# qhasm: 0t7 = 0ab5
# asm 1: movdqa <0ab5=int6464#6,>0t7=int6464#14
# asm 2: movdqa <0ab5=%xmm5,>0t7=%xmm13
movdqa %xmm5,%xmm13

# qhasm: float6464 0t7 *= *(int128 *)(0t2p + 32)
# asm 1: mulpd 32(<0t2p=int64#4),<0t7=int6464#14
# asm 2: mulpd 32(<0t2p=%rcx),<0t7=%xmm13
mulpd 32(%rcx),%xmm13

# qhasm: float6464 1r7 +=0t7
# asm 1: addpd <0t7=int6464#14,<1r7=int6464#9
# asm 2: addpd <0t7=%xmm13,<1r7=%xmm8
addpd %xmm13,%xmm8

# qhasm: 0t8 = 0ab5
# asm 1: movdqa <0ab5=int6464#6,>0t8=int6464#14
# asm 2: movdqa <0ab5=%xmm5,>0t8=%xmm13
movdqa %xmm5,%xmm13

# qhasm: float6464 0t8 *= *(int128 *)(0t2p + 48)
# asm 1: mulpd 48(<0t2p=int64#4),<0t8=int6464#14
# asm 2: mulpd 48(<0t2p=%rcx),<0t8=%xmm13
mulpd 48(%rcx),%xmm13

# qhasm: float6464 1r8 +=0t8
# asm 1: addpd <0t8=int6464#14,<1r8=int6464#10
# asm 2: addpd <0t8=%xmm13,<1r8=%xmm9
addpd %xmm13,%xmm9

# qhasm: 0t9 = 0ab5
# asm 1: movdqa <0ab5=int6464#6,>0t9=int6464#14
# asm 2: movdqa <0ab5=%xmm5,>0t9=%xmm13
movdqa %xmm5,%xmm13

# qhasm: float6464 0t9 *= *(int128 *)(0t2p + 64)
# asm 1: mulpd 64(<0t2p=int64#4),<0t9=int6464#14
# asm 2: mulpd 64(<0t2p=%rcx),<0t9=%xmm13
mulpd 64(%rcx),%xmm13

# qhasm: float6464 1r9 +=0t9
# asm 1: addpd <0t9=int6464#14,<1r9=int6464#11
# asm 2: addpd <0t9=%xmm13,<1r9=%xmm10
addpd %xmm13,%xmm10

# qhasm: 0t10 = 0ab5
# asm 1: movdqa <0ab5=int6464#6,>0t10=int6464#14
# asm 2: movdqa <0ab5=%xmm5,>0t10=%xmm13
movdqa %xmm5,%xmm13

# qhasm: float6464 0t10 *= *(int128 *)(0t2p + 80)
# asm 1: mulpd 80(<0t2p=int64#4),<0t10=int6464#14
# asm 2: mulpd 80(<0t2p=%rcx),<0t10=%xmm13
mulpd 80(%rcx),%xmm13

# qhasm: float6464 1r10 +=0t10
# asm 1: addpd <0t10=int6464#14,<1r10=int6464#12
# asm 2: addpd <0t10=%xmm13,<1r10=%xmm11
addpd %xmm13,%xmm11

# qhasm: 0t11 = 0ab5
# asm 1: movdqa <0ab5=int6464#6,>0t11=int6464#14
# asm 2: movdqa <0ab5=%xmm5,>0t11=%xmm13
movdqa %xmm5,%xmm13

# qhasm: float6464 0t11 *= *(int128 *)(0t2p + 96)
# asm 1: mulpd 96(<0t2p=int64#4),<0t11=int6464#14
# asm 2: mulpd 96(<0t2p=%rcx),<0t11=%xmm13
mulpd 96(%rcx),%xmm13

# qhasm: float6464 1r11 +=0t11
# asm 1: addpd <0t11=int6464#14,<1r11=int6464#1
# asm 2: addpd <0t11=%xmm13,<1r11=%xmm0
addpd %xmm13,%xmm0

# qhasm: 0t13 = 0ab5
# asm 1: movdqa <0ab5=int6464#6,>0t13=int6464#14
# asm 2: movdqa <0ab5=%xmm5,>0t13=%xmm13
movdqa %xmm5,%xmm13

# qhasm: float6464 0t13 *= *(int128 *)(0t2p + 128)
# asm 1: mulpd 128(<0t2p=int64#4),<0t13=int6464#14
# asm 2: mulpd 128(<0t2p=%rcx),<0t13=%xmm13
mulpd 128(%rcx),%xmm13

# qhasm: float6464 0res13 +=0t13
# asm 1: addpd <0t13=int6464#14,<0res13=int6464#3
# asm 2: addpd <0t13=%xmm13,<0res13=%xmm2
addpd %xmm13,%xmm2

# qhasm: 0t14 = 0ab5
# asm 1: movdqa <0ab5=int6464#6,>0t14=int6464#14
# asm 2: movdqa <0ab5=%xmm5,>0t14=%xmm13
movdqa %xmm5,%xmm13

# qhasm: float6464 0t14 *= *(int128 *)(0t2p + 144)
# asm 1: mulpd 144(<0t2p=int64#4),<0t14=int6464#14
# asm 2: mulpd 144(<0t2p=%rcx),<0t14=%xmm13
mulpd 144(%rcx),%xmm13

# qhasm: float6464 0res14 +=0t14
# asm 1: addpd <0t14=int6464#14,<0res14=int6464#4
# asm 2: addpd <0t14=%xmm13,<0res14=%xmm3
addpd %xmm13,%xmm3

# qhasm: 0t15 = 0ab5
# asm 1: movdqa <0ab5=int6464#6,>0t15=int6464#14
# asm 2: movdqa <0ab5=%xmm5,>0t15=%xmm13
movdqa %xmm5,%xmm13

# qhasm: float6464 0t15 *= *(int128 *)(0t2p + 160)
# asm 1: mulpd 160(<0t2p=int64#4),<0t15=int6464#14
# asm 2: mulpd 160(<0t2p=%rcx),<0t15=%xmm13
mulpd 160(%rcx),%xmm13

# qhasm: float6464 0res15 +=0t15
# asm 1: addpd <0t15=int6464#14,<0res15=int6464#5
# asm 2: addpd <0t15=%xmm13,<0res15=%xmm4
addpd %xmm13,%xmm4

# qhasm: 0t16 = 0ab5
# asm 1: movdqa <0ab5=int6464#6,>0t16=int6464#6
# asm 2: movdqa <0ab5=%xmm5,>0t16=%xmm5
movdqa %xmm5,%xmm5

# qhasm: float6464 0t16 *= *(int128 *)(0t2p + 176)
# asm 1: mulpd 176(<0t2p=int64#4),<0t16=int6464#6
# asm 2: mulpd 176(<0t2p=%rcx),<0t16=%xmm5
mulpd 176(%rcx),%xmm5

# qhasm: 0res16 =0t16
# asm 1: movdqa <0t16=int6464#6,>0res16=int6464#6
# asm 2: movdqa <0t16=%xmm5,>0res16=%xmm5
movdqa %xmm5,%xmm5

# qhasm: 0t6 = 0ab5six
# asm 1: movdqa <0ab5six=int6464#13,>0t6=int6464#14
# asm 2: movdqa <0ab5six=%xmm12,>0t6=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t6 *= *(int128 *)(0t2p + 16)
# asm 1: mulpd 16(<0t2p=int64#4),<0t6=int6464#14
# asm 2: mulpd 16(<0t2p=%rcx),<0t6=%xmm13
mulpd 16(%rcx),%xmm13

# qhasm: float6464 1r6 +=0t6
# asm 1: addpd <0t6=int6464#14,<1r6=int6464#8
# asm 2: addpd <0t6=%xmm13,<1r6=%xmm7
addpd %xmm13,%xmm7

# qhasm: 0t12 = 0ab5six
# asm 1: movdqa <0ab5six=int6464#13,>0t12=int6464#13
# asm 2: movdqa <0ab5six=%xmm12,>0t12=%xmm12
movdqa %xmm12,%xmm12

# qhasm: float6464 0t12 *= *(int128 *)(0t2p + 112)
# asm 1: mulpd 112(<0t2p=int64#4),<0t12=int6464#13
# asm 2: mulpd 112(<0t2p=%rcx),<0t12=%xmm12
mulpd 112(%rcx),%xmm12

# qhasm: float6464 0res12 +=0t12
# asm 1: addpd <0t12=int6464#13,<0res12=int6464#2
# asm 2: addpd <0t12=%xmm12,<0res12=%xmm1
addpd %xmm12,%xmm1

# qhasm: *(int128 *)(0resp + 80) = 1r5
# asm 1: movdqa <1r5=int6464#7,80(<0resp=int64#5)
# asm 2: movdqa <1r5=%xmm6,80(<0resp=%r8)
movdqa %xmm6,80(%r8)

# qhasm: 0ab6 = *(int128 *)(0t1p + 96)
# asm 1: movdqa 96(<0t1p=int64#2),>0ab6=int6464#7
# asm 2: movdqa 96(<0t1p=%rsi),>0ab6=%xmm6
movdqa 96(%rsi),%xmm6

# qhasm: 0t6 = 0ab6
# asm 1: movdqa <0ab6=int6464#7,>0t6=int6464#13
# asm 2: movdqa <0ab6=%xmm6,>0t6=%xmm12
movdqa %xmm6,%xmm12

# qhasm: float6464 0t6 *= *(int128 *)(0t2p + 0)
# asm 1: mulpd 0(<0t2p=int64#4),<0t6=int6464#13
# asm 2: mulpd 0(<0t2p=%rcx),<0t6=%xmm12
mulpd 0(%rcx),%xmm12

# qhasm: float6464 1r6 +=0t6
# asm 1: addpd <0t6=int6464#13,<1r6=int6464#8
# asm 2: addpd <0t6=%xmm12,<1r6=%xmm7
addpd %xmm12,%xmm7

# qhasm: 0t7 = 0ab6
# asm 1: movdqa <0ab6=int6464#7,>0t7=int6464#13
# asm 2: movdqa <0ab6=%xmm6,>0t7=%xmm12
movdqa %xmm6,%xmm12

# qhasm: float6464 0t7 *= *(int128 *)(0t2p + 16)
# asm 1: mulpd 16(<0t2p=int64#4),<0t7=int6464#13
# asm 2: mulpd 16(<0t2p=%rcx),<0t7=%xmm12
mulpd 16(%rcx),%xmm12

# qhasm: float6464 1r7 +=0t7
# asm 1: addpd <0t7=int6464#13,<1r7=int6464#9
# asm 2: addpd <0t7=%xmm12,<1r7=%xmm8
addpd %xmm12,%xmm8

# qhasm: 0t8 = 0ab6
# asm 1: movdqa <0ab6=int6464#7,>0t8=int6464#13
# asm 2: movdqa <0ab6=%xmm6,>0t8=%xmm12
movdqa %xmm6,%xmm12

# qhasm: float6464 0t8 *= *(int128 *)(0t2p + 32)
# asm 1: mulpd 32(<0t2p=int64#4),<0t8=int6464#13
# asm 2: mulpd 32(<0t2p=%rcx),<0t8=%xmm12
mulpd 32(%rcx),%xmm12

# qhasm: float6464 1r8 +=0t8
# asm 1: addpd <0t8=int6464#13,<1r8=int6464#10
# asm 2: addpd <0t8=%xmm12,<1r8=%xmm9
addpd %xmm12,%xmm9

# qhasm: 0t9 = 0ab6
# asm 1: movdqa <0ab6=int6464#7,>0t9=int6464#13
# asm 2: movdqa <0ab6=%xmm6,>0t9=%xmm12
movdqa %xmm6,%xmm12

# qhasm: float6464 0t9 *= *(int128 *)(0t2p + 48)
# asm 1: mulpd 48(<0t2p=int64#4),<0t9=int6464#13
# asm 2: mulpd 48(<0t2p=%rcx),<0t9=%xmm12
mulpd 48(%rcx),%xmm12

# qhasm: float6464 1r9 +=0t9
# asm 1: addpd <0t9=int6464#13,<1r9=int6464#11
# asm 2: addpd <0t9=%xmm12,<1r9=%xmm10
addpd %xmm12,%xmm10

# qhasm: 0t10 = 0ab6
# asm 1: movdqa <0ab6=int6464#7,>0t10=int6464#13
# asm 2: movdqa <0ab6=%xmm6,>0t10=%xmm12
movdqa %xmm6,%xmm12

# qhasm: float6464 0t10 *= *(int128 *)(0t2p + 64)
# asm 1: mulpd 64(<0t2p=int64#4),<0t10=int6464#13
# asm 2: mulpd 64(<0t2p=%rcx),<0t10=%xmm12
mulpd 64(%rcx),%xmm12

# qhasm: float6464 1r10 +=0t10
# asm 1: addpd <0t10=int6464#13,<1r10=int6464#12
# asm 2: addpd <0t10=%xmm12,<1r10=%xmm11
addpd %xmm12,%xmm11

# qhasm: 0t11 = 0ab6
# asm 1: movdqa <0ab6=int6464#7,>0t11=int6464#13
# asm 2: movdqa <0ab6=%xmm6,>0t11=%xmm12
movdqa %xmm6,%xmm12

# qhasm: float6464 0t11 *= *(int128 *)(0t2p + 80)
# asm 1: mulpd 80(<0t2p=int64#4),<0t11=int6464#13
# asm 2: mulpd 80(<0t2p=%rcx),<0t11=%xmm12
mulpd 80(%rcx),%xmm12

# qhasm: float6464 1r11 +=0t11
# asm 1: addpd <0t11=int6464#13,<1r11=int6464#1
# asm 2: addpd <0t11=%xmm12,<1r11=%xmm0
addpd %xmm12,%xmm0

# qhasm: 0t12 = 0ab6
# asm 1: movdqa <0ab6=int6464#7,>0t12=int6464#13
# asm 2: movdqa <0ab6=%xmm6,>0t12=%xmm12
movdqa %xmm6,%xmm12

# qhasm: float6464 0t12 *= *(int128 *)(0t2p + 96)
# asm 1: mulpd 96(<0t2p=int64#4),<0t12=int6464#13
# asm 2: mulpd 96(<0t2p=%rcx),<0t12=%xmm12
mulpd 96(%rcx),%xmm12

# qhasm: float6464 0res12 +=0t12
# asm 1: addpd <0t12=int6464#13,<0res12=int6464#2
# asm 2: addpd <0t12=%xmm12,<0res12=%xmm1
addpd %xmm12,%xmm1

# qhasm: 0t13 = 0ab6
# asm 1: movdqa <0ab6=int6464#7,>0t13=int6464#13
# asm 2: movdqa <0ab6=%xmm6,>0t13=%xmm12
movdqa %xmm6,%xmm12

# qhasm: float6464 0t13 *= *(int128 *)(0t2p + 112)
# asm 1: mulpd 112(<0t2p=int64#4),<0t13=int6464#13
# asm 2: mulpd 112(<0t2p=%rcx),<0t13=%xmm12
mulpd 112(%rcx),%xmm12

# qhasm: float6464 0res13 +=0t13
# asm 1: addpd <0t13=int6464#13,<0res13=int6464#3
# asm 2: addpd <0t13=%xmm12,<0res13=%xmm2
addpd %xmm12,%xmm2

# qhasm: 0t14 = 0ab6
# asm 1: movdqa <0ab6=int6464#7,>0t14=int6464#13
# asm 2: movdqa <0ab6=%xmm6,>0t14=%xmm12
movdqa %xmm6,%xmm12

# qhasm: float6464 0t14 *= *(int128 *)(0t2p + 128)
# asm 1: mulpd 128(<0t2p=int64#4),<0t14=int6464#13
# asm 2: mulpd 128(<0t2p=%rcx),<0t14=%xmm12
mulpd 128(%rcx),%xmm12

# qhasm: float6464 0res14 +=0t14
# asm 1: addpd <0t14=int6464#13,<0res14=int6464#4
# asm 2: addpd <0t14=%xmm12,<0res14=%xmm3
addpd %xmm12,%xmm3

# qhasm: 0t15 = 0ab6
# asm 1: movdqa <0ab6=int6464#7,>0t15=int6464#13
# asm 2: movdqa <0ab6=%xmm6,>0t15=%xmm12
movdqa %xmm6,%xmm12

# qhasm: float6464 0t15 *= *(int128 *)(0t2p + 144)
# asm 1: mulpd 144(<0t2p=int64#4),<0t15=int6464#13
# asm 2: mulpd 144(<0t2p=%rcx),<0t15=%xmm12
mulpd 144(%rcx),%xmm12

# qhasm: float6464 0res15 +=0t15
# asm 1: addpd <0t15=int6464#13,<0res15=int6464#5
# asm 2: addpd <0t15=%xmm12,<0res15=%xmm4
addpd %xmm12,%xmm4

# qhasm: 0t16 = 0ab6
# asm 1: movdqa <0ab6=int6464#7,>0t16=int6464#13
# asm 2: movdqa <0ab6=%xmm6,>0t16=%xmm12
movdqa %xmm6,%xmm12

# qhasm: float6464 0t16 *= *(int128 *)(0t2p + 160)
# asm 1: mulpd 160(<0t2p=int64#4),<0t16=int6464#13
# asm 2: mulpd 160(<0t2p=%rcx),<0t16=%xmm12
mulpd 160(%rcx),%xmm12

# qhasm: float6464 0res16 +=0t16
# asm 1: addpd <0t16=int6464#13,<0res16=int6464#6
# asm 2: addpd <0t16=%xmm12,<0res16=%xmm5
addpd %xmm12,%xmm5

# qhasm: 0t17 = 0ab6
# asm 1: movdqa <0ab6=int6464#7,>0t17=int6464#7
# asm 2: movdqa <0ab6=%xmm6,>0t17=%xmm6
movdqa %xmm6,%xmm6

# qhasm: float6464 0t17 *= *(int128 *)(0t2p + 176)
# asm 1: mulpd 176(<0t2p=int64#4),<0t17=int6464#7
# asm 2: mulpd 176(<0t2p=%rcx),<0t17=%xmm6
mulpd 176(%rcx),%xmm6

# qhasm: 0res17 =0t17
# asm 1: movdqa <0t17=int6464#7,>0res17=int6464#7
# asm 2: movdqa <0t17=%xmm6,>0res17=%xmm6
movdqa %xmm6,%xmm6

# qhasm: *(int128 *)(0resp + 96) = 1r6
# asm 1: movdqa <1r6=int6464#8,96(<0resp=int64#5)
# asm 2: movdqa <1r6=%xmm7,96(<0resp=%r8)
movdqa %xmm7,96(%r8)

# qhasm: 0ab7 = *(int128 *)(0t1p + 112)
# asm 1: movdqa 112(<0t1p=int64#2),>0ab7=int6464#8
# asm 2: movdqa 112(<0t1p=%rsi),>0ab7=%xmm7
movdqa 112(%rsi),%xmm7

# qhasm: 0ab7six = 0ab7
# asm 1: movdqa <0ab7=int6464#8,>0ab7six=int6464#13
# asm 2: movdqa <0ab7=%xmm7,>0ab7six=%xmm12
movdqa %xmm7,%xmm12

# qhasm: float6464 0ab7six *= SIX_SIX
# asm 1: mulpd SIX_SIX,<0ab7six=int6464#13
# asm 2: mulpd SIX_SIX,<0ab7six=%xmm12
mulpd SIX_SIX,%xmm12

# qhasm: 0t7 = 0ab7
# asm 1: movdqa <0ab7=int6464#8,>0t7=int6464#14
# asm 2: movdqa <0ab7=%xmm7,>0t7=%xmm13
movdqa %xmm7,%xmm13

# qhasm: float6464 0t7 *= *(int128 *)(0t2p + 0)
# asm 1: mulpd 0(<0t2p=int64#4),<0t7=int6464#14
# asm 2: mulpd 0(<0t2p=%rcx),<0t7=%xmm13
mulpd 0(%rcx),%xmm13

# qhasm: float6464 1r7 +=0t7
# asm 1: addpd <0t7=int6464#14,<1r7=int6464#9
# asm 2: addpd <0t7=%xmm13,<1r7=%xmm8
addpd %xmm13,%xmm8

# qhasm: 0t13 = 0ab7
# asm 1: movdqa <0ab7=int6464#8,>0t13=int6464#8
# asm 2: movdqa <0ab7=%xmm7,>0t13=%xmm7
movdqa %xmm7,%xmm7

# qhasm: float6464 0t13 *= *(int128 *)(0t2p + 96)
# asm 1: mulpd 96(<0t2p=int64#4),<0t13=int6464#8
# asm 2: mulpd 96(<0t2p=%rcx),<0t13=%xmm7
mulpd 96(%rcx),%xmm7

# qhasm: float6464 0res13 +=0t13
# asm 1: addpd <0t13=int6464#8,<0res13=int6464#3
# asm 2: addpd <0t13=%xmm7,<0res13=%xmm2
addpd %xmm7,%xmm2

# qhasm: 0t8 = 0ab7six
# asm 1: movdqa <0ab7six=int6464#13,>0t8=int6464#8
# asm 2: movdqa <0ab7six=%xmm12,>0t8=%xmm7
movdqa %xmm12,%xmm7

# qhasm: float6464 0t8 *= *(int128 *)(0t2p + 16)
# asm 1: mulpd 16(<0t2p=int64#4),<0t8=int6464#8
# asm 2: mulpd 16(<0t2p=%rcx),<0t8=%xmm7
mulpd 16(%rcx),%xmm7

# qhasm: float6464 1r8 +=0t8
# asm 1: addpd <0t8=int6464#8,<1r8=int6464#10
# asm 2: addpd <0t8=%xmm7,<1r8=%xmm9
addpd %xmm7,%xmm9

# qhasm: 0t9 = 0ab7six
# asm 1: movdqa <0ab7six=int6464#13,>0t9=int6464#8
# asm 2: movdqa <0ab7six=%xmm12,>0t9=%xmm7
movdqa %xmm12,%xmm7

# qhasm: float6464 0t9 *= *(int128 *)(0t2p + 32)
# asm 1: mulpd 32(<0t2p=int64#4),<0t9=int6464#8
# asm 2: mulpd 32(<0t2p=%rcx),<0t9=%xmm7
mulpd 32(%rcx),%xmm7

# qhasm: float6464 1r9 +=0t9
# asm 1: addpd <0t9=int6464#8,<1r9=int6464#11
# asm 2: addpd <0t9=%xmm7,<1r9=%xmm10
addpd %xmm7,%xmm10

# qhasm: 0t10 = 0ab7six
# asm 1: movdqa <0ab7six=int6464#13,>0t10=int6464#8
# asm 2: movdqa <0ab7six=%xmm12,>0t10=%xmm7
movdqa %xmm12,%xmm7

# qhasm: float6464 0t10 *= *(int128 *)(0t2p + 48)
# asm 1: mulpd 48(<0t2p=int64#4),<0t10=int6464#8
# asm 2: mulpd 48(<0t2p=%rcx),<0t10=%xmm7
mulpd 48(%rcx),%xmm7

# qhasm: float6464 1r10 +=0t10
# asm 1: addpd <0t10=int6464#8,<1r10=int6464#12
# asm 2: addpd <0t10=%xmm7,<1r10=%xmm11
addpd %xmm7,%xmm11

# qhasm: 0t11 = 0ab7six
# asm 1: movdqa <0ab7six=int6464#13,>0t11=int6464#8
# asm 2: movdqa <0ab7six=%xmm12,>0t11=%xmm7
movdqa %xmm12,%xmm7

# qhasm: float6464 0t11 *= *(int128 *)(0t2p + 64)
# asm 1: mulpd 64(<0t2p=int64#4),<0t11=int6464#8
# asm 2: mulpd 64(<0t2p=%rcx),<0t11=%xmm7
mulpd 64(%rcx),%xmm7

# qhasm: float6464 1r11 +=0t11
# asm 1: addpd <0t11=int6464#8,<1r11=int6464#1
# asm 2: addpd <0t11=%xmm7,<1r11=%xmm0
addpd %xmm7,%xmm0

# qhasm: 0t12 = 0ab7six
# asm 1: movdqa <0ab7six=int6464#13,>0t12=int6464#8
# asm 2: movdqa <0ab7six=%xmm12,>0t12=%xmm7
movdqa %xmm12,%xmm7

# qhasm: float6464 0t12 *= *(int128 *)(0t2p + 80)
# asm 1: mulpd 80(<0t2p=int64#4),<0t12=int6464#8
# asm 2: mulpd 80(<0t2p=%rcx),<0t12=%xmm7
mulpd 80(%rcx),%xmm7

# qhasm: float6464 0res12 +=0t12
# asm 1: addpd <0t12=int6464#8,<0res12=int6464#2
# asm 2: addpd <0t12=%xmm7,<0res12=%xmm1
addpd %xmm7,%xmm1

# qhasm: 0t14 = 0ab7six
# asm 1: movdqa <0ab7six=int6464#13,>0t14=int6464#8
# asm 2: movdqa <0ab7six=%xmm12,>0t14=%xmm7
movdqa %xmm12,%xmm7

# qhasm: float6464 0t14 *= *(int128 *)(0t2p + 112)
# asm 1: mulpd 112(<0t2p=int64#4),<0t14=int6464#8
# asm 2: mulpd 112(<0t2p=%rcx),<0t14=%xmm7
mulpd 112(%rcx),%xmm7

# qhasm: float6464 0res14 +=0t14
# asm 1: addpd <0t14=int6464#8,<0res14=int6464#4
# asm 2: addpd <0t14=%xmm7,<0res14=%xmm3
addpd %xmm7,%xmm3

# qhasm: 0t15 = 0ab7six
# asm 1: movdqa <0ab7six=int6464#13,>0t15=int6464#8
# asm 2: movdqa <0ab7six=%xmm12,>0t15=%xmm7
movdqa %xmm12,%xmm7

# qhasm: float6464 0t15 *= *(int128 *)(0t2p + 128)
# asm 1: mulpd 128(<0t2p=int64#4),<0t15=int6464#8
# asm 2: mulpd 128(<0t2p=%rcx),<0t15=%xmm7
mulpd 128(%rcx),%xmm7

# qhasm: float6464 0res15 +=0t15
# asm 1: addpd <0t15=int6464#8,<0res15=int6464#5
# asm 2: addpd <0t15=%xmm7,<0res15=%xmm4
addpd %xmm7,%xmm4

# qhasm: 0t16 = 0ab7six
# asm 1: movdqa <0ab7six=int6464#13,>0t16=int6464#8
# asm 2: movdqa <0ab7six=%xmm12,>0t16=%xmm7
movdqa %xmm12,%xmm7

# qhasm: float6464 0t16 *= *(int128 *)(0t2p + 144)
# asm 1: mulpd 144(<0t2p=int64#4),<0t16=int6464#8
# asm 2: mulpd 144(<0t2p=%rcx),<0t16=%xmm7
mulpd 144(%rcx),%xmm7

# qhasm: float6464 0res16 +=0t16
# asm 1: addpd <0t16=int6464#8,<0res16=int6464#6
# asm 2: addpd <0t16=%xmm7,<0res16=%xmm5
addpd %xmm7,%xmm5

# qhasm: 0t17 = 0ab7six
# asm 1: movdqa <0ab7six=int6464#13,>0t17=int6464#8
# asm 2: movdqa <0ab7six=%xmm12,>0t17=%xmm7
movdqa %xmm12,%xmm7

# qhasm: float6464 0t17 *= *(int128 *)(0t2p + 160)
# asm 1: mulpd 160(<0t2p=int64#4),<0t17=int6464#8
# asm 2: mulpd 160(<0t2p=%rcx),<0t17=%xmm7
mulpd 160(%rcx),%xmm7

# qhasm: float6464 0res17 +=0t17
# asm 1: addpd <0t17=int6464#8,<0res17=int6464#7
# asm 2: addpd <0t17=%xmm7,<0res17=%xmm6
addpd %xmm7,%xmm6

# qhasm: 0t18 = 0ab7six
# asm 1: movdqa <0ab7six=int6464#13,>0t18=int6464#8
# asm 2: movdqa <0ab7six=%xmm12,>0t18=%xmm7
movdqa %xmm12,%xmm7

# qhasm: float6464 0t18 *= *(int128 *)(0t2p + 176)
# asm 1: mulpd 176(<0t2p=int64#4),<0t18=int6464#8
# asm 2: mulpd 176(<0t2p=%rcx),<0t18=%xmm7
mulpd 176(%rcx),%xmm7

# qhasm: 0res18 =0t18
# asm 1: movdqa <0t18=int6464#8,>0res18=int6464#8
# asm 2: movdqa <0t18=%xmm7,>0res18=%xmm7
movdqa %xmm7,%xmm7

# qhasm: *(int128 *)(0resp + 112) = 1r7
# asm 1: movdqa <1r7=int6464#9,112(<0resp=int64#5)
# asm 2: movdqa <1r7=%xmm8,112(<0resp=%r8)
movdqa %xmm8,112(%r8)

# qhasm: 0ab8 = *(int128 *)(0t1p + 128)
# asm 1: movdqa 128(<0t1p=int64#2),>0ab8=int6464#9
# asm 2: movdqa 128(<0t1p=%rsi),>0ab8=%xmm8
movdqa 128(%rsi),%xmm8

# qhasm: 0ab8six = 0ab8
# asm 1: movdqa <0ab8=int6464#9,>0ab8six=int6464#13
# asm 2: movdqa <0ab8=%xmm8,>0ab8six=%xmm12
movdqa %xmm8,%xmm12

# qhasm: float6464 0ab8six *= SIX_SIX
# asm 1: mulpd SIX_SIX,<0ab8six=int6464#13
# asm 2: mulpd SIX_SIX,<0ab8six=%xmm12
mulpd SIX_SIX,%xmm12

# qhasm: 0t8 = 0ab8
# asm 1: movdqa <0ab8=int6464#9,>0t8=int6464#14
# asm 2: movdqa <0ab8=%xmm8,>0t8=%xmm13
movdqa %xmm8,%xmm13

# qhasm: float6464 0t8 *= *(int128 *)(0t2p + 0)
# asm 1: mulpd 0(<0t2p=int64#4),<0t8=int6464#14
# asm 2: mulpd 0(<0t2p=%rcx),<0t8=%xmm13
mulpd 0(%rcx),%xmm13

# qhasm: float6464 1r8 +=0t8
# asm 1: addpd <0t8=int6464#14,<1r8=int6464#10
# asm 2: addpd <0t8=%xmm13,<1r8=%xmm9
addpd %xmm13,%xmm9

# qhasm: 0t13 = 0ab8
# asm 1: movdqa <0ab8=int6464#9,>0t13=int6464#14
# asm 2: movdqa <0ab8=%xmm8,>0t13=%xmm13
movdqa %xmm8,%xmm13

# qhasm: float6464 0t13 *= *(int128 *)(0t2p + 80)
# asm 1: mulpd 80(<0t2p=int64#4),<0t13=int6464#14
# asm 2: mulpd 80(<0t2p=%rcx),<0t13=%xmm13
mulpd 80(%rcx),%xmm13

# qhasm: float6464 0res13 +=0t13
# asm 1: addpd <0t13=int6464#14,<0res13=int6464#3
# asm 2: addpd <0t13=%xmm13,<0res13=%xmm2
addpd %xmm13,%xmm2

# qhasm: 0t14 = 0ab8
# asm 1: movdqa <0ab8=int6464#9,>0t14=int6464#14
# asm 2: movdqa <0ab8=%xmm8,>0t14=%xmm13
movdqa %xmm8,%xmm13

# qhasm: float6464 0t14 *= *(int128 *)(0t2p + 96)
# asm 1: mulpd 96(<0t2p=int64#4),<0t14=int6464#14
# asm 2: mulpd 96(<0t2p=%rcx),<0t14=%xmm13
mulpd 96(%rcx),%xmm13

# qhasm: float6464 0res14 +=0t14
# asm 1: addpd <0t14=int6464#14,<0res14=int6464#4
# asm 2: addpd <0t14=%xmm13,<0res14=%xmm3
addpd %xmm13,%xmm3

# qhasm: 0t19 = 0ab8
# asm 1: movdqa <0ab8=int6464#9,>0t19=int6464#9
# asm 2: movdqa <0ab8=%xmm8,>0t19=%xmm8
movdqa %xmm8,%xmm8

# qhasm: float6464 0t19 *= *(int128 *)(0t2p + 176)
# asm 1: mulpd 176(<0t2p=int64#4),<0t19=int6464#9
# asm 2: mulpd 176(<0t2p=%rcx),<0t19=%xmm8
mulpd 176(%rcx),%xmm8

# qhasm: 0res19 =0t19
# asm 1: movdqa <0t19=int6464#9,>0res19=int6464#9
# asm 2: movdqa <0t19=%xmm8,>0res19=%xmm8
movdqa %xmm8,%xmm8

# qhasm: 0t9 = 0ab8six
# asm 1: movdqa <0ab8six=int6464#13,>0t9=int6464#14
# asm 2: movdqa <0ab8six=%xmm12,>0t9=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t9 *= *(int128 *)(0t2p + 16)
# asm 1: mulpd 16(<0t2p=int64#4),<0t9=int6464#14
# asm 2: mulpd 16(<0t2p=%rcx),<0t9=%xmm13
mulpd 16(%rcx),%xmm13

# qhasm: float6464 1r9 +=0t9
# asm 1: addpd <0t9=int6464#14,<1r9=int6464#11
# asm 2: addpd <0t9=%xmm13,<1r9=%xmm10
addpd %xmm13,%xmm10

# qhasm: 0t10 = 0ab8six
# asm 1: movdqa <0ab8six=int6464#13,>0t10=int6464#14
# asm 2: movdqa <0ab8six=%xmm12,>0t10=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t10 *= *(int128 *)(0t2p + 32)
# asm 1: mulpd 32(<0t2p=int64#4),<0t10=int6464#14
# asm 2: mulpd 32(<0t2p=%rcx),<0t10=%xmm13
mulpd 32(%rcx),%xmm13

# qhasm: float6464 1r10 +=0t10
# asm 1: addpd <0t10=int6464#14,<1r10=int6464#12
# asm 2: addpd <0t10=%xmm13,<1r10=%xmm11
addpd %xmm13,%xmm11

# qhasm: 0t11 = 0ab8six
# asm 1: movdqa <0ab8six=int6464#13,>0t11=int6464#14
# asm 2: movdqa <0ab8six=%xmm12,>0t11=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t11 *= *(int128 *)(0t2p + 48)
# asm 1: mulpd 48(<0t2p=int64#4),<0t11=int6464#14
# asm 2: mulpd 48(<0t2p=%rcx),<0t11=%xmm13
mulpd 48(%rcx),%xmm13

# qhasm: float6464 1r11 +=0t11
# asm 1: addpd <0t11=int6464#14,<1r11=int6464#1
# asm 2: addpd <0t11=%xmm13,<1r11=%xmm0
addpd %xmm13,%xmm0

# qhasm: 0t12 = 0ab8six
# asm 1: movdqa <0ab8six=int6464#13,>0t12=int6464#14
# asm 2: movdqa <0ab8six=%xmm12,>0t12=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t12 *= *(int128 *)(0t2p + 64)
# asm 1: mulpd 64(<0t2p=int64#4),<0t12=int6464#14
# asm 2: mulpd 64(<0t2p=%rcx),<0t12=%xmm13
mulpd 64(%rcx),%xmm13

# qhasm: float6464 0res12 +=0t12
# asm 1: addpd <0t12=int6464#14,<0res12=int6464#2
# asm 2: addpd <0t12=%xmm13,<0res12=%xmm1
addpd %xmm13,%xmm1

# qhasm: 0t15 = 0ab8six
# asm 1: movdqa <0ab8six=int6464#13,>0t15=int6464#14
# asm 2: movdqa <0ab8six=%xmm12,>0t15=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t15 *= *(int128 *)(0t2p + 112)
# asm 1: mulpd 112(<0t2p=int64#4),<0t15=int6464#14
# asm 2: mulpd 112(<0t2p=%rcx),<0t15=%xmm13
mulpd 112(%rcx),%xmm13

# qhasm: float6464 0res15 +=0t15
# asm 1: addpd <0t15=int6464#14,<0res15=int6464#5
# asm 2: addpd <0t15=%xmm13,<0res15=%xmm4
addpd %xmm13,%xmm4

# qhasm: 0t16 = 0ab8six
# asm 1: movdqa <0ab8six=int6464#13,>0t16=int6464#14
# asm 2: movdqa <0ab8six=%xmm12,>0t16=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t16 *= *(int128 *)(0t2p + 128)
# asm 1: mulpd 128(<0t2p=int64#4),<0t16=int6464#14
# asm 2: mulpd 128(<0t2p=%rcx),<0t16=%xmm13
mulpd 128(%rcx),%xmm13

# qhasm: float6464 0res16 +=0t16
# asm 1: addpd <0t16=int6464#14,<0res16=int6464#6
# asm 2: addpd <0t16=%xmm13,<0res16=%xmm5
addpd %xmm13,%xmm5

# qhasm: 0t17 = 0ab8six
# asm 1: movdqa <0ab8six=int6464#13,>0t17=int6464#14
# asm 2: movdqa <0ab8six=%xmm12,>0t17=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t17 *= *(int128 *)(0t2p + 144)
# asm 1: mulpd 144(<0t2p=int64#4),<0t17=int6464#14
# asm 2: mulpd 144(<0t2p=%rcx),<0t17=%xmm13
mulpd 144(%rcx),%xmm13

# qhasm: float6464 0res17 +=0t17
# asm 1: addpd <0t17=int6464#14,<0res17=int6464#7
# asm 2: addpd <0t17=%xmm13,<0res17=%xmm6
addpd %xmm13,%xmm6

# qhasm: 0t18 = 0ab8six
# asm 1: movdqa <0ab8six=int6464#13,>0t18=int6464#13
# asm 2: movdqa <0ab8six=%xmm12,>0t18=%xmm12
movdqa %xmm12,%xmm12

# qhasm: float6464 0t18 *= *(int128 *)(0t2p + 160)
# asm 1: mulpd 160(<0t2p=int64#4),<0t18=int6464#13
# asm 2: mulpd 160(<0t2p=%rcx),<0t18=%xmm12
mulpd 160(%rcx),%xmm12

# qhasm: float6464 0res18 +=0t18
# asm 1: addpd <0t18=int6464#13,<0res18=int6464#8
# asm 2: addpd <0t18=%xmm12,<0res18=%xmm7
addpd %xmm12,%xmm7

# qhasm: *(int128 *)(0resp + 128) = 1r8
# asm 1: movdqa <1r8=int6464#10,128(<0resp=int64#5)
# asm 2: movdqa <1r8=%xmm9,128(<0resp=%r8)
movdqa %xmm9,128(%r8)

# qhasm: 0ab9 = *(int128 *)(0t1p + 144)
# asm 1: movdqa 144(<0t1p=int64#2),>0ab9=int6464#10
# asm 2: movdqa 144(<0t1p=%rsi),>0ab9=%xmm9
movdqa 144(%rsi),%xmm9

# qhasm: 0ab9six = 0ab9
# asm 1: movdqa <0ab9=int6464#10,>0ab9six=int6464#13
# asm 2: movdqa <0ab9=%xmm9,>0ab9six=%xmm12
movdqa %xmm9,%xmm12

# qhasm: float6464 0ab9six *= SIX_SIX
# asm 1: mulpd SIX_SIX,<0ab9six=int6464#13
# asm 2: mulpd SIX_SIX,<0ab9six=%xmm12
mulpd SIX_SIX,%xmm12

# qhasm: 0t9 = 0ab9
# asm 1: movdqa <0ab9=int6464#10,>0t9=int6464#14
# asm 2: movdqa <0ab9=%xmm9,>0t9=%xmm13
movdqa %xmm9,%xmm13

# qhasm: float6464 0t9 *= *(int128 *)(0t2p + 0)
# asm 1: mulpd 0(<0t2p=int64#4),<0t9=int6464#14
# asm 2: mulpd 0(<0t2p=%rcx),<0t9=%xmm13
mulpd 0(%rcx),%xmm13

# qhasm: float6464 1r9 +=0t9
# asm 1: addpd <0t9=int6464#14,<1r9=int6464#11
# asm 2: addpd <0t9=%xmm13,<1r9=%xmm10
addpd %xmm13,%xmm10

# qhasm: 0t13 = 0ab9
# asm 1: movdqa <0ab9=int6464#10,>0t13=int6464#14
# asm 2: movdqa <0ab9=%xmm9,>0t13=%xmm13
movdqa %xmm9,%xmm13

# qhasm: float6464 0t13 *= *(int128 *)(0t2p + 64)
# asm 1: mulpd 64(<0t2p=int64#4),<0t13=int6464#14
# asm 2: mulpd 64(<0t2p=%rcx),<0t13=%xmm13
mulpd 64(%rcx),%xmm13

# qhasm: float6464 0res13 +=0t13
# asm 1: addpd <0t13=int6464#14,<0res13=int6464#3
# asm 2: addpd <0t13=%xmm13,<0res13=%xmm2
addpd %xmm13,%xmm2

# qhasm: 0t14 = 0ab9
# asm 1: movdqa <0ab9=int6464#10,>0t14=int6464#14
# asm 2: movdqa <0ab9=%xmm9,>0t14=%xmm13
movdqa %xmm9,%xmm13

# qhasm: float6464 0t14 *= *(int128 *)(0t2p + 80)
# asm 1: mulpd 80(<0t2p=int64#4),<0t14=int6464#14
# asm 2: mulpd 80(<0t2p=%rcx),<0t14=%xmm13
mulpd 80(%rcx),%xmm13

# qhasm: float6464 0res14 +=0t14
# asm 1: addpd <0t14=int6464#14,<0res14=int6464#4
# asm 2: addpd <0t14=%xmm13,<0res14=%xmm3
addpd %xmm13,%xmm3

# qhasm: 0t15 = 0ab9
# asm 1: movdqa <0ab9=int6464#10,>0t15=int6464#14
# asm 2: movdqa <0ab9=%xmm9,>0t15=%xmm13
movdqa %xmm9,%xmm13

# qhasm: float6464 0t15 *= *(int128 *)(0t2p + 96)
# asm 1: mulpd 96(<0t2p=int64#4),<0t15=int6464#14
# asm 2: mulpd 96(<0t2p=%rcx),<0t15=%xmm13
mulpd 96(%rcx),%xmm13

# qhasm: float6464 0res15 +=0t15
# asm 1: addpd <0t15=int6464#14,<0res15=int6464#5
# asm 2: addpd <0t15=%xmm13,<0res15=%xmm4
addpd %xmm13,%xmm4

# qhasm: 0t19 = 0ab9
# asm 1: movdqa <0ab9=int6464#10,>0t19=int6464#14
# asm 2: movdqa <0ab9=%xmm9,>0t19=%xmm13
movdqa %xmm9,%xmm13

# qhasm: float6464 0t19 *= *(int128 *)(0t2p + 160)
# asm 1: mulpd 160(<0t2p=int64#4),<0t19=int6464#14
# asm 2: mulpd 160(<0t2p=%rcx),<0t19=%xmm13
mulpd 160(%rcx),%xmm13

# qhasm: float6464 0res19 +=0t19
# asm 1: addpd <0t19=int6464#14,<0res19=int6464#9
# asm 2: addpd <0t19=%xmm13,<0res19=%xmm8
addpd %xmm13,%xmm8

# qhasm: 0t20 = 0ab9
# asm 1: movdqa <0ab9=int6464#10,>0t20=int6464#10
# asm 2: movdqa <0ab9=%xmm9,>0t20=%xmm9
movdqa %xmm9,%xmm9

# qhasm: float6464 0t20 *= *(int128 *)(0t2p + 176)
# asm 1: mulpd 176(<0t2p=int64#4),<0t20=int6464#10
# asm 2: mulpd 176(<0t2p=%rcx),<0t20=%xmm9
mulpd 176(%rcx),%xmm9

# qhasm: 0res20 =0t20
# asm 1: movdqa <0t20=int6464#10,>0res20=int6464#10
# asm 2: movdqa <0t20=%xmm9,>0res20=%xmm9
movdqa %xmm9,%xmm9

# qhasm: 0t10 = 0ab9six
# asm 1: movdqa <0ab9six=int6464#13,>0t10=int6464#14
# asm 2: movdqa <0ab9six=%xmm12,>0t10=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t10 *= *(int128 *)(0t2p + 16)
# asm 1: mulpd 16(<0t2p=int64#4),<0t10=int6464#14
# asm 2: mulpd 16(<0t2p=%rcx),<0t10=%xmm13
mulpd 16(%rcx),%xmm13

# qhasm: float6464 1r10 +=0t10
# asm 1: addpd <0t10=int6464#14,<1r10=int6464#12
# asm 2: addpd <0t10=%xmm13,<1r10=%xmm11
addpd %xmm13,%xmm11

# qhasm: 0t11 = 0ab9six
# asm 1: movdqa <0ab9six=int6464#13,>0t11=int6464#14
# asm 2: movdqa <0ab9six=%xmm12,>0t11=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t11 *= *(int128 *)(0t2p + 32)
# asm 1: mulpd 32(<0t2p=int64#4),<0t11=int6464#14
# asm 2: mulpd 32(<0t2p=%rcx),<0t11=%xmm13
mulpd 32(%rcx),%xmm13

# qhasm: float6464 1r11 +=0t11
# asm 1: addpd <0t11=int6464#14,<1r11=int6464#1
# asm 2: addpd <0t11=%xmm13,<1r11=%xmm0
addpd %xmm13,%xmm0

# qhasm: 0t12 = 0ab9six
# asm 1: movdqa <0ab9six=int6464#13,>0t12=int6464#14
# asm 2: movdqa <0ab9six=%xmm12,>0t12=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t12 *= *(int128 *)(0t2p + 48)
# asm 1: mulpd 48(<0t2p=int64#4),<0t12=int6464#14
# asm 2: mulpd 48(<0t2p=%rcx),<0t12=%xmm13
mulpd 48(%rcx),%xmm13

# qhasm: float6464 0res12 +=0t12
# asm 1: addpd <0t12=int6464#14,<0res12=int6464#2
# asm 2: addpd <0t12=%xmm13,<0res12=%xmm1
addpd %xmm13,%xmm1

# qhasm: 0t16 = 0ab9six
# asm 1: movdqa <0ab9six=int6464#13,>0t16=int6464#14
# asm 2: movdqa <0ab9six=%xmm12,>0t16=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t16 *= *(int128 *)(0t2p + 112)
# asm 1: mulpd 112(<0t2p=int64#4),<0t16=int6464#14
# asm 2: mulpd 112(<0t2p=%rcx),<0t16=%xmm13
mulpd 112(%rcx),%xmm13

# qhasm: float6464 0res16 +=0t16
# asm 1: addpd <0t16=int6464#14,<0res16=int6464#6
# asm 2: addpd <0t16=%xmm13,<0res16=%xmm5
addpd %xmm13,%xmm5

# qhasm: 0t17 = 0ab9six
# asm 1: movdqa <0ab9six=int6464#13,>0t17=int6464#14
# asm 2: movdqa <0ab9six=%xmm12,>0t17=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t17 *= *(int128 *)(0t2p + 128)
# asm 1: mulpd 128(<0t2p=int64#4),<0t17=int6464#14
# asm 2: mulpd 128(<0t2p=%rcx),<0t17=%xmm13
mulpd 128(%rcx),%xmm13

# qhasm: float6464 0res17 +=0t17
# asm 1: addpd <0t17=int6464#14,<0res17=int6464#7
# asm 2: addpd <0t17=%xmm13,<0res17=%xmm6
addpd %xmm13,%xmm6

# qhasm: 0t18 = 0ab9six
# asm 1: movdqa <0ab9six=int6464#13,>0t18=int6464#13
# asm 2: movdqa <0ab9six=%xmm12,>0t18=%xmm12
movdqa %xmm12,%xmm12

# qhasm: float6464 0t18 *= *(int128 *)(0t2p + 144)
# asm 1: mulpd 144(<0t2p=int64#4),<0t18=int6464#13
# asm 2: mulpd 144(<0t2p=%rcx),<0t18=%xmm12
mulpd 144(%rcx),%xmm12

# qhasm: float6464 0res18 +=0t18
# asm 1: addpd <0t18=int6464#13,<0res18=int6464#8
# asm 2: addpd <0t18=%xmm12,<0res18=%xmm7
addpd %xmm12,%xmm7

# qhasm: *(int128 *)(0resp + 144) = 1r9
# asm 1: movdqa <1r9=int6464#11,144(<0resp=int64#5)
# asm 2: movdqa <1r9=%xmm10,144(<0resp=%r8)
movdqa %xmm10,144(%r8)

# qhasm: 0ab10 = *(int128 *)(0t1p + 160)
# asm 1: movdqa 160(<0t1p=int64#2),>0ab10=int6464#11
# asm 2: movdqa 160(<0t1p=%rsi),>0ab10=%xmm10
movdqa 160(%rsi),%xmm10

# qhasm: 0ab10six = 0ab10
# asm 1: movdqa <0ab10=int6464#11,>0ab10six=int6464#13
# asm 2: movdqa <0ab10=%xmm10,>0ab10six=%xmm12
movdqa %xmm10,%xmm12

# qhasm: float6464 0ab10six *= SIX_SIX
# asm 1: mulpd SIX_SIX,<0ab10six=int6464#13
# asm 2: mulpd SIX_SIX,<0ab10six=%xmm12
mulpd SIX_SIX,%xmm12

# qhasm: 0t10 = 0ab10
# asm 1: movdqa <0ab10=int6464#11,>0t10=int6464#14
# asm 2: movdqa <0ab10=%xmm10,>0t10=%xmm13
movdqa %xmm10,%xmm13

# qhasm: float6464 0t10 *= *(int128 *)(0t2p + 0)
# asm 1: mulpd 0(<0t2p=int64#4),<0t10=int6464#14
# asm 2: mulpd 0(<0t2p=%rcx),<0t10=%xmm13
mulpd 0(%rcx),%xmm13

# qhasm: float6464 1r10 +=0t10
# asm 1: addpd <0t10=int6464#14,<1r10=int6464#12
# asm 2: addpd <0t10=%xmm13,<1r10=%xmm11
addpd %xmm13,%xmm11

# qhasm: 0t13 = 0ab10
# asm 1: movdqa <0ab10=int6464#11,>0t13=int6464#14
# asm 2: movdqa <0ab10=%xmm10,>0t13=%xmm13
movdqa %xmm10,%xmm13

# qhasm: float6464 0t13 *= *(int128 *)(0t2p + 48)
# asm 1: mulpd 48(<0t2p=int64#4),<0t13=int6464#14
# asm 2: mulpd 48(<0t2p=%rcx),<0t13=%xmm13
mulpd 48(%rcx),%xmm13

# qhasm: float6464 0res13 +=0t13
# asm 1: addpd <0t13=int6464#14,<0res13=int6464#3
# asm 2: addpd <0t13=%xmm13,<0res13=%xmm2
addpd %xmm13,%xmm2

# qhasm: 0t14 = 0ab10
# asm 1: movdqa <0ab10=int6464#11,>0t14=int6464#14
# asm 2: movdqa <0ab10=%xmm10,>0t14=%xmm13
movdqa %xmm10,%xmm13

# qhasm: float6464 0t14 *= *(int128 *)(0t2p + 64)
# asm 1: mulpd 64(<0t2p=int64#4),<0t14=int6464#14
# asm 2: mulpd 64(<0t2p=%rcx),<0t14=%xmm13
mulpd 64(%rcx),%xmm13

# qhasm: float6464 0res14 +=0t14
# asm 1: addpd <0t14=int6464#14,<0res14=int6464#4
# asm 2: addpd <0t14=%xmm13,<0res14=%xmm3
addpd %xmm13,%xmm3

# qhasm: 0t16 = 0ab10
# asm 1: movdqa <0ab10=int6464#11,>0t16=int6464#14
# asm 2: movdqa <0ab10=%xmm10,>0t16=%xmm13
movdqa %xmm10,%xmm13

# qhasm: float6464 0t16 *= *(int128 *)(0t2p + 96)
# asm 1: mulpd 96(<0t2p=int64#4),<0t16=int6464#14
# asm 2: mulpd 96(<0t2p=%rcx),<0t16=%xmm13
mulpd 96(%rcx),%xmm13

# qhasm: float6464 0res16 +=0t16
# asm 1: addpd <0t16=int6464#14,<0res16=int6464#6
# asm 2: addpd <0t16=%xmm13,<0res16=%xmm5
addpd %xmm13,%xmm5

# qhasm: 0t15 = 0ab10
# asm 1: movdqa <0ab10=int6464#11,>0t15=int6464#14
# asm 2: movdqa <0ab10=%xmm10,>0t15=%xmm13
movdqa %xmm10,%xmm13

# qhasm: float6464 0t15 *= *(int128 *)(0t2p + 80)
# asm 1: mulpd 80(<0t2p=int64#4),<0t15=int6464#14
# asm 2: mulpd 80(<0t2p=%rcx),<0t15=%xmm13
mulpd 80(%rcx),%xmm13

# qhasm: float6464 0res15 +=0t15
# asm 1: addpd <0t15=int6464#14,<0res15=int6464#5
# asm 2: addpd <0t15=%xmm13,<0res15=%xmm4
addpd %xmm13,%xmm4

# qhasm: 0t19 = 0ab10
# asm 1: movdqa <0ab10=int6464#11,>0t19=int6464#14
# asm 2: movdqa <0ab10=%xmm10,>0t19=%xmm13
movdqa %xmm10,%xmm13

# qhasm: float6464 0t19 *= *(int128 *)(0t2p + 144)
# asm 1: mulpd 144(<0t2p=int64#4),<0t19=int6464#14
# asm 2: mulpd 144(<0t2p=%rcx),<0t19=%xmm13
mulpd 144(%rcx),%xmm13

# qhasm: float6464 0res19 +=0t19
# asm 1: addpd <0t19=int6464#14,<0res19=int6464#9
# asm 2: addpd <0t19=%xmm13,<0res19=%xmm8
addpd %xmm13,%xmm8

# qhasm: 0t20 = 0ab10
# asm 1: movdqa <0ab10=int6464#11,>0t20=int6464#14
# asm 2: movdqa <0ab10=%xmm10,>0t20=%xmm13
movdqa %xmm10,%xmm13

# qhasm: float6464 0t20 *= *(int128 *)(0t2p + 160)
# asm 1: mulpd 160(<0t2p=int64#4),<0t20=int6464#14
# asm 2: mulpd 160(<0t2p=%rcx),<0t20=%xmm13
mulpd 160(%rcx),%xmm13

# qhasm: float6464 0res20 +=0t20
# asm 1: addpd <0t20=int6464#14,<0res20=int6464#10
# asm 2: addpd <0t20=%xmm13,<0res20=%xmm9
addpd %xmm13,%xmm9

# qhasm: 0t21 = 0ab10
# asm 1: movdqa <0ab10=int6464#11,>0t21=int6464#11
# asm 2: movdqa <0ab10=%xmm10,>0t21=%xmm10
movdqa %xmm10,%xmm10

# qhasm: float6464 0t21 *= *(int128 *)(0t2p + 176)
# asm 1: mulpd 176(<0t2p=int64#4),<0t21=int6464#11
# asm 2: mulpd 176(<0t2p=%rcx),<0t21=%xmm10
mulpd 176(%rcx),%xmm10

# qhasm: 0res21 =0t21
# asm 1: movdqa <0t21=int6464#11,>0res21=int6464#11
# asm 2: movdqa <0t21=%xmm10,>0res21=%xmm10
movdqa %xmm10,%xmm10

# qhasm: 0t11 = 0ab10six
# asm 1: movdqa <0ab10six=int6464#13,>0t11=int6464#14
# asm 2: movdqa <0ab10six=%xmm12,>0t11=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t11 *= *(int128 *)(0t2p + 16)
# asm 1: mulpd 16(<0t2p=int64#4),<0t11=int6464#14
# asm 2: mulpd 16(<0t2p=%rcx),<0t11=%xmm13
mulpd 16(%rcx),%xmm13

# qhasm: float6464 1r11 +=0t11
# asm 1: addpd <0t11=int6464#14,<1r11=int6464#1
# asm 2: addpd <0t11=%xmm13,<1r11=%xmm0
addpd %xmm13,%xmm0

# qhasm: 0t12 = 0ab10six
# asm 1: movdqa <0ab10six=int6464#13,>0t12=int6464#14
# asm 2: movdqa <0ab10six=%xmm12,>0t12=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t12 *= *(int128 *)(0t2p + 32)
# asm 1: mulpd 32(<0t2p=int64#4),<0t12=int6464#14
# asm 2: mulpd 32(<0t2p=%rcx),<0t12=%xmm13
mulpd 32(%rcx),%xmm13

# qhasm: float6464 0res12 +=0t12
# asm 1: addpd <0t12=int6464#14,<0res12=int6464#2
# asm 2: addpd <0t12=%xmm13,<0res12=%xmm1
addpd %xmm13,%xmm1

# qhasm: 0t17 = 0ab10six
# asm 1: movdqa <0ab10six=int6464#13,>0t17=int6464#14
# asm 2: movdqa <0ab10six=%xmm12,>0t17=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t17 *= *(int128 *)(0t2p + 112)
# asm 1: mulpd 112(<0t2p=int64#4),<0t17=int6464#14
# asm 2: mulpd 112(<0t2p=%rcx),<0t17=%xmm13
mulpd 112(%rcx),%xmm13

# qhasm: float6464 0res17 +=0t17
# asm 1: addpd <0t17=int6464#14,<0res17=int6464#7
# asm 2: addpd <0t17=%xmm13,<0res17=%xmm6
addpd %xmm13,%xmm6

# qhasm: 0t18 = 0ab10six
# asm 1: movdqa <0ab10six=int6464#13,>0t18=int6464#13
# asm 2: movdqa <0ab10six=%xmm12,>0t18=%xmm12
movdqa %xmm12,%xmm12

# qhasm: float6464 0t18 *= *(int128 *)(0t2p + 128)
# asm 1: mulpd 128(<0t2p=int64#4),<0t18=int6464#13
# asm 2: mulpd 128(<0t2p=%rcx),<0t18=%xmm12
mulpd 128(%rcx),%xmm12

# qhasm: float6464 0res18 +=0t18
# asm 1: addpd <0t18=int6464#13,<0res18=int6464#8
# asm 2: addpd <0t18=%xmm12,<0res18=%xmm7
addpd %xmm12,%xmm7

# qhasm: *(int128 *)(0resp + 160) = 1r10
# asm 1: movdqa <1r10=int6464#12,160(<0resp=int64#5)
# asm 2: movdqa <1r10=%xmm11,160(<0resp=%r8)
movdqa %xmm11,160(%r8)

# qhasm: 0ab11 = *(int128 *)(0t1p + 176)
# asm 1: movdqa 176(<0t1p=int64#2),>0ab11=int6464#12
# asm 2: movdqa 176(<0t1p=%rsi),>0ab11=%xmm11
movdqa 176(%rsi),%xmm11

# qhasm: 0ab11six = 0ab11
# asm 1: movdqa <0ab11=int6464#12,>0ab11six=int6464#13
# asm 2: movdqa <0ab11=%xmm11,>0ab11six=%xmm12
movdqa %xmm11,%xmm12

# qhasm: float6464 0ab11six *= SIX_SIX
# asm 1: mulpd SIX_SIX,<0ab11six=int6464#13
# asm 2: mulpd SIX_SIX,<0ab11six=%xmm12
mulpd SIX_SIX,%xmm12

# qhasm: 0t11 = 0ab11
# asm 1: movdqa <0ab11=int6464#12,>0t11=int6464#14
# asm 2: movdqa <0ab11=%xmm11,>0t11=%xmm13
movdqa %xmm11,%xmm13

# qhasm: float6464 0t11 *= *(int128 *)(0t2p + 0)
# asm 1: mulpd 0(<0t2p=int64#4),<0t11=int6464#14
# asm 2: mulpd 0(<0t2p=%rcx),<0t11=%xmm13
mulpd 0(%rcx),%xmm13

# qhasm: float6464 1r11 +=0t11
# asm 1: addpd <0t11=int6464#14,<1r11=int6464#1
# asm 2: addpd <0t11=%xmm13,<1r11=%xmm0
addpd %xmm13,%xmm0

# qhasm: 0t13 = 0ab11
# asm 1: movdqa <0ab11=int6464#12,>0t13=int6464#14
# asm 2: movdqa <0ab11=%xmm11,>0t13=%xmm13
movdqa %xmm11,%xmm13

# qhasm: float6464 0t13 *= *(int128 *)(0t2p + 32)
# asm 1: mulpd 32(<0t2p=int64#4),<0t13=int6464#14
# asm 2: mulpd 32(<0t2p=%rcx),<0t13=%xmm13
mulpd 32(%rcx),%xmm13

# qhasm: float6464 0res13 +=0t13
# asm 1: addpd <0t13=int6464#14,<0res13=int6464#3
# asm 2: addpd <0t13=%xmm13,<0res13=%xmm2
addpd %xmm13,%xmm2

# qhasm: 0t14 = 0ab11
# asm 1: movdqa <0ab11=int6464#12,>0t14=int6464#14
# asm 2: movdqa <0ab11=%xmm11,>0t14=%xmm13
movdqa %xmm11,%xmm13

# qhasm: float6464 0t14 *= *(int128 *)(0t2p + 48)
# asm 1: mulpd 48(<0t2p=int64#4),<0t14=int6464#14
# asm 2: mulpd 48(<0t2p=%rcx),<0t14=%xmm13
mulpd 48(%rcx),%xmm13

# qhasm: float6464 0res14 +=0t14
# asm 1: addpd <0t14=int6464#14,<0res14=int6464#4
# asm 2: addpd <0t14=%xmm13,<0res14=%xmm3
addpd %xmm13,%xmm3

# qhasm: 0t15 = 0ab11
# asm 1: movdqa <0ab11=int6464#12,>0t15=int6464#14
# asm 2: movdqa <0ab11=%xmm11,>0t15=%xmm13
movdqa %xmm11,%xmm13

# qhasm: float6464 0t15 *= *(int128 *)(0t2p + 64)
# asm 1: mulpd 64(<0t2p=int64#4),<0t15=int6464#14
# asm 2: mulpd 64(<0t2p=%rcx),<0t15=%xmm13
mulpd 64(%rcx),%xmm13

# qhasm: float6464 0res15 +=0t15
# asm 1: addpd <0t15=int6464#14,<0res15=int6464#5
# asm 2: addpd <0t15=%xmm13,<0res15=%xmm4
addpd %xmm13,%xmm4

# qhasm: 0t16 = 0ab11
# asm 1: movdqa <0ab11=int6464#12,>0t16=int6464#14
# asm 2: movdqa <0ab11=%xmm11,>0t16=%xmm13
movdqa %xmm11,%xmm13

# qhasm: float6464 0t16 *= *(int128 *)(0t2p + 80)
# asm 1: mulpd 80(<0t2p=int64#4),<0t16=int6464#14
# asm 2: mulpd 80(<0t2p=%rcx),<0t16=%xmm13
mulpd 80(%rcx),%xmm13

# qhasm: float6464 0res16 +=0t16
# asm 1: addpd <0t16=int6464#14,<0res16=int6464#6
# asm 2: addpd <0t16=%xmm13,<0res16=%xmm5
addpd %xmm13,%xmm5

# qhasm: 0t17 = 0ab11
# asm 1: movdqa <0ab11=int6464#12,>0t17=int6464#14
# asm 2: movdqa <0ab11=%xmm11,>0t17=%xmm13
movdqa %xmm11,%xmm13

# qhasm: float6464 0t17 *= *(int128 *)(0t2p + 96)
# asm 1: mulpd 96(<0t2p=int64#4),<0t17=int6464#14
# asm 2: mulpd 96(<0t2p=%rcx),<0t17=%xmm13
mulpd 96(%rcx),%xmm13

# qhasm: float6464 0res17 +=0t17
# asm 1: addpd <0t17=int6464#14,<0res17=int6464#7
# asm 2: addpd <0t17=%xmm13,<0res17=%xmm6
addpd %xmm13,%xmm6

# qhasm: 0t19 = 0ab11
# asm 1: movdqa <0ab11=int6464#12,>0t19=int6464#14
# asm 2: movdqa <0ab11=%xmm11,>0t19=%xmm13
movdqa %xmm11,%xmm13

# qhasm: float6464 0t19 *= *(int128 *)(0t2p + 128)
# asm 1: mulpd 128(<0t2p=int64#4),<0t19=int6464#14
# asm 2: mulpd 128(<0t2p=%rcx),<0t19=%xmm13
mulpd 128(%rcx),%xmm13

# qhasm: float6464 0res19 +=0t19
# asm 1: addpd <0t19=int6464#14,<0res19=int6464#9
# asm 2: addpd <0t19=%xmm13,<0res19=%xmm8
addpd %xmm13,%xmm8

# qhasm: 0t20 = 0ab11
# asm 1: movdqa <0ab11=int6464#12,>0t20=int6464#14
# asm 2: movdqa <0ab11=%xmm11,>0t20=%xmm13
movdqa %xmm11,%xmm13

# qhasm: float6464 0t20 *= *(int128 *)(0t2p + 144)
# asm 1: mulpd 144(<0t2p=int64#4),<0t20=int6464#14
# asm 2: mulpd 144(<0t2p=%rcx),<0t20=%xmm13
mulpd 144(%rcx),%xmm13

# qhasm: float6464 0res20 +=0t20
# asm 1: addpd <0t20=int6464#14,<0res20=int6464#10
# asm 2: addpd <0t20=%xmm13,<0res20=%xmm9
addpd %xmm13,%xmm9

# qhasm: 0t21 = 0ab11
# asm 1: movdqa <0ab11=int6464#12,>0t21=int6464#14
# asm 2: movdqa <0ab11=%xmm11,>0t21=%xmm13
movdqa %xmm11,%xmm13

# qhasm: float6464 0t21 *= *(int128 *)(0t2p + 160)
# asm 1: mulpd 160(<0t2p=int64#4),<0t21=int6464#14
# asm 2: mulpd 160(<0t2p=%rcx),<0t21=%xmm13
mulpd 160(%rcx),%xmm13

# qhasm: float6464 0res21 +=0t21
# asm 1: addpd <0t21=int6464#14,<0res21=int6464#11
# asm 2: addpd <0t21=%xmm13,<0res21=%xmm10
addpd %xmm13,%xmm10

# qhasm: 0t22 = 0ab11
# asm 1: movdqa <0ab11=int6464#12,>0t22=int6464#12
# asm 2: movdqa <0ab11=%xmm11,>0t22=%xmm11
movdqa %xmm11,%xmm11

# qhasm: float6464 0t22 *= *(int128 *)(0t2p + 176)
# asm 1: mulpd 176(<0t2p=int64#4),<0t22=int6464#12
# asm 2: mulpd 176(<0t2p=%rcx),<0t22=%xmm11
mulpd 176(%rcx),%xmm11

# qhasm: 0res22 =0t22
# asm 1: movdqa <0t22=int6464#12,>0res22=int6464#12
# asm 2: movdqa <0t22=%xmm11,>0res22=%xmm11
movdqa %xmm11,%xmm11

# qhasm: 0t12 = 0ab11six
# asm 1: movdqa <0ab11six=int6464#13,>0t12=int6464#14
# asm 2: movdqa <0ab11six=%xmm12,>0t12=%xmm13
movdqa %xmm12,%xmm13

# qhasm: float6464 0t12 *= *(int128 *)(0t2p + 16)
# asm 1: mulpd 16(<0t2p=int64#4),<0t12=int6464#14
# asm 2: mulpd 16(<0t2p=%rcx),<0t12=%xmm13
mulpd 16(%rcx),%xmm13

# qhasm: float6464 0res12 +=0t12
# asm 1: addpd <0t12=int6464#14,<0res12=int6464#2
# asm 2: addpd <0t12=%xmm13,<0res12=%xmm1
addpd %xmm13,%xmm1

# qhasm: 0t18 = 0ab11six
# asm 1: movdqa <0ab11six=int6464#13,>0t18=int6464#13
# asm 2: movdqa <0ab11six=%xmm12,>0t18=%xmm12
movdqa %xmm12,%xmm12

# qhasm: float6464 0t18 *= *(int128 *)(0t2p + 112)
# asm 1: mulpd 112(<0t2p=int64#4),<0t18=int6464#13
# asm 2: mulpd 112(<0t2p=%rcx),<0t18=%xmm12
mulpd 112(%rcx),%xmm12

# qhasm: float6464 0res18 +=0t18
# asm 1: addpd <0t18=int6464#13,<0res18=int6464#8
# asm 2: addpd <0t18=%xmm12,<0res18=%xmm7
addpd %xmm12,%xmm7

# qhasm: *(int128 *)(0resp + 176) = 1r11
# asm 1: movdqa <1r11=int6464#1,176(<0resp=int64#5)
# asm 2: movdqa <1r11=%xmm0,176(<0resp=%r8)
movdqa %xmm0,176(%r8)

# qhasm: *(int128 *)(0myp + 352) = 0res22
# asm 1: movdqa <0res22=int6464#12,352(<0myp=int64#3)
# asm 2: movdqa <0res22=%xmm11,352(<0myp=%rdx)
movdqa %xmm11,352(%rdx)

# qhasm: 0res22 = unpack high double of 0res22 and 0res22
# asm 1: unpckhpd <0res22=int6464#12,<0res22=int6464#12
# asm 2: unpckhpd <0res22=%xmm11,<0res22=%xmm11
unpckhpd %xmm11,%xmm11

# qhasm: float6464 0res22 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res22=int6464#12
# asm 2: mulpd SIX_ONE,<0res22=%xmm11
mulpd SIX_ONE,%xmm11

# qhasm: float6464 0res22 += *(int128 *)(0myp + 352)
# asm 1: addpd 352(<0myp=int64#3),<0res22=int6464#12
# asm 2: addpd 352(<0myp=%rdx),<0res22=%xmm11
addpd 352(%rdx),%xmm11

# qhasm: *(int128 *)(0myp + 336) = 0res21
# asm 1: movdqa <0res21=int6464#11,336(<0myp=int64#3)
# asm 2: movdqa <0res21=%xmm10,336(<0myp=%rdx)
movdqa %xmm10,336(%rdx)

# qhasm: 0res21 = unpack high double of 0res21 and 0res21
# asm 1: unpckhpd <0res21=int6464#11,<0res21=int6464#11
# asm 2: unpckhpd <0res21=%xmm10,<0res21=%xmm10
unpckhpd %xmm10,%xmm10

# qhasm: float6464 0res21 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res21=int6464#11
# asm 2: mulpd SIX_ONE,<0res21=%xmm10
mulpd SIX_ONE,%xmm10

# qhasm: float6464 0res21 += *(int128 *)(0myp + 336)
# asm 1: addpd 336(<0myp=int64#3),<0res21=int6464#11
# asm 2: addpd 336(<0myp=%rdx),<0res21=%xmm10
addpd 336(%rdx),%xmm10

# qhasm: *(int128 *)(0myp + 320) = 0res20
# asm 1: movdqa <0res20=int6464#10,320(<0myp=int64#3)
# asm 2: movdqa <0res20=%xmm9,320(<0myp=%rdx)
movdqa %xmm9,320(%rdx)

# qhasm: 0res20 = unpack high double of 0res20 and 0res20
# asm 1: unpckhpd <0res20=int6464#10,<0res20=int6464#10
# asm 2: unpckhpd <0res20=%xmm9,<0res20=%xmm9
unpckhpd %xmm9,%xmm9

# qhasm: float6464 0res20 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res20=int6464#10
# asm 2: mulpd SIX_ONE,<0res20=%xmm9
mulpd SIX_ONE,%xmm9

# qhasm: float6464 0res20 += *(int128 *)(0myp + 320)
# asm 1: addpd 320(<0myp=int64#3),<0res20=int6464#10
# asm 2: addpd 320(<0myp=%rdx),<0res20=%xmm9
addpd 320(%rdx),%xmm9

# qhasm: *(int128 *)(0myp + 304) = 0res19
# asm 1: movdqa <0res19=int6464#9,304(<0myp=int64#3)
# asm 2: movdqa <0res19=%xmm8,304(<0myp=%rdx)
movdqa %xmm8,304(%rdx)

# qhasm: 0res19 = unpack high double of 0res19 and 0res19
# asm 1: unpckhpd <0res19=int6464#9,<0res19=int6464#9
# asm 2: unpckhpd <0res19=%xmm8,<0res19=%xmm8
unpckhpd %xmm8,%xmm8

# qhasm: float6464 0res19 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res19=int6464#9
# asm 2: mulpd SIX_ONE,<0res19=%xmm8
mulpd SIX_ONE,%xmm8

# qhasm: float6464 0res19 += *(int128 *)(0myp + 304)
# asm 1: addpd 304(<0myp=int64#3),<0res19=int6464#9
# asm 2: addpd 304(<0myp=%rdx),<0res19=%xmm8
addpd 304(%rdx),%xmm8

# qhasm: *(int128 *)(0myp + 288) = 0res18
# asm 1: movdqa <0res18=int6464#8,288(<0myp=int64#3)
# asm 2: movdqa <0res18=%xmm7,288(<0myp=%rdx)
movdqa %xmm7,288(%rdx)

# qhasm: 0res18 = unpack high double of 0res18 and 0res18
# asm 1: unpckhpd <0res18=int6464#8,<0res18=int6464#8
# asm 2: unpckhpd <0res18=%xmm7,<0res18=%xmm7
unpckhpd %xmm7,%xmm7

# qhasm: float6464 0res18 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res18=int6464#8
# asm 2: mulpd SIX_ONE,<0res18=%xmm7
mulpd SIX_ONE,%xmm7

# qhasm: float6464 0res18 += *(int128 *)(0myp + 288)
# asm 1: addpd 288(<0myp=int64#3),<0res18=int6464#8
# asm 2: addpd 288(<0myp=%rdx),<0res18=%xmm7
addpd 288(%rdx),%xmm7

# qhasm: *(int128 *)(0myp + 272) = 0res17
# asm 1: movdqa <0res17=int6464#7,272(<0myp=int64#3)
# asm 2: movdqa <0res17=%xmm6,272(<0myp=%rdx)
movdqa %xmm6,272(%rdx)

# qhasm: 0res17 = unpack high double of 0res17 and 0res17
# asm 1: unpckhpd <0res17=int6464#7,<0res17=int6464#7
# asm 2: unpckhpd <0res17=%xmm6,<0res17=%xmm6
unpckhpd %xmm6,%xmm6

# qhasm: float6464 0res17 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res17=int6464#7
# asm 2: mulpd SIX_ONE,<0res17=%xmm6
mulpd SIX_ONE,%xmm6

# qhasm: float6464 0res17 += *(int128 *)(0myp + 272)
# asm 1: addpd 272(<0myp=int64#3),<0res17=int6464#7
# asm 2: addpd 272(<0myp=%rdx),<0res17=%xmm6
addpd 272(%rdx),%xmm6

# qhasm: *(int128 *)(0myp + 256) = 0res16
# asm 1: movdqa <0res16=int6464#6,256(<0myp=int64#3)
# asm 2: movdqa <0res16=%xmm5,256(<0myp=%rdx)
movdqa %xmm5,256(%rdx)

# qhasm: 0res16 = unpack high double of 0res16 and 0res16
# asm 1: unpckhpd <0res16=int6464#6,<0res16=int6464#6
# asm 2: unpckhpd <0res16=%xmm5,<0res16=%xmm5
unpckhpd %xmm5,%xmm5

# qhasm: float6464 0res16 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res16=int6464#6
# asm 2: mulpd SIX_ONE,<0res16=%xmm5
mulpd SIX_ONE,%xmm5

# qhasm: float6464 0res16 += *(int128 *)(0myp + 256)
# asm 1: addpd 256(<0myp=int64#3),<0res16=int6464#6
# asm 2: addpd 256(<0myp=%rdx),<0res16=%xmm5
addpd 256(%rdx),%xmm5

# qhasm: *(int128 *)(0myp + 240) = 0res15
# asm 1: movdqa <0res15=int6464#5,240(<0myp=int64#3)
# asm 2: movdqa <0res15=%xmm4,240(<0myp=%rdx)
movdqa %xmm4,240(%rdx)

# qhasm: 0res15 = unpack high double of 0res15 and 0res15
# asm 1: unpckhpd <0res15=int6464#5,<0res15=int6464#5
# asm 2: unpckhpd <0res15=%xmm4,<0res15=%xmm4
unpckhpd %xmm4,%xmm4

# qhasm: float6464 0res15 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res15=int6464#5
# asm 2: mulpd SIX_ONE,<0res15=%xmm4
mulpd SIX_ONE,%xmm4

# qhasm: float6464 0res15 += *(int128 *)(0myp + 240)
# asm 1: addpd 240(<0myp=int64#3),<0res15=int6464#5
# asm 2: addpd 240(<0myp=%rdx),<0res15=%xmm4
addpd 240(%rdx),%xmm4

# qhasm: *(int128 *)(0myp + 224) = 0res14
# asm 1: movdqa <0res14=int6464#4,224(<0myp=int64#3)
# asm 2: movdqa <0res14=%xmm3,224(<0myp=%rdx)
movdqa %xmm3,224(%rdx)

# qhasm: 0res14 = unpack high double of 0res14 and 0res14
# asm 1: unpckhpd <0res14=int6464#4,<0res14=int6464#4
# asm 2: unpckhpd <0res14=%xmm3,<0res14=%xmm3
unpckhpd %xmm3,%xmm3

# qhasm: float6464 0res14 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res14=int6464#4
# asm 2: mulpd SIX_ONE,<0res14=%xmm3
mulpd SIX_ONE,%xmm3

# qhasm: float6464 0res14 += *(int128 *)(0myp + 224)
# asm 1: addpd 224(<0myp=int64#3),<0res14=int6464#4
# asm 2: addpd 224(<0myp=%rdx),<0res14=%xmm3
addpd 224(%rdx),%xmm3

# qhasm: *(int128 *)(0myp + 208) = 0res13
# asm 1: movdqa <0res13=int6464#3,208(<0myp=int64#3)
# asm 2: movdqa <0res13=%xmm2,208(<0myp=%rdx)
movdqa %xmm2,208(%rdx)

# qhasm: 0res13 = unpack high double of 0res13 and 0res13
# asm 1: unpckhpd <0res13=int6464#3,<0res13=int6464#3
# asm 2: unpckhpd <0res13=%xmm2,<0res13=%xmm2
unpckhpd %xmm2,%xmm2

# qhasm: float6464 0res13 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res13=int6464#3
# asm 2: mulpd SIX_ONE,<0res13=%xmm2
mulpd SIX_ONE,%xmm2

# qhasm: float6464 0res13 += *(int128 *)(0myp + 208)
# asm 1: addpd 208(<0myp=int64#3),<0res13=int6464#3
# asm 2: addpd 208(<0myp=%rdx),<0res13=%xmm2
addpd 208(%rdx),%xmm2

# qhasm: *(int128 *)(0myp + 192) = 0res12
# asm 1: movdqa <0res12=int6464#2,192(<0myp=int64#3)
# asm 2: movdqa <0res12=%xmm1,192(<0myp=%rdx)
movdqa %xmm1,192(%rdx)

# qhasm: 0res12 = unpack high double of 0res12 and 0res12
# asm 1: unpckhpd <0res12=int6464#2,<0res12=int6464#2
# asm 2: unpckhpd <0res12=%xmm1,<0res12=%xmm1
unpckhpd %xmm1,%xmm1

# qhasm: float6464 0res12 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res12=int6464#2
# asm 2: mulpd SIX_ONE,<0res12=%xmm1
mulpd SIX_ONE,%xmm1

# qhasm: float6464 0res12 += *(int128 *)(0myp + 192)
# asm 1: addpd 192(<0myp=int64#3),<0res12=int6464#2
# asm 2: addpd 192(<0myp=%rdx),<0res12=%xmm1
addpd 192(%rdx),%xmm1

# qhasm: 0res11 = *(int128 *)(0resp + 176)
# asm 1: movdqa 176(<0resp=int64#5),>0res11=int6464#1
# asm 2: movdqa 176(<0resp=%r8),>0res11=%xmm0
movdqa 176(%r8),%xmm0

# qhasm: 0res11 = unpack high double of 0res11 and 0res11
# asm 1: unpckhpd <0res11=int6464#1,<0res11=int6464#1
# asm 2: unpckhpd <0res11=%xmm0,<0res11=%xmm0
unpckhpd %xmm0,%xmm0

# qhasm: float6464 0res11 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res11=int6464#1
# asm 2: mulpd SIX_ONE,<0res11=%xmm0
mulpd SIX_ONE,%xmm0

# qhasm: float6464 0res11 += *(int128 *)(0resp + 176)
# asm 1: addpd 176(<0resp=int64#5),<0res11=int6464#1
# asm 2: addpd 176(<0resp=%r8),<0res11=%xmm0
addpd 176(%r8),%xmm0

# qhasm: *(int128 *)(0myp + 176) = 0res11
# asm 1: movdqa <0res11=int6464#1,176(<0myp=int64#3)
# asm 2: movdqa <0res11=%xmm0,176(<0myp=%rdx)
movdqa %xmm0,176(%rdx)

# qhasm: 0res10 = *(int128 *)(0resp + 160)
# asm 1: movdqa 160(<0resp=int64#5),>0res10=int6464#1
# asm 2: movdqa 160(<0resp=%r8),>0res10=%xmm0
movdqa 160(%r8),%xmm0

# qhasm: 0res10 = unpack high double of 0res10 and 0res10
# asm 1: unpckhpd <0res10=int6464#1,<0res10=int6464#1
# asm 2: unpckhpd <0res10=%xmm0,<0res10=%xmm0
unpckhpd %xmm0,%xmm0

# qhasm: float6464 0res10 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res10=int6464#1
# asm 2: mulpd SIX_ONE,<0res10=%xmm0
mulpd SIX_ONE,%xmm0

# qhasm: float6464 0res10 += *(int128 *)(0resp + 160)
# asm 1: addpd 160(<0resp=int64#5),<0res10=int6464#1
# asm 2: addpd 160(<0resp=%r8),<0res10=%xmm0
addpd 160(%r8),%xmm0

# qhasm: *(int128 *)(0myp + 160) = 0res10
# asm 1: movdqa <0res10=int6464#1,160(<0myp=int64#3)
# asm 2: movdqa <0res10=%xmm0,160(<0myp=%rdx)
movdqa %xmm0,160(%rdx)

# qhasm: 0res9 = *(int128 *)(0resp + 144)
# asm 1: movdqa 144(<0resp=int64#5),>0res9=int6464#1
# asm 2: movdqa 144(<0resp=%r8),>0res9=%xmm0
movdqa 144(%r8),%xmm0

# qhasm: 0res9 = unpack high double of 0res9 and 0res9
# asm 1: unpckhpd <0res9=int6464#1,<0res9=int6464#1
# asm 2: unpckhpd <0res9=%xmm0,<0res9=%xmm0
unpckhpd %xmm0,%xmm0

# qhasm: float6464 0res9 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res9=int6464#1
# asm 2: mulpd SIX_ONE,<0res9=%xmm0
mulpd SIX_ONE,%xmm0

# qhasm: float6464 0res9 += *(int128 *)(0resp + 144)
# asm 1: addpd 144(<0resp=int64#5),<0res9=int6464#1
# asm 2: addpd 144(<0resp=%r8),<0res9=%xmm0
addpd 144(%r8),%xmm0

# qhasm: *(int128 *)(0myp + 144) = 0res9
# asm 1: movdqa <0res9=int6464#1,144(<0myp=int64#3)
# asm 2: movdqa <0res9=%xmm0,144(<0myp=%rdx)
movdqa %xmm0,144(%rdx)

# qhasm: 0res8 = *(int128 *)(0resp + 128)
# asm 1: movdqa 128(<0resp=int64#5),>0res8=int6464#1
# asm 2: movdqa 128(<0resp=%r8),>0res8=%xmm0
movdqa 128(%r8),%xmm0

# qhasm: 0res8 = unpack high double of 0res8 and 0res8
# asm 1: unpckhpd <0res8=int6464#1,<0res8=int6464#1
# asm 2: unpckhpd <0res8=%xmm0,<0res8=%xmm0
unpckhpd %xmm0,%xmm0

# qhasm: float6464 0res8 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res8=int6464#1
# asm 2: mulpd SIX_ONE,<0res8=%xmm0
mulpd SIX_ONE,%xmm0

# qhasm: float6464 0res8 += *(int128 *)(0resp + 128)
# asm 1: addpd 128(<0resp=int64#5),<0res8=int6464#1
# asm 2: addpd 128(<0resp=%r8),<0res8=%xmm0
addpd 128(%r8),%xmm0

# qhasm: *(int128 *)(0myp + 128) = 0res8
# asm 1: movdqa <0res8=int6464#1,128(<0myp=int64#3)
# asm 2: movdqa <0res8=%xmm0,128(<0myp=%rdx)
movdqa %xmm0,128(%rdx)

# qhasm: 0res7 = *(int128 *)(0resp + 112)
# asm 1: movdqa 112(<0resp=int64#5),>0res7=int6464#1
# asm 2: movdqa 112(<0resp=%r8),>0res7=%xmm0
movdqa 112(%r8),%xmm0

# qhasm: 0res7 = unpack high double of 0res7 and 0res7
# asm 1: unpckhpd <0res7=int6464#1,<0res7=int6464#1
# asm 2: unpckhpd <0res7=%xmm0,<0res7=%xmm0
unpckhpd %xmm0,%xmm0

# qhasm: float6464 0res7 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res7=int6464#1
# asm 2: mulpd SIX_ONE,<0res7=%xmm0
mulpd SIX_ONE,%xmm0

# qhasm: float6464 0res7 += *(int128 *)(0resp + 112)
# asm 1: addpd 112(<0resp=int64#5),<0res7=int6464#1
# asm 2: addpd 112(<0resp=%r8),<0res7=%xmm0
addpd 112(%r8),%xmm0

# qhasm: *(int128 *)(0myp + 112) = 0res7
# asm 1: movdqa <0res7=int6464#1,112(<0myp=int64#3)
# asm 2: movdqa <0res7=%xmm0,112(<0myp=%rdx)
movdqa %xmm0,112(%rdx)

# qhasm: 0res6 = *(int128 *)(0resp + 96)
# asm 1: movdqa 96(<0resp=int64#5),>0res6=int6464#1
# asm 2: movdqa 96(<0resp=%r8),>0res6=%xmm0
movdqa 96(%r8),%xmm0

# qhasm: 0res6 = unpack high double of 0res6 and 0res6
# asm 1: unpckhpd <0res6=int6464#1,<0res6=int6464#1
# asm 2: unpckhpd <0res6=%xmm0,<0res6=%xmm0
unpckhpd %xmm0,%xmm0

# qhasm: float6464 0res6 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res6=int6464#1
# asm 2: mulpd SIX_ONE,<0res6=%xmm0
mulpd SIX_ONE,%xmm0

# qhasm: float6464 0res6 += *(int128 *)(0resp + 96)
# asm 1: addpd 96(<0resp=int64#5),<0res6=int6464#1
# asm 2: addpd 96(<0resp=%r8),<0res6=%xmm0
addpd 96(%r8),%xmm0

# qhasm: *(int128 *)(0myp + 96) = 0res6
# asm 1: movdqa <0res6=int6464#1,96(<0myp=int64#3)
# asm 2: movdqa <0res6=%xmm0,96(<0myp=%rdx)
movdqa %xmm0,96(%rdx)

# qhasm: 0res5 = *(int128 *)(0resp + 80)
# asm 1: movdqa 80(<0resp=int64#5),>0res5=int6464#1
# asm 2: movdqa 80(<0resp=%r8),>0res5=%xmm0
movdqa 80(%r8),%xmm0

# qhasm: 0res5 = unpack high double of 0res5 and 0res5
# asm 1: unpckhpd <0res5=int6464#1,<0res5=int6464#1
# asm 2: unpckhpd <0res5=%xmm0,<0res5=%xmm0
unpckhpd %xmm0,%xmm0

# qhasm: float6464 0res5 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res5=int6464#1
# asm 2: mulpd SIX_ONE,<0res5=%xmm0
mulpd SIX_ONE,%xmm0

# qhasm: float6464 0res5 += *(int128 *)(0resp + 80)
# asm 1: addpd 80(<0resp=int64#5),<0res5=int6464#1
# asm 2: addpd 80(<0resp=%r8),<0res5=%xmm0
addpd 80(%r8),%xmm0

# qhasm: *(int128 *)(0myp + 80) = 0res5
# asm 1: movdqa <0res5=int6464#1,80(<0myp=int64#3)
# asm 2: movdqa <0res5=%xmm0,80(<0myp=%rdx)
movdqa %xmm0,80(%rdx)

# qhasm: 0res4 = *(int128 *)(0resp + 64)
# asm 1: movdqa 64(<0resp=int64#5),>0res4=int6464#1
# asm 2: movdqa 64(<0resp=%r8),>0res4=%xmm0
movdqa 64(%r8),%xmm0

# qhasm: 0res4 = unpack high double of 0res4 and 0res4
# asm 1: unpckhpd <0res4=int6464#1,<0res4=int6464#1
# asm 2: unpckhpd <0res4=%xmm0,<0res4=%xmm0
unpckhpd %xmm0,%xmm0

# qhasm: float6464 0res4 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res4=int6464#1
# asm 2: mulpd SIX_ONE,<0res4=%xmm0
mulpd SIX_ONE,%xmm0

# qhasm: float6464 0res4 += *(int128 *)(0resp + 64)
# asm 1: addpd 64(<0resp=int64#5),<0res4=int6464#1
# asm 2: addpd 64(<0resp=%r8),<0res4=%xmm0
addpd 64(%r8),%xmm0

# qhasm: *(int128 *)(0myp + 64) = 0res4
# asm 1: movdqa <0res4=int6464#1,64(<0myp=int64#3)
# asm 2: movdqa <0res4=%xmm0,64(<0myp=%rdx)
movdqa %xmm0,64(%rdx)

# qhasm: 0res3 = *(int128 *)(0resp + 48)
# asm 1: movdqa 48(<0resp=int64#5),>0res3=int6464#1
# asm 2: movdqa 48(<0resp=%r8),>0res3=%xmm0
movdqa 48(%r8),%xmm0

# qhasm: 0res3 = unpack high double of 0res3 and 0res3
# asm 1: unpckhpd <0res3=int6464#1,<0res3=int6464#1
# asm 2: unpckhpd <0res3=%xmm0,<0res3=%xmm0
unpckhpd %xmm0,%xmm0

# qhasm: float6464 0res3 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res3=int6464#1
# asm 2: mulpd SIX_ONE,<0res3=%xmm0
mulpd SIX_ONE,%xmm0

# qhasm: float6464 0res3 += *(int128 *)(0resp + 48)
# asm 1: addpd 48(<0resp=int64#5),<0res3=int6464#1
# asm 2: addpd 48(<0resp=%r8),<0res3=%xmm0
addpd 48(%r8),%xmm0

# qhasm: *(int128 *)(0myp + 48) = 0res3
# asm 1: movdqa <0res3=int6464#1,48(<0myp=int64#3)
# asm 2: movdqa <0res3=%xmm0,48(<0myp=%rdx)
movdqa %xmm0,48(%rdx)

# qhasm: 0res2 = *(int128 *)(0resp + 32)
# asm 1: movdqa 32(<0resp=int64#5),>0res2=int6464#1
# asm 2: movdqa 32(<0resp=%r8),>0res2=%xmm0
movdqa 32(%r8),%xmm0

# qhasm: 0res2 = unpack high double of 0res2 and 0res2
# asm 1: unpckhpd <0res2=int6464#1,<0res2=int6464#1
# asm 2: unpckhpd <0res2=%xmm0,<0res2=%xmm0
unpckhpd %xmm0,%xmm0

# qhasm: float6464 0res2 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res2=int6464#1
# asm 2: mulpd SIX_ONE,<0res2=%xmm0
mulpd SIX_ONE,%xmm0

# qhasm: float6464 0res2 += *(int128 *)(0resp + 32)
# asm 1: addpd 32(<0resp=int64#5),<0res2=int6464#1
# asm 2: addpd 32(<0resp=%r8),<0res2=%xmm0
addpd 32(%r8),%xmm0

# qhasm: *(int128 *)(0myp + 32) = 0res2
# asm 1: movdqa <0res2=int6464#1,32(<0myp=int64#3)
# asm 2: movdqa <0res2=%xmm0,32(<0myp=%rdx)
movdqa %xmm0,32(%rdx)

# qhasm: 0res1 = *(int128 *)(0resp + 16)
# asm 1: movdqa 16(<0resp=int64#5),>0res1=int6464#1
# asm 2: movdqa 16(<0resp=%r8),>0res1=%xmm0
movdqa 16(%r8),%xmm0

# qhasm: 0res1 = unpack high double of 0res1 and 0res1
# asm 1: unpckhpd <0res1=int6464#1,<0res1=int6464#1
# asm 2: unpckhpd <0res1=%xmm0,<0res1=%xmm0
unpckhpd %xmm0,%xmm0

# qhasm: float6464 0res1 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res1=int6464#1
# asm 2: mulpd SIX_ONE,<0res1=%xmm0
mulpd SIX_ONE,%xmm0

# qhasm: float6464 0res1 += *(int128 *)(0resp + 16)
# asm 1: addpd 16(<0resp=int64#5),<0res1=int6464#1
# asm 2: addpd 16(<0resp=%r8),<0res1=%xmm0
addpd 16(%r8),%xmm0

# qhasm: *(int128 *)(0myp + 16) = 0res1
# asm 1: movdqa <0res1=int6464#1,16(<0myp=int64#3)
# asm 2: movdqa <0res1=%xmm0,16(<0myp=%rdx)
movdqa %xmm0,16(%rdx)

# qhasm: 0res0 = *(int128 *)(0resp + 0)
# asm 1: movdqa 0(<0resp=int64#5),>0res0=int6464#1
# asm 2: movdqa 0(<0resp=%r8),>0res0=%xmm0
movdqa 0(%r8),%xmm0

# qhasm: 0res0 = unpack high double of 0res0 and 0res0
# asm 1: unpckhpd <0res0=int6464#1,<0res0=int6464#1
# asm 2: unpckhpd <0res0=%xmm0,<0res0=%xmm0
unpckhpd %xmm0,%xmm0

# qhasm: float6464 0res0 *= SIX_ONE
# asm 1: mulpd SIX_ONE,<0res0=int6464#1
# asm 2: mulpd SIX_ONE,<0res0=%xmm0
mulpd SIX_ONE,%xmm0

# qhasm: float6464 0res0 += *(int128 *)(0resp + 0)
# asm 1: addpd 0(<0resp=int64#5),<0res0=int6464#1
# asm 2: addpd 0(<0resp=%r8),<0res0=%xmm0
addpd 0(%r8),%xmm0

# qhasm: *(int128 *)(0myp + 0) = 0res0
# asm 1: movdqa <0res0=int6464#1,0(<0myp=int64#3)
# asm 2: movdqa <0res0=%xmm0,0(<0myp=%rdx)
movdqa %xmm0,0(%rdx)

# qhasm: int6464 2r0

# qhasm: int6464 2r1

# qhasm: int6464 2r2

# qhasm: int6464 2r3

# qhasm: int6464 2r4

# qhasm: int6464 2r5

# qhasm: int6464 2r6

# qhasm: int6464 2r7

# qhasm: int6464 2r8

# qhasm: int6464 2r9

# qhasm: int6464 2r10

# qhasm: int6464 2r11

# qhasm: int6464 1t0

# qhasm: int6464 1t1

# qhasm: int6464 1t2

# qhasm: int6464 1t3

# qhasm: int6464 1t4

# qhasm: int6464 1t5

# qhasm: int6464 1t6

# qhasm: int6464 1t7

# qhasm: int6464 1t8

# qhasm: int6464 1t9

# qhasm: int6464 1t10

# qhasm: int6464 1t11

# qhasm: int6464 1t12

# qhasm: int6464 1t13

# qhasm: int6464 1t14

# qhasm: int6464 1t15

# qhasm: int6464 1t16

# qhasm: int6464 1t17

# qhasm: int6464 1t18

# qhasm: int6464 1t19

# qhasm: int6464 1t20

# qhasm: int6464 1t21

# qhasm: int6464 1t22

# qhasm: 2r0 = *(int128 *)(0myp + 0)
# asm 1: movdqa 0(<0myp=int64#3),>2r0=int6464#1
# asm 2: movdqa 0(<0myp=%rdx),>2r0=%xmm0
movdqa 0(%rdx),%xmm0

# qhasm: float6464 2r0 -= 0res12
# asm 1: subpd <0res12=int6464#2,<2r0=int6464#1
# asm 2: subpd <0res12=%xmm1,<2r0=%xmm0
subpd %xmm1,%xmm0

# qhasm: 1t15 = 0res15
# asm 1: movdqa <0res15=int6464#5,>1t15=int6464#13
# asm 2: movdqa <0res15=%xmm4,>1t15=%xmm12
movdqa %xmm4,%xmm12

# qhasm: float6464 1t15 *= SIX_SIX
# asm 1: mulpd SIX_SIX,<1t15=int6464#13
# asm 2: mulpd SIX_SIX,<1t15=%xmm12
mulpd SIX_SIX,%xmm12

# qhasm: float6464 2r0 += 1t15
# asm 1: addpd <1t15=int6464#13,<2r0=int6464#1
# asm 2: addpd <1t15=%xmm12,<2r0=%xmm0
addpd %xmm12,%xmm0

# qhasm: 1t18 = 0res18
# asm 1: movdqa <0res18=int6464#8,>1t18=int6464#13
# asm 2: movdqa <0res18=%xmm7,>1t18=%xmm12
movdqa %xmm7,%xmm12

# qhasm: float6464 1t18 *= TWO_TWO
# asm 1: mulpd TWO_TWO,<1t18=int6464#13
# asm 2: mulpd TWO_TWO,<1t18=%xmm12
mulpd TWO_TWO,%xmm12

# qhasm: float6464 2r0 -= 1t18
# asm 1: subpd <1t18=int6464#13,<2r0=int6464#1
# asm 2: subpd <1t18=%xmm12,<2r0=%xmm0
subpd %xmm12,%xmm0

# qhasm: 1t21 = 0res21
# asm 1: movdqa <0res21=int6464#11,>1t21=int6464#13
# asm 2: movdqa <0res21=%xmm10,>1t21=%xmm12
movdqa %xmm10,%xmm12

# qhasm: float6464 1t21 *= SIX_SIX
# asm 1: mulpd SIX_SIX,<1t21=int6464#13
# asm 2: mulpd SIX_SIX,<1t21=%xmm12
mulpd SIX_SIX,%xmm12

# qhasm: float6464 2r0 -= 1t21
# asm 1: subpd <1t21=int6464#13,<2r0=int6464#1
# asm 2: subpd <1t21=%xmm12,<2r0=%xmm0
subpd %xmm12,%xmm0

# qhasm: *(int128 *)(0myp + 0) = 2r0
# asm 1: movdqa <2r0=int6464#1,0(<0myp=int64#3)
# asm 2: movdqa <2r0=%xmm0,0(<0myp=%rdx)
movdqa %xmm0,0(%rdx)

# qhasm: 2r3 = *(int128 *)(0myp + 48)
# asm 1: movdqa 48(<0myp=int64#3),>2r3=int6464#1
# asm 2: movdqa 48(<0myp=%rdx),>2r3=%xmm0
movdqa 48(%rdx),%xmm0

# qhasm: float6464 2r3 -= 0res12
# asm 1: subpd <0res12=int6464#2,<2r3=int6464#1
# asm 2: subpd <0res12=%xmm1,<2r3=%xmm0
subpd %xmm1,%xmm0

# qhasm: 1t15 = 0res15
# asm 1: movdqa <0res15=int6464#5,>1t15=int6464#13
# asm 2: movdqa <0res15=%xmm4,>1t15=%xmm12
movdqa %xmm4,%xmm12

# qhasm: float6464 1t15 *= FIVE_FIVE
# asm 1: mulpd FIVE_FIVE,<1t15=int6464#13
# asm 2: mulpd FIVE_FIVE,<1t15=%xmm12
mulpd FIVE_FIVE,%xmm12

# qhasm: float6464 2r3 += 1t15
# asm 1: addpd <1t15=int6464#13,<2r3=int6464#1
# asm 2: addpd <1t15=%xmm12,<2r3=%xmm0
addpd %xmm12,%xmm0

# qhasm: float6464 2r3 -= 0res18
# asm 1: subpd <0res18=int6464#8,<2r3=int6464#1
# asm 2: subpd <0res18=%xmm7,<2r3=%xmm0
subpd %xmm7,%xmm0

# qhasm: 1t21 = 0res21
# asm 1: movdqa <0res21=int6464#11,>1t21=int6464#13
# asm 2: movdqa <0res21=%xmm10,>1t21=%xmm12
movdqa %xmm10,%xmm12

# qhasm: float6464 1t21 *= EIGHT_EIGHT
# asm 1: mulpd EIGHT_EIGHT,<1t21=int6464#13
# asm 2: mulpd EIGHT_EIGHT,<1t21=%xmm12
mulpd EIGHT_EIGHT,%xmm12

# qhasm: float6464 2r3 -= 1t21
# asm 1: subpd <1t21=int6464#13,<2r3=int6464#1
# asm 2: subpd <1t21=%xmm12,<2r3=%xmm0
subpd %xmm12,%xmm0

# qhasm: *(int128 *)(0myp + 48) = 2r3
# asm 1: movdqa <2r3=int6464#1,48(<0myp=int64#3)
# asm 2: movdqa <2r3=%xmm0,48(<0myp=%rdx)
movdqa %xmm0,48(%rdx)

# qhasm: 2r6 = *(int128 *)(0myp + 96)
# asm 1: movdqa 96(<0myp=int64#3),>2r6=int6464#1
# asm 2: movdqa 96(<0myp=%rdx),>2r6=%xmm0
movdqa 96(%rdx),%xmm0

# qhasm: 1t12 = 0res12
# asm 1: movdqa <0res12=int6464#2,>1t12=int6464#13
# asm 2: movdqa <0res12=%xmm1,>1t12=%xmm12
movdqa %xmm1,%xmm12

# qhasm: float6464 1t12 *= FOUR_FOUR
# asm 1: mulpd FOUR_FOUR,<1t12=int6464#13
# asm 2: mulpd FOUR_FOUR,<1t12=%xmm12
mulpd FOUR_FOUR,%xmm12

# qhasm: float6464 2r6 -= 1t12
# asm 1: subpd <1t12=int6464#13,<2r6=int6464#1
# asm 2: subpd <1t12=%xmm12,<2r6=%xmm0
subpd %xmm12,%xmm0

# qhasm: 1t15 = 0res15
# asm 1: movdqa <0res15=int6464#5,>1t15=int6464#13
# asm 2: movdqa <0res15=%xmm4,>1t15=%xmm12
movdqa %xmm4,%xmm12

# qhasm: float6464 1t15 *= EIGHTEEN_EIGHTEEN
# asm 1: mulpd EIGHTEEN_EIGHTEEN,<1t15=int6464#13
# asm 2: mulpd EIGHTEEN_EIGHTEEN,<1t15=%xmm12
mulpd EIGHTEEN_EIGHTEEN,%xmm12

# qhasm: float6464 2r6 += 1t15
# asm 1: addpd <1t15=int6464#13,<2r6=int6464#1
# asm 2: addpd <1t15=%xmm12,<2r6=%xmm0
addpd %xmm12,%xmm0

# qhasm: 1t18 = 0res18
# asm 1: movdqa <0res18=int6464#8,>1t18=int6464#13
# asm 2: movdqa <0res18=%xmm7,>1t18=%xmm12
movdqa %xmm7,%xmm12

# qhasm: float6464 1t18 *= THREE_THREE
# asm 1: mulpd THREE_THREE,<1t18=int6464#13
# asm 2: mulpd THREE_THREE,<1t18=%xmm12
mulpd THREE_THREE,%xmm12

# qhasm: float6464 2r6 -= 1t18
# asm 1: subpd <1t18=int6464#13,<2r6=int6464#1
# asm 2: subpd <1t18=%xmm12,<2r6=%xmm0
subpd %xmm12,%xmm0

# qhasm: 1t21 = 0res21
# asm 1: movdqa <0res21=int6464#11,>1t21=int6464#13
# asm 2: movdqa <0res21=%xmm10,>1t21=%xmm12
movdqa %xmm10,%xmm12

# qhasm: float6464 1t21 *= THIRTY_THIRTY
# asm 1: mulpd THIRTY_THIRTY,<1t21=int6464#13
# asm 2: mulpd THIRTY_THIRTY,<1t21=%xmm12
mulpd THIRTY_THIRTY,%xmm12

# qhasm: float6464 2r6 -= 1t21
# asm 1: subpd <1t21=int6464#13,<2r6=int6464#1
# asm 2: subpd <1t21=%xmm12,<2r6=%xmm0
subpd %xmm12,%xmm0

# qhasm: *(int128 *)(0myp + 96) = 2r6
# asm 1: movdqa <2r6=int6464#1,96(<0myp=int64#3)
# asm 2: movdqa <2r6=%xmm0,96(<0myp=%rdx)
movdqa %xmm0,96(%rdx)

# qhasm: 2r9 = *(int128 *)(0myp + 144)
# asm 1: movdqa 144(<0myp=int64#3),>2r9=int6464#1
# asm 2: movdqa 144(<0myp=%rdx),>2r9=%xmm0
movdqa 144(%rdx),%xmm0

# qhasm: float6464 2r9 -= 0res12
# asm 1: subpd <0res12=int6464#2,<2r9=int6464#1
# asm 2: subpd <0res12=%xmm1,<2r9=%xmm0
subpd %xmm1,%xmm0

# qhasm: 1t15 = 0res15
# asm 1: movdqa <0res15=int6464#5,>1t15=int6464#2
# asm 2: movdqa <0res15=%xmm4,>1t15=%xmm1
movdqa %xmm4,%xmm1

# qhasm: float6464 1t15 *= TWO_TWO
# asm 1: mulpd TWO_TWO,<1t15=int6464#2
# asm 2: mulpd TWO_TWO,<1t15=%xmm1
mulpd TWO_TWO,%xmm1

# qhasm: float6464 2r9 += 1t15
# asm 1: addpd <1t15=int6464#2,<2r9=int6464#1
# asm 2: addpd <1t15=%xmm1,<2r9=%xmm0
addpd %xmm1,%xmm0

# qhasm: float6464 2r9 += 0res18
# asm 1: addpd <0res18=int6464#8,<2r9=int6464#1
# asm 2: addpd <0res18=%xmm7,<2r9=%xmm0
addpd %xmm7,%xmm0

# qhasm: 1t21 = 0res21
# asm 1: movdqa <0res21=int6464#11,>1t21=int6464#2
# asm 2: movdqa <0res21=%xmm10,>1t21=%xmm1
movdqa %xmm10,%xmm1

# qhasm: float6464 1t21 *= NINE_NINE
# asm 1: mulpd NINE_NINE,<1t21=int6464#2
# asm 2: mulpd NINE_NINE,<1t21=%xmm1
mulpd NINE_NINE,%xmm1

# qhasm: float6464 2r9 -= 1t21
# asm 1: subpd <1t21=int6464#2,<2r9=int6464#1
# asm 2: subpd <1t21=%xmm1,<2r9=%xmm0
subpd %xmm1,%xmm0

# qhasm: *(int128 *)(0myp + 144) = 2r9
# asm 1: movdqa <2r9=int6464#1,144(<0myp=int64#3)
# asm 2: movdqa <2r9=%xmm0,144(<0myp=%rdx)
movdqa %xmm0,144(%rdx)

# qhasm: 2r1 = *(int128 *)(0myp + 16)
# asm 1: movdqa 16(<0myp=int64#3),>2r1=int6464#1
# asm 2: movdqa 16(<0myp=%rdx),>2r1=%xmm0
movdqa 16(%rdx),%xmm0

# qhasm: float6464 2r1 -= 0res13
# asm 1: subpd <0res13=int6464#3,<2r1=int6464#1
# asm 2: subpd <0res13=%xmm2,<2r1=%xmm0
subpd %xmm2,%xmm0

# qhasm: float6464 2r1 += 0res16
# asm 1: addpd <0res16=int6464#6,<2r1=int6464#1
# asm 2: addpd <0res16=%xmm5,<2r1=%xmm0
addpd %xmm5,%xmm0

# qhasm: 1t19 = 0res19
# asm 1: movdqa <0res19=int6464#9,>1t19=int6464#2
# asm 2: movdqa <0res19=%xmm8,>1t19=%xmm1
movdqa %xmm8,%xmm1

# qhasm: float6464 1t19 *= TWO_TWO
# asm 1: mulpd TWO_TWO,<1t19=int6464#2
# asm 2: mulpd TWO_TWO,<1t19=%xmm1
mulpd TWO_TWO,%xmm1

# qhasm: float6464 2r1 -= 1t19
# asm 1: subpd <1t19=int6464#2,<2r1=int6464#1
# asm 2: subpd <1t19=%xmm1,<2r1=%xmm0
subpd %xmm1,%xmm0

# qhasm: float6464 2r1 -= 0res22
# asm 1: subpd <0res22=int6464#12,<2r1=int6464#1
# asm 2: subpd <0res22=%xmm11,<2r1=%xmm0
subpd %xmm11,%xmm0

# qhasm: *(int128 *)(0myp + 16) = 2r1
# asm 1: movdqa <2r1=int6464#1,16(<0myp=int64#3)
# asm 2: movdqa <2r1=%xmm0,16(<0myp=%rdx)
movdqa %xmm0,16(%rdx)

# qhasm: 2r4 = *(int128 *)(0myp + 64)
# asm 1: movdqa 64(<0myp=int64#3),>2r4=int6464#1
# asm 2: movdqa 64(<0myp=%rdx),>2r4=%xmm0
movdqa 64(%rdx),%xmm0

# qhasm: 1t13 = 0res13
# asm 1: movdqa <0res13=int6464#3,>1t13=int6464#2
# asm 2: movdqa <0res13=%xmm2,>1t13=%xmm1
movdqa %xmm2,%xmm1

# qhasm: float6464 1t13 *= SIX_SIX
# asm 1: mulpd SIX_SIX,<1t13=int6464#2
# asm 2: mulpd SIX_SIX,<1t13=%xmm1
mulpd SIX_SIX,%xmm1

# qhasm: float6464 2r4 -= 1t13
# asm 1: subpd <1t13=int6464#2,<2r4=int6464#1
# asm 2: subpd <1t13=%xmm1,<2r4=%xmm0
subpd %xmm1,%xmm0

# qhasm: 1t16 = 0res16
# asm 1: movdqa <0res16=int6464#6,>1t16=int6464#2
# asm 2: movdqa <0res16=%xmm5,>1t16=%xmm1
movdqa %xmm5,%xmm1

# qhasm: float6464 1t16 *= FIVE_FIVE
# asm 1: mulpd FIVE_FIVE,<1t16=int6464#2
# asm 2: mulpd FIVE_FIVE,<1t16=%xmm1
mulpd FIVE_FIVE,%xmm1

# qhasm: float6464 2r4 += 1t16
# asm 1: addpd <1t16=int6464#2,<2r4=int6464#1
# asm 2: addpd <1t16=%xmm1,<2r4=%xmm0
addpd %xmm1,%xmm0

# qhasm: 1t19 = 0res19
# asm 1: movdqa <0res19=int6464#9,>1t19=int6464#2
# asm 2: movdqa <0res19=%xmm8,>1t19=%xmm1
movdqa %xmm8,%xmm1

# qhasm: float6464 1t19 *= SIX_SIX
# asm 1: mulpd SIX_SIX,<1t19=int6464#2
# asm 2: mulpd SIX_SIX,<1t19=%xmm1
mulpd SIX_SIX,%xmm1

# qhasm: float6464 2r4 -= 1t19
# asm 1: subpd <1t19=int6464#2,<2r4=int6464#1
# asm 2: subpd <1t19=%xmm1,<2r4=%xmm0
subpd %xmm1,%xmm0

# qhasm: 1t22 = 0res22
# asm 1: movdqa <0res22=int6464#12,>1t22=int6464#2
# asm 2: movdqa <0res22=%xmm11,>1t22=%xmm1
movdqa %xmm11,%xmm1

# qhasm: float6464 1t22 *= EIGHT_EIGHT
# asm 1: mulpd EIGHT_EIGHT,<1t22=int6464#2
# asm 2: mulpd EIGHT_EIGHT,<1t22=%xmm1
mulpd EIGHT_EIGHT,%xmm1

# qhasm: float6464 2r4 -= 1t22
# asm 1: subpd <1t22=int6464#2,<2r4=int6464#1
# asm 2: subpd <1t22=%xmm1,<2r4=%xmm0
subpd %xmm1,%xmm0

# qhasm: *(int128 *)(0myp + 64) = 2r4
# asm 1: movdqa <2r4=int6464#1,64(<0myp=int64#3)
# asm 2: movdqa <2r4=%xmm0,64(<0myp=%rdx)
movdqa %xmm0,64(%rdx)

# qhasm: 2r7 = *(int128 *)(0myp + 112)
# asm 1: movdqa 112(<0myp=int64#3),>2r7=int6464#1
# asm 2: movdqa 112(<0myp=%rdx),>2r7=%xmm0
movdqa 112(%rdx),%xmm0

# qhasm: 1t13 = 0res13
# asm 1: movdqa <0res13=int6464#3,>1t13=int6464#2
# asm 2: movdqa <0res13=%xmm2,>1t13=%xmm1
movdqa %xmm2,%xmm1

# qhasm: float6464 1t13 *= FOUR_FOUR
# asm 1: mulpd FOUR_FOUR,<1t13=int6464#2
# asm 2: mulpd FOUR_FOUR,<1t13=%xmm1
mulpd FOUR_FOUR,%xmm1

# qhasm: float6464 2r7 -= 1t13
# asm 1: subpd <1t13=int6464#2,<2r7=int6464#1
# asm 2: subpd <1t13=%xmm1,<2r7=%xmm0
subpd %xmm1,%xmm0

# qhasm: 1t16 = 0res16
# asm 1: movdqa <0res16=int6464#6,>1t16=int6464#2
# asm 2: movdqa <0res16=%xmm5,>1t16=%xmm1
movdqa %xmm5,%xmm1

# qhasm: float6464 1t16 *= THREE_THREE
# asm 1: mulpd THREE_THREE,<1t16=int6464#2
# asm 2: mulpd THREE_THREE,<1t16=%xmm1
mulpd THREE_THREE,%xmm1

# qhasm: float6464 2r7 += 1t16
# asm 1: addpd <1t16=int6464#2,<2r7=int6464#1
# asm 2: addpd <1t16=%xmm1,<2r7=%xmm0
addpd %xmm1,%xmm0

# qhasm: 1t19 = 0res19
# asm 1: movdqa <0res19=int6464#9,>1t19=int6464#2
# asm 2: movdqa <0res19=%xmm8,>1t19=%xmm1
movdqa %xmm8,%xmm1

# qhasm: float6464 1t19 *= THREE_THREE
# asm 1: mulpd THREE_THREE,<1t19=int6464#2
# asm 2: mulpd THREE_THREE,<1t19=%xmm1
mulpd THREE_THREE,%xmm1

# qhasm: float6464 2r7 -= 1t19
# asm 1: subpd <1t19=int6464#2,<2r7=int6464#1
# asm 2: subpd <1t19=%xmm1,<2r7=%xmm0
subpd %xmm1,%xmm0

# qhasm: 1t22 = 0res22
# asm 1: movdqa <0res22=int6464#12,>1t22=int6464#2
# asm 2: movdqa <0res22=%xmm11,>1t22=%xmm1
movdqa %xmm11,%xmm1

# qhasm: float6464 1t22 *= FIVE_FIVE
# asm 1: mulpd FIVE_FIVE,<1t22=int6464#2
# asm 2: mulpd FIVE_FIVE,<1t22=%xmm1
mulpd FIVE_FIVE,%xmm1

# qhasm: float6464 2r7 -= 1t22
# asm 1: subpd <1t22=int6464#2,<2r7=int6464#1
# asm 2: subpd <1t22=%xmm1,<2r7=%xmm0
subpd %xmm1,%xmm0

# qhasm: *(int128 *)(0myp + 112) = 2r7
# asm 1: movdqa <2r7=int6464#1,112(<0myp=int64#3)
# asm 2: movdqa <2r7=%xmm0,112(<0myp=%rdx)
movdqa %xmm0,112(%rdx)

# qhasm: 2r10 = *(int128 *)(0myp + 160)
# asm 1: movdqa 160(<0myp=int64#3),>2r10=int6464#1
# asm 2: movdqa 160(<0myp=%rdx),>2r10=%xmm0
movdqa 160(%rdx),%xmm0

# qhasm: 1t13 = 0res13
# asm 1: movdqa <0res13=int6464#3,>1t13=int6464#2
# asm 2: movdqa <0res13=%xmm2,>1t13=%xmm1
movdqa %xmm2,%xmm1

# qhasm: float6464 1t13 *= SIX_SIX
# asm 1: mulpd SIX_SIX,<1t13=int6464#2
# asm 2: mulpd SIX_SIX,<1t13=%xmm1
mulpd SIX_SIX,%xmm1

# qhasm: float6464 2r10 -= 1t13
# asm 1: subpd <1t13=int6464#2,<2r10=int6464#1
# asm 2: subpd <1t13=%xmm1,<2r10=%xmm0
subpd %xmm1,%xmm0

# qhasm: 1t16 = 0res16
# asm 1: movdqa <0res16=int6464#6,>1t16=int6464#2
# asm 2: movdqa <0res16=%xmm5,>1t16=%xmm1
movdqa %xmm5,%xmm1

# qhasm: float6464 1t16 *= TWO_TWO
# asm 1: mulpd TWO_TWO,<1t16=int6464#2
# asm 2: mulpd TWO_TWO,<1t16=%xmm1
mulpd TWO_TWO,%xmm1

# qhasm: float6464 2r10 += 1t16
# asm 1: addpd <1t16=int6464#2,<2r10=int6464#1
# asm 2: addpd <1t16=%xmm1,<2r10=%xmm0
addpd %xmm1,%xmm0

# qhasm: 1t19 = 0res19
# asm 1: movdqa <0res19=int6464#9,>1t19=int6464#2
# asm 2: movdqa <0res19=%xmm8,>1t19=%xmm1
movdqa %xmm8,%xmm1

# qhasm: float6464 1t19 *= SIX_SIX
# asm 1: mulpd SIX_SIX,<1t19=int6464#2
# asm 2: mulpd SIX_SIX,<1t19=%xmm1
mulpd SIX_SIX,%xmm1

# qhasm: float6464 2r10 += 1t19
# asm 1: addpd <1t19=int6464#2,<2r10=int6464#1
# asm 2: addpd <1t19=%xmm1,<2r10=%xmm0
addpd %xmm1,%xmm0

# qhasm: 1t22 = 0res22
# asm 1: movdqa <0res22=int6464#12,>1t22=int6464#2
# asm 2: movdqa <0res22=%xmm11,>1t22=%xmm1
movdqa %xmm11,%xmm1

# qhasm: float6464 1t22 *= NINE_NINE
# asm 1: mulpd NINE_NINE,<1t22=int6464#2
# asm 2: mulpd NINE_NINE,<1t22=%xmm1
mulpd NINE_NINE,%xmm1

# qhasm: float6464 2r10 -= 1t22
# asm 1: subpd <1t22=int6464#2,<2r10=int6464#1
# asm 2: subpd <1t22=%xmm1,<2r10=%xmm0
subpd %xmm1,%xmm0

# qhasm: *(int128 *)(0myp + 160) = 2r10
# asm 1: movdqa <2r10=int6464#1,160(<0myp=int64#3)
# asm 2: movdqa <2r10=%xmm0,160(<0myp=%rdx)
movdqa %xmm0,160(%rdx)

# qhasm: 2r2 = *(int128 *)(0myp + 32)
# asm 1: movdqa 32(<0myp=int64#3),>2r2=int6464#1
# asm 2: movdqa 32(<0myp=%rdx),>2r2=%xmm0
movdqa 32(%rdx),%xmm0

# qhasm: float6464 2r2 -= 0res14
# asm 1: subpd <0res14=int6464#4,<2r2=int6464#1
# asm 2: subpd <0res14=%xmm3,<2r2=%xmm0
subpd %xmm3,%xmm0

# qhasm: float6464 2r2 += 0res17
# asm 1: addpd <0res17=int6464#7,<2r2=int6464#1
# asm 2: addpd <0res17=%xmm6,<2r2=%xmm0
addpd %xmm6,%xmm0

# qhasm: 1t20 = 0res20
# asm 1: movdqa <0res20=int6464#10,>1t20=int6464#2
# asm 2: movdqa <0res20=%xmm9,>1t20=%xmm1
movdqa %xmm9,%xmm1

# qhasm: float6464 1t20 *= TWO_TWO
# asm 1: mulpd TWO_TWO,<1t20=int6464#2
# asm 2: mulpd TWO_TWO,<1t20=%xmm1
mulpd TWO_TWO,%xmm1

# qhasm: float6464 2r2 -= 1t20
# asm 1: subpd <1t20=int6464#2,<2r2=int6464#1
# asm 2: subpd <1t20=%xmm1,<2r2=%xmm0
subpd %xmm1,%xmm0

# qhasm: *(int128 *)(0myp + 32) = 2r2
# asm 1: movdqa <2r2=int6464#1,32(<0myp=int64#3)
# asm 2: movdqa <2r2=%xmm0,32(<0myp=%rdx)
movdqa %xmm0,32(%rdx)

# qhasm: 2r5 = *(int128 *)(0myp + 80)
# asm 1: movdqa 80(<0myp=int64#3),>2r5=int6464#1
# asm 2: movdqa 80(<0myp=%rdx),>2r5=%xmm0
movdqa 80(%rdx),%xmm0

# qhasm: 1t14 = 0res14
# asm 1: movdqa <0res14=int6464#4,>1t14=int6464#2
# asm 2: movdqa <0res14=%xmm3,>1t14=%xmm1
movdqa %xmm3,%xmm1

# qhasm: float6464 1t14 *= SIX_SIX
# asm 1: mulpd SIX_SIX,<1t14=int6464#2
# asm 2: mulpd SIX_SIX,<1t14=%xmm1
mulpd SIX_SIX,%xmm1

# qhasm: float6464 2r5 -= 1t14
# asm 1: subpd <1t14=int6464#2,<2r5=int6464#1
# asm 2: subpd <1t14=%xmm1,<2r5=%xmm0
subpd %xmm1,%xmm0

# qhasm: 1t17 = 0res17
# asm 1: movdqa <0res17=int6464#7,>1t17=int6464#2
# asm 2: movdqa <0res17=%xmm6,>1t17=%xmm1
movdqa %xmm6,%xmm1

# qhasm: float6464 1t17 *= FIVE_FIVE
# asm 1: mulpd FIVE_FIVE,<1t17=int6464#2
# asm 2: mulpd FIVE_FIVE,<1t17=%xmm1
mulpd FIVE_FIVE,%xmm1

# qhasm: float6464 2r5 += 1t17
# asm 1: addpd <1t17=int6464#2,<2r5=int6464#1
# asm 2: addpd <1t17=%xmm1,<2r5=%xmm0
addpd %xmm1,%xmm0

# qhasm: 1t20 = 0res20
# asm 1: movdqa <0res20=int6464#10,>1t20=int6464#2
# asm 2: movdqa <0res20=%xmm9,>1t20=%xmm1
movdqa %xmm9,%xmm1

# qhasm: float6464 1t20 *= SIX_SIX
# asm 1: mulpd SIX_SIX,<1t20=int6464#2
# asm 2: mulpd SIX_SIX,<1t20=%xmm1
mulpd SIX_SIX,%xmm1

# qhasm: float6464 2r5 -= 1t20
# asm 1: subpd <1t20=int6464#2,<2r5=int6464#1
# asm 2: subpd <1t20=%xmm1,<2r5=%xmm0
subpd %xmm1,%xmm0

# qhasm: *(int128 *)(0myp + 80) = 2r5
# asm 1: movdqa <2r5=int6464#1,80(<0myp=int64#3)
# asm 2: movdqa <2r5=%xmm0,80(<0myp=%rdx)
movdqa %xmm0,80(%rdx)

# qhasm: 2r8 = *(int128 *)(0myp + 128)
# asm 1: movdqa 128(<0myp=int64#3),>2r8=int6464#1
# asm 2: movdqa 128(<0myp=%rdx),>2r8=%xmm0
movdqa 128(%rdx),%xmm0

# qhasm: 1t14 = 0res14
# asm 1: movdqa <0res14=int6464#4,>1t14=int6464#2
# asm 2: movdqa <0res14=%xmm3,>1t14=%xmm1
movdqa %xmm3,%xmm1

# qhasm: float6464 1t14 *= FOUR_FOUR
# asm 1: mulpd FOUR_FOUR,<1t14=int6464#2
# asm 2: mulpd FOUR_FOUR,<1t14=%xmm1
mulpd FOUR_FOUR,%xmm1

# qhasm: float6464 2r8 -= 1t14
# asm 1: subpd <1t14=int6464#2,<2r8=int6464#1
# asm 2: subpd <1t14=%xmm1,<2r8=%xmm0
subpd %xmm1,%xmm0

# qhasm: 1t17 = 0res17
# asm 1: movdqa <0res17=int6464#7,>1t17=int6464#2
# asm 2: movdqa <0res17=%xmm6,>1t17=%xmm1
movdqa %xmm6,%xmm1

# qhasm: float6464 1t17 *= THREE_THREE
# asm 1: mulpd THREE_THREE,<1t17=int6464#2
# asm 2: mulpd THREE_THREE,<1t17=%xmm1
mulpd THREE_THREE,%xmm1

# qhasm: float6464 2r8 += 1t17
# asm 1: addpd <1t17=int6464#2,<2r8=int6464#1
# asm 2: addpd <1t17=%xmm1,<2r8=%xmm0
addpd %xmm1,%xmm0

# qhasm: 1t20 = 0res20
# asm 1: movdqa <0res20=int6464#10,>1t20=int6464#2
# asm 2: movdqa <0res20=%xmm9,>1t20=%xmm1
movdqa %xmm9,%xmm1

# qhasm: float6464 1t20 *= THREE_THREE
# asm 1: mulpd THREE_THREE,<1t20=int6464#2
# asm 2: mulpd THREE_THREE,<1t20=%xmm1
mulpd THREE_THREE,%xmm1

# qhasm: float6464 2r8 -= 1t20
# asm 1: subpd <1t20=int6464#2,<2r8=int6464#1
# asm 2: subpd <1t20=%xmm1,<2r8=%xmm0
subpd %xmm1,%xmm0

# qhasm: *(int128 *)(0myp + 128) = 2r8
# asm 1: movdqa <2r8=int6464#1,128(<0myp=int64#3)
# asm 2: movdqa <2r8=%xmm0,128(<0myp=%rdx)
movdqa %xmm0,128(%rdx)

# qhasm: 2r11 = *(int128 *)(0myp + 176)
# asm 1: movdqa 176(<0myp=int64#3),>2r11=int6464#1
# asm 2: movdqa 176(<0myp=%rdx),>2r11=%xmm0
movdqa 176(%rdx),%xmm0

# qhasm: 1t14 = 0res14
# asm 1: movdqa <0res14=int6464#4,>1t14=int6464#2
# asm 2: movdqa <0res14=%xmm3,>1t14=%xmm1
movdqa %xmm3,%xmm1

# qhasm: float6464 1t14 *= SIX_SIX
# asm 1: mulpd SIX_SIX,<1t14=int6464#2
# asm 2: mulpd SIX_SIX,<1t14=%xmm1
mulpd SIX_SIX,%xmm1

# qhasm: float6464 2r11 -= 1t14
# asm 1: subpd <1t14=int6464#2,<2r11=int6464#1
# asm 2: subpd <1t14=%xmm1,<2r11=%xmm0
subpd %xmm1,%xmm0

# qhasm: 1t17 = 0res17
# asm 1: movdqa <0res17=int6464#7,>1t17=int6464#2
# asm 2: movdqa <0res17=%xmm6,>1t17=%xmm1
movdqa %xmm6,%xmm1

# qhasm: float6464 1t17 *= TWO_TWO
# asm 1: mulpd TWO_TWO,<1t17=int6464#2
# asm 2: mulpd TWO_TWO,<1t17=%xmm1
mulpd TWO_TWO,%xmm1

# qhasm: float6464 2r11 += 1t17
# asm 1: addpd <1t17=int6464#2,<2r11=int6464#1
# asm 2: addpd <1t17=%xmm1,<2r11=%xmm0
addpd %xmm1,%xmm0

# qhasm: 1t20 = 0res20
# asm 1: movdqa <0res20=int6464#10,>1t20=int6464#2
# asm 2: movdqa <0res20=%xmm9,>1t20=%xmm1
movdqa %xmm9,%xmm1

# qhasm: float6464 1t20 *= SIX_SIX
# asm 1: mulpd SIX_SIX,<1t20=int6464#2
# asm 2: mulpd SIX_SIX,<1t20=%xmm1
mulpd SIX_SIX,%xmm1

# qhasm: float6464 2r11 += 1t20
# asm 1: addpd <1t20=int6464#2,<2r11=int6464#1
# asm 2: addpd <1t20=%xmm1,<2r11=%xmm0
addpd %xmm1,%xmm0

# qhasm: *(int128 *)(0myp + 176) = 2r11
# asm 1: movdqa <2r11=int6464#1,176(<0myp=int64#3)
# asm 2: movdqa <2r11=%xmm0,176(<0myp=%rdx)
movdqa %xmm0,176(%rdx)

# qhasm: int6464 0round

# qhasm: int6464 0carry

# qhasm: int6464 2t6

# qhasm: 0r0 = *(int128 *)(0myp + 0)
# asm 1: movdqa 0(<0myp=int64#3),>0r0=int6464#1
# asm 2: movdqa 0(<0myp=%rdx),>0r0=%xmm0
movdqa 0(%rdx),%xmm0

# qhasm: 0r1 = *(int128 *)(0myp + 16)
# asm 1: movdqa 16(<0myp=int64#3),>0r1=int6464#2
# asm 2: movdqa 16(<0myp=%rdx),>0r1=%xmm1
movdqa 16(%rdx),%xmm1

# qhasm: 0r2 = *(int128 *)(0myp + 32)
# asm 1: movdqa 32(<0myp=int64#3),>0r2=int6464#3
# asm 2: movdqa 32(<0myp=%rdx),>0r2=%xmm2
movdqa 32(%rdx),%xmm2

# qhasm: 0r3 = *(int128 *)(0myp + 48)
# asm 1: movdqa 48(<0myp=int64#3),>0r3=int6464#4
# asm 2: movdqa 48(<0myp=%rdx),>0r3=%xmm3
movdqa 48(%rdx),%xmm3

# qhasm: 0r4 = *(int128 *)(0myp + 64)
# asm 1: movdqa 64(<0myp=int64#3),>0r4=int6464#5
# asm 2: movdqa 64(<0myp=%rdx),>0r4=%xmm4
movdqa 64(%rdx),%xmm4

# qhasm: 0r5 = *(int128 *)(0myp + 80)
# asm 1: movdqa 80(<0myp=int64#3),>0r5=int6464#6
# asm 2: movdqa 80(<0myp=%rdx),>0r5=%xmm5
movdqa 80(%rdx),%xmm5

# qhasm: 0r6 = *(int128 *)(0myp + 96)
# asm 1: movdqa 96(<0myp=int64#3),>0r6=int6464#7
# asm 2: movdqa 96(<0myp=%rdx),>0r6=%xmm6
movdqa 96(%rdx),%xmm6

# qhasm: 0r7 = *(int128 *)(0myp + 112)
# asm 1: movdqa 112(<0myp=int64#3),>0r7=int6464#8
# asm 2: movdqa 112(<0myp=%rdx),>0r7=%xmm7
movdqa 112(%rdx),%xmm7

# qhasm: 0r8 = *(int128 *)(0myp + 128)
# asm 1: movdqa 128(<0myp=int64#3),>0r8=int6464#9
# asm 2: movdqa 128(<0myp=%rdx),>0r8=%xmm8
movdqa 128(%rdx),%xmm8

# qhasm: 0r9 = *(int128 *)(0myp + 144)
# asm 1: movdqa 144(<0myp=int64#3),>0r9=int6464#10
# asm 2: movdqa 144(<0myp=%rdx),>0r9=%xmm9
movdqa 144(%rdx),%xmm9

# qhasm: 0r10 = *(int128 *)(0myp + 160)
# asm 1: movdqa 160(<0myp=int64#3),>0r10=int6464#11
# asm 2: movdqa 160(<0myp=%rdx),>0r10=%xmm10
movdqa 160(%rdx),%xmm10

# qhasm: 0r11 = *(int128 *)(0myp + 176)
# asm 1: movdqa 176(<0myp=int64#3),>0r11=int6464#12
# asm 2: movdqa 176(<0myp=%rdx),>0r11=%xmm11
movdqa 176(%rdx),%xmm11

# qhasm: 0round = ROUND_ROUND
# asm 1: movdqa ROUND_ROUND,<0round=int6464#13
# asm 2: movdqa ROUND_ROUND,<0round=%xmm12
movdqa ROUND_ROUND,%xmm12

# qhasm: 0carry = 0r1
# asm 1: movdqa <0r1=int6464#2,>0carry=int6464#14
# asm 2: movdqa <0r1=%xmm1,>0carry=%xmm13
movdqa %xmm1,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r2 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r2=int6464#3
# asm 2: addpd <0carry=%xmm13,<0r2=%xmm2
addpd %xmm13,%xmm2

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r1 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r1=int6464#2
# asm 2: subpd <0carry=%xmm13,<0r1=%xmm1
subpd %xmm13,%xmm1

# qhasm: 0carry = 0r4
# asm 1: movdqa <0r4=int6464#5,>0carry=int6464#14
# asm 2: movdqa <0r4=%xmm4,>0carry=%xmm13
movdqa %xmm4,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r5 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r5=int6464#6
# asm 2: addpd <0carry=%xmm13,<0r5=%xmm5
addpd %xmm13,%xmm5

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r4 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r4=int6464#5
# asm 2: subpd <0carry=%xmm13,<0r4=%xmm4
subpd %xmm13,%xmm4

# qhasm: 0carry = 0r7
# asm 1: movdqa <0r7=int6464#8,>0carry=int6464#14
# asm 2: movdqa <0r7=%xmm7,>0carry=%xmm13
movdqa %xmm7,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r8 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r8=int6464#9
# asm 2: addpd <0carry=%xmm13,<0r8=%xmm8
addpd %xmm13,%xmm8

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r7 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r7=int6464#8
# asm 2: subpd <0carry=%xmm13,<0r7=%xmm7
subpd %xmm13,%xmm7

# qhasm: 0carry = 0r10
# asm 1: movdqa <0r10=int6464#11,>0carry=int6464#14
# asm 2: movdqa <0r10=%xmm10,>0carry=%xmm13
movdqa %xmm10,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r11 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r11=int6464#12
# asm 2: addpd <0carry=%xmm13,<0r11=%xmm11
addpd %xmm13,%xmm11

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r10 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r10=int6464#11
# asm 2: subpd <0carry=%xmm13,<0r10=%xmm10
subpd %xmm13,%xmm10

# qhasm: 0carry = 0r2
# asm 1: movdqa <0r2=int6464#3,>0carry=int6464#14
# asm 2: movdqa <0r2=%xmm2,>0carry=%xmm13
movdqa %xmm2,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r3 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r3=int6464#4
# asm 2: addpd <0carry=%xmm13,<0r3=%xmm3
addpd %xmm13,%xmm3

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r2 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r2=int6464#3
# asm 2: subpd <0carry=%xmm13,<0r2=%xmm2
subpd %xmm13,%xmm2

# qhasm: 0carry = 0r5
# asm 1: movdqa <0r5=int6464#6,>0carry=int6464#14
# asm 2: movdqa <0r5=%xmm5,>0carry=%xmm13
movdqa %xmm5,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r6 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r6=int6464#7
# asm 2: addpd <0carry=%xmm13,<0r6=%xmm6
addpd %xmm13,%xmm6

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r5 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r5=int6464#6
# asm 2: subpd <0carry=%xmm13,<0r5=%xmm5
subpd %xmm13,%xmm5

# qhasm: 0carry = 0r8
# asm 1: movdqa <0r8=int6464#9,>0carry=int6464#14
# asm 2: movdqa <0r8=%xmm8,>0carry=%xmm13
movdqa %xmm8,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r9 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r9=int6464#10
# asm 2: addpd <0carry=%xmm13,<0r9=%xmm9
addpd %xmm13,%xmm9

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r8 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r8=int6464#9
# asm 2: subpd <0carry=%xmm13,<0r8=%xmm8
subpd %xmm13,%xmm8

# qhasm: 0carry = 0r11
# asm 1: movdqa <0r11=int6464#12,>0carry=int6464#14
# asm 2: movdqa <0r11=%xmm11,>0carry=%xmm13
movdqa %xmm11,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r0 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r0=int6464#1
# asm 2: subpd <0carry=%xmm13,<0r0=%xmm0
subpd %xmm13,%xmm0

# qhasm: float6464 0r3 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r3=int6464#4
# asm 2: subpd <0carry=%xmm13,<0r3=%xmm3
subpd %xmm13,%xmm3

# qhasm: 2t6 = 0carry
# asm 1: movdqa <0carry=int6464#14,>2t6=int6464#15
# asm 2: movdqa <0carry=%xmm13,>2t6=%xmm14
movdqa %xmm13,%xmm14

# qhasm: float6464 2t6 *= FOUR_FOUR
# asm 1: mulpd FOUR_FOUR,<2t6=int6464#15
# asm 2: mulpd FOUR_FOUR,<2t6=%xmm14
mulpd FOUR_FOUR,%xmm14

# qhasm: float6464 0r6 -= 2t6
# asm 1: subpd <2t6=int6464#15,<0r6=int6464#7
# asm 2: subpd <2t6=%xmm14,<0r6=%xmm6
subpd %xmm14,%xmm6

# qhasm: float6464 0r9 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r9=int6464#10
# asm 2: subpd <0carry=%xmm13,<0r9=%xmm9
subpd %xmm13,%xmm9

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r11 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r11=int6464#12
# asm 2: subpd <0carry=%xmm13,<0r11=%xmm11
subpd %xmm13,%xmm11

# qhasm: 0carry = 0r0
# asm 1: movdqa <0r0=int6464#1,>0carry=int6464#14
# asm 2: movdqa <0r0=%xmm0,>0carry=%xmm13
movdqa %xmm0,%xmm13

# qhasm: float6464 0carry *= V6INV_V6INV
# asm 1: mulpd V6INV_V6INV,<0carry=int6464#14
# asm 2: mulpd V6INV_V6INV,<0carry=%xmm13
mulpd V6INV_V6INV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r1 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r1=int6464#2
# asm 2: addpd <0carry=%xmm13,<0r1=%xmm1
addpd %xmm13,%xmm1

# qhasm: float6464 0carry *= V6_V6
# asm 1: mulpd V6_V6,<0carry=int6464#14
# asm 2: mulpd V6_V6,<0carry=%xmm13
mulpd V6_V6,%xmm13

# qhasm: float6464 0r0 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r0=int6464#1
# asm 2: subpd <0carry=%xmm13,<0r0=%xmm0
subpd %xmm13,%xmm0

# qhasm: 0carry = 0r3
# asm 1: movdqa <0r3=int6464#4,>0carry=int6464#14
# asm 2: movdqa <0r3=%xmm3,>0carry=%xmm13
movdqa %xmm3,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r4 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r4=int6464#5
# asm 2: addpd <0carry=%xmm13,<0r4=%xmm4
addpd %xmm13,%xmm4

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r3 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r3=int6464#4
# asm 2: subpd <0carry=%xmm13,<0r3=%xmm3
subpd %xmm13,%xmm3

# qhasm: 0carry = 0r6
# asm 1: movdqa <0r6=int6464#7,>0carry=int6464#14
# asm 2: movdqa <0r6=%xmm6,>0carry=%xmm13
movdqa %xmm6,%xmm13

# qhasm: float6464 0carry *= V6INV_V6INV
# asm 1: mulpd V6INV_V6INV,<0carry=int6464#14
# asm 2: mulpd V6INV_V6INV,<0carry=%xmm13
mulpd V6INV_V6INV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r7 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r7=int6464#8
# asm 2: addpd <0carry=%xmm13,<0r7=%xmm7
addpd %xmm13,%xmm7

# qhasm: float6464 0carry *= V6_V6
# asm 1: mulpd V6_V6,<0carry=int6464#14
# asm 2: mulpd V6_V6,<0carry=%xmm13
mulpd V6_V6,%xmm13

# qhasm: float6464 0r6 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r6=int6464#7
# asm 2: subpd <0carry=%xmm13,<0r6=%xmm6
subpd %xmm13,%xmm6

# qhasm: 0carry = 0r9
# asm 1: movdqa <0r9=int6464#10,>0carry=int6464#14
# asm 2: movdqa <0r9=%xmm9,>0carry=%xmm13
movdqa %xmm9,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r10 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r10=int6464#11
# asm 2: addpd <0carry=%xmm13,<0r10=%xmm10
addpd %xmm13,%xmm10

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r9 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r9=int6464#10
# asm 2: subpd <0carry=%xmm13,<0r9=%xmm9
subpd %xmm13,%xmm9

# qhasm: 0carry = 0r1
# asm 1: movdqa <0r1=int6464#2,>0carry=int6464#14
# asm 2: movdqa <0r1=%xmm1,>0carry=%xmm13
movdqa %xmm1,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r2 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r2=int6464#3
# asm 2: addpd <0carry=%xmm13,<0r2=%xmm2
addpd %xmm13,%xmm2

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r1 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r1=int6464#2
# asm 2: subpd <0carry=%xmm13,<0r1=%xmm1
subpd %xmm13,%xmm1

# qhasm: 0carry = 0r4
# asm 1: movdqa <0r4=int6464#5,>0carry=int6464#14
# asm 2: movdqa <0r4=%xmm4,>0carry=%xmm13
movdqa %xmm4,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r5 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r5=int6464#6
# asm 2: addpd <0carry=%xmm13,<0r5=%xmm5
addpd %xmm13,%xmm5

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r4 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r4=int6464#5
# asm 2: subpd <0carry=%xmm13,<0r4=%xmm4
subpd %xmm13,%xmm4

# qhasm: 0carry = 0r7
# asm 1: movdqa <0r7=int6464#8,>0carry=int6464#14
# asm 2: movdqa <0r7=%xmm7,>0carry=%xmm13
movdqa %xmm7,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r8 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r8=int6464#9
# asm 2: addpd <0carry=%xmm13,<0r8=%xmm8
addpd %xmm13,%xmm8

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r7 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r7=int6464#8
# asm 2: subpd <0carry=%xmm13,<0r7=%xmm7
subpd %xmm13,%xmm7

# qhasm: 0carry = 0r10
# asm 1: movdqa <0r10=int6464#11,>0carry=int6464#14
# asm 2: movdqa <0r10=%xmm10,>0carry=%xmm13
movdqa %xmm10,%xmm13

# qhasm: float6464 0carry *= VINV_VINV
# asm 1: mulpd VINV_VINV,<0carry=int6464#14
# asm 2: mulpd VINV_VINV,<0carry=%xmm13
mulpd VINV_VINV,%xmm13

# qhasm: float6464 0carry += 0round
# asm 1: addpd <0round=int6464#13,<0carry=int6464#14
# asm 2: addpd <0round=%xmm12,<0carry=%xmm13
addpd %xmm12,%xmm13

# qhasm: float6464 0carry -= 0round
# asm 1: subpd <0round=int6464#13,<0carry=int6464#14
# asm 2: subpd <0round=%xmm12,<0carry=%xmm13
subpd %xmm12,%xmm13

# qhasm: float6464 0r11 += 0carry
# asm 1: addpd <0carry=int6464#14,<0r11=int6464#12
# asm 2: addpd <0carry=%xmm13,<0r11=%xmm11
addpd %xmm13,%xmm11

# qhasm: float6464 0carry *= V_V
# asm 1: mulpd V_V,<0carry=int6464#14
# asm 2: mulpd V_V,<0carry=%xmm13
mulpd V_V,%xmm13

# qhasm: float6464 0r10 -= 0carry
# asm 1: subpd <0carry=int6464#14,<0r10=int6464#11
# asm 2: subpd <0carry=%xmm13,<0r10=%xmm10
subpd %xmm13,%xmm10

# qhasm: *(int128 *)(0rop +   0) =  0r0
# asm 1: movdqa <0r0=int6464#1,0(<0rop=int64#1)
# asm 2: movdqa <0r0=%xmm0,0(<0rop=%rdi)
movdqa %xmm0,0(%rdi)

# qhasm: *(int128 *)(0rop +  16) =  0r1
# asm 1: movdqa <0r1=int6464#2,16(<0rop=int64#1)
# asm 2: movdqa <0r1=%xmm1,16(<0rop=%rdi)
movdqa %xmm1,16(%rdi)

# qhasm: *(int128 *)(0rop +  32) =  0r2
# asm 1: movdqa <0r2=int6464#3,32(<0rop=int64#1)
# asm 2: movdqa <0r2=%xmm2,32(<0rop=%rdi)
movdqa %xmm2,32(%rdi)

# qhasm: *(int128 *)(0rop +  48) =  0r3
# asm 1: movdqa <0r3=int6464#4,48(<0rop=int64#1)
# asm 2: movdqa <0r3=%xmm3,48(<0rop=%rdi)
movdqa %xmm3,48(%rdi)

# qhasm: *(int128 *)(0rop +  64) =  0r4
# asm 1: movdqa <0r4=int6464#5,64(<0rop=int64#1)
# asm 2: movdqa <0r4=%xmm4,64(<0rop=%rdi)
movdqa %xmm4,64(%rdi)

# qhasm: *(int128 *)(0rop +  80) =  0r5
# asm 1: movdqa <0r5=int6464#6,80(<0rop=int64#1)
# asm 2: movdqa <0r5=%xmm5,80(<0rop=%rdi)
movdqa %xmm5,80(%rdi)

# qhasm: *(int128 *)(0rop +  96) =  0r6
# asm 1: movdqa <0r6=int6464#7,96(<0rop=int64#1)
# asm 2: movdqa <0r6=%xmm6,96(<0rop=%rdi)
movdqa %xmm6,96(%rdi)

# qhasm: *(int128 *)(0rop + 112) =  0r7
# asm 1: movdqa <0r7=int6464#8,112(<0rop=int64#1)
# asm 2: movdqa <0r7=%xmm7,112(<0rop=%rdi)
movdqa %xmm7,112(%rdi)

# qhasm: *(int128 *)(0rop + 128) =  0r8
# asm 1: movdqa <0r8=int6464#9,128(<0rop=int64#1)
# asm 2: movdqa <0r8=%xmm8,128(<0rop=%rdi)
movdqa %xmm8,128(%rdi)

# qhasm: *(int128 *)(0rop + 144) =  0r9
# asm 1: movdqa <0r9=int6464#10,144(<0rop=int64#1)
# asm 2: movdqa <0r9=%xmm9,144(<0rop=%rdi)
movdqa %xmm9,144(%rdi)

# qhasm: *(int128 *)(0rop + 160) = 0r10
# asm 1: movdqa <0r10=int6464#11,160(<0rop=int64#1)
# asm 2: movdqa <0r10=%xmm10,160(<0rop=%rdi)
movdqa %xmm10,160(%rdi)

# qhasm: *(int128 *)(0rop + 176) = 0r11
# asm 1: movdqa <0r11=int6464#12,176(<0rop=int64#1)
# asm 2: movdqa <0r11=%xmm11,176(<0rop=%rdi)
movdqa %xmm11,176(%rdi)

# qhasm: leave
add %r11,%rsp
mov %rdi,%rax
mov %rsi,%rdx
ret
