/*
 * File:   dclxvi-notsecure/parameters.c
 * Author: Ruben Niederhagen, Peter Schwabe
 * Public Domain
 */

#include "fpe.h"
#include "fp2e.h"
#include "fp6e.h"
#include "fp12e.h"
#include "curvepoint_fp.h"
#include "twistpoint_fp2.h"
#include "scalar.h"

#ifdef __cplusplus
#define EXTERN extern
#else
#define EXTERN
#endif

EXTERN const scalar_t bn_6uplus2 =  {0x78D0000000000002ULL,2,0,0};
EXTERN const unsigned long bn_bitlen_6uplus2 = 66;
EXTERN const scalar_t bn_pminus2 =  {0x78CFFFFFFFFFFFFFULL, 0x12D7C60000000002ULL, 0x8475000838000004ULL, 0x098213DB62D24002ULL};
EXTERN const scalar_t bn_u =        {0x6978000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL};
EXTERN const unsigned long bn_u_bitsize = 63;

/* BEGIN Only needed for old final exponentiation */
EXTERN const scalar_t bn_nine =     {0x0000000000000009ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL};
EXTERN const scalar_t bn_6u2plus1 = {0x0000000000000001ULL, 0x04B5F18000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL};
EXTERN const unsigned int bn_6u2plus1_bitsize = 129;
EXTERN const scalar_t bn_6uplus5 =  {0x78D0000000000005ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000000ULL};
EXTERN const unsigned int bn_6uplus5_bitsize = 66;
/* END Only needed for old final exponentiation */

EXTERN const fp6e_t tau = {{{{{0}}}}}; // F_{p^{12}} is constructed as F_{p^6}[Z]/(Z^2 - tau) F_{p^6}[Z]
EXTERN const double bn_v = 1966080.;
EXTERN const double bn_v6 = 11796480.;
const char * bn_pstr = "120092732040802788441093648045657013314235355142139720793828567809913782272001" ;

EXTERN const fpe_t bn_zeta       = {{{ 1.,0.,-983040., 2.,0.,0., 3.,0.,-983040.,1.,0.,0.}}};  /* zeta   */
EXTERN const fpe_t bn_zeta2      = {{{-2.,0.,-983040.,-1.,0.,0.,-3.,0.,-983040.,0.,0.,0.}}};  /* zeta^2 */

EXTERN const curvepoint_fp_t bn_curvegen = {{{{{1.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.}}}, 
                                      {{{5738611, 25948, -895076, -29163, -621127, 770423, -2478194, 537041, -592428, 321291, -596960, -759180}}}, 
                                      {{{1.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.}}},
                                      {{{0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.}}}}};                                                       

EXTERN const twistpoint_fp2_t bn_twistgen = {{{{{2248211.,  3435907.,  654395.,  -52098.,  344219.,  -953484.,  
                                          -37167.,  -16511.,  708033.,  575144.,  637942.,  -72375.,  
                                          2885827.,  682614.,  895998.,  703527.,  779384.,  560541.,  
                                          -731972.,  880738.,  149557.,  -508093.,  483261.,  802767.}}},
                                       {{{-1514211.,  923059.,  -797910.,  -133463.,  559878.,  -340798.,  
                                          -207204.,  686347.,  -69354.,  332833.,  483908.,  -493016.,  
                                          -2836540.,  -2476772.,  973883.,  153048.,  -256976.,  384047.,  
                                          -289692.,  -906878.,  -375172.,  -636317.,  541927.,  -522331.}}},
                                       {{{1.,0.,0.,0.,0.,0., 0.,0.,0.,0.,0.,0., 0.,0.,0.,0.,0.,0., 0.,0.,0.,0.,0.,0.}}},
                                       {{{0.,0.,0.,0.,0.,0., 0.,0.,0.,0.,0.,0., 0.,0.,0.,0.,0.,0., 0.,0.,0.,0.,0.,0.}}}}};

EXTERN const fp2e_t bn_z2p          = {{{2286629., 4597217., 127863., 769359., 353939., 799587., 
                                  637452., -761045., -636625., 856322., -537774., -219365., 
                                  1334248., 3202007., -764203., 702607., 934430., -816207., 
                                  -678965., -980498., 526964., -833158., -718277., -478913.}}}; /* Z^(2p) */
EXTERN const fp2e_t bn_z3p          = {{{-867329., -743425., -25380., -864360., -487843., 424455., 
                                  391645., -226042., 949426., 813794., 968579., 549342., 
                                  3001354., -4168257., -19010., 826312., -341668., 549747., 
                                  362632., 872564., -931747., -517772., 433624., 90809.}}}; /* Z^(3p) */

// Field constants
EXTERN const fp2e_t bn_xi = {{{6.,1.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.}}}; 
    // constant coefficient in the irreducible polynomial Y^3 - xi, used to construct F_{p^6} as extension of F_{p^12}
EXTERN const fp2e_t bn_ypminus1 = {{{2286629., 4597217., 127863., 769359., 353939., 799587., 
                                  637452., -761045., -636625., 856322., -537774., -219365., 
                                  1334248., 3202007., -764203., 702607., 934430., -816207., 
                                  -678965., -980498., 526964., -833158., -718277., -478913.}}}; // Y^{p-1} lies in F_{p^2}
EXTERN const fp2e_t bn_zpminus1 = {{{-5752581., 3922276., -379416., 633628., 46388., -841366., 
                                  -87296., 552856., -275398., -370577., -908547., -58506., 
                                  -3429621., -5134399., 177889., -548269., -32395., -767732.,
                                  91527., -153404., 615061., -569445., -263633., 315857.}}}; // Z^{p-1}, lies in F_{p^2}


// Multiples of powers of xi needed for cometa-pairing computation
/*
fp2e_t xi2; // xi^2
fp2e_t _1o27xi3; // 1/27 xi^3
fp2e_t _1o3xi3; // 1/3 xi^3
fp2e_t _1o3xi; // 1/3 xi
fp2e_t zpminus1; // Z^{p-1}, lies in F_{p^2}
fp2e_t zpminus1inv; // Z^{p-1}, lies in F_{p^2}
*/

#undef EXTERN
