/*
 * File:   dclxvi-notsecure/scalar.c
 * Author: Ruben Niederhagen, Peter Schwabe
 * Public Domain
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "scalar.h"

void scalar_setrandom(scalar_t rop)
{
  int i;
  FILE *urand = fopen("/dev/urandom", "r");
  if (urand == NULL)
  {
    fprintf(stderr, "Could not open device file /dev/urandom");
    exit(1);
  }
  for(i=0;i<32;i++) i[(unsigned char*)rop] = fgetc(urand);
  fclose(urand);
}

void scalar_set_lluarray(scalar_t rop, unsigned long long v[4])
{
  int i;
  for(i=0;i<4;i++) rop[i] = v[i];
}

int scalar_getbit(const scalar_t s, unsigned int pos)
{
  assert(pos < 256);
  return (s[pos >> 6] >> (pos & 0x3f)) & 1;
}

// Returns the position of the most significant set bit
int scalar_scanb(const scalar_t s)
{
  int i;
  unsigned int pos = 0;
  for(i=255;i>0;i--)
    if(scalar_getbit(s,i) && pos == 0) pos = i;
  return pos;
}

void scalar_print(FILE *fh, const scalar_t t)
{
  int i;
  for(i=3;i>=0;i--)
    fprintf(fh, "%llx", t[i]);
}

