#include <stdio.h>
#include <stdlib.h>
#include "../fastrandombytes.h"
#include "../cpucycles.h"
#include "../crypto_sign.h"
#include "../poly.h"

//Formerly static functions
void ntt(poly out);
void inverse_ntt(poly out);


#define MLEN 59
#define NRUNS 1000
#define NRUNS_SIGN 100000


static int cmp_llu(const void *a, const void*b)
{
  if(*(unsigned long long *)a < *(unsigned long long *)b) return -1;
  if(*(unsigned long long *)a > *(unsigned long long *)b) return 1;
  return 0;
}


static unsigned long long median(unsigned long long *l, size_t llen)
{
  qsort(l,llen,sizeof(unsigned long long),cmp_llu);

  if(llen%2) return l[llen/2];
  else return (l[llen/2-1]+l[llen/2])/2;
}

static unsigned long long average(unsigned long long *t, size_t tlen)
{
  unsigned long long acc=0;
  size_t i;
  for(i=0;i<tlen;i++)
    acc += t[i];
  return acc/(tlen);
}

static void print_results(const char *s, unsigned long long *t, size_t tlen)
{
  size_t i;
  printf("%s", s);
  for(i=0;i<tlen-1;i++)
  {
    t[i] = t[i+1] - t[i];
    printf("%llu ", t[i]);
  }
  printf("\n");
  printf("median:  %llu\n", median(t, tlen));
  printf("average: %llu\n", average(t, tlen-1));
  printf("\n");
}


unsigned char mi[MLEN];
unsigned char mo[MLEN+crypto_sign_BYTES];
unsigned char sm[MLEN+crypto_sign_BYTES];
unsigned char pk[crypto_sign_PUBLICKEYBYTES];
unsigned char sk[crypto_sign_SECRETKEYBYTES];
unsigned long long smlen, mlen;


poly f,g,h,c;
poly z, y;

unsigned long long t[NRUNS_SIGN];

int main()
{
  int i;
  
  FILE *urandom = fopen("/dev/urandom", "r");
  for(i=0;i<MLEN;i++)
    mi[i] = fgetc(urandom);


  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    crypto_sign_keypair(pk, sk);
  }
  print_results("crypto_sign_keypair: ", t, NRUNS);


  for(i=0;i<NRUNS_SIGN;i++)
  {
    t[i] = cpucycles();
    crypto_sign(sm, &smlen, mi, MLEN, sk);
  }
  print_results("crypto_sign: ", t, NRUNS_SIGN);


  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    crypto_sign_open(mo, &mlen, sm, smlen, pk);
  }
  print_results("crypto_sign_open: ", t, NRUNS);

  /*
  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    poly_setrandom(f);
  }
  print_results("poly_setrandom: ", t, NRUNS);
  */

  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    poly_setrandom_maxk(f);
  }
  print_results("poly_setrandom_maxk: ", t, NRUNS);

  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    poly_setrandom_max1(f);
  }
  print_results("poly_setrandom_max1: ", t, NRUNS);


  /*
  poly_setrandom(f);
  poly_setrandom(g);
  poly_setrandom(h);
  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    poly_add(f, g, h);
  }
  print_results("poly_add: ", t, NRUNS);


  poly_setrandom(f);
  poly_setrandom(g);
  poly_setrandom(h);
  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    poly_sub(f, g, h);
  }
  print_results("poly_sub: ", t, NRUNS);

  poly_setrandom_maxkm32(y);
  poly_setrandom_maxkm32(z);
  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    poly_compress(sm+1044, y, z);
  }
  print_results("poly_compress: ", t, NRUNS);


  poly_setrandom_maxkm32(y);
  poly_setrandom_maxkm32(z);
  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    poly_decompress(z, sm+1044);
  }
  print_results("poly_decompress: ", t, NRUNS);
  */

  /*
  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    poly_extract_high_bits(sm, f, 2*PARAM_KM32+1); 
  }
  print_results("poly_extract_high_bits: ", t, NRUNS);
  */

  poly_setrandom_maxk(f);
  poly_setrandom_maxk(g);
  poly_setrandom_maxk(h);
  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    poly_mul(f,g,h);
  }
  print_results("poly_mul: ", t, NRUNS);

  poly_setrandom_maxk(f);
  poly_setrandom_maxk(g);
  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    poly_mul_a(f,g);
  }
  print_results("poly_mul_a: ", t, NRUNS);

  poly_setrandom_maxk(f);
  for(i=0;i<NRUNS;i++)
    {
    t[i] = cpucycles();
    ntt(f);
  }
  print_results("ntt: ", t, NRUNS);

  /*
  poly_setrandom(f);
  for(i=0;i<NRUNS;i++)
    {
      t[i] = cpucycles();
      inverse_ntt(f);
    }
  print_results("inverse_ntt: ", t, NRUNS);

  poly_setrandom(f);
  for(i=0;i<NRUNS;i++)
    {
      t[i] = cpucycles();
      poly_pack(sm, f);
    }
  print_results("poly_pack: ", t, NRUNS);


  for(i=0;i<20;i++) sm[i] = fgetc(urandom); 
  for(i=0;i<NRUNS;i++)
  {
    t[i] = cpucycles();
    poly_fromhash(c, sm);
  }
  print_results("poly_fromhash: ", t, NRUNS);
  */

  fclose(urandom);
  return 0;
}
