#include <stdio.h>
#include <string.h>

#include "../crypto_sign.h"
#include "../api.h"

#define MLEN 3491
#define NTESTS 100000

unsigned char sk[CRYPTO_SECRETKEYBYTES];
unsigned char pk[CRYPTO_PUBLICKEYBYTES];
unsigned char mi[MLEN];
unsigned char mo[MLEN];
unsigned char sm[MLEN+CRYPTO_BYTES];
unsigned long long smlen;
unsigned long long mlen;


int main()
{
  int r, j;
  unsigned long long i;
  
  FILE *urandom = fopen("/dev/urandom", "r");

  //Test run 0: Same keypair, original message => all signatures valid
  for(j=0; j< NTESTS; j++)
  {
    crypto_sign_keypair(pk, sk);

    for(i=0;i<MLEN;i++) mi[i] = fgetc(urandom);

    r = crypto_sign(sm, &smlen, mi, MLEN, sk);
    
    /* Test valid signature */
    r = crypto_sign_open(mo, &mlen, sm, smlen, pk);
    printf("%d\n", r);
    r = memcmp(mi,mo,MLEN);
    printf("%d\n", r);
    printf("%llu\n", MLEN-mlen);
  }
  
  //Test run 1: Same keypair, messages modified => all signatures invalid
  for(j=0; j< NTESTS; j++)
  {
    crypto_sign_keypair(pk, sk);

    for(i=0;i<MLEN;i++) mi[i] = fgetc(urandom);

    crypto_sign(sm, &smlen, mi, MLEN, sk);
    
    /* Make message invalid: flip a bit somewhere */
    sm[(j % MLEN) + CRYPTO_BYTES] = sm[(j % MLEN) + CRYPTO_BYTES] ^ (1 << (j%8));

    /* Test signature on modified message */
    r = crypto_sign_open(mo, &mlen, sm, smlen, pk);
    printf("%d\n", r+1);
    r = memcmp(mi,mo,MLEN);
    printf("%d\n", (r!=0) - 1);
    printf("%llu\n", mlen+1);
  }

 //Test run 2: wrong key, original messages => all signatures invalid
  for(j=0; j< NTESTS; j++)
  {
    for(i=0;i<MLEN;i++) mi[i] = fgetc(urandom);

    crypto_sign(sm, &smlen, mi, MLEN, sk);    

    /* New keypair */
    crypto_sign_keypair(pk, sk);
    
    /* Test signature with wrong keypair*/
    r = crypto_sign_open(mo, &mlen, sm, smlen, pk);
    printf("%d\n", r+1);
    r = memcmp(mi,mo,MLEN);
    printf("%d\n", (r!=0) - 1);
    printf("%llu\n", mlen+1);
  }
  
  fclose(urandom);
  return 0;
}
