/*
 * Decompiled with CFR 0.152.
 */
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CommonTokenStream;
import parser.ErrorList;
import parser.eccLexer;
import parser.eccParser;
import tokens.Program;
import tokens.datastructures.CallTargets;
import tokens.datastructures.ConstantCollection;
import tokens.datastructures.Registers;
import utils.Printer;

public class Main {
    public static void main(String[] args) {
        if (args.length < 3 || args.length > 5) {
            System.err.println("usage: <input-file> <constants-file> <program-file> [<MULT_CYCLES>] [-v2]");
            System.err.println("  e.g.: input\\brainpool01.ecc nacl_constants3.vhd nacl_controller3_rom_program.vhd");
            System.exit(-1);
        }
        String filePath = args[0];
        String filename1 = args[1];
        String filename2 = args[2];
        Printer.setInputFilename(filePath);
        try {
            ANTLRFileStream inStream = new ANTLRFileStream(filePath);
            eccLexer lexer = new eccLexer(inStream);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            eccParser parser = new eccParser(tokens);
            Program program = parser.program();
            int i = 3;
            while (i < args.length) {
                if (args[i].equals("-v2")) {
                    ConstantCollection.V2 = 1;
                } else {
                    ConstantCollection.setMultCyles(Integer.parseInt(args[3]));
                }
                ++i;
            }
            program.resolveMacrosAndRegisterUsage();
            Registers.generateAddressTable();
            CallTargets.check();
            Registers.check();
            program.check();
            ConstantCollection.check();
            program.prepareForWriting();
            CallTargets.prepareForWriting();
            if (ErrorList.errorCount() > 0) {
                ErrorList.print();
                Printer.printLine();
                Printer.print("", 0);
                Printer.print("Due to errors, output was not generated!", 0);
                System.exit(-3);
            } else if (ErrorList.warningCount() > 0) {
                ErrorList.print();
            }
            ConstantCollection.printList();
            ConstantCollection.writeFile(filename1);
            program.writeFile(filename2);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-2);
        }
        System.exit(0);
    }
}

