/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.editor.EditorInspectorItem;
import org.antlr.works.editor.InspectorDelegate;
import org.antlr.works.editor.idea.IdeaAction;
import org.antlr.works.grammar.RefactorEngine;
import org.antlr.works.grammar.decisiondfa.DecisionDFAEngine;
import org.antlr.works.grammar.element.ElementGrammarName;
import org.antlr.works.grammar.element.ElementImport;
import org.antlr.works.grammar.element.ElementReference;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.element.ElementToken;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorInspector {
    private GrammarEngine engine;
    private DecisionDFAEngine decisionDFAEngine;
    private InspectorDelegate delegate;

    public EditorInspector(GrammarEngine engine, DecisionDFAEngine decisionDFAEngine, InspectorDelegate delegate) {
        this.engine = engine;
        this.decisionDFAEngine = decisionDFAEngine;
        this.delegate = delegate;
    }

    public void close() {
        this.engine = null;
        this.decisionDFAEngine = null;
        this.delegate = null;
    }

    public List<EditorInspectorItem> getErrors() {
        ArrayList<EditorInspectorItem> errors = new ArrayList<EditorInspectorItem>();
        this.discoverInvalidGrammarName(errors);
        this.discoverInvalidCharLiteralTokens(errors);
        this.discoverUndefinedReferences(errors);
        this.discoverUndefinedImports(errors);
        this.discoverDuplicateRules(errors);
        return errors;
    }

    public List<EditorInspectorItem> getWarnings() {
        ArrayList<EditorInspectorItem> warnings = new ArrayList<EditorInspectorItem>();
        this.discoverLeftRecursionRules(warnings);
        this.discoverLeftRecursiveRulesSet(warnings);
        return warnings;
    }

    public List<EditorInspectorItem> getDecisionDFAs() {
        ArrayList<EditorInspectorItem> items = new ArrayList<EditorInspectorItem>();
        this.discoverDecisionDFAs(items);
        return items;
    }

    protected List<EditorInspectorItem> getAllItemsAtIndex(int index) {
        ArrayList<EditorInspectorItem> items = new ArrayList<EditorInspectorItem>();
        items.addAll(this.getItemsAtIndex(this.getErrors(), index));
        items.addAll(this.getItemsAtIndex(this.getWarnings(), index));
        items.addAll(this.getItemsAtIndex(this.getDecisionDFAs(), index));
        return items;
    }

    protected List<EditorInspectorItem> getItemsAtIndex(List<EditorInspectorItem> items, int index) {
        ArrayList<EditorInspectorItem> filteredItems = new ArrayList<EditorInspectorItem>();
        for (EditorInspectorItem item : items) {
            if (index < item.startIndex || index > item.endIndex) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    protected void discoverInvalidGrammarName(List<EditorInspectorItem> items) {
        ElementGrammarName n = this.getGrammarName();
        String grammarFileName = this.getGrammarNameFromFile();
        if (n != null && grammarFileName != null && !grammarFileName.equals(n.getName())) {
            ATEToken t = n.name;
            ItemInvalidGrammarName item = new ItemInvalidGrammarName();
            item.setAttributes(t, t.getStartIndex(), t.getEndIndex(), t.startLineNumber, Color.red, "Invalid grammar name '" + t.getAttribute() + "'");
            items.add(item);
        }
    }

    private ElementGrammarName getGrammarName() {
        return this.engine.getElementName();
    }

    private String getGrammarNameFromFile() {
        String filename = this.delegate.getFileName();
        if (filename == null) {
            return null;
        }
        return XJUtils.getPathByDeletingPathExtension(filename);
    }

    protected void discoverInvalidCharLiteralTokens(List<EditorInspectorItem> items) {
        List<ATEToken> tokens = this.engine.getTokens();
        if (tokens == null) {
            return;
        }
        for (ATEToken t : tokens) {
            if (t.type != 2 || RefactorEngine.ignoreScopeForDoubleQuoteLiteral(t.scope)) continue;
            ItemInvalidCharLiteral item = new ItemInvalidCharLiteral();
            item.setAttributes(t, t.getStartIndex(), t.getEndIndex(), t.startLineNumber, Color.red, "Invalid character literal '" + t.getAttribute() + "' - must use single quote");
            items.add(item);
        }
    }

    protected void discoverUndefinedReferences(List<EditorInspectorItem> items) {
        List<ElementReference> undefinedRefs = this.engine.getUndefinedReferences();
        if (undefinedRefs == null) {
            return;
        }
        for (ElementReference ref : undefinedRefs) {
            ItemUndefinedReference item = new ItemUndefinedReference();
            item.setAttributes(ref.token, ref.token.getStartIndex(), ref.token.getEndIndex(), ref.token.startLineNumber, Color.red, "Undefined reference \"" + ref.token.getAttribute() + "\"");
            items.add(item);
        }
    }

    protected void discoverUndefinedImports(List<EditorInspectorItem> items) {
        List<ElementImport> imports = this.engine.getUndefinedImports();
        if (imports == null) {
            return;
        }
        for (ElementImport ref : imports) {
            ItemUndefinedImport item = new ItemUndefinedImport();
            item.setAttributes(ref.token, ref.token.getStartIndex(), ref.token.getEndIndex(), ref.token.startLineNumber, Color.red, "Undefined import \"" + ref.token.getAttribute() + "\"");
            items.add(item);
        }
    }

    protected void discoverDuplicateRules(List<EditorInspectorItem> items) {
        List<ElementRule> rules = this.engine.getDuplicateRules();
        if (rules == null) {
            return;
        }
        for (ElementRule rule : rules) {
            ItemDuplicateRule item = new ItemDuplicateRule();
            item.setAttributes(rule.start, rule.start.getStartIndex(), rule.start.getEndIndex(), rule.start.startLineNumber, Color.red, "Duplicate rule \"" + rule.name + "\"");
            items.add(item);
        }
    }

    protected void discoverLeftRecursionRules(List<EditorInspectorItem> items) {
        List<ElementRule> rules = this.engine.getRules();
        if (rules == null) {
            return;
        }
        for (ElementRule rule : rules) {
            if (!rule.hasLeftRecursion()) continue;
            ItemLeftRecursion item = new ItemLeftRecursion();
            item.setAttributes(rule.start, rule.start.getStartIndex(), rule.start.getEndIndex(), rule.start.startLineNumber, Color.blue, "Rule \"" + rule.name + "\" is left-recursive");
            items.add(item);
        }
    }

    protected void discoverLeftRecursiveRulesSet(List<EditorInspectorItem> items) {
        List<ElementRule> rules = this.engine.getRules();
        if (rules == null) {
            return;
        }
        for (ElementRule rule : rules) {
            Set rulesSet = rule.getLeftRecursiveRulesSet();
            if (rulesSet == null || rulesSet.size() < 2) continue;
            EditorInspectorItem item = new EditorInspectorItem();
            item.setAttributes(rule.start, rule.start.getStartIndex(), rule.start.getEndIndex(), rule.start.startLineNumber, Color.blue, "Rule \"" + rule.name + "\" is mutually left-recursive with other rules (see Console)");
            items.add(item);
        }
    }

    protected void discoverDecisionDFAs(List<EditorInspectorItem> items) {
        items.addAll(this.decisionDFAEngine.getDecisionDFAItems());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemInvalidGrammarName
    extends EditorInspectorItem {
        @Override
        public List<IdeaAction> getIdeaActions() {
            ArrayList<IdeaAction> actions = new ArrayList<IdeaAction>();
            actions.add(new IdeaAction("Change grammar name to '" + EditorInspector.this.getGrammarNameFromFile() + "'", this, 4, this.token));
            return actions;
        }

        @Override
        public void ideaActionFire(IdeaAction action, int actionID) {
            switch (actionID) {
                case 4: {
                    ElementGrammarName n = EditorInspector.this.getGrammarName();
                    ATEToken name = n.name;
                    EditorInspector.this.delegate.replaceText(name.start, name.end, EditorInspector.this.getGrammarNameFromFile());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemInvalidCharLiteral
    extends EditorInspectorItem {
        @Override
        public List<IdeaAction> getIdeaActions() {
            ArrayList<IdeaAction> actions = new ArrayList<IdeaAction>();
            actions.add(new IdeaAction("Convert literals to single quote", this, 3, this.token));
            return actions;
        }

        @Override
        public void ideaActionFire(IdeaAction action, int actionID) {
            switch (actionID) {
                case 3: {
                    EditorInspector.this.delegate.convertLiteralsToSingleQuote();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemLeftRecursion
    extends EditorInspectorItem {
        @Override
        public List<IdeaAction> getIdeaActions() {
            ArrayList<IdeaAction> actions = new ArrayList<IdeaAction>();
            actions.add(new IdeaAction("Remove left recursion of rule '" + this.token.getAttribute() + "'", this, 2, this.token));
            return actions;
        }

        @Override
        public void ideaActionFire(IdeaAction action, int actionID) {
            switch (actionID) {
                case 2: {
                    EditorInspector.this.delegate.removeLeftRecursion();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemDuplicateRule
    extends EditorInspectorItem {
        @Override
        public List<IdeaAction> getIdeaActions() {
            ArrayList<IdeaAction> actions = new ArrayList<IdeaAction>();
            actions.add(new IdeaAction("Delete rule '" + this.token.getAttribute() + "'", this, 0, this.token));
            return actions;
        }

        @Override
        public void ideaActionFire(IdeaAction action, int actionID) {
            switch (actionID) {
                case 0: {
                    EditorInspector.this.delegate.deleteRuleAtCurrentPosition();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemUndefinedImport
    extends EditorInspectorItem {
        @Override
        public List<IdeaAction> getIdeaActions() {
            ArrayList<IdeaAction> actions = new ArrayList<IdeaAction>();
            actions.add(new IdeaAction("Create file '" + this.token.getAttribute() + "'", this, 6, this.token));
            return actions;
        }

        @Override
        public void ideaActionFire(IdeaAction action, int actionID) {
            switch (actionID) {
                case 6: {
                    EditorInspector.this.delegate.createFile(action.token.getAttribute());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemUndefinedReference
    extends EditorInspectorItem {
        @Override
        public List<IdeaAction> getIdeaActions() {
            ArrayList<IdeaAction> actions = new ArrayList<IdeaAction>();
            actions.add(new IdeaAction("Create rule '" + this.token.getAttribute() + "'", this, 1, this.token));
            return actions;
        }

        @Override
        public void ideaActionFire(IdeaAction action, int actionID) {
            switch (actionID) {
                case 1: {
                    EditorInspector.this.delegate.createRuleAtIndex(((ElementToken)action.token).lexer, action.token.getAttribute(), null);
                }
            }
        }
    }
}

