/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar.decisiondfa;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.NFAState;
import org.antlr.tool.Grammar;
import org.antlr.tool.Rule;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.grammar.antlr.ANTLRGrammarEngine;
import org.antlr.works.grammar.decisiondfa.DecisionDFAItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionDFAEngine {
    private GrammarWindow window;
    private Set<Integer> usesSemPreds = new HashSet<Integer>();
    private Set<Integer> usesSynPreds = new HashSet<Integer>();
    private Map<Integer, List<Integer>> decisionDFA = new HashMap<Integer, List<Integer>>();
    private Grammar discoveredLexerGrammar;
    private Grammar discoveredParserGrammar;

    public DecisionDFAEngine(GrammarWindow window) {
        this.window = window;
    }

    public void close() {
        this.window = null;
    }

    public void reset() {
        this.decisionDFA.clear();
    }

    public int getDecisionDFACount() {
        return this.decisionDFA.size();
    }

    public Grammar getDiscoveredLexerGrammar() {
        return this.discoveredLexerGrammar;
    }

    public Grammar getDiscoveredParserGrammar() {
        return this.discoveredParserGrammar;
    }

    public void discoverAllDecisions() throws Exception {
        this.discover(0, this.window.getTextEditor().getText().length());
    }

    private void discover(int start, int end) throws Exception {
        HashSet<Integer> lineIndexes = new HashSet<Integer>();
        for (int index = start; index < end; ++index) {
            lineIndexes.add(this.window.getTextEditor().getLineIndexAtTextPosition(index));
        }
        ANTLRGrammarEngine antlrEngineGrammar = this.window.getGrammarEngine().getANTLRGrammarEngine();
        antlrEngineGrammar.analyze();
        this.discoveredLexerGrammar = antlrEngineGrammar.getLexerGrammar();
        this.discoveredParserGrammar = antlrEngineGrammar.getParserGrammar();
        this.decisionDFA.clear();
        this.usesSynPreds.clear();
        this.usesSemPreds.clear();
        this.discover(this.discoveredLexerGrammar, lineIndexes, this.usesSemPreds, this.usesSynPreds);
        this.discover(this.discoveredParserGrammar, lineIndexes, this.usesSemPreds, this.usesSynPreds);
    }

    private void discover(Grammar g, Set<Integer> lineIndexes, Set<Integer> usesSemPreds, Set<Integer> usesSynPreds) {
        if (g == null) {
            return;
        }
        if (g.decisionsWhoseDFAsUsesSemPreds != null) {
            for (DFA dfa : g.decisionsWhoseDFAsUsesSemPreds) {
                usesSemPreds.add(dfa.getDecisionNumber());
            }
        }
        if (g.decisionsWhoseDFAsUsesSynPreds != null) {
            for (DFA dfa : g.decisionsWhoseDFAsUsesSynPreds) {
                usesSynPreds.add(dfa.getDecisionNumber());
            }
        }
        for (Integer lineIndex : lineIndexes) {
            this.addPositions(lineIndex, g.getLookaheadDFAColumnsForLineInFile(lineIndex));
        }
    }

    public void addPositions(Integer line, List<Integer> columnsForLineInFile) {
        if (columnsForLineInFile.isEmpty()) {
            return;
        }
        this.decisionDFA.put(line, columnsForLineInFile);
    }

    public boolean isDecisionPointAroundLocation(int line, int column) {
        List<Integer> s = this.decisionDFA.get(line + 1);
        return s != null && (s.contains(column - 1) || s.contains(column));
    }

    public List<DecisionDFAItem> getDecisionDFAItems() {
        ArrayList<DecisionDFAItem> items = new ArrayList<DecisionDFAItem>();
        for (int lineIndex : this.decisionDFA.keySet()) {
            for (int columnIndex : this.decisionDFA.get(lineIndex)) {
                DFA dfa = this.getDFAAtPosition(lineIndex, columnIndex);
                if (dfa == null) {
                    System.err.println("DFA is null for line " + lineIndex + " and column " + columnIndex);
                    continue;
                }
                Grammar g = this.discoveredLexerGrammar;
                if (g != null) {
                    Rule r = g.getRule("Tokens");
                    NFAState s = (NFAState)r.startState.transition((int)0).target;
                    if (s == null) {
                        System.err.println("NFAState s is null for rule " + r.name);
                        continue;
                    }
                    if (dfa.getDecisionNumber() == s.getDecisionNumber()) continue;
                }
                Color c = new Color(0, 128, 64);
                String title = "DFA decision " + dfa.getDecisionNumber();
                String info = "";
                if (this.usesSemPreds.contains(dfa.getDecisionNumber())) {
                    info = info + "uses semantic predicate";
                    c = new Color(255, 220, 0);
                } else if (this.usesSynPreds.contains(dfa.getDecisionNumber())) {
                    info = info + "uses syntactic predicate";
                    c = new Color(255, 220, 0);
                }
                if (dfa.isCyclic()) {
                    if (info.length() > 0) {
                        info = info + ", ";
                    }
                    info = info + "cyclic";
                }
                if (info.length() > 0) {
                    info = info + ", ";
                }
                info = info + dfa.getNumberOfStates() + " states";
                Point p = this.window.textEditor.getLineTextPositionsAtLineIndex(lineIndex - 1);
                if (p == null) continue;
                DecisionDFAItem item = new DecisionDFAItem(this.window);
                item.setAttributes(null, p.x + columnIndex - 1, p.x + columnIndex, lineIndex - 1, c, title + " (" + info + ")");
                item.shape = 3;
                items.add(item);
            }
        }
        return items;
    }

    public DFA getDFAAtPosition(int line, int column) {
        DFA dfa = null;
        if (this.discoveredParserGrammar != null) {
            dfa = this.discoveredParserGrammar.getLookaheadDFAFromPositionInFile(line, column);
        }
        if (dfa == null && this.discoveredLexerGrammar != null) {
            dfa = this.discoveredLexerGrammar.getLookaheadDFAFromPositionInFile(line, column);
        }
        return dfa;
    }

    public void refreshMenu() {
        this.window.getMainMenuBar().refresh();
    }

    public void refresh() {
        this.window.textEditor.damage();
        this.window.textEditor.repaint();
    }
}

