/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stringtemplate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import org.antlr.works.ate.ATEPanel;
import org.antlr.works.ate.ATEPanelAdapter;
import org.antlr.works.ate.ATETextPane;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.editor.EditorRules;
import org.antlr.works.editor.GrammarWindowTab;
import org.antlr.works.editor.completion.AutoCompletionMenu;
import org.antlr.works.editor.completion.AutoCompletionMenuDelegate;
import org.antlr.works.editor.navigation.GoToHistory;
import org.antlr.works.editor.navigation.GoToRule;
import org.antlr.works.editor.navigation.GoToRuleDelegate;
import org.antlr.works.find.FindAndReplace;
import org.antlr.works.find.FindAndReplaceDelegate;
import org.antlr.works.find.Usages;
import org.antlr.works.grammar.element.Jumpable;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.works.menu.ActionRefactor;
import org.antlr.works.menu.FindMenuDelegate;
import org.antlr.works.menu.GoToMenu;
import org.antlr.works.menu.GoToMenuDelegate;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.stringtemplate.STRulePanel;
import org.antlr.works.stringtemplate.STWindowMenu;
import org.antlr.works.stringtemplate.STWindowToolbar;
import org.antlr.works.stringtemplate.element.ElementTemplateReference;
import org.antlr.works.stringtemplate.element.ElementTemplateRule;
import org.antlr.works.stringtemplate.menu.ContextualStringTemplateMenuFactory;
import org.antlr.works.stringtemplate.syntax.ATEStringTemplateSyntaxEngine;
import org.antlr.works.stringtemplate.syntax.ATEStringTemplateSyntaxParser;
import org.antlr.xjlib.appkit.frame.XJWindow;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemCheck;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.undo.XJUndoDelegate;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.foundation.XJUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STWindow
extends XJWindow
implements AutoCompletionMenuDelegate,
XJUndoDelegate,
GoToRuleDelegate,
FindAndReplaceDelegate,
FindMenuDelegate,
GoToMenuDelegate {
    private STWindowMenu stringTemplateMenu;
    private STWindowToolbar toolbar;
    private JPanel mainPanel;
    private final List<GrammarWindowTab> tabs = new ArrayList<GrammarWindowTab>();
    private final Set<String> loadedStringTemplateFileNames = new HashSet<String>();
    public AutoCompletionMenu autoCompletionMenu;
    public ATEPanel textEditor;
    public STRulePanel stRulesPanel;
    public FindAndReplace findAndReplace;
    public GoToHistory goToHistory;
    public GoToRule goToRule;

    @Override
    public void awake() {
        this.stringTemplateMenu = new STWindowMenu(this);
        this.toolbar = new STWindowToolbar(this);
        this.createTextEditor();
        this.stRulesPanel = new STRulePanel(this);
        this.create();
        this.assemble();
        super.awake();
    }

    public void setContentPanel(JPanel panel) {
        this.getContentPane().add(panel);
        this.pack();
    }

    public void assemble() {
        JSplitPane verticalSplit = new JSplitPane();
        verticalSplit.setBorder(null);
        verticalSplit.setOrientation(1);
        verticalSplit.setRightComponent(this.textEditor);
        verticalSplit.setLeftComponent(this.stRulesPanel);
        verticalSplit.setContinuousLayout(false);
        verticalSplit.setOneTouchExpandable(true);
        verticalSplit.setResizeWeight(0.25);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(null);
        this.mainPanel.add((Component)this.toolbar.getToolbar(), "North");
        this.mainPanel.add((Component)verticalSplit, "Center");
        this.setContentPanel(this.mainPanel);
    }

    public void refreshMainMenuBar() {
        this.getMainMenuBar().refreshState();
    }

    public boolean loadStringTemplate(String name) {
        String fileName = name + ".st";
        String folder = this.getDocument().getDocumentFolder();
        if (folder == null) {
            return false;
        }
        String file = XJUtils.concatPath(folder, fileName);
        if (!new File(file).exists()) {
            return false;
        }
        if (this.loadedStringTemplateFileNames.contains(fileName)) {
            return true;
        }
        this.loadedStringTemplateFileNames.add(fileName);
        return true;
    }

    public STWindowToolbar getToolbar() {
        return this.toolbar;
    }

    public ActionRefactor getActionRefactor() {
        return this.stringTemplateMenu.getActionRefactor();
    }

    public GoToMenu getActionGoTo() {
        return this.stringTemplateMenu.getActionGoTo();
    }

    public ContextualStringTemplateMenuFactory createContextualStringTemplateMenuFactory() {
        return new ContextualStringTemplateMenuFactory(this.stringTemplateMenu);
    }

    public JPopupMenu getContextualMenu(int textIndex) {
        return this.stringTemplateMenu.getContextualMenu(textIndex);
    }

    public STWindowMenu getComponentContainerStringTemplateMenu() {
        return this.stringTemplateMenu;
    }

    public boolean componentDocumentWillSave() {
        AWPrefs.setLastSavedDocument(this.getFilePath());
        if (!this.isFileWritable()) {
            XJAlert.display(this.getJavaContainer(), "Cannot Save", "This file cannot be saved. Check the file permission on the disk and try again.");
            return false;
        }
        return true;
    }

    @Override
    public boolean close(boolean force) {
        if (!super.close(force)) {
            return false;
        }
        this.goToRule.close();
        this.autoCompletionMenu.close();
        this.textEditor.close();
        this.unregisterUndo(this);
        this.stringTemplateMenu.close();
        this.toolbar.close();
        return true;
    }

    @Override
    public void customizeFileMenu(XJMenu menu) {
        this.stringTemplateMenu.customizeFileMenu(menu);
    }

    @Override
    public void customizeMenuBar(XJMainMenuBar menubar) {
        this.stringTemplateMenu.customizeMenuBar(menubar);
    }

    @Override
    public void menuItemState(XJMenuItem item) {
        this.stringTemplateMenu.menuItemState(item);
    }

    @Override
    public void handleMenuSelected(XJMenu menu) {
    }

    @Override
    public void windowActivated() {
        for (GrammarWindowTab et : this.tabs) {
            et.editorActivated();
        }
    }

    public int getSimilarTab(GrammarWindowTab tab) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            GrammarWindowTab t = this.tabs.get(i);
            if (!t.getTabName().equals(tab.getTabName())) continue;
            return i;
        }
        return -1;
    }

    public void setComponent(JPanel panel, GrammarWindowTab tab) {
        this.setComponent(panel, tab.getTabComponent());
    }

    public void setComponent(JPanel panel, Component c) {
        panel.removeAll();
        panel.add(c);
        panel.revalidate();
        panel.repaint();
    }

    public void create() {
        this.initAutoCompletion();
        this.initTools();
        this.register();
    }

    protected void createTextEditor() {
        this.textEditor = new ATEPanel(this);
        this.textEditor.setParserEngine(new ATEStringTemplateSyntaxEngine());
        this.textEditor.setSyntaxColoring(true);
        this.textEditor.setAnalysisColumnVisible(false);
        this.applyPrefs();
        this.textEditor.setDelegate(new TextPanelDelegate());
    }

    protected void initAutoCompletion() {
        if (this.autoCompletionMenu != null) {
            this.autoCompletionMenu.close();
        }
        this.autoCompletionMenu = new AutoCompletionMenu(this, this.getTextPane(), this);
    }

    protected void initTools() {
        this.goToHistory = new GoToHistory();
        this.findAndReplace = new FindAndReplace(this);
        this.goToRule = new GoToRule(this, this, this.getTextPane());
    }

    protected void register() {
        this.registerUndo(this, this.getTextPane());
    }

    public void applyPrefs() {
        this.textEditor.setFoldingEnabled(AWPrefs.getFoldingEnabled());
        this.textEditor.setLineNumberEnabled(AWPrefs.getLineNumberEnabled());
        this.textEditor.setHighlightCursorLine(AWPrefs.getHighlightCursorEnabled());
        this.textEditor.getTextPane().setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.textEditor.getTextPane().setTabSize(AWPrefs.getEditorTabSize());
        this.textEditor.refresh();
        this.initAutoCompletion();
        this.applyFont();
    }

    public void applyFont() {
        this.getTextPane().setFont(new Font(AWPrefs.getEditorFont(), 0, AWPrefs.getEditorFontSize()));
        this.getTextPane().setTabSize(AWPrefs.getEditorTabSize());
    }

    @Override
    public String getText() {
        return this.textEditor.getText();
    }

    @Override
    public void setText(String text) {
        this.textEditor.setText(text);
    }

    @Override
    public ATEPanel getTextEditor() {
        return this.textEditor;
    }

    @Override
    public ATETextPane getTextPane() {
        return this.textEditor.getTextPane();
    }

    @Override
    public void setCaretPosition(int pos) {
        this.textEditor.setCaretPosition(pos);
    }

    @Override
    public int getCaretPosition() {
        return this.textEditor.getCaretPosition();
    }

    @Override
    public GrammarEngine getGrammarEngine() {
        return null;
    }

    @Override
    public void goToHistoryRememberCurrentPosition() {
        this.goToHistory.addPosition(this.getCaretPosition());
        this.refreshMainMenuBar();
    }

    public ElementTemplateReference getCurrentReference() {
        return this.getReferenceAtPosition(this.getCaretPosition());
    }

    public ElementTemplateReference getReferenceAtPosition(int pos) {
        for (ElementTemplateReference ref : this.getReferences()) {
            if (!ref.containsIndex(pos)) continue;
            return ref;
        }
        return null;
    }

    public List<ElementTemplateReference> getReferences() {
        return ((ATEStringTemplateSyntaxParser)this.getTextEditor().getParserEngine().getParser()).references;
    }

    public List<ATEToken> getDeclarations() {
        return ((ATEStringTemplateSyntaxParser)this.getTextEditor().getParserEngine().getParser()).decls;
    }

    @Override
    public void goToBackward() {
        if (this.goToHistory.canGoBack()) {
            this.setCaretPosition(this.goToHistory.getBackPosition(this.getCaretPosition()));
            this.refreshMainMenuBar();
        }
    }

    @Override
    public void goToForward() {
        if (this.goToHistory.canGoForward()) {
            this.setCaretPosition(this.goToHistory.getForwardPosition());
            this.refreshMainMenuBar();
        }
    }

    @Override
    public List<ATELine> getLines() {
        return this.textEditor.getLines();
    }

    @Override
    public void find() {
        StatisticsAW.shared().recordEvent(10);
        this.findAndReplace.find();
    }

    @Override
    public FindAndReplace getFindAndReplace() {
        return this.findAndReplace;
    }

    @Override
    public GoToRule getGoToRule() {
        return this.goToRule;
    }

    @Override
    public boolean goToRule(String ruleName) {
        for (ElementTemplateRule r : this.getRules()) {
            if (!r.name.equals(ruleName)) continue;
            this.goToHistoryRememberCurrentPosition();
            this.setCaretPosition(r.start.getStartIndex());
            return true;
        }
        return false;
    }

    @Override
    public List<String> getRulesStartingWith(String match) {
        ArrayList<String> matches = new ArrayList<String>();
        if (this.getRules() == null) {
            return matches;
        }
        for (ElementTemplateRule r : this.getRules()) {
            String rname = r.name.toLowerCase();
            if (!rname.startsWith(match) || matches.contains(r.name)) continue;
            matches.add(r.name);
        }
        return matches;
    }

    @Override
    public void goToDeclaration() {
        ElementTemplateReference ref = this.getCurrentReference();
        this.getActionGoTo().goToDeclaration(ref);
    }

    @Override
    public void goToDeclaration(Jumpable ref) {
        if (ref == null) {
            return;
        }
        this.goToHistoryRememberCurrentPosition();
        int index = this.getFirstDeclarationPosition(ref.getName());
        if (index != -1) {
            this.setCaretPosition(index);
        }
    }

    @Override
    public Set<Integer> getBreakpoints() {
        return null;
    }

    public int getFirstDeclarationPosition(String name) {
        ATEToken token = this.getFirstDeclaration(name);
        if (token != null) {
            return token.start;
        }
        return -1;
    }

    private ATEToken getFirstDeclaration(String name) {
        for (ATEToken decl : this.getDeclarations()) {
            if (!decl.getAttribute().equals(name)) continue;
            return decl;
        }
        return null;
    }

    @Override
    public ATEToken getCurrentToken() {
        return this.getTokenAtPosition(this.getCaretPosition(), false);
    }

    @Override
    public EditorRules getEditorRules() {
        return null;
    }

    public List<ElementTemplateRule> getRules() {
        return ((ATEStringTemplateSyntaxParser)this.getTextEditor().getParserEngine().getParser()).templateRules;
    }

    @Override
    public void addUsagesTab(Usages usage) {
    }

    @Override
    public void selectTextRange(int startIndex, int endIndex) {
        this.textEditor.selectTextRange(startIndex, endIndex);
    }

    @Override
    public List<ATEToken> getTokens() {
        return this.textEditor.getTokens();
    }

    public ATEToken getTokenAtPosition(int pos, boolean fromRight) {
        List<ATEToken> tokens = this.getTokens();
        if (tokens == null) {
            return null;
        }
        if (fromRight) {
            for (int i = tokens.size() - 1; i >= 0; --i) {
                ATEToken token = tokens.get(i);
                if (!token.containsIndex(pos)) continue;
                return token;
            }
        } else {
            for (ATEToken token : tokens) {
                if (!token.containsIndex(pos)) continue;
                return token;
            }
        }
        return null;
    }

    public boolean isRulesSorted() {
        return this.stRulesPanel.isRulesSorted();
    }

    public void toggleRulesSorting() {
        StatisticsAW.shared().recordEvent(123);
        this.stRulesPanel.toggleSorting();
        this.getToolbar().updateStates();
        this.stRulesPanel.refreshRules();
    }

    public JPopupMenu rulesGetContextualMenu() {
        ContextualStringTemplateMenuFactory factory = this.createContextualStringTemplateMenuFactory();
        XJMenuItemCheck item = (XJMenuItemCheck)factory.addItem(110);
        item.setSelected(this.isRulesSorted());
        return factory.menu;
    }

    public void componentDocumentContentChanged() {
        if (!this.isFileExists()) {
            XJAlert.display(this.getJavaContainer(), "Warning", "The document cannot be found on the disk anymore.");
            return;
        }
        if (AWPrefs.isAlertFileChangesDetected()) {
            XJAlert alert = XJAlert.createInstance();
            alert.setDisplayDoNotShowAgainButton(true);
            int result = alert.showCustom(this.getJavaContainer(), "File Changes", "The file \"" + this.getFileName() + "\" changed on the disk. Do you want to reload it?", "Cancel", "Reload", 1, 0);
            AWPrefs.setAlertFileChangesDetected(!alert.isDoNotShowAgain());
            if (result == 0) {
                return;
            }
        }
        int oldCursorPosition = this.textEditor.getCaretPosition();
        try {
            this.getDocument().reload();
        }
        catch (Exception e) {
            e.printStackTrace();
            XJAlert.display(this.getJavaContainer(), "Error Reloading Document", "An error occurred when reloading the document:\n" + e.toString());
        }
        this.textEditor.setCaretPosition(Math.min(oldCursorPosition, this.getText().length()), true, AWPrefs.getSmoothScrolling());
    }

    public void loadText(String text) {
        this.textEditor.loadText(text);
    }

    public void beginGroupChange(String name) {
        this.disableTextPane(false);
        this.beginTextPaneUndoGroup(name);
    }

    public void endGroupChange() {
        this.endTextPaneUndoGroup();
        this.enableTextPane(false);
        this.textEditor.parse();
        this.changeDone();
    }

    public void enableTextPane(boolean undo) {
        this.textEditor.setEnableRecordChange(true);
        if (undo) {
            this.enableTextPaneUndo();
        }
    }

    public void disableTextPane(boolean undo) {
        this.textEditor.setEnableRecordChange(false);
        if (undo) {
            this.disableTextPaneUndo();
        }
    }

    public void beginTextPaneUndoGroup(String name) {
        XJUndo undo = this.getUndo(this.getTextPane());
        if (undo != null) {
            undo.beginUndoGroup(name);
        }
    }

    public void endTextPaneUndoGroup() {
        XJUndo undo = this.getUndo(this.getTextPane());
        if (undo != null) {
            undo.endUndoGroup();
        }
    }

    public void disableTextPaneUndo() {
        this.textEditor.disableUndo();
    }

    public void enableTextPaneUndo() {
        this.textEditor.enableUndo();
    }

    @Override
    public void undoManagerWillUndo(boolean redo) {
    }

    public void changeDone() {
        this.getDocument().changeDone();
    }

    @Override
    public void undoManagerDidUndo(boolean redo) {
        this.changeDone();
    }

    public void notificationPrefsChanged() {
        this.applyPrefs();
    }

    @Override
    public List<String> autoCompletionMenuGetMatchingWordsForPartialWord(String partialWord) {
        partialWord = partialWord.toLowerCase();
        ArrayList<String> matchingArgs = new ArrayList<String>();
        ArrayList<String> matchingRules = new ArrayList<String>();
        List<ElementTemplateRule> rules = ((ATEStringTemplateSyntaxParser)this.textEditor.getParserEngine().getParser()).templateRules;
        int index = this.getCaretPosition();
        if (rules == null || rules.size() == 0) {
            return null;
        }
        for (ElementTemplateRule rule : rules) {
            if (rule.name.toLowerCase().startsWith(partialWord) && !matchingRules.contains(rule.name)) {
                matchingRules.add(rule.name);
            }
            if (!rule.containsIndex(index)) continue;
            for (ATEToken arg : rule.args) {
                if (!arg.getAttribute().toLowerCase().startsWith(partialWord) || matchingArgs.contains(arg.getAttribute())) continue;
                matchingArgs.add(arg.getAttribute());
            }
        }
        Collections.sort(matchingRules);
        Collections.sort(matchingArgs);
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(matchingArgs);
        ret.addAll(matchingRules);
        return ret;
    }

    @Override
    public void autoCompletionMenuWillDisplay() {
    }

    public synchronized boolean isFileExists() {
        String path = this.getFilePath();
        if (path == null) {
            return false;
        }
        File f = new File(path);
        return f.exists();
    }

    public synchronized boolean isFileWritable() {
        String path = this.getFilePath();
        if (path == null) {
            return true;
        }
        File f = new File(path);
        return !f.exists() || f.canWrite();
    }

    public synchronized String getFilePath() {
        return this.getDocument().getDocumentPath();
    }

    public synchronized String getFileName() {
        return this.getDocument().getDocumentName();
    }

    public void print() {
        try {
            this.textEditor.print();
        }
        catch (PrinterException e) {
            XJAlert.display(this.getJavaContainer(), "Print Error", "An error occurred while printing:\n" + e.toString());
        }
    }

    private class TextPanelDelegate
    extends ATEPanelAdapter {
        private TextPanelDelegate() {
        }

        public void ateChangeUpdate(int offset, int length, boolean insert) {
            STWindow.this.getDocument().changeDone();
        }

        public void ateEngineAfterParsing() {
            STWindow.this.stRulesPanel.refreshRules();
        }

        public void ateCaretUpdate(int index) {
            STWindow.this.autoCompletionMenu.updateAutoCompleteList();
        }

        public void ateInvokePopUp(Component component, int x, int y) {
            JPopupMenu m = STWindow.this.getContextualMenu(STWindow.this.textEditor.getTextIndexAtPosition(x, y));
            if (m != null) {
                m.show(component, x, y);
            }
        }
    }
}

