/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.fa;

import java.util.HashSet;
import java.util.Set;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.fa.FATransition;
import org.antlr.works.visualization.fa.FAWalkerDelegate;

public class FAWalker {
    private FAWalkerDelegate delegate;
    private int mode;
    private Set<FAState> visitedStates = new HashSet<FAState>();

    public FAWalker(FAWalkerDelegate delegate, int mode) {
        this.delegate = delegate;
        this.mode = mode;
    }

    public void walk(FAState state) {
        if (this.visitedStates.contains(state)) {
            return;
        }
        this.visitedStates.add(state);
        this.delegate.walkerState(state, this.mode);
        for (FATransition transition : state.transitions) {
            this.delegate.walkerTransition(transition, this.mode);
            this.walk(transition.target);
        }
    }
}

