/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.QuadCurve2D;
import org.antlr.works.visualization.graphics.GEngine;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.shape.SLinkArc;

public class GEngineGraphics
extends GEngine {
    SLinkArc link_arc = new SLinkArc();

    public Graphics2D getG2D() {
        return this.context.getGraphics2D();
    }

    public void setColor(Color color) {
        this.getG2D().setColor(color);
    }

    public Color getColor() {
        return this.getG2D().getColor();
    }

    public void setLineWidth(float width) {
        this.getG2D().setStroke(new BasicStroke(width));
    }

    public float getStringPixelWidth(Font font, String s) {
        this.getG2D().setFont(font);
        TextLayout layout = new TextLayout(s, this.getG2D().getFont(), this.getG2D().getFontRenderContext());
        return (float)layout.getBounds().getWidth();
    }

    public void drawLine(float x0, float y0, float x1, float y1) {
        this.getG2D().drawLine((int)x0, (int)y0, (int)x1, (int)y1);
    }

    public void drawArc(float x, float y, float w, float h, int a0, int a1) {
        this.getG2D().drawArc((int)x, (int)y, (int)w, (int)h, a0, a1);
    }

    public void drawCircle(float x, float y, float r) {
        this.getG2D().drawArc((int)(x - r), (int)(y - r), (int)(2.0f * r), (int)(2.0f * r), 0, 360);
    }

    public void drawRect(float x, float y, float dx, float dy) {
        this.getG2D().drawRect((int)x, (int)y, (int)dx, (int)dy);
    }

    public void drawRoundRect(float x, float y, float dx, float dy, float arc_dx, float arc_dy) {
        this.getG2D().drawRoundRect((int)x, (int)y, (int)dx, (int)dy, (int)arc_dx, (int)arc_dy);
    }

    public void drawOval(float x, float y, float dx, float dy) {
        this.getG2D().drawOval((int)x, (int)y, (int)dx, (int)dy);
    }

    public void fillRect(float x, float y, float dx, float dy) {
        this.getG2D().fillRect((int)x, (int)y, (int)dx, (int)dy);
    }

    public void fillOval(float x, float y, float dx, float dy) {
        this.getG2D().fillOval((int)x, (int)y, (int)dx, (int)dy);
    }

    public void fillCircle(float x, float y, float r) {
        this.getG2D().fillArc((int)(x - r), (int)(y - r), (int)(2.0f * r), (int)(2.0f * r), 0, 360);
    }

    public void drawRightArrow(float ox, float oy, float w, float h) {
        int[] x = new int[]{(int)(ox - w), (int)ox, (int)(ox - w)};
        int[] y = new int[]{(int)(oy - h), (int)oy, (int)(oy + h)};
        this.getG2D().drawPolygon(x, y, 3);
        this.getG2D().fillPolygon(x, y, 3);
    }

    public void drawUpArrow(float ox, float oy, float w, float h) {
        int[] x = new int[]{(int)(ox - h), (int)ox, (int)(ox + h)};
        int[] y = new int[]{(int)(oy + w), (int)oy, (int)(oy + w)};
        this.getG2D().drawPolygon(x, y, 3);
        this.getG2D().fillPolygon(x, y, 3);
    }

    public void drawDownArrow(float ox, float oy, float w, float h) {
        int[] x = new int[]{(int)(ox - h), (int)ox, (int)(ox + h)};
        int[] y = new int[]{(int)(oy - w), (int)oy, (int)(oy - w)};
        this.getG2D().drawPolygon(x, y, 3);
        this.getG2D().fillPolygon(x, y, 3);
    }

    public void drawString(Font font, String s, float x, float y, int align) {
        this.getG2D().setFont(font);
        TextLayout layout = new TextLayout(s, font, this.getG2D().getFontRenderContext());
        float tx = Float.MIN_VALUE;
        float ty = Float.MIN_VALUE;
        switch (align) {
            case 0: {
                tx = (float)((double)x - layout.getBounds().getWidth() * 0.5);
                ty = (float)((double)y + layout.getBounds().getHeight() * 0.5);
                break;
            }
            case 1: {
                tx = (float)((double)x - layout.getBounds().getWidth() * 0.5);
                ty = y;
                break;
            }
            case 2: {
                tx = (float)((double)x - layout.getBounds().getWidth());
                ty = (float)((double)y + layout.getBounds().getHeight() * 0.5);
                break;
            }
            case 3: {
                tx = x;
                ty = (float)((double)y + layout.getBounds().getHeight() * 0.5);
            }
        }
        layout.draw(this.getG2D(), tx, ty - 1.0f);
    }

    public void drawSpline(float x0, float y0, float x1, float y1, float startOffset, float endOffset, float flateness, boolean arrow) {
        this.link_arc.setStart(x0, y0);
        this.link_arc.setEnd(x1, y1);
        this.link_arc.setStartTangentOffset(startOffset);
        this.link_arc.setEndTangentOffset(endOffset);
        this.link_arc.setFlateness(flateness);
        this.link_arc.setArrowVisible(arrow);
        this.link_arc.update();
        this.link_arc.setColor(this.getG2D().getColor());
        this.link_arc.draw(this.getG2D());
    }

    public void drawArcConnector(float x0, float y0, float x1, float y1, float start_offset, float end_offset, float ctrl_offset, float arc_offset, boolean arrow) {
        if (x0 > x1) {
            ctrl_offset *= -1.0f;
            arc_offset *= -1.0f;
        }
        float cx = x1 - ctrl_offset;
        float ax0 = cx - arc_offset;
        Vector2D a = new Vector2D(cx, y0);
        Vector2D b = new Vector2D(x1, y1);
        Vector2D z = a.add(b.sub(a).setLength(Math.abs(arc_offset)));
        this.drawLine(x0 + start_offset, y0, ax0, y0);
        this.drawSpline((float)z.x, (float)z.y, x1, y1, 0.0f, end_offset, 0.0f, arrow);
        QuadCurve2D.Float quad = new QuadCurve2D.Float();
        quad.setCurve(ax0, y0, cx, y0, (float)z.x, (float)z.y);
        this.getG2D().draw(quad);
    }
}

