/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.app.MacOS;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import javax.swing.JFrame;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuBarDelegate;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.utils.XJLocalizable;
import org.antlr.xjlib.foundation.XJSystem;

public class XJApplicationMacOS
extends XJApplication
implements XJMenuBarDelegate {
    protected JFrame invisibleFrame = null;
    protected XJMainMenuBar mainMenuBar = null;

    public XJApplicationMacOS() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Application.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void handleAbout(ApplicationEvent e) {
                XJApplicationMacOS.this.displayAbout();
                e.setHandled(true);
            }

            public void handleOpenApplication(ApplicationEvent e) {
            }

            public void handleOpenFile(ApplicationEvent e) {
                XJApplicationMacOS.this.openDocument(e.getFilename());
            }

            public void handlePreferences(ApplicationEvent e) {
                XJApplicationMacOS.this.performPreferences();
            }

            public void handlePrintFile(ApplicationEvent e) {
            }

            public void handleQuit(ApplicationEvent e) {
                XJApplicationMacOS.this.performQuit();
            }
        });
    }

    protected void startup() {
        super.startup();
        if (!XJSystem.isHeadless()) {
            this.createFramelessMenuBar();
        }
    }

    protected void addPreferencesMenuItem() {
        Application.getApplication().addPreferencesMenuItem();
        Application.getApplication().setEnabledPreferencesMenu(true);
    }

    protected void removePreferencesMenuItem() {
        Application.getApplication().removePreferencesMenuItem();
    }

    private void createFramelessMenuBar() {
        this.invisibleFrame = new JFrame();
        this.invisibleFrame.setUndecorated(true);
        this.mainMenuBar = XJMainMenuBar.createInstance();
        this.mainMenuBar.createMenuBar();
        this.mainMenuBar.setDelegate(this);
        this.mainMenuBar.refreshState();
        this.invisibleFrame.setJMenuBar(this.mainMenuBar.getJMenuBar());
        this.invisibleFrame.setLocation(0, 0);
        this.invisibleFrame.setSize(0, 0);
        this.invisibleFrame.pack();
        this.invisibleFrame.setVisible(true);
    }

    public void menuItemState(XJMenuItem item) {
        int tag = item.getTag();
        switch (tag) {
            case 10000: {
                item.setTitle(XJLocalizable.getXJString("New") + (XJApplication.shared().getDocumentExtensions().size() > 1 ? "..." : ""));
            }
            case 10001: 
            case 20000: 
            case 20001: {
                item.setEnabled(true);
                break;
            }
            default: {
                if (XJMainMenuBar.isRecentFilesItem(item)) {
                    item.setEnabled(true);
                    break;
                }
                item.setEnabled(false);
            }
        }
    }

    public void handleMenuEvent(XJMenu menu, XJMenuItem item) {
    }

    public void handleMenuSelected(XJMenu menu) {
    }
}

