/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.app;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.antlr.xjlib.appkit.swing.XJColorChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJPreferences {
    protected Preferences prefs = null;
    protected Map<String, EventListener> bindings = new HashMap<String, EventListener>();

    public XJPreferences(Class c) {
        this.prefs = Preferences.userNodeForPackage(c);
    }

    public void flush() {
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public void setString(String key, String value) {
        this.prefs.put(key, value);
    }

    public String getString(String key, String def) {
        return this.prefs.get(key, def);
    }

    public void setInt(String key, int value) {
        this.prefs.putInt(key, value);
    }

    public void setInt(String key, Integer value) {
        this.prefs.putInt(key, value);
    }

    public int getInt(String key, int def) {
        return this.prefs.getInt(key, def);
    }

    public void setBoolean(String key, boolean value) {
        this.prefs.putBoolean(key, value);
    }

    public boolean getBoolean(String key, boolean def) {
        return this.prefs.getBoolean(key, def);
    }

    public void setColor(String key, Color value) {
        this.setObject(key, value);
    }

    public Color getColor(String key, Color def) {
        return (Color)this.getObject(key, def);
    }

    public void setList(String key, List<String> array) {
        this.setObject(key, array);
    }

    public List<String> getList(String key) {
        return (List)this.getObject(key, null);
    }

    public void setObject(String key, Object obj) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(obj);
            out.close();
            this.prefs.putByteArray(key, bos.toByteArray());
        }
        catch (Exception e) {
            System.err.println("Cannot set the object associated with key " + key + ": " + e);
        }
    }

    public Object getObject(String key, Object defaultObject) {
        try {
            byte[] bytes = this.prefs.getByteArray(key, null);
            if (bytes == null) {
                return defaultObject;
            }
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object o = in.readObject();
            in.close();
            return o;
        }
        catch (Exception e) {
            System.err.println("Cannot get the object associated with key " + key + ": " + e);
            return defaultObject;
        }
    }

    public void remove(String key) {
        this.prefs.remove(key);
    }

    public String[] getKeys() {
        try {
            return this.prefs.keys();
        }
        catch (BackingStoreException e) {
            System.err.println("Cannot retrieve the keys" + e);
            return null;
        }
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public void bindToPreferences(JComboBox component, String key, int defaultValue) {
        try {
            component.setSelectedIndex(this.getInt(key, defaultValue));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.setInt(key, component.getSelectedIndex());
        JComboBoxBindingAction action = new JComboBoxBindingAction(component, key, true);
        this.bindings.put(key, action);
        component.addActionListener(action);
    }

    public void bindToPreferences(JComboBox component, String key, String defaultValue) {
        component.setSelectedItem(this.getString(key, defaultValue));
        this.setString(key, (String)component.getSelectedItem());
        JComboBoxBindingAction action = new JComboBoxBindingAction(component, key, false);
        this.bindings.put(key, action);
        component.addActionListener(action);
    }

    public void bindToPreferences(JSpinner component, String key, int defaultValue) {
        component.setValue(this.getInt(key, defaultValue));
        this.setInt(key, (Integer)component.getValue());
        JSpinnerBindingAction action = new JSpinnerBindingAction(component, key);
        this.bindings.put(key, action);
        component.addChangeListener(action);
    }

    public void bindToPreferences(JTextField component, String key, int defaultValue) {
        this.bindToPreferences(component, key, String.valueOf(defaultValue));
    }

    public void bindToPreferences(JTextField component, String key, String defaultValue) {
        component.setText(this.getString(key, defaultValue));
        this.setString(key, component.getText());
        JTextFieldBindingAction action = new JTextFieldBindingAction(component, key);
        this.bindings.put(key, action);
        component.addActionListener(action);
    }

    public void bindToPreferences(JTextPane component, String key, String defaultValue) {
        component.setText(this.getString(key, defaultValue));
        this.setString(key, component.getText());
        JTextPaneBindingAction action = new JTextPaneBindingAction(component, key);
        this.bindings.put(key, action);
        component.addKeyListener(action);
    }

    public void defaultPreference(JCheckBox component, String key, boolean defaultValue) {
        component.setSelected(defaultValue);
        this.setBoolean(key, component.isSelected());
    }

    public void bindToPreferences(JCheckBox component, String key, boolean defaultValue) {
        component.setSelected(this.getBoolean(key, defaultValue));
        this.setBoolean(key, component.isSelected());
        JCheckBoxBindingAction action = new JCheckBoxBindingAction(component, key);
        this.bindings.put(key, action);
        component.addActionListener(action);
    }

    public void unbindFromPreferences(JCheckBox component, String key) {
        ActionListener actionListener = (ActionListener)this.bindings.remove(key);
        if (actionListener != null) {
            component.removeActionListener(actionListener);
        }
    }

    public void bindToPreferences(JToggleButton component, String key, boolean defaultValue) {
        component.setSelected(this.getBoolean(key, defaultValue));
        this.setBoolean(key, component.isSelected());
        JToggleButtonBindingAction action = new JToggleButtonBindingAction(component, key);
        this.bindings.put(key, action);
        component.addActionListener(action);
    }

    public void unbindFromPreferences(JToggleButton component, String key) {
        ActionListener actionListener = (ActionListener)this.bindings.remove(key);
        if (actionListener != null) {
            component.removeActionListener(actionListener);
        }
    }

    public void bindToPreferences(ButtonGroup component, String key, String defaultValue) {
        component.setSelected(this.getButtonWithActionCommand(component, this.getString(key, defaultValue)).getModel(), true);
        this.setString(key, component.getSelection().getActionCommand());
        ButtonGroupBindingAction action = new ButtonGroupBindingAction(component, key);
        this.bindings.put(key, action);
        Enumeration<AbstractButton> elements = component.getElements();
        while (elements.hasMoreElements()) {
            AbstractButton button = elements.nextElement();
            button.addActionListener(action);
        }
    }

    public void defaultPreference(JPanel component, String key, Color defaultValue) {
        component.setBackground(defaultValue);
        this.setColor(key, component.getBackground());
    }

    public void bindToPreferences(JPanel component, String key, Color defaultValue) {
        component.setBackground(this.getColor(key, defaultValue));
        this.setColor(key, component.getBackground());
        ColorChooserBindingMouseListener listener = new ColorChooserBindingMouseListener(component, key);
        this.bindings.put(key, listener);
        component.addMouseListener(listener);
    }

    public void applyPreferences() {
        for (String s : this.bindings.keySet()) {
            this.applyPreference(s);
        }
    }

    public void applyPreference(String key) {
        EventListener o = this.bindings.get(key);
        if (o instanceof ActionListener) {
            ActionListener action = (ActionListener)o;
            action.actionPerformed(null);
        } else if (o instanceof ChangeListener) {
            ChangeListener action = (ChangeListener)o;
            action.stateChanged(null);
        } else if (o instanceof MouseListener) {
            MouseListener listener = (MouseListener)o;
            listener.mousePressed(null);
        }
    }

    protected AbstractButton getButtonWithActionCommand(ButtonGroup group, String actionCommand) {
        Enumeration<AbstractButton> elements = group.getElements();
        while (elements.hasMoreElements()) {
            AbstractButton button = elements.nextElement();
            if (!button.getActionCommand().equalsIgnoreCase(actionCommand)) continue;
            return button;
        }
        return null;
    }

    protected class ColorChooserBindingMouseListener
    extends MouseAdapter {
        JPanel component = null;
        String key = null;

        public ColorChooserBindingMouseListener(JPanel component, String key) {
            this.component = component;
            this.key = key;
        }

        public void mousePressed(MouseEvent e) {
            if (e == null) {
                XJPreferences.this.setColor(this.key, this.component.getBackground());
            } else {
                XJColorChooser cc = new XJColorChooser(this.component.getParent(), true, this.component);
                if (cc.runModal() == 1) {
                    XJPreferences.this.setColor(this.key, cc.getColor());
                }
            }
        }
    }

    protected class JSpinnerBindingAction
    implements ChangeListener {
        JSpinner component = null;
        String key = null;

        public JSpinnerBindingAction(JSpinner component, String key) {
            this.component = component;
            this.key = key;
        }

        public void stateChanged(ChangeEvent e) {
            XJPreferences.this.setInt(this.key, (Integer)this.component.getValue());
        }
    }

    protected class ButtonGroupBindingAction
    implements ActionListener {
        ButtonGroup component = null;
        String key = null;

        public ButtonGroupBindingAction(ButtonGroup component, String key) {
            this.component = component;
            this.key = key;
        }

        public void actionPerformed(ActionEvent e) {
            XJPreferences.this.setString(this.key, this.component.getSelection().getActionCommand());
        }
    }

    protected class JToggleButtonBindingAction
    implements ActionListener {
        JToggleButton component = null;
        String key = null;

        public JToggleButtonBindingAction(JToggleButton component, String key) {
            this.component = component;
            this.key = key;
        }

        public void actionPerformed(ActionEvent e) {
            XJPreferences.this.setBoolean(this.key, this.component.isSelected());
        }
    }

    protected class JCheckBoxBindingAction
    implements ActionListener {
        JCheckBox component = null;
        String key = null;

        public JCheckBoxBindingAction(JCheckBox component, String key) {
            this.component = component;
            this.key = key;
        }

        public void actionPerformed(ActionEvent e) {
            XJPreferences.this.setBoolean(this.key, this.component.isSelected());
        }
    }

    protected class JTextPaneBindingAction
    implements KeyListener {
        JTextPane component = null;
        String key = null;

        public JTextPaneBindingAction(JTextPane component, String key) {
            this.component = component;
            this.key = key;
        }

        public void keyTyped(KeyEvent e) {
            XJPreferences.this.setString(this.key, this.component.getText());
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    protected class JTextFieldBindingAction
    implements ActionListener {
        JTextField component = null;
        String key = null;

        public JTextFieldBindingAction(JTextField component, String key) {
            this.component = component;
            this.key = key;
        }

        public void actionPerformed(ActionEvent e) {
            XJPreferences.this.setString(this.key, this.component.getText());
        }
    }

    protected class JComboBoxBindingAction
    implements ActionListener {
        JComboBox component = null;
        String key = null;
        boolean index = false;

        public JComboBoxBindingAction(JComboBox component, String key, boolean index) {
            this.component = component;
            this.key = key;
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.index) {
                XJPreferences.this.setInt(this.key, this.component.getSelectedIndex());
            } else {
                XJPreferences.this.setString(this.key, (String)this.component.getSelectedItem());
            }
        }
    }
}

