/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.frame;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTextPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.antlr.xjlib.appkit.XJControl;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.app.XJPreferences;
import org.antlr.xjlib.appkit.frame.XJFrameDelegate;
import org.antlr.xjlib.appkit.frame.XJInternalFrameHandling;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuBarCustomizer;
import org.antlr.xjlib.appkit.menu.XJMenuBarDelegate;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.undo.XJUndoDelegate;
import org.antlr.xjlib.appkit.undo.XJUndoEngine;
import org.antlr.xjlib.appkit.utils.XJLocalizable;
import org.antlr.xjlib.foundation.XJSystem;

public class XJFrame
extends XJControl
implements XJMenuBarCustomizer,
XJMenuBarDelegate {
    private static final String PROPERTY_WINDOW_MODIFIED = "windowModified";
    private static final String PREF_DESKTOP_BOUNDS = "xjdesktop_bounds";
    private static final boolean useDesktop = XJApplication.shared().useDesktopMode();
    private static JDesktopPane desktop;
    protected static JFrame desktopFrame;
    protected static XJMainMenuBar desktopDefaultMenuBar;
    private JInternalFrame jInternalFrame;
    private JFrame jFrame;
    private WindowListener wl;
    private InternalFrameAdapter ifa;
    protected XJMainMenuBar mainMenuBar;
    protected XJFrameDelegate delegate;
    protected XJUndoEngine undoEngine;
    protected boolean alreadyBecomeVisible = false;
    protected boolean dirty = false;
    private String title;
    private static final String PREF_WINDOWS_BOUNDS_PREFIX = "xjframe_bounds.";
    private static final int MAX_WINDOWS_BOUND_KEYS = 100;

    private static void restoreDesktopBounds() {
        Rectangle r = (Rectangle)XJApplication.shared().getPreferences().getObject(PREF_DESKTOP_BOUNDS, null);
        if (r != null) {
            desktopFrame.setLocation(r.x, r.y);
            desktopFrame.setSize(r.width, r.height);
        }
    }

    private static void saveDesktopBounds() {
        Point pos = desktopFrame.getLocation();
        Dimension s = desktopFrame.getSize();
        Rectangle r = new Rectangle(pos.x, pos.y, s.width, s.height);
        XJPreferences prefs = XJApplication.shared().getPreferences();
        prefs.setObject(PREF_DESKTOP_BOUNDS, r);
    }

    public static void closeDesktop() {
        if (useDesktop) {
            XJFrame.saveDesktopBounds();
        }
    }

    public XJFrame() {
        if (useDesktop) {
            if (desktopFrame == null) {
                desktopFrame = new JFrame();
                desktopFrame.setDefaultCloseOperation(0);
                desktopFrame.setTitle(XJApplication.shared().getApplicationName());
                this.wl = new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        XJApplication.shared().performQuit();
                    }
                };
                desktopFrame.addWindowListener(this.wl);
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                dim = new Dimension((int)((double)dim.width * 0.9), (int)((double)dim.height * 0.9));
                desktopFrame.setSize(dim);
                desktopFrame.setPreferredSize(dim);
                desktopFrame.setLocationRelativeTo(null);
                XJFrame.restoreDesktopBounds();
                desktop = new JDesktopPane();
                desktopFrame.getContentPane().add((Component)desktop, "Center");
                desktopFrame.setVisible(true);
                new XJInternalFrameHandling();
            }
            this.jInternalFrame = new JInternalFrame();
            this.jInternalFrame.setResizable(true);
            this.jInternalFrame.setClosable(true);
            this.jInternalFrame.setMaximizable(true);
            this.jInternalFrame.setIconifiable(true);
            desktop.add(this.jInternalFrame);
            this.ifa = new InternalFrameAdapter(){

                public void internalFrameActivated(InternalFrameEvent e) {
                    XJMainMenuBar mb = XJFrame.this.getMainMenuBar();
                    if (mb != null) {
                        desktopFrame.setJMenuBar(mb.getJMenuBar());
                    }
                    XJFrame.this.windowActivated();
                }

                public void internalFrameDeactivated(InternalFrameEvent e) {
                    if (XJFrame.this.jInternalFrame != null) {
                        XJFrame.this.windowDeactivated();
                    }
                }

                public void internalFrameClosing(InternalFrameEvent e) {
                    XJFrame.this.close(false);
                }
            };
            this.jInternalFrame.addInternalFrameListener(this.ifa);
        } else {
            this.jFrame = new JFrame();
            this.wl = new WindowAdapter(){

                public void windowActivated(WindowEvent e) {
                    XJFrame.this.windowActivated();
                }

                public void windowDeactivated(WindowEvent e) {
                    if (XJFrame.this.jFrame != null) {
                        XJFrame.this.windowDeactivated();
                    }
                }

                public void windowClosing(WindowEvent e) {
                    XJFrame.this.close(false);
                }
            };
            this.jFrame.addWindowListener(this.wl);
        }
        this.setDefaultSize();
        this.undoEngine = new XJUndoEngine();
    }

    public void awake() {
        if (this.shouldDisplayMainMenuBar()) {
            this.mainMenuBar = XJMainMenuBar.createInstance();
            this.mainMenuBar.setCustomizer(this);
            this.mainMenuBar.setDelegate(this);
            this.mainMenuBar.createMenuBar();
            this.setMainMenuBar(this.mainMenuBar);
            this.undoEngine.setMainMenuBar(this.mainMenuBar);
        }
    }

    public void setDelegate(XJFrameDelegate delegate) {
        this.delegate = delegate;
    }

    public XJFrameDelegate getDelegate() {
        return this.delegate;
    }

    public void setDefaultCloseOperation(int operation) {
        if (useDesktop) {
            this.jInternalFrame.setDefaultCloseOperation(operation);
        } else {
            this.jFrame.setDefaultCloseOperation(operation);
        }
    }

    public Container getContentPane() {
        if (useDesktop) {
            return this.jInternalFrame.getContentPane();
        }
        return this.jFrame.getContentPane();
    }

    public JRootPane getRootPane() {
        if (useDesktop) {
            return this.jInternalFrame.getRootPane();
        }
        return this.jFrame.getRootPane();
    }

    public JLayeredPane getLayeredPane() {
        if (useDesktop) {
            return this.jInternalFrame.getLayeredPane();
        }
        return this.jFrame.getLayeredPane();
    }

    public Component getGlassPane() {
        if (useDesktop) {
            return this.jInternalFrame.getGlassPane();
        }
        return this.jFrame.getGlassPane();
    }

    public void setMainMenuBar(XJMainMenuBar menubar) {
        this.mainMenuBar = menubar;
        if (useDesktop) {
            if (this.jInternalFrame.isSelected()) {
                desktopFrame.setJMenuBar(this.mainMenuBar.getJMenuBar());
            }
        } else {
            this.jFrame.setJMenuBar(this.mainMenuBar.getJMenuBar());
        }
    }

    public XJMainMenuBar getMainMenuBar() {
        return this.mainMenuBar;
    }

    public void menuItemStatusChanged(int tag) {
        if (this.mainMenuBar == null) {
            return;
        }
        this.mainMenuBar.refresh();
    }

    public void setTitle(String title) {
        this.title = title;
        if (XJSystem.isMacOS()) {
            File f = null;
            if (title != null && !(f = new File(title)).exists()) {
                f = null;
            }
            this.getRootPane().putClientProperty("Window.documentFile", f);
        }
        if (useDesktop) {
            this.jInternalFrame.setTitle(this.customizeWindowTitle(this.getTitle()));
        } else {
            this.jFrame.setTitle(this.customizeWindowTitle(this.getTitle()));
        }
    }

    public String getTitle() {
        return this.title == null ? "Untitled" : this.title;
    }

    public void updateTitle() {
        this.setTitle(this.title);
    }

    private String customizeWindowTitle(String title) {
        if (this.dirty() && !XJSystem.isMacOS()) {
            return title + " *";
        }
        return title;
    }

    public void setLocation(Point loc) {
        if (useDesktop) {
            this.jInternalFrame.setLocation(loc);
        } else {
            this.jFrame.setLocation(loc);
        }
    }

    public Point getLocation() {
        if (useDesktop) {
            return this.jInternalFrame.getLocation();
        }
        return this.jFrame.getLocation();
    }

    public void setSize(int dx, int dy) {
        if (useDesktop) {
            this.jInternalFrame.setSize(dx, dy);
        } else {
            this.jFrame.setSize(dx, dy);
        }
    }

    public void setPreferredSize(int dx, int dy) {
        this.setPreferredSize(new Dimension(dx, dy));
    }

    public void setPreferredSize(Dimension size) {
        if (useDesktop) {
            this.jInternalFrame.setPreferredSize(size);
        } else {
            this.jFrame.setPreferredSize(size);
        }
    }

    public Dimension getPreferredSize() {
        if (useDesktop) {
            return this.jInternalFrame.getPreferredSize();
        }
        return this.jFrame.getPreferredSize();
    }

    public void setSize(Dimension size) {
        if (useDesktop) {
            this.jInternalFrame.setSize(size);
        } else {
            this.jFrame.setSize(size);
        }
    }

    public Dimension getSize() {
        if (useDesktop) {
            return this.jInternalFrame.getSize();
        }
        return this.jFrame.getSize();
    }

    public void setDefaultSize() {
        if (useDesktop) {
            Dimension dim = desktop.getSize();
            this.setPreferredSize((int)((double)dim.width * 0.8), (int)((double)dim.height * 0.8));
        } else {
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            this.setPreferredSize((int)((double)dim.width * 0.5), (int)((double)dim.height * 0.5));
        }
    }

    public void setResizable(boolean flag) {
        if (useDesktop) {
            this.jInternalFrame.setResizable(flag);
        } else {
            this.jFrame.setResizable(flag);
        }
    }

    public void setMaximizable(boolean flag) {
        if (useDesktop) {
            this.jInternalFrame.setMaximizable(flag);
        }
    }

    public boolean isMaximized() {
        return useDesktop && this.jInternalFrame.isMaximum();
    }

    public void pack() {
        if (useDesktop) {
            this.jInternalFrame.pack();
        } else {
            this.jFrame.pack();
        }
    }

    public void bringToFront() {
        if (useDesktop) {
            if (this.jInternalFrame == null) {
                return;
            }
            this.jInternalFrame.moveToFront();
            try {
                this.jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
        } else {
            this.jFrame.toFront();
        }
    }

    public void setVisible(boolean flag) {
        if (flag && !this.alreadyBecomeVisible) {
            this.alreadyBecomeVisible = true;
            this.restoreWindowBounds();
            this.ensureVisibility();
            this.becomingVisibleForTheFirstTime();
        }
        if (useDesktop) {
            this.jInternalFrame.setVisible(flag);
        } else {
            this.jFrame.setVisible(flag);
        }
        this.bringToFront();
    }

    public void ensureVisibility() {
        if (!this.isVisibleOnScreen()) {
            this.center();
        }
    }

    public void becomingVisibleForTheFirstTime() {
    }

    public String autosaveName() {
        return null;
    }

    public boolean isVisible() {
        if (useDesktop) {
            return this.jInternalFrame != null && this.jInternalFrame.isVisible();
        }
        return this.jFrame.isVisible();
    }

    public boolean isActive() {
        if (useDesktop) {
            return this.jInternalFrame != null && this.jInternalFrame.isSelected();
        }
        return this.jFrame.isActive();
    }

    public void show() {
        this.setVisible(true);
    }

    public void showModal() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public boolean isCompletelyOnScreen() {
        return this.isVisibleOnScreen();
    }

    public boolean isVisibleOnScreen() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Rectangle fr = useDesktop ? this.jInternalFrame.getBounds() : this.jFrame.getBounds();
        for (GraphicsDevice g : gs) {
            GraphicsConfiguration dc = g.getDefaultConfiguration();
            if (!fr.intersects(dc.getBounds())) continue;
            return true;
        }
        return false;
    }

    public void center() {
        if (useDesktop) {
            Dimension s = desktopFrame.getSize();
            Dimension id = this.jInternalFrame.getSize();
            this.jInternalFrame.setLocation(s.width / 2 - id.width / 2, s.height / 2 - id.height / 2);
        } else {
            this.jFrame.setLocationRelativeTo(null);
        }
    }

    public void setPosition(int x, int y) {
        this.setLocation(new Point(x, y));
    }

    public void offsetPosition(int dx, int dy) {
        Point p = this.getLocation();
        this.setPosition(p.x + dx, p.y + dy);
    }

    public boolean performClose(boolean force) {
        return this.close(force);
    }

    protected boolean close(boolean force) {
        XJMainMenuBar.removeInstance(this.mainMenuBar);
        if (this.mainMenuBar != null) {
            this.mainMenuBar.setCustomizer(null);
            this.mainMenuBar.setDelegate(null);
            this.mainMenuBar = null;
        }
        this.saveWindowBounds();
        if (useDesktop) {
            if (this.jInternalFrame.isSelected()) {
                desktopFrame.setJMenuBar(desktopDefaultMenuBar.getJMenuBar());
            }
            this.jInternalFrame.removeInternalFrameListener(this.ifa);
            this.jInternalFrame.dispose();
            desktop.remove(this.jInternalFrame);
            this.jInternalFrame = null;
            for (JInternalFrame f : desktop.getAllFrames()) {
                if (!f.isVisible()) continue;
                try {
                    f.setSelected(true);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
                break;
            }
        } else {
            this.jFrame.removeWindowListener(this.wl);
            this.jFrame.dispose();
            this.jFrame = null;
        }
        if (this.delegate != null) {
            this.delegate.frameDidClose(this);
        }
        return true;
    }

    public void setDirty() {
        if (!XJApplication.shared().supportsPersistence()) {
            return;
        }
        if (!this.dirty) {
            this.dirty = true;
            this.getRootPane().putClientProperty(PROPERTY_WINDOW_MODIFIED, Boolean.TRUE);
            this.menuItemStatusChanged(10002);
            this.updateTitle();
            this.dirtyChanged();
        }
    }

    public void resetDirty() {
        if (!XJApplication.shared().supportsPersistence()) {
            return;
        }
        if (this.dirty) {
            this.dirty = false;
            this.getRootPane().putClientProperty(PROPERTY_WINDOW_MODIFIED, Boolean.FALSE);
            this.menuItemStatusChanged(10002);
            this.updateTitle();
            this.dirtyChanged();
        }
    }

    public void dirtyChanged() {
    }

    public boolean dirty() {
        if (!XJApplication.shared().supportsPersistence()) {
            return false;
        }
        Boolean b = (Boolean)this.getRootPane().getClientProperty(PROPERTY_WINDOW_MODIFIED);
        return b != null && b != false;
    }

    public void registerUndo(XJUndoDelegate delegate, JTextPane textPane) {
        this.undoEngine.registerUndo(new XJUndo(this.undoEngine, delegate), textPane);
    }

    public void unregisterUndo(XJUndoDelegate delegate) {
        this.undoEngine.unregisterUndo(delegate);
    }

    public void performUndo() {
        XJUndo undo = this.getCurrentUndo();
        if (undo != null) {
            undo.performUndo();
        }
    }

    public void performRedo() {
        XJUndo undo = this.getCurrentUndo();
        if (undo != null) {
            undo.performRedo();
        }
    }

    public XJUndo getUndo(JTextPane textPane) {
        return this.undoEngine.getUndo(textPane);
    }

    public XJUndo getCurrentUndo() {
        return this.undoEngine.getCurrentUndo();
    }

    public boolean shouldDisplayMainMenuBar() {
        return true;
    }

    public boolean shouldAppearsInWindowMenu() {
        return false;
    }

    public void windowActivated() {
    }

    public void windowDeactivated() {
    }

    public void customizeFileMenu(XJMenu menu) {
    }

    public void customizeEditMenu(XJMenu menu) {
    }

    public void customizeWindowMenu(XJMenu menu) {
    }

    public void customizeHelpMenu(XJMenu menu) {
    }

    public void customizeMenuBar(XJMainMenuBar menubar) {
    }

    public void menuItemState(XJMenuItem item) {
        switch (item.getTag()) {
            case 10000: {
                item.setTitle(XJLocalizable.getXJString("New") + (XJApplication.shared().getDocumentExtensions().size() > 1 ? "..." : ""));
                break;
            }
            case 10023: 
            case 10024: {
                this.getMainMenuBar().menuUndoRedoItemState(this.undoEngine.getCurrentUndo());
            }
        }
    }

    public void handleMenuEvent(XJMenu menu, XJMenuItem item) {
        switch (item.getTag()) {
            case 10023: {
                this.performUndo();
                break;
            }
            case 10024: {
                this.performRedo();
                break;
            }
            case 10025: {
                XJFrame.performActionOnFocusedJComponent("cut-to-clipboard");
                break;
            }
            case 10026: {
                XJFrame.performActionOnFocusedJComponent("copy-to-clipboard");
                break;
            }
            case 10027: {
                XJFrame.performActionOnFocusedJComponent("paste-from-clipboard");
                break;
            }
            case 10028: {
                XJFrame.performActionOnFocusedJComponent("select-all");
            }
        }
    }

    public void handleMenuSelected(XJMenu menu) {
    }

    public static void performActionOnFocusedJComponent(String action) {
        JComponent c = XJFrame.getFocusedJComponent();
        if (c != null) {
            c.getActionMap().get(action).actionPerformed(null);
        }
    }

    public static JComponent getFocusedJComponent() {
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (c instanceof JComponent) {
            return (JComponent)c;
        }
        return null;
    }

    public Container getJavaContainer() {
        if (useDesktop) {
            return this.jInternalFrame;
        }
        return this.jFrame;
    }

    private void restoreWindowBounds() {
        String name = this.autosaveName();
        if (name == null) {
            return;
        }
        Rectangle r = this.restoreWindowBoundsNewWay(name);
        if (r == null) {
            r = (Rectangle)XJApplication.shared().getPreferences().getObject(name, null);
        }
        if (r != null) {
            this.setPosition(r.x, r.y);
            this.setSize(r.width, r.height);
        }
    }

    private Rectangle restoreWindowBoundsNewWay(String name) {
        return (Rectangle)XJApplication.shared().getPreferences().getObject(PREF_WINDOWS_BOUNDS_PREFIX + name, null);
    }

    private void saveWindowBounds() {
        String name = this.autosaveName();
        if (name == null) {
            return;
        }
        Point pos = this.getLocation();
        Dimension s = this.getSize();
        Rectangle r = new Rectangle(pos.x, pos.y, s.width, s.height);
        XJPreferences prefs = XJApplication.shared().getPreferences();
        String[] keys = prefs.getKeys();
        if (keys != null) {
            int count = 0;
            for (String key : keys) {
                if (!key.startsWith(PREF_WINDOWS_BOUNDS_PREFIX) || ++count <= 100) continue;
                prefs.remove(key);
            }
        }
        prefs.setObject(PREF_WINDOWS_BOUNDS_PREFIX + name, r);
    }
}

