/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.antlr.xjlib.appkit.frame.XJView;
import org.antlr.xjlib.appkit.gview.GViewDelegate;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.event.GEventCreateElement;
import org.antlr.xjlib.appkit.gview.event.GEventCreateLinkElement;
import org.antlr.xjlib.appkit.gview.event.GEventDelegate;
import org.antlr.xjlib.appkit.gview.event.GEventDragElement;
import org.antlr.xjlib.appkit.gview.event.GEventDragRootElement;
import org.antlr.xjlib.appkit.gview.event.GEventDragSelection;
import org.antlr.xjlib.appkit.gview.event.GEventEditElement;
import org.antlr.xjlib.appkit.gview.event.GEventFocusElement;
import org.antlr.xjlib.appkit.gview.event.GEventManager;
import org.antlr.xjlib.appkit.gview.event.GEventModifyLinkElement;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.object.GLink;
import org.antlr.xjlib.appkit.gview.timer.GTimer;
import org.antlr.xjlib.appkit.gview.timer.GTimerDelegate;
import org.antlr.xjlib.appkit.gview.utils.GAlphaVariator;
import org.antlr.xjlib.appkit.gview.utils.GMagnetic;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;
import org.antlr.xjlib.appkit.swing.XJGraphics2DPS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GView
extends XJView
implements XJMenuItemDelegate,
GTimerDelegate,
GEventDelegate {
    public static final double DEFAULT_LINK_FLATENESS = 40.0;
    public static final int SCROLL_TO_VISIBLE_MARGIN = 10;
    protected GViewDelegate delegate = null;
    protected GEventManager eventManager = new GEventManager(this);
    protected GElement rootElement = null;
    protected Point lastMousePosition = null;
    protected boolean smoothGraphics = true;
    protected float zoom = 1.0f;
    protected boolean autoAdjustSize = false;
    protected boolean drawBorder = true;
    protected int sizeMargin = 0;
    protected GTimer selectionTimer = new GTimer(this);
    protected GTimer focusTimer = new GTimer(this);
    protected GAlphaVariator selectionAlphaVariator = new GAlphaVariator();
    protected GAlphaVariator focusAlphaVariator = new GAlphaVariator();
    protected Set<GMagnetic> magnetics = new HashSet<GMagnetic>();
    protected boolean magneticsVisible = false;

    public GView() {
        this.setFocusable(false);
        this.setBackground(Color.gray);
        this.setPreferredSize(new Dimension(1024, 600));
        this.addDefaultEventManager();
    }

    public void addDefaultEventManager() {
        this.eventManager.add(new GEventDragElement(this));
        this.eventManager.add(new GEventDragRootElement(this));
        this.eventManager.add(new GEventDragSelection(this));
        this.eventManager.add(new GEventEditElement(this));
        this.eventManager.add(new GEventCreateLinkElement(this));
        this.eventManager.add(new GEventCreateElement(this));
        this.eventManager.add(new GEventFocusElement(this));
        this.eventManager.add(new GEventModifyLinkElement(this));
    }

    public int defaultLinkShape() {
        return 0;
    }

    public void setRootElement(GElement element) {
        this.rootElement = element;
        if (this.rootElement != null) {
            this.rootElement.setPanel(this);
            this.autoAdjustSize();
        }
    }

    public GElement getRootElement() {
        return this.rootElement;
    }

    public GEventManager getEventManager() {
        return this.eventManager;
    }

    public void setDelegate(GViewDelegate delegate) {
        this.delegate = delegate;
    }

    public void setSmoothGraphics(boolean flag) {
        this.smoothGraphics = flag;
    }

    public boolean getSmoothGraphics() {
        return this.smoothGraphics;
    }

    public void setAutoAdjustSize(boolean flag) {
        this.autoAdjustSize = flag;
    }

    public boolean getAutoAdjustSize() {
        return this.autoAdjustSize;
    }

    public float getSelectionAlphaValue() {
        return this.selectionAlphaVariator.getAlphaValue();
    }

    public float getFocusAlphaValue() {
        return this.focusAlphaVariator.getAlphaValue();
    }

    public Point getMousePosition(MouseEvent e) {
        Point p = e.getPoint();
        if (this.zoom != 1.0f) {
            return new Point((int)((float)p.x / this.zoom), (int)((float)p.y / this.zoom));
        }
        return p;
    }

    public Point getLastMousePosition() {
        return this.lastMousePosition;
    }

    public void setDrawBorder(boolean flag) {
        this.drawBorder = flag;
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
        this.autoAdjustSize();
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setSizeMargin(int margin) {
        this.sizeMargin = margin;
    }

    public void setRealSize(Dimension d) {
        if (this.sizeMargin > 0) {
            d.width += this.sizeMargin;
            d.height += this.sizeMargin;
        }
        this.setPreferredSize(d);
        this.setMaximumSize(d);
        this.revalidate();
    }

    public void setRealSize(int dx, int dy) {
        this.setRealSize(new Dimension(dx, dy));
    }

    public Dimension getRealSize() {
        return this.getPreferredSize();
    }

    public void autoAdjustSize() {
        if (this.rootElement == null || !this.autoAdjustSize) {
            return;
        }
        Rect bounds = this.rootElement.bounds();
        this.setRealSize((int)((float)(bounds.r.x + bounds.r.width) * this.zoom), (int)((float)(bounds.r.y + bounds.r.height) * this.zoom));
        if (this.delegate != null) {
            this.delegate.viewSizeDidChange();
        }
    }

    public void centerAll() {
        if (this.rootElement == null) {
            return;
        }
        Dimension d = this.getRealSize();
        if (d.width == 0 && d.height == 0) {
            d = this.getPreferredSize();
        }
        Rectangle r = this.rootElement.bounds().rectangle();
        double x = (double)(d.width - r.width) * 0.5;
        double y = (double)(d.height - r.height) * 0.5;
        this.rootElement.move(x - (double)r.x, y - (double)r.y);
    }

    public void setMagneticsVisible(boolean flag) {
        this.magneticsVisible = flag;
        this.repaint();
    }

    public boolean isMagneticsVisible() {
        return this.magneticsVisible;
    }

    public void toggleShowMagnetics() {
        this.setMagneticsVisible(!this.isMagneticsVisible());
    }

    public void createMagnetics() {
        int i;
        this.magnetics.clear();
        double f = 0.0;
        for (i = 0; i < this.delegate.getHorizontalMagnetics(); ++i) {
            this.magnetics.add(GMagnetic.createHorizontal(f += 1.0 / (double)(this.delegate.getHorizontalMagnetics() + 1)));
        }
        f = 0.0;
        for (i = 0; i < this.delegate.getVerticalMagnetics(); ++i) {
            this.magnetics.add(GMagnetic.createVertical(f += 1.0 / (double)(this.delegate.getVerticalMagnetics() + 1)));
        }
    }

    public void showAndAjustPositionToMagnetics(Vector2D position) {
        for (GMagnetic magnetic : this.magnetics) {
            magnetic.showAndAjust(position, this.getRealSize());
        }
    }

    public void hideAllMagnetics() {
        for (GMagnetic magnetic : this.magnetics) {
            magnetic.setVisible(false);
        }
    }

    public void scrollElementToVisible(GElement element) {
        Rect frame = element.getFrame();
        Rectangle r = frame == null ? new Rectangle((int)element.getPositionX(), (int)element.getPositionY(), 1, 1) : frame.r;
        r.x = (int)((float)r.x * this.zoom);
        r.y = (int)((float)r.y * this.zoom);
        r.width = (int)((float)r.width * this.zoom);
        r.height = (int)((float)r.height * this.zoom);
        r.x -= 10;
        r.y -= 10;
        r.width += 20;
        r.height += 20;
        this.scrollRectToVisible(r);
    }

    public void addSelectedElement(GElement element) {
        this.selectionTimer.add(element);
    }

    public void removeSelectedElement(GElement element) {
        this.selectionTimer.remove(element);
    }

    public void addFocusedElement(GElement element) {
        this.focusTimer.add(element);
    }

    public void removeFocusedElement(GElement element) {
        this.focusTimer.remove(element);
    }

    public BufferedImage getImage() {
        int width = this.getPreferredSize().width;
        int height = this.getPreferredSize().height;
        BufferedImage image = new BufferedImage(width, height, 5);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        super.paintComponent(g2d);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
        this.rootElement.drawRecursive(g2d);
        g2d.dispose();
        return image;
    }

    public String getEPS() {
        XJGraphics2DPS g2d = new XJGraphics2DPS();
        g2d.setMargins(6, 6);
        this.rootElement.drawRecursive(g2d);
        return g2d.getPSText();
    }

    public Image makeColorTransparent(Image im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            public int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public void drawMagnetics(Graphics2D g2d) {
        g2d.setColor(Color.yellow);
        for (GMagnetic magnetic : this.magnetics) {
            if (!this.magneticsVisible && !magnetic.isVisible()) continue;
            magnetic.draw(g2d, this.getRealSize());
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.smoothGraphics) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.drawBorder) {
            g2d.setColor(Color.white);
            g2d.fillRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
            g2d.setColor(Color.darkGray);
            g2d.drawRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
            g2d.clipRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
        }
        g2d.scale(this.zoom, this.zoom);
        this.drawMagnetics(g2d);
        if (this.rootElement != null) {
            this.rootElement.drawRecursive(g2d);
        }
        this.eventManager.performEventObjects(1, null, null, g);
    }

    public void addMenuItem(JPopupMenu menu, String title, int tag, Object object) {
        XJMenuItem item = new XJMenuItem();
        item.setTitle(title);
        item.setTag(tag);
        item.setObject(object);
        item.setDelegate(this);
        menu.add(item.getSwingComponent());
    }

    public JPopupMenu getContextualMenu(GElement element) {
        return null;
    }

    public List<GElement> getSelectedElements() {
        return this.selectionTimer.getElements();
    }

    public GElement getElementAtMousePosition(MouseEvent e) {
        return this.getElementAtPoint(this.getMousePosition(e));
    }

    public GElement getElementAtPoint(Point p) {
        if (this.rootElement != null) {
            return this.rootElement.match(p);
        }
        return null;
    }

    public void changeDone() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.changeOccured();
    }

    public void selectElementsInRect(int x, int y, int dx, int dy) {
        Rect rectangle = new Rect(x, y, (double)dx, (double)dy);
        if (this.rootElement == null || this.rootElement.getElements() == null) {
            return;
        }
        for (GElement element : this.rootElement.getElements()) {
            boolean selected = Rect.intersect(rectangle, element.bounds());
            element.setSelected(selected);
            if (selected) {
                this.addSelectedElement(element);
                continue;
            }
            this.removeSelectedElement(element);
        }
    }

    public void selectAllElements(boolean select) {
        if (this.rootElement == null) {
            return;
        }
        for (GElement element : this.rootElement.getElements()) {
            element.setSelected(select);
            if (select) {
                this.addSelectedElement(element);
                continue;
            }
            this.removeSelectedElement(element);
        }
    }

    public void moveSelectedElements(double dx, double dy) {
        for (GElement element : this.selectionTimer.getElements()) {
            element.move(dx, dy);
        }
        this.autoAdjustSize();
    }

    @Override
    public void timerFired(GTimer timer) {
        if (timer == this.selectionTimer) {
            this.selectionAlphaVariator.run();
        } else if (timer == this.focusTimer) {
            this.focusAlphaVariator.run();
        }
        this.repaint();
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu menu = this.getContextualMenu(this.getElementAtPoint(this.getMousePosition(e)));
            if (menu != null) {
                this.requestFocus();
                menu.show(this, e.getX(), e.getY());
                this.lastMousePosition = this.getMousePosition(e);
            }
        } else {
            super.processMouseEvent(e);
        }
    }

    @Override
    public void handleMousePressed(MouseEvent e) {
        this.eventManager.performEventObjects(2, e, this.getMousePosition(e), null);
    }

    @Override
    public void handleMouseReleased(MouseEvent e) {
        this.eventManager.performEventObjects(3, e, this.getMousePosition(e), null);
    }

    @Override
    public void handleMouseDragged(MouseEvent e) {
        this.eventManager.performEventObjects(4, e, this.getMousePosition(e), null);
    }

    @Override
    public void handleMouseMoved(MouseEvent e) {
        this.eventManager.performEventObjects(5, e, this.getMousePosition(e), null);
        if (this.delegate != null) {
            this.delegate.contextualHelp(this.getElementAtPoint(this.getMousePosition(e)));
        }
    }

    @Override
    public void handleMouseEntered(MouseEvent e) {
        this.selectionTimer.refresh();
        this.focusTimer.refresh();
    }

    @Override
    public void handleMouseExited(MouseEvent e) {
        this.selectionTimer.stop();
        this.focusTimer.stop();
    }

    @Override
    public void handleMenuEvent(XJMenu menu, XJMenuItem item) {
    }

    @Override
    public void eventChangeDone() {
        this.autoAdjustSize();
        this.changeDone();
    }

    @Override
    public void eventShouldRepaint() {
        this.repaint();
    }

    @Override
    public GElement eventQueryElementAtPoint(Point p) {
        return this.getElementAtPoint(p);
    }

    @Override
    public GElement eventQueryRootElement() {
        return this.rootElement;
    }

    @Override
    public void eventSouldSelectAllElements(boolean flag) {
        this.selectAllElements(flag);
    }

    @Override
    public void eventMoveSelectedElements(int dx, int dy) {
        this.moveSelectedElements(dx, dy);
    }

    @Override
    public void eventCreateElement(Point p, boolean doubleclick) {
    }

    @Override
    public void eventEditElement(GElement e) {
    }

    @Override
    public boolean eventCanCreateLink() {
        return false;
    }

    @Override
    public double eventLinkFlateness() {
        return 40.0;
    }

    @Override
    public void eventCreateLink(GElement source, String sourceAnchorKey, GElement target, String targetAnchorKey, int shape, Point p) {
        this.rootElement.addElement(new GLink(source, sourceAnchorKey, target, targetAnchorKey, shape, "", p, 40.0));
    }

    @Override
    public void eventSelectElementsInRect(int x, int y, int dx, int dy) {
        this.selectElementsInRect(x, y, dx, dy);
    }

    @Override
    public void eventAddFocusedElement(GElement element) {
        this.addFocusedElement(element);
    }

    @Override
    public void eventRemoveFocusedElement(GElement element) {
        this.removeFocusedElement(element);
    }

    @Override
    public boolean eventIsSelectedElement(GElement element) {
        return this.selectionTimer.contains(element);
    }

    public class MyContextualMenuListener
    implements PopupMenuListener {
        public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
            GView.this.repaint();
        }

        public void popupMenuCanceled(PopupMenuEvent event) {
        }
    }
}

