/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.base;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;

public class Path2D {
    private List<Vector2D> points = new ArrayList<Vector2D>();

    public void clear() {
        this.points.clear();
    }

    public void add(Vector2D v) {
        this.points.add(v);
    }

    public void add(double x, double y) {
        this.add(new Vector2D(x, y));
    }

    public void draw(Graphics g) {
        Vector2D lastV = null;
        for (Vector2D v : this.points) {
            if (lastV != null) {
                g.drawLine((int)lastV.getX(), (int)lastV.getY(), (int)v.getX(), (int)v.getY());
            }
            lastV = v;
        }
    }

    public boolean contains(double x, double y) {
        Vector2D oldv = null;
        for (Vector2D v : this.points) {
            if (oldv != null) {
                Rect r = new Rect(oldv, v);
                r.inset(-4.0);
                if (r.contains(x, y)) {
                    return true;
                }
            }
            oldv = v;
        }
        return false;
    }

    public Vector2D getEndDirection() {
        if (this.points.size() < 2) {
            return null;
        }
        Vector2D v1 = this.points.get(this.points.size() - 2);
        Vector2D v2 = this.points.get(this.points.size() - 1);
        return v1.sub(v2);
    }
}

