/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.shape;

import java.awt.Graphics;
import java.awt.Graphics2D;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.shape.SLinkArc;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class SLinkBezier
extends SLinkArc
implements XJXMLSerializable {
    protected Vector2D[] controlPointsAbs;
    protected Vector2D labelPositionAbs;
    protected Vector2D[] controlPointsRel;
    protected Vector2D labelPositionRel;
    protected Vector2D oldStart;
    protected Vector2D oldEnd;
    protected Vector2D originalEndPointOffset;
    protected double originalZLength;
    protected double x0 = 0.0;
    protected double y0 = 0.0;
    protected double x1 = 0.0;
    protected double y1 = 0.0;
    protected static final int MODE_END = 1;
    protected static final int MODE_NOSTRETCH = 0;
    protected static final int MODE_STRETCH = -1;

    public void setControlPoints(Vector2D[] points) {
        this.controlPointsAbs = points;
        this.resetFrame();
        for (int i = 0; i < points.length; ++i) {
            this.updateFrame(points[i]);
        }
    }

    public void setLabelPosition(Vector2D position) {
        this.labelPositionAbs = position;
    }

    public Rect getFrame() {
        return new Rect(this.x0, this.y0, this.x1 - this.x0, this.y1 - this.y0);
    }

    public boolean contains(double x, double y) {
        return false;
    }

    public Vector2D absToRel(Vector2D p) {
        if (this.selfLoop) {
            return p.sub(this.start);
        }
        Vector2D z = this.end.sub(this.start);
        Vector2D a = p.sub(this.start);
        double lb = a.dot(z) / z.length();
        Vector2D b = z.normalize().setLength(lb);
        Vector2D c = a.sub(b);
        double lc = c.length() * (double)a.crossSign(z);
        return new Vector2D(lb, lc);
    }

    public Vector2D relToAbs(Vector2D p, int mode) {
        if (this.selfLoop) {
            return this.start.add(p);
        }
        Vector2D nz = this.end.sub(this.start);
        double f = nz.length() / this.originalZLength;
        double lb = p.getX();
        double lc = p.getY();
        if (mode == 1) {
            return this.end.add(this.originalEndPointOffset);
        }
        if (mode == 0) {
            f = 1.0;
        }
        Vector2D nb = nz.normalize().setLength(f * lb);
        Vector2D nc = nz.copy().rotate(-90.0).normalize().setLength(lc);
        return this.start.add(nb.add(nc));
    }

    public void update() {
        int max = this.controlPointsAbs.length;
        if (this.controlPointsRel == null) {
            this.controlPointsRel = new Vector2D[this.controlPointsAbs.length];
            for (int i = 0; i < max; ++i) {
                this.controlPointsRel[i] = this.absToRel(this.controlPointsAbs[i]);
            }
            if (this.labelPositionAbs != null) {
                this.labelPositionRel = this.absToRel(this.labelPositionAbs);
            }
            this.originalEndPointOffset = this.controlPointsAbs[max - 1].sub(this.end);
            this.originalZLength = this.end.sub(this.start).length();
        } else if (!this.oldStart.equals(this.start) || !this.oldEnd.equals(this.end)) {
            this.resetFrame();
            for (int i = 0; i < max; ++i) {
                this.controlPointsAbs[i] = this.relToAbs(this.controlPointsRel[i], i == 0 ? 0 : (i == max - 1 ? 1 : -1));
                this.updateFrame(this.controlPointsAbs[i]);
            }
            if (this.labelPositionRel != null) {
                this.labelPositionAbs = this.relToAbs(this.labelPositionRel, -1);
            }
        }
        this.oldStart = this.start;
        this.oldEnd = this.end;
    }

    public void draw(Graphics2D g) {
        this.drawShape(g);
    }

    public void drawShape(Graphics2D g) {
        if (this.controlPointsAbs != null) {
            this.bspline(g);
        }
        if (this.labelPositionAbs != null) {
            this.label.setPosition(this.labelPositionAbs.getX(), this.labelPositionAbs.getY());
            this.label.draw(g);
        }
    }

    public void lines(Graphics g) {
        g.setColor(this.color);
        for (int i = 0; i < this.controlPointsAbs.length; ++i) {
            Vector2D pt = this.controlPointsAbs[i];
            double x = pt.x;
            double y = pt.y;
            g.fillRect((int)(x - 2.0), (int)(y - 2.0), 4, 4);
        }
    }

    public void bspline(Graphics g) {
        g.setColor(this.color);
        int n = this.controlPointsAbs.length;
        double x = 0.0;
        double y = 0.0;
        double time_delta = 0.1;
        boolean first = true;
        double fx = 0.0;
        double fy = 0.0;
        for (int i = 1; i < n - 2; ++i) {
            Vector2D p0 = this.controlPointsAbs[i - 1];
            Vector2D p1 = this.controlPointsAbs[i];
            Vector2D p2 = this.controlPointsAbs[i + 1];
            Vector2D p3 = this.controlPointsAbs[i + 2];
            double xA = p0.x;
            double xB = p1.x;
            double xC = p2.x;
            double xD = p3.x;
            double yA = p0.y;
            double yB = p1.y;
            double yC = p2.y;
            double yD = p3.y;
            double a3 = (-xA + 3.0 * (xB - xC) + xD) / 6.0;
            double b3 = (-yA + 3.0 * (yB - yC) + yD) / 6.0;
            double a2 = (xA - 2.0 * xB + xC) / 2.0;
            double b2 = (yA - 2.0 * yB + yC) / 2.0;
            double a1 = (xC - xA) / 2.0;
            double b1 = (yC - yA) / 2.0;
            double a0 = (xA + 4.0 * xB + xC) / 6.0;
            double b0 = (yA + 4.0 * yB + yC) / 6.0;
            for (double t = 0.0; t <= 1.0; t += time_delta) {
                double x0 = x;
                double y0 = y;
                double x1 = ((a3 * t + a2) * t + a1) * t + a0;
                double y1 = ((b3 * t + b2) * t + b1) * t + b0;
                x = (int)Math.round(x1);
                y = (int)Math.round(y1);
                if (first) {
                    first = false;
                    fx = x;
                    fy = y;
                    continue;
                }
                g.drawLine((int)x0, (int)y0, (int)x, (int)y);
            }
        }
        Vector2D p0 = this.controlPointsAbs[0];
        g.drawLine((int)p0.getX(), (int)p0.getY(), (int)fx, (int)fy);
        Vector2D p1 = this.controlPointsAbs[n - 1];
        g.drawLine((int)x, (int)y, (int)p1.getX(), (int)p1.getY());
        this.arrow.setAnchor(p1.getX(), p1.getY());
        this.arrow.setDirection(new Vector2D(x - p1.getX(), y - p1.getY()));
        this.arrow.draw(g);
    }

    private void resetFrame() {
        if (this.start != null && this.end != null) {
            this.x0 = Math.min(this.start.x, this.end.x);
            this.y0 = Math.min(this.start.y, this.end.y);
            this.x1 = Math.max(this.start.x, this.end.x);
            this.y1 = Math.max(this.start.y, this.end.y);
        } else {
            this.x0 = 2.147483647E9;
            this.y0 = 2.147483647E9;
            this.x1 = -2.147483648E9;
            this.y1 = -2.147483648E9;
        }
    }

    private void updateFrame(Vector2D point) {
        this.updateFrame(point.x, point.y);
    }

    private void updateFrame(double x, double y) {
        this.x0 = Math.min(this.x0, x);
        this.y0 = Math.min(this.y0, y);
        this.x1 = Math.max(this.x1, x);
        this.y1 = Math.max(this.y1, y);
    }
}

