/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.shape;

import org.antlr.xjlib.appkit.gview.base.Path2D;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.shape.SLinkElbow;

public class SLinkElbowTopBottom {
    public static final int TOP_BOTTOM = 0;
    public static final int BOTTOM_TOP = 1;
    public static final int LABEL_OFFSET = 10;
    public SLinkElbow link = null;
    public Path2D path = null;

    public SLinkElbowTopBottom(SLinkElbow link) {
        this.link = link;
    }

    public void updateTopBottom() {
        this.path = this.link.path;
        if (this.link.getStartWithOffset().getY() > this.link.getEndWithOffset().getY()) {
            this.buildVerticalPath();
        } else if (Math.abs(this.link.end.x - this.link.start.x) >= 50.0) {
            this.buildHorizontalPath();
        } else {
            this.buildHorizontalRightPath(0);
        }
    }

    public void updateBottomTop() {
        this.path = this.link.path;
        if (this.link.getStartWithOffset().getY() <= this.link.getEndWithOffset().getY()) {
            this.buildVerticalPath();
        } else if (Math.abs(this.link.end.x - this.link.start.x) >= 50.0) {
            this.buildHorizontalPath();
        } else {
            this.buildHorizontalRightPath(1);
        }
    }

    public void buildVerticalPath() {
        Vector2D start_ = this.link.getStartWithOffset();
        Vector2D end_ = this.link.getEndWithOffset();
        Vector2D ab = end_.sub(start_);
        Vector2D p1 = start_.add(new Vector2D(0.0, ab.getY() * 0.5));
        Vector2D p2 = p1.add(new Vector2D(ab.getX(), 0.0));
        Vector2D p3 = p2.add(new Vector2D(0.0, ab.getY() * 0.5));
        this.path.add(this.link.start);
        this.path.add(start_);
        this.path.add(p1);
        this.path.add(p2);
        this.path.add(p3);
        this.path.add(end_);
        this.path.add(this.link.end);
        this.link.label.setPosition(p1.add(p2.sub(p1).stretch(0.5)).shift(0.0, -10.0));
    }

    public void buildHorizontalPath() {
        Vector2D start_ = this.link.getStartWithOffset();
        Vector2D end_ = this.link.getEndWithOffset();
        Vector2D ab = end_.sub(start_);
        Vector2D p1 = start_.add(new Vector2D(ab.getX() * 0.5, 0.0));
        Vector2D p2 = p1.add(new Vector2D(0.0, ab.getY()));
        Vector2D p3 = p2.add(new Vector2D(ab.getX() * 0.5, 0.0));
        this.path.add(this.link.start);
        this.path.add(start_);
        this.path.add(p1);
        this.path.add(p2);
        this.path.add(p3);
        this.path.add(end_);
        this.path.add(this.link.end);
        this.link.label.setPosition(p1.add(p2.sub(p1).stretch(0.5)).shift(10.0, 0.0));
    }

    public void buildHorizontalRightPath(int direction) {
        double start_box_right_edge;
        double end_box_right_edge;
        Vector2D start_ = this.link.getStartWithOffset();
        Vector2D end_ = this.link.getEndWithOffset();
        Vector2D start = this.link.start;
        Vector2D end = this.link.end;
        double farest_x = Math.max(start_.x, end_.x) + 40.0;
        if (direction == 1) {
            if (start_.y < end.y + 40.0 + (double)this.link.outOffsetLength && start_.x <= (end_box_right_edge = end.x + 20.0) + 5.0) {
                start_.y = end.y + 40.0 + (double)this.link.outOffsetLength;
            }
            if (end_.y > start.y - 40.0 - (double)this.link.outOffsetLength && end_.x <= (start_box_right_edge = start.x + 20.0) + 5.0) {
                end_.y = start.y - 40.0 - (double)this.link.outOffsetLength;
            }
        } else if (direction == 0) {
            if (start_.y > end.y - 40.0 - (double)this.link.outOffsetLength && start_.x <= (end_box_right_edge = end.x + 20.0) + 5.0) {
                start_.y = end.y - 40.0 - (double)this.link.outOffsetLength;
            }
            if (end_.y < start.y + 40.0 + (double)this.link.outOffsetLength && end_.x <= (start_box_right_edge = start.x + 20.0) + 5.0) {
                end_.y = start.y + 40.0 + (double)this.link.outOffsetLength;
            }
        }
        Vector2D p1 = start_.add(new Vector2D(farest_x - start.x, 0.0));
        Vector2D p2 = end_.add(new Vector2D(farest_x - end.x, 0.0));
        this.path.add(start);
        this.path.add(start_);
        this.path.add(p1);
        this.path.add(p2);
        this.path.add(end_);
        this.path.add(end);
        this.link.label.setPosition(p1.add(p2.sub(p1).stretch(0.5)).shift(10.0, 0.0));
    }
}

