/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.menu;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemSeparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJMenu
extends XJMenuItem {
    protected JMenu jMenu = new JMenu();
    protected List<XJMenuItem> items = new ArrayList<XJMenuItem>();
    protected XJMainMenuBar mainMenuBar;

    public XJMenu() {
        this.jMenu.addMenuListener(new XJMenuListener());
    }

    public void setMainMenuBar(XJMainMenuBar mainMenuBar) {
        this.mainMenuBar = mainMenuBar;
        for (int index = 0; index < this.items.size(); ++index) {
            XJMenuItem item = this.items.get(index);
            if (!(item instanceof XJMenu)) continue;
            XJMenu menu = (XJMenu)item;
            menu.setMainMenuBar(mainMenuBar);
        }
    }

    @Override
    public void setTitle(String title) {
        this.jMenu.setText(title);
    }

    public void addSeparator() {
        this.items.add(new XJMenuItemSeparator());
        this.jMenu.addSeparator();
    }

    public void addItem(XJMenuItem item) {
        item.setMenu(this);
        this.items.add(item);
        this.jMenu.add(item.getSwingComponent());
    }

    public void addItem(XJMenu menu) {
        menu.setMenu(this);
        this.items.add(menu);
        this.jMenu.add(menu.getSwingComponent());
    }

    public void insertSeparatorBefore(int menuItemTag) {
        XJMenuItem menuItem = this.getItemForTag(menuItemTag);
        if (menuItem == null) {
            return;
        }
        this.insertSeparatorAtIndex(this.items.indexOf(menuItem));
    }

    public void insertSeparatorAfter(int menuItemTag) {
        XJMenuItem menuItem = this.getItemForTag(menuItemTag);
        if (menuItem == null) {
            return;
        }
        this.insertSeparatorAtIndex(this.items.indexOf(menuItem) + 1);
    }

    public void insertSeparatorAtIndex(int index) {
        this.items.add(index, new XJMenuItemSeparator());
        this.jMenu.insertSeparator(index);
    }

    public void insertItemBefore(XJMenuItem item, int menuItemTag) {
        XJMenuItem menuItem = this.getItemForTag(menuItemTag);
        if (menuItem == null) {
            return;
        }
        this.insertItemAtIndex(item, this.items.indexOf(menuItem));
    }

    public void insertItemAfter(XJMenuItem item, int menuItemTag) {
        XJMenuItem menuItem = this.getItemForTag(menuItemTag);
        if (menuItem == null) {
            return;
        }
        this.insertItemAtIndex(item, this.items.indexOf(menuItem) + 1);
    }

    public void insertItemAtIndex(XJMenuItem item, int index) {
        this.items.add(index, item);
        this.jMenu.add((Component)item.getSwingComponent(), index);
    }

    public void removeItem(int index) {
        this.jMenu.remove(index);
    }

    public XJMenuItem getItemForTag(int tag) {
        for (XJMenuItem menuItem : this.items) {
            if (menuItem.getTag() != tag) continue;
            return menuItem;
        }
        return null;
    }

    public XJMenuItem getItemAtIndex(int index) {
        if (index >= 0 && index < this.items.size()) {
            return this.items.get(index);
        }
        return null;
    }

    public int getItemCount() {
        return this.jMenu.getItemCount();
    }

    public Iterator<XJMenuItem> itemIterator() {
        return this.items.iterator();
    }

    public void clear() {
        this.items.clear();
        this.jMenu.removeAll();
    }

    @Override
    public JComponent getSwingComponent() {
        return this.jMenu;
    }

    public class XJMenuListener
    implements MenuListener {
        public void menuSelected(MenuEvent e) {
            if (XJMenu.this.mainMenuBar != null) {
                XJMenu.this.mainMenuBar.menuSelected(XJMenu.this);
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }
}

