/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.LinkedList;
import utils.Printer;

public class ErrorList {
    private static int lexer_errors = 0;
    private static int parser_errors = 0;
    private static LinkedList<String> errors = new LinkedList();
    private static LinkedList<String> warnings = new LinkedList();

    public static void incLexerErrorCounter() {
        ++lexer_errors;
    }

    public static void incParserErrorCounter() {
        ++parser_errors;
    }

    public static void addWarning(String msg) {
        warnings.add(msg);
    }

    public static void addError(String msg) {
        errors.add(msg);
    }

    public static void print() {
        if (lexer_errors + parser_errors > 0) {
            Printer.printLine();
            Printer.print("", 0);
            Printer.print("Errors during parsing: " + (lexer_errors + parser_errors), 0);
            Printer.print("", 0);
        }
        if (ErrorList.errorCount() > 0) {
            Printer.print("Other errors (" + ErrorList.errorCount() + "): ", 0);
            for (String msg : errors) {
                Printer.print(msg, 1);
            }
            Printer.print("", 0);
        }
        if (ErrorList.warningCount() > 0) {
            Printer.print("Warnings (" + ErrorList.warningCount() + "): ", 0);
            for (String msg : warnings) {
                Printer.print(msg, 1);
            }
        }
    }

    public static int warningCount() {
        return warnings.size();
    }

    public static int errorCount() {
        return errors.size() + lexer_errors + parser_errors;
    }
}

