/*
 * Decompiled with CFR 0.152.
 */
package tokens;

import java.io.PrintWriter;
import org.antlr.runtime.Token;
import parser.ErrorList;
import tokens.InstructionList;
import tokens.Program;
import tokens.TokenPosition;
import tokens.Variable;
import tokens.datastructures.ConstantCollection;
import tokens.eccToken;
import tokens.instructions.InstructionMACRO;
import tokens.instructions.InstructionSpecification;
import tokens.instructions.InstructionUSE;
import tokens.instructions.InstructionWithFetch;
import tokens.instructions.InstructionWithParameter;
import tokens.instructions.InstructionWithoutParameter;
import utils.Printer;

public class Instruction
extends eccToken {
    private TokenPosition position;
    private Type type;
    private InstructionSpecification specification;
    private boolean hideUSE = false;
    private InstructionList list;
    private int romID;

    public Instruction() {
        this.type = Type.MACRO;
        this.romID = ConstantCollection.PROGRAM_ROMS - 1;
        this.specification = new InstructionMACRO();
    }

    public Instruction(Type type, int romID, InstructionSpecification specification) {
        this.type = type;
        this.romID = romID;
        this.specification = specification;
    }

    public Instruction(Token type, Variable variable) {
        this.type = Type.valueOf(type.getText());
        this.romID = ConstantCollection.PROGRAM_ROMS - 1;
        this.position = new TokenPosition(type);
        this.specification = new InstructionWithFetch(this.type, variable);
    }

    public Instruction(Token type, Token parameter) {
        this.type = Type.valueOf(type.getText());
        this.romID = ConstantCollection.PROGRAM_ROMS - 1;
        this.position = new TokenPosition(type);
        this.specification = new InstructionWithParameter(this.type, parameter);
    }

    public Instruction(Token type) {
        this.type = Type.valueOf(type.getText());
        this.romID = ConstantCollection.PROGRAM_ROMS - 1;
        this.position = new TokenPosition(type);
        this.specification = new InstructionWithoutParameter(this.type);
    }

    public Instruction(Type type, Token u01, Token u02, Token u03, Token u04, Token u05, Token u06, Token u07, Token u08, Token u09, Token u10, Token u11, Token u12, Token u13, Token u14, Token u15, Token u16) {
        this.type = type;
        this.romID = ConstantCollection.PROGRAM_ROMS - 1;
        this.specification = u05 == null ? new InstructionUSE(u01, u02, u03, u04) : (u09 == null ? new InstructionUSE(u01, u02, u03, u04, u05, u06, u07, u08) : (u13 == null ? new InstructionUSE(u01, u02, u03, u04, u05, u06, u07, u08, u09, u10, u11, u12) : new InstructionUSE(u01, u02, u03, u04, u05, u06, u07, u08, u09, u10, u11, u12, u13, u14, u15, u16)));
    }

    public void setMacro(Token name, Token parameter0) {
        ((InstructionMACRO)this.specification).define(name, parameter0);
    }

    public void addMacroParameter(Token parameter) {
        ((InstructionMACRO)this.specification).addParameter(parameter);
    }

    public boolean isMacro() {
        return this.specification instanceof InstructionMACRO;
    }

    public void hideUse() {
        if (this.specification instanceof InstructionUSE) {
            this.hideUSE = true;
        } else if (this.specification instanceof InstructionMACRO) {
            ((InstructionMACRO)this.specification).hideUse();
        }
    }

    public boolean isUse() {
        return this.specification instanceof InstructionUSE;
    }

    public void setList(InstructionList list) {
        if (this.specification instanceof InstructionWithFetch) {
            InstructionWithFetch tmp = (InstructionWithFetch)this.specification;
            if (tmp.getVariable() != null) {
                list.updateVariable(tmp.getVariable());
            } else if (list.getCurrentVariable() == null) {
                ErrorList.addError("@" + this.position + " - no FETCH adress given!");
            } else {
                tmp.setVariable(list.getCurrentVariable());
            }
        } else if (this.specification instanceof InstructionUSE) {
            ((InstructionUSE)this.specification).setInstructionList(list);
        } else if (this.specification instanceof InstructionMACRO) {
            ((InstructionMACRO)this.specification).setInstructionList(list);
        }
        this.list = list;
    }

    @Override
    public void printCode() {
        Printer.print(this.toString(), 1);
    }

    public void check() {
        this.specification.check();
    }

    public InstructionSpecification getSpecification() {
        return this.specification;
    }

    public void resolveMacro(Program program) {
        if (this.hideUSE) {
            this.list.increaseLength(-1);
            if (this.romID == 0) {
                --ConstantCollection.PROGRAM_SIZE0;
            } else {
                --ConstantCollection.PROGRAM_SIZE1;
            }
        }
        if (this.specification instanceof InstructionMACRO) {
            ((InstructionMACRO)this.specification).resolveMacro(program);
        } else if (this.specification instanceof InstructionUSE) {
            ((InstructionUSE)this.specification).registerUsage();
        }
    }

    public void prepareForWriting(Program program) {
        if (this.specification instanceof InstructionUSE) {
            ((InstructionUSE)this.specification).prepareForWriting();
        } else if (this.specification instanceof InstructionMACRO) {
            ((InstructionMACRO)this.specification).prepareForWriting(program);
        } else if (this.specification instanceof InstructionUSE) {
            ((InstructionMACRO)this.specification).prepareForWriting(program);
        }
    }

    @Override
    public void writeVHDLCode(PrintWriter writer, boolean last) {
        if (this.hideUSE && ConstantCollection.V2 == 0) {
            writer.println("--  I_SETBA  & \"000000\",");
        } else if (this.hideUSE) {
            writer.println("--  I_MPS    & \"000000\",");
        } else {
            this.specification.writeVHDLCode(writer, last);
        }
    }

    public String toString() {
        if (this.hideUSE) {
            return "--SETBA ";
        }
        String s = this.type.name();
        while (s.length() < 6) {
            s = String.valueOf(s) + " ";
        }
        if (this.specification != null) {
            return this.specification.toString();
        }
        return s;
    }

    public static enum Type {
        NOP,
        ROL32,
        BUFALU,
        BUF,
        RSTL,
        RST,
        SETSGN,
        WR,
        WRROR,
        FLC,
        ADD,
        SUB,
        ADDC,
        SUBC,
        ADDAE,
        SUBAE,
        SUBCC,
        SUBH,
        CALL,
        CMPI,
        CMPD,
        CMPSP,
        REPEAT,
        ROL24,
        SUBACC,
        SUBIAC,
        RET,
        SWAP0,
        SWAP1,
        SWAPLC,
        LDCOMB,
        SKIPB,
        INCLC,
        DECLC,
        MUL,
        MULNEG,
        MUL256,
        HLT,
        SAVEC,
        SAVECI,
        SAVECX,
        SAVEOF,
        UPDOF,
        RED,
        REDC,
        AND,
        OR,
        XOR,
        INCBA,
        DECBA,
        ROR8,
        ROL8,
        ROL16,
        ROR24,
        ROR30,
        ROR2,
        ROL7,
        ROL9,
        ROL13,
        ROL18,
        USE,
        MACRO;

    }
}

