/*
 * Decompiled with CFR 0.152.
 */
package tokens;

import java.io.PrintWriter;
import java.util.LinkedList;
import tokens.Instruction;
import tokens.Program;
import tokens.Variable;
import tokens.eccToken;

public class InstructionList
extends eccToken {
    private Program program;
    private String name;
    private LinkedList<Instruction> list = new LinkedList();
    private Variable current_variable;
    private int additionalLength = 0;

    public void addInstruction(Instruction instruction) {
        this.list.add(instruction);
        instruction.setList(this);
        if (instruction.isMacro()) {
            ++this.additionalLength;
        }
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void updateVariable(Variable variable) {
        this.current_variable = variable;
    }

    public Variable getCurrentVariable() {
        return this.current_variable;
    }

    public int size() {
        return this.list.size() + this.additionalLength;
    }

    public void increaseLength(int size) {
        this.additionalLength += size;
        this.program.moveOffset(this.name, size);
    }

    public boolean removeFirstUse() {
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get(i).isUse() || this.list.get(i).isMacro()) {
                this.list.get(i).hideUse();
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void printCode() {
        for (Instruction instruction : this.list) {
            instruction.printCode();
        }
    }

    public void check() {
        for (Instruction instruction : this.list) {
            instruction.check();
        }
    }

    public void resolveMacros() {
        int i = 0;
        while (i < this.list.size()) {
            Instruction current = this.list.get(i);
            if (current.isMacro() || current.isUse()) {
                current.resolveMacro(this.program);
            }
            ++i;
        }
    }

    public void prepareForWriting() {
        for (Instruction instruction : this.list) {
            instruction.prepareForWriting(this.program);
        }
    }

    @Override
    public void writeVHDLCode(PrintWriter writer, boolean last) {
        int i = 0;
        while (i < this.list.size()) {
            this.list.get(i).writeVHDLCode(writer, last && i == this.list.size() - 1);
            ++i;
        }
    }
}

