/*
 * Decompiled with CFR 0.152.
 */
package tokens;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.LinkedList;
import org.antlr.runtime.Token;
import parser.ErrorList;
import tokens.Instruction;
import tokens.InstructionList;
import tokens.TokenPosition;
import tokens.Variable;
import tokens.datastructures.ALUConstants;
import tokens.datastructures.CallTargets;
import tokens.datastructures.Constant;
import tokens.datastructures.ConstantCollection;
import tokens.datastructures.Macro;
import tokens.datastructures.Registers;
import tokens.instructions.InstructionWithFetch;
import utils.Converter;
import utils.Printer;

public class Program {
    private LinkedList<String> registers = new LinkedList();
    private LinkedList<Constant> constants = new LinkedList();
    private LinkedList<Parameter> parameters = new LinkedList();
    private LinkedList<Function> functions0 = new LinkedList();
    private LinkedList<Function> functions1 = new LinkedList();
    private int romIndex = 0;
    private LinkedList<Macro> macros = new LinkedList();
    private boolean hasRemovedFirstUse = false;

    public void addMacro(Token name, Token parameterCount, Token callTarget, Token u01, Token u02, Token u03, Token u04, Token u05, Token u06, Token u07, Token u08, Token u09, Token u10, Token u11, Token u12, Token u13, Token u14, Token u15, Token u16) {
        Macro macro = new Macro(name.getText(), callTarget);
        if (u01 != null) {
            macro.addParameter(u01);
        }
        if (u02 != null) {
            macro.addParameter(u02);
        }
        if (u03 != null) {
            macro.addParameter(u03);
        }
        if (u04 != null) {
            macro.addParameter(u04);
        }
        if (u05 != null) {
            macro.addParameter(u05);
        }
        if (u06 != null) {
            macro.addParameter(u06);
        }
        if (u07 != null) {
            macro.addParameter(u07);
        }
        if (u08 != null) {
            macro.addParameter(u08);
        }
        if (u09 != null) {
            macro.addParameter(u09);
        }
        if (u10 != null) {
            macro.addParameter(u10);
        }
        if (u11 != null) {
            macro.addParameter(u11);
        }
        if (u12 != null) {
            macro.addParameter(u12);
        }
        if (u13 != null) {
            macro.addParameter(u13);
        }
        if (u14 != null) {
            macro.addParameter(u14);
        }
        if (u15 != null) {
            macro.addParameter(u15);
        }
        if (u16 != null) {
            macro.addParameter(u16);
        }
        this.macros.add(macro);
    }

    public Macro getMacro(Token name) {
        String s = name.getText();
        for (Macro macro : this.macros) {
            if (!macro.getName().equals(s)) continue;
            return macro;
        }
        ErrorList.addError("@" + new TokenPosition(name) + " - macro \"" + s + "\" is not defined!");
        return null;
    }

    public void resolveMacrosAndRegisterUsage() {
        for (Function function : this.functions0) {
            function.list.resolveMacros();
        }
        for (Function function : this.functions1) {
            function.list.resolveMacros();
        }
    }

    public void addRegisterFirst(Token name) {
        this.registers.add(name.getText());
        Registers.addRegisterFirst(name);
    }

    public void addRegister(Token name) {
        this.registers.add(name.getText());
        Registers.addRegister(name);
    }

    public void addConstant(Token name, Token c0, Token c1, Token c2, Token c3, Token c4, Token c5, Token c6, Token c7) {
        Constant constant = new Constant(name, c0, c1, c2, c3, c4, c5, c6, c7);
        if (ALUConstants.addConstant(name, constant)) {
            this.constants.add(constant);
        }
    }

    public void startNewTestCase() {
        ConstantCollection.startNewTestCase();
    }

    public void setStartPoint(Token id) {
        ConstantCollection.setStartPoint(id);
    }

    public void addTestInput(Token name, Token c0, Token c1, Token c2, Token c3, Token c4, Token c5, Token c6, Token c7) {
        ConstantCollection.addTestInput(new Constant(name, c0, c1, c2, c3, c4, c5, c6, c7));
    }

    public void addTestOutput(Token name, Token c0, Token c1, Token c2, Token c3, Token c4, Token c5, Token c6, Token c7) {
        ConstantCollection.addTestOutput(new Constant(name, c0, c1, c2, c3, c4, c5, c6, c7));
    }

    public void addParameter(Token n, Token v) {
        ParameterType type = ParameterType.valueOf(n.getText());
        int value = Converter.intFromString(v.getText());
        if (type == ParameterType.MULT_CYCLES) {
            if (value != 2 && value != 3 && value != 4 && value != 8 && value != 16) {
                ErrorList.addError("@" + new TokenPosition(v) + " - Invalid value for MULT_CYCLES! Must be in {2,3,4,8,16}.");
                return;
            }
            ConstantCollection.MULT_CYCLES = value;
            if (value == 2) {
                ConstantCollection.ROTATE_VARIANTS = 7;
            } else if (value == 3) {
                ConstantCollection.ROTATE_VARIANTS = 5;
            }
        } else if (type == ParameterType.CALL_STACK_SIZE) {
            ConstantCollection.CALL_STACK_SIZE = value;
        } else if (type == ParameterType.USE_CARRY_IN_AS0) {
            ConstantCollection.USE_CARRY_IN_AS0 = value > 0 ? 1 : 0;
        } else if (type == ParameterType.NUM_SWAP_REGS) {
            ConstantCollection.NUM_SWAP_REGS = value;
        } else if (type == ParameterType.ADDER_CONSTANT0) {
            ConstantCollection.USE_CARRY_IN_AS0 = 1;
            ConstantCollection.ADDER_CONSTANT0 = value;
            ConstantCollection.addAdderConstant(value);
        } else if (type == ParameterType.USE_CSA) {
            ConstantCollection.USE_CSA = value;
        } else if (type == ParameterType.COMB_SIZE) {
            ConstantCollection.COMB_SIZE = value;
            if (value != 0 && value != 4 && value != 16) {
                ErrorList.addError("@" + new TokenPosition(v) + " - Invalid value for COMB_SIZE! Must be in {0, 4, 16}.");
                return;
            }
        }
        this.parameters.add(new Parameter(type, value));
    }

    public void addStartPoint(Token name, Token id) {
        ConstantCollection.addStartPoint(name, id);
    }

    public void startNewROM(Token token) {
        if (this.romIndex > 0) {
            ErrorList.addError("@" + new TokenPosition(token) + " - Only 1 \"NEWROM\" possible!");
            return;
        }
        this.romIndex = 1;
        ConstantCollection.PROGRAM_ROMS = 2;
    }

    private LinkedList<Function> currentROM() {
        if (this.romIndex == 0) {
            return this.functions0;
        }
        return this.functions1;
    }

    public void addFunction(Token name, InstructionList list) {
        if (list.size() == 0) {
            ErrorList.addError("@" + new TokenPosition(name) + " - Function \"" + name.getText() + "\" is empty");
        } else if (this.getFunction(name.getText()) != null) {
            ErrorList.addError("@" + new TokenPosition(name) + " - Function \"" + name.getText() + "\" duplicated!");
        } else {
            int offset = 0;
            if (!this.hasRemovedFirstUse) {
                this.hasRemovedFirstUse = list.removeFirstUse();
            }
            if (this.currentROM().size() > 0) {
                offset = this.currentROM().getLast().offset + this.currentROM().getLast().list.size();
            }
            this.currentROM().add(new Function(name.getText(), list, offset));
            list.setProgram(this);
            list.setName(name.getText());
            CallTargets.addTarget(name.getText(), offset, this.romIndex);
            if (ConstantCollection.PROGRAM_ROMS == 1) {
                ConstantCollection.PROGRAM_SIZE0 += list.size();
            } else {
                ConstantCollection.PROGRAM_SIZE1 += list.size();
            }
        }
    }

    public void moveOffset(String functionName, int size) {
        int offset = -1;
        for (Function function : this.functions0) {
            if (!function.name.equals(functionName)) continue;
            offset = function.offset;
            break;
        }
        if (offset >= 0) {
            for (Function function : this.functions0) {
                if (function.offset <= offset) continue;
                function.offset += size;
            }
            return;
        }
        for (Function function : this.functions1) {
            if (!function.name.equals(functionName)) continue;
            offset = function.offset;
            break;
        }
        for (Function function : this.functions1) {
            if (function.offset <= offset) continue;
            function.offset += size;
        }
    }

    private Function getFunction(String name) {
        for (Function function : this.functions0) {
            if (!function.name.equals(name)) continue;
            return function;
        }
        for (Function function : this.functions1) {
            if (!function.name.equals(name)) continue;
            return function;
        }
        return null;
    }

    public void printCode() {
        String s = "Registers: ";
        int i = 0;
        while (i < this.registers.size()) {
            s = i > 0 ? String.valueOf(s) + ", " + this.registers.get(i) : String.valueOf(s) + this.registers.get(i);
            ++i;
        }
        s = String.valueOf(s) + ";";
        Printer.print(s, 0);
        if (this.constants.size() > 0) {
            Printer.print("\nConstants: ", 0);
            i = 0;
            while (i < this.constants.size()) {
                Constant c = this.constants.get(i);
                if (i < this.constants.size() - 1) {
                    Printer.print(String.valueOf(c.getName()) + " = { " + c.toStringL() + "\n         " + c.toStringH() + " },", 1);
                } else {
                    Printer.print(String.valueOf(c.getName()) + " = { " + c.toStringL() + "\n         " + c.toStringH() + " };", 1);
                }
                ++i;
            }
        }
        if (this.parameters.size() > 0) {
            Printer.print("\nParameters: ", 0);
            i = 0;
            while (i < this.parameters.size()) {
                Parameter p = this.parameters.get(i);
                s = p.type.toString();
                while (s.length() < 16) {
                    s = String.valueOf(s) + " ";
                }
                s = String.valueOf(s) + " = " + p.value;
                s = i < this.parameters.size() - 1 ? String.valueOf(s) + "," : String.valueOf(s) + ";";
                Printer.print(s, 1);
                ++i;
            }
        }
        Printer.print("", 0);
        Printer.print("///////////////////////////////////////////////////////////", 0);
        for (Function function : this.functions0) {
            Printer.print("", 0);
            s = String.valueOf(function.name) + ":";
            while (s.length() < 27) {
                s = String.valueOf(s) + " ";
            }
            Printer.print(String.valueOf(s) + "//Address: " + function.offset, 0);
            function.list.printCode();
        }
        if (this.romIndex > 0) {
            Printer.print("\n==========================\nNEWROM\n==========================", 0);
            for (Function function : this.functions1) {
                Printer.print("", 0);
                s = String.valueOf(function.name) + ":";
                while (s.length() < 27) {
                    s = String.valueOf(s) + " ";
                }
                Printer.print(String.valueOf(s) + "//Address: " + function.offset, 0);
                function.list.printCode();
            }
        }
    }

    public void writeFile(String filename) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(filename);
        Printer.writeHeader(writer);
        this.writeVHDLCode(writer);
        writer.close();
    }

    public void check() {
        if (ConstantCollection.USE_SUBH == 1 && ConstantCollection.USE_SUBIAC == 1) {
            ErrorList.addError("@0 - it is not possible to use SUBH and SUBIAC!");
        }
        for (Function function : this.functions0) {
            function.list.check();
        }
        for (Function function : this.functions1) {
            function.list.check();
        }
    }

    public void prepareForWriting() {
        for (Function function : this.functions0) {
            function.list.prepareForWriting();
        }
        for (Function function : this.functions1) {
            function.list.prepareForWriting();
        }
        for (Function function : this.functions0) {
            ConstantCollection.addFunction(function.name, function.offset, 0);
        }
        for (Function function : this.functions1) {
            ConstantCollection.addFunction(function.name, function.offset, 1);
        }
        ConstantCollection.calculateProgramSize();
        if (ConstantCollection.PROGRAM_ROMS == 1) {
            return;
        }
        if (this.functions0.size() < ConstantCollection.PROGRAM_SIZE) {
            int offset = 0;
            if (this.currentROM().size() > 0) {
                offset = this.functions0.getLast().offset + this.functions0.getLast().list.size();
            }
            this.functions0.add(new Function("padding0", ConstantCollection.PROGRAM_SIZE - ConstantCollection.PROGRAM_SIZE0 - 16, offset, 0));
        } else {
            int offset = 0;
            if (this.currentROM().size() > 0) {
                offset = this.functions1.getLast().offset + this.functions1.getLast().list.size();
            }
            this.functions1.add(new Function("padding1", ConstantCollection.PROGRAM_SIZE - ConstantCollection.PROGRAM_SIZE1, offset, 1));
        }
    }

    public void writeVHDLCode(PrintWriter writer) {
        Function function;
        writer.println("");
        writer.println("library ieee;");
        writer.println("use ieee.std_logic_1164.all;");
        writer.println("use ieee.std_logic_unsigned.all;");
        writer.println("");
        writer.println("use work.nacl_constants.all;");
        writer.println("");
        writer.println("entity nacl_controller_rom_program is");
        writer.println("  port(");
        writer.println("    program_counter :  in std_logic_vector(PROGRAM_SIZE_LD-1 downto 0);");
        writer.println("    code            : out std_logic_vector(8 downto 0);");
        writer.println("    sel_start_point :  in std_logic_vector(START_POINTS_LD-1 downto 0)");
        writer.println("  );");
        writer.println("end nacl_controller_rom_program;");
        writer.println("");
        writer.println("architecture behaviour of nacl_controller_rom_program is");
        writer.println("");
        writer.println("  type program_rom_type is array(0 to PROGRAM_SIZE-1) of std_logic_vector (8 downto 0);");
        writer.println("  constant program_rom0 : program_rom_type := (");
        int i = 0;
        while (i < this.functions0.size()) {
            function = this.functions0.get(i);
            writer.println("");
            writer.println("  -----------------------------------" + function.name);
            writer.println("");
            function.list.writeVHDLCode(writer, false);
            ++i;
        }
        writer.println("---------------------------------------------------------");
        writer.println("    I_NOP    & \"00000\"");
        writer.println("  );");
        writer.println("");
        if (ConstantCollection.PROGRAM_ROMS > 1) {
            writer.println("  constant program_rom1 : program_rom_type := (");
            i = 0;
            while (i < this.functions1.size()) {
                function = this.functions1.get(i);
                writer.println("");
                writer.println("  -----------------------------------" + function.name);
                writer.println("");
                function.list.writeVHDLCode(writer, false);
                ++i;
            }
            writer.println("---------------------------------------------------------");
            writer.println("    I_NOP    & \"00000\"");
            writer.println("  );");
            writer.println("");
        }
        if (ConstantCollection.PROGRAM_ROMS > 1) {
            writer.println("  signal code0 : std_logic_vector(8 downto 0);");
            writer.println("  signal code1 : std_logic_vector(8 downto 0);");
        }
        writer.println("begin");
        writer.println("");
        if (ConstantCollection.PROGRAM_ROMS > 1) {
            writer.println("  code0 <= program_rom0(conv_integer(program_counter));");
            writer.println("  code1 <= program_rom1(conv_integer(program_counter));");
            writer.println("");
            writer.println("  romMux : process(sel_start_point, code0, code1) begin");
            writer.println("    if sel_start_point > 1 and PROGRAM_ROMS = 2 then");
            writer.println("      code <= code1;");
            writer.println("    else");
            writer.println("      code <= code0;");
            writer.println("    end if;");
            writer.println("  end process;");
        } else {
            writer.println("  code <= program_rom0(conv_integer(program_counter));");
        }
        writer.println("");
        writer.println("end;");
        writer.println("");
    }

    private class Function {
        public String name;
        public InstructionList list;
        public int offset;

        public Function(String name, InstructionList list, int offset) {
            this.name = name;
            this.list = list;
            this.offset = offset;
        }

        public Function(String name, int length, int offset, int romID) {
            this.name = name;
            this.list = new InstructionList();
            this.offset = offset;
            int i = 0;
            while (i < length) {
                this.list.addInstruction(new Instruction(Instruction.Type.NOP, romID, new InstructionWithFetch(Instruction.Type.NOP, new Variable(0, 0))));
                ++i;
            }
        }
    }

    private class Parameter {
        public ParameterType type;
        public int value;

        public Parameter(ParameterType type, int value) {
            this.type = type;
            this.value = value;
        }
    }

    public static enum ParameterType {
        MULT_CYCLES,
        CALL_STACK_SIZE,
        USE_CARRY_IN_AS0,
        NUM_SWAP_REGS,
        ADDER_CONSTANT0,
        USE_CSA,
        COMB_SIZE;

    }
}

