/*
 * Decompiled with CFR 0.152.
 */
package tokens;

import org.antlr.runtime.Token;
import parser.ErrorList;
import tokens.TokenPosition;
import utils.Converter;

public class Variable {
    private int id;
    private int offset;
    private TokenPosition position;

    public Variable(int id, Token offset) {
        this.id = id;
        this.offset = Converter.intFromString(offset.getText());
        this.position = new TokenPosition(offset);
        if (this.offset > 7) {
            ErrorList.addError("@" + this.position + " - Offset too big!");
        }
    }

    public Variable(int id, int offset) {
        this.id = id;
        this.offset = offset;
        if (this.offset > 7) {
            ErrorList.addError("@0 - Offset too big!");
        }
    }

    public String toString() {
        return "V" + this.id + "[" + this.offset + "]";
    }

    public String toVHDLString() {
        return "\"" + Converter.toBinaryString(this.id, 2) + "\" & \"" + Converter.toBinaryString(this.offset, 3) + "\"";
    }
}

