/*
 * Decompiled with CFR 0.152.
 */
package tokens.datastructures;

import java.util.LinkedList;
import org.antlr.runtime.Token;
import parser.ErrorList;
import tokens.TokenPosition;
import tokens.datastructures.ConstantCollection;
import utils.Printer;

public class CallTargets {
    private static LinkedList<Target> targets = new LinkedList();

    public static void addTarget(String name, int address, int romID) {
        for (Target target : targets) {
            if (!target.name.equals(name)) continue;
            if (target.address < 0) {
                target.address = address;
                target.romID = romID;
            }
            return;
        }
        targets.add(new Target(name, address, romID));
    }

    public static void setCallingToken(Token callingToken) {
        Target target2;
        String name = callingToken.getText();
        for (Target target2 : targets) {
            if (!target2.name.equals(name)) continue;
            if (target2.callingToken == null) {
                target2.callingToken = callingToken;
            }
            return;
        }
        target2 = new Target(name, -1, -1);
        target2.callingToken = callingToken;
        targets.add(target2);
    }

    public static int getTargetID(Token token, int romID) {
        String name = token.getText();
        for (Target target : targets) {
            if (!target.name.equals(name)) continue;
            if (romID == target.romID) {
                return target.ID;
            }
            ErrorList.addError("@" + new TokenPosition(token) + " - target is in false ROM!");
            return -1;
        }
        return -1;
    }

    public static void check() {
        for (Target target : targets) {
            if (target.address >= 0) continue;
            ErrorList.addError("@" + new TokenPosition(target.callingToken) + " - undefined reference \"" + target.name + "\"!");
        }
    }

    public static void prepareForWriting() {
        for (Target target : targets) {
            if (target.callingToken == null) continue;
            target.ID = ConstantCollection.addCallTarget(target.name);
        }
    }

    public static void printList() {
        Printer.print("CallTargets:", 0);
        for (Target target : targets) {
            if (target.callingToken == null || target.address <= 0) continue;
            Printer.print(String.valueOf(target.ID) + " (" + target.name + "): " + target.address, 1);
        }
    }

    public static LinkedList<Integer> getTargetList() {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (Target target : targets) {
            list.add(target.address);
        }
        return list;
    }

    private static class Target {
        public String name;
        public int address;
        public Token callingToken;
        public int ID;
        public int romID;

        public Target(String name, int address, int romID) {
            this.name = name;
            this.address = address;
            this.ID = -1;
            this.romID = romID;
        }
    }
}

