/*
 * Decompiled with CFR 0.152.
 */
package tokens.datastructures;

import org.antlr.runtime.Token;
import tokens.TokenPosition;
import utils.Converter;

public class Constant {
    private String name;
    private long[] constants = new long[8];
    private int values;
    private TokenPosition position;

    public Constant(Token c0) {
        this.constants[0] = Converter.longFromString(c0);
        this.values = 1;
    }

    public Constant(Token name, Token c0, Token c1, Token c2, Token c3, Token c4, Token c5, Token c6, Token c7) {
        this.name = name.getText();
        this.constants[0] = Converter.longFromString(c0);
        this.constants[1] = Converter.longFromString(c1);
        this.constants[2] = Converter.longFromString(c2);
        this.constants[3] = Converter.longFromString(c3);
        this.constants[4] = Converter.longFromString(c4);
        this.constants[5] = Converter.longFromString(c5);
        this.constants[6] = Converter.longFromString(c6);
        this.constants[7] = Converter.longFromString(c7);
        this.position = new TokenPosition(name);
        this.values = 8;
    }

    public boolean equals(Constant rhs) {
        if (this.values != rhs.values) {
            return false;
        }
        int i = 0;
        while (i < this.values) {
            if (this.constants[i] != rhs.constants[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int contains(Token rhs) {
        long tmp = Converter.longFromString(rhs);
        int i = 0;
        while (i < this.values) {
            if (this.constants[i] == tmp) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isComplete() {
        return this.values == 8;
    }

    public int add(Token constant) {
        if (this.values == 8) {
            return 8;
        }
        this.constants[this.values] = Converter.longFromString(constant);
        return this.values++;
    }

    public TokenPosition getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public String toStringL() {
        return String.format("0x%08X, 0x%08X, 0x%08X, 0x%08X", this.constants[0], this.constants[1], this.constants[2], this.constants[3]);
    }

    public String toStringH() {
        return String.format("0x%08X, 0x%08X, 0x%08X, 0x%08X", this.constants[4], this.constants[5], this.constants[6], this.constants[7]);
    }

    public String toString() {
        return String.valueOf(this.toStringL()) + ", " + this.toStringH();
    }

    public String toVhdlString() {
        String s = "";
        int i = 0;
        while (i < 8) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            s = String.valueOf(s) + String.format("X\"%08X\"", this.constants[i]);
            ++i;
        }
        return s;
    }
}

