/*
 * Decompiled with CFR 0.152.
 */
package tokens.datastructures;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import org.antlr.runtime.Token;
import parser.ErrorList;
import tokens.TokenPosition;
import tokens.datastructures.ALUConstants;
import tokens.datastructures.Constant;
import tokens.datastructures.Registers;
import utils.Converter;
import utils.Pair;
import utils.Printer;

public class ConstantCollection {
    public static int WORD_SIZE = 32;
    public static int NUM_REGISTERS = 0;
    public static int MULT_CYCLES = 4;
    public static int NUM_CONSTANTS = 0;
    public static int ROTATE_VARIANTS = 4;
    public static int CALL_STACK_SIZE = 2;
    public static int CALL_TARGETS = 0;
    public static int PROGRAM_SIZE = 0;
    public static int PROGRAM_SIZE0 = 0;
    public static int PROGRAM_SIZE1 = 0;
    public static int ADDRESS_PAGE_SIZE = 0;
    public static int ADDRESS_PAGES = 0;
    public static int ACCU_EXTENSION = 0;
    public static int REPEAT_CONSTANTS = 0;
    public static int REPEAT_CONSTANT_BITS = 1;
    public static int SKIP_CONSTANTS = 0;
    public static int ADDER_CONSTANTS = 0;
    public static int LOOP_COUNTER_BITS = 8;
    public static int NUM_SWAP_REGS = 0;
    public static int ADDER_CONSTANT0 = 1;
    public static int COMB_SIZE = 0;
    public static int START_POINTS = 0;
    public static int START_POINT_CONSTANTS = 0;
    public static int PROGRAM_ROMS = 1;
    public static int V2 = 0;
    public static int USE_CARRY_IN_AS0 = 0;
    public static int USE_LOGIC = 0;
    public static int USE_MUL256 = 0;
    public static int USE_INCBA = 0;
    public static int USE_SUBACC = 0;
    public static int USE_SUBIAC = 0;
    public static int USE_SUBH = 0;
    public static int USE_MULNEG = 0;
    public static int USE_SETSGN = 0;
    public static int USE_REPEAT = 0;
    public static int USE_LCPOS = 0;
    public static int USE_LCNEG = 0;
    public static int USE_ROR8 = 0;
    public static int USE_ROL7 = 0;
    public static int USE_ROL8 = 0;
    public static int USE_ROL16 = 0;
    public static int USE_ROR24 = 0;
    public static int USE_OVERFLOW = 0;
    public static int USE_SELFTEST = 0;
    public static int USE_CSA = 0;
    public static int USE_SKIPB = 0;
    public static int USE_CMPSP = 0;
    public static int USE_FAST_CALL = 0;
    public static int USE_LATCHES = 0;
    private static LinkedList<Pair<Integer, Integer>> skipConstants = new LinkedList();
    private static LinkedList<Integer> adderConstants = new LinkedList();
    private static LinkedList<Integer> repeatConstants = new LinkedList();
    private static LinkedList<Integer> startingConstants = new LinkedList();
    private static HashMap<String, Pair<Integer, Integer>> functionOffsetList = new HashMap();
    private static LinkedList<Pair<Integer, String>> callTargets = new LinkedList();
    private static LinkedList<Token> startpoints = new LinkedList();
    private static LinkedList<TestCase> testcases = new LinkedList();

    public static int addSkipConstant(int constant, int difference) {
        int i = 0;
        while (i < skipConstants.size()) {
            if (skipConstants.get(i).getFirst() + skipConstants.get(i).getSecond() == constant + difference) {
                return i;
            }
            ++i;
        }
        skipConstants.add(new Pair<Integer, Integer>(constant, difference));
        ++SKIP_CONSTANTS;
        return skipConstants.size() - 1;
    }

    public static int addAdderConstant(int constant) {
        if (USE_CARRY_IN_AS0 == 1 && constant == 0) {
            return 0;
        }
        int i = USE_CARRY_IN_AS0;
        while (i < adderConstants.size()) {
            if (adderConstants.get(i) == constant) {
                return i;
            }
            ++i;
        }
        adderConstants.add(constant);
        ++ADDER_CONSTANTS;
        return adderConstants.size() - 1;
    }

    public static int addRepeatConstant(int value) {
        int i = 0;
        while (i < repeatConstants.size()) {
            if (repeatConstants.get(i).equals(value)) {
                return i;
            }
            ++i;
        }
        repeatConstants.add(value);
        ++REPEAT_CONSTANTS;
        int width = (int)Math.ceil(Math.log(value) / Math.log(2.0));
        if (REPEAT_CONSTANT_BITS < width) {
            REPEAT_CONSTANT_BITS = width;
        }
        return repeatConstants.size() - 1;
    }

    public static void addFunction(String name, int offset, int romID) {
        functionOffsetList.put(name, new Pair<Integer, Integer>(offset, romID));
    }

    public static int addCallTarget(String name) {
        Pair<Integer, Integer> entry = functionOffsetList.get(name);
        callTargets.add(new Pair<Integer, String>(entry == null ? -1 : entry.getFirst(), name));
        ++CALL_TARGETS;
        return callTargets.size() - 1;
    }

    public static int addStartingConstant(Token value) {
        int v = Integer.parseInt(value.getText());
        int i = 0;
        while (i < startingConstants.size()) {
            if (startingConstants.get(i) == v) {
                return i;
            }
            ++i;
        }
        if (v > START_POINTS) {
            ErrorList.addError("@" + new TokenPosition(value) + " - value is larger than biggest startingpoint-id!");
            return 0;
        }
        startingConstants.add(v);
        ++START_POINT_CONSTANTS;
        return startingConstants.size() - 1;
    }

    public static void addStartPoint(Token name, Token id) {
        int ID = Integer.parseInt(id.getText());
        int i = startpoints.size();
        while (i <= ID) {
            startpoints.add(null);
            ++i;
        }
        if (startpoints.get(ID) != null) {
            ErrorList.addError("@" + new TokenPosition(name) + " - startpoint-ID duplicated!");
            return;
        }
        startpoints.set(ID, name);
        START_POINTS = startpoints.size();
    }

    public static void startNewTestCase() {
        testcases.add(new TestCase());
    }

    public static void setStartPoint(Token id) {
        ConstantCollection.testcases.getLast().start_point = Converter.intFromString(id.getText());
    }

    public static void addTestInput(Constant constant) {
        int ID = Registers.getRegisterID(constant.getName());
        if (ID < 0) {
            ErrorList.addError("@" + constant.getPosition() + " - unknown name of test input " + constant.getName() + "!");
            return;
        }
        ConstantCollection.testcases.getLast().testInput.add(new Pair<Constant, Integer>(constant, ID));
        USE_SELFTEST = 1;
    }

    public static void addTestOutput(Constant constant) {
        int ID = Registers.getRegisterID(constant.getName());
        if (ID < 0) {
            ErrorList.addError("@" + constant.getPosition() + " - unknown name of test output " + constant.getName() + "!");
            return;
        }
        ConstantCollection.testcases.getLast().testOutput.add(new Pair<Constant, Integer>(constant, ID));
    }

    public static void setMultCyles(int value) {
        MULT_CYCLES = value;
        ACCU_EXTENSION = value == 2 && USE_MUL256 == 1 ? 32 : 0;
        ROTATE_VARIANTS = value == 2 ? 7 : (value == 3 ? 5 : 4);
    }

    public static void calculateProgramSize() {
        PROGRAM_SIZE = Math.max(PROGRAM_SIZE0, PROGRAM_SIZE1 - 16);
    }

    public static void check() {
        long max_constant_size;
        switch (MULT_CYCLES) {
            case 2: {
                max_constant_size = 0xFFFFFFFFL;
                break;
            }
            case 3: {
                max_constant_size = 2047L;
                break;
            }
            case 4: {
                max_constant_size = 255L;
                break;
            }
            case 8: {
                max_constant_size = 15L;
                break;
            }
            default: {
                max_constant_size = 3L;
            }
        }
        for (Integer c : adderConstants) {
            if ((long)c.intValue() <= max_constant_size) continue;
            ErrorList.addError("@0 - Value for Adder setting too big (" + c + ")!");
        }
        if (COMB_SIZE > NUM_CONSTANTS) {
            ErrorList.addError("@0 - not enough constants for comb!");
        }
    }

    public static void printList() {
        int indent = 1;
        int width = 22;
        Printer.print2Columns("WORD_SIZE", "= " + WORD_SIZE, indent, width);
        Printer.print2Columns("NUM_REGISTERS", "= " + NUM_REGISTERS, indent, width);
        Printer.print2Columns("MULT_CYCLES", "= " + MULT_CYCLES, indent, width);
        Printer.print2Columns("NUM_CONSTANTS", "= " + NUM_CONSTANTS, indent, width);
        Printer.print2Columns("ROTATE_VARIANTS", "= " + ROTATE_VARIANTS, indent, width);
        Printer.print2Columns("CALL_STACK_SIZE", "= " + CALL_STACK_SIZE, indent, width);
        Printer.print2Columns("CALL_TARGETS", "= " + CALL_TARGETS, indent, width);
        Printer.print2Columns("PROGRAM_SIZE", "= " + PROGRAM_SIZE, indent, width);
        Printer.print2Columns("ADDRESS_PAGE_SIZE", "= " + ADDRESS_PAGE_SIZE / 4, indent, width);
        Printer.print2Columns("ADDRESS_PAGES", "= " + ADDRESS_PAGES, indent, width);
        Printer.print2Columns("ACCU_EXTENSION", "= " + ACCU_EXTENSION, indent, width);
        Printer.print2Columns("REPEAT_CONSTANTS", "= " + REPEAT_CONSTANTS, indent, width);
        Printer.print2Columns("REPEAT_CONSTANT_BITS", "= " + REPEAT_CONSTANT_BITS, indent, width);
        Printer.print2Columns("SKIP_CONSTANTS", "= " + SKIP_CONSTANTS, indent, width);
        Printer.print2Columns("ADDER_CONSTANTS", "= " + ADDER_CONSTANTS, indent, width);
        Printer.print2Columns("LOOP_COUNTER_BITS", "= " + LOOP_COUNTER_BITS, indent, width);
        Printer.print2Columns("NUM_SWAP_REGS", "= " + NUM_SWAP_REGS, indent, width);
        Printer.print2Columns("COMB_SIZE", "= " + COMB_SIZE, indent, width);
        Printer.print2Columns("START_POINTS", "= " + START_POINTS, indent, width);
        Printer.print2Columns("START_POINT_CONSTANTS", "= " + START_POINT_CONSTANTS, indent, width);
        Printer.print2Columns("PROGRAM_ROMS", "= " + PROGRAM_ROMS, indent, width);
        Printer.print("", 0);
        Printer.print2Columns("USE_CARRY_IN_AS0", "= " + USE_CARRY_IN_AS0, indent, width);
        Printer.print2Columns("USE_LOGIC", "= " + USE_LOGIC, indent, width);
        Printer.print2Columns("USE_MUL256", "= " + USE_MUL256, indent, width);
        Printer.print2Columns("USE_INCBA", "= " + USE_INCBA, indent, width);
        Printer.print2Columns("USE_SUBACC", "= " + USE_SUBACC, indent, width);
        Printer.print2Columns("USE_SUBIAC", "= " + USE_SUBIAC, indent, width);
        Printer.print2Columns("USE_SUBH", "= " + USE_SUBH, indent, width);
        Printer.print2Columns("USE_MULNEG", "= " + USE_MULNEG, indent, width);
        Printer.print2Columns("USE_SETSGN", "= " + USE_SETSGN, indent, width);
        Printer.print2Columns("USE_REPEAT", "= " + USE_REPEAT, indent, width);
        Printer.print2Columns("USE_LCPOS", "= " + USE_LCPOS, indent, width);
        Printer.print2Columns("USE_LCNEG", "= " + USE_LCNEG, indent, width);
        Printer.print2Columns("USE_OVERFLOW", "= " + USE_OVERFLOW, indent, width);
        Printer.print2Columns("USE_SELFTEST", "= " + USE_SELFTEST, indent, width);
        Printer.print2Columns("USE_CSA", "= " + USE_CSA, indent, width);
        Printer.print2Columns("USE_SKIPB", "= " + USE_SKIPB, indent, width);
        Printer.print2Columns("USE_CMPSP", "= " + USE_CMPSP, indent, width);
        Printer.print2Columns("USE_FAST_CALL", "= " + USE_FAST_CALL, indent, width);
        Printer.print2Columns("USE_LATCHES", "= " + USE_LATCHES, indent, width);
        Printer.print2Columns("USE_V2", "= " + V2, indent, width);
    }

    public static void writeFile(String filename) throws FileNotFoundException {
        int i;
        TestCase testcase;
        int PROGRAM_SIZE_LD = (int)Math.ceil(Math.log(PROGRAM_SIZE + 1) / Math.log(2.0));
        int START_POINTS_LD = (int)Math.ceil(Math.log(START_POINTS) / Math.log(2.0));
        int NUM_ADDERS = (WORD_SIZE + MULT_CYCLES - 1) / MULT_CYCLES - 1;
        int ADDRESSES = NUM_REGISTERS * 8 + NUM_CONSTANTS * 8;
        int ADDRESS_WIDTH = (int)Math.ceil(Math.log(ADDRESSES) / Math.log(2.0));
        int w = ++PROGRAM_SIZE > 999 ? 4 : (PROGRAM_SIZE > 99 ? 3 : 2);
        int TESTCASES = testcases.size();
        int TEST_INPUTS = TESTCASES > 0 ? ConstantCollection.testcases.getFirst().testInput.size() : 0;
        int TEST_OUTPUTS = TESTCASES > 0 ? ConstantCollection.testcases.getFirst().testOutput.size() : 0;
        String ROL8_index = Converter.toBinaryString(ROTATE_VARIANTS + 1, 4);
        String ROL16_index = Converter.toBinaryString(ROTATE_VARIANTS + 1 + (USE_ROL8 == 1 ? 1 : 0), 4);
        String ROR2_index = Converter.toBinaryString(ROTATE_VARIANTS + 1 + (USE_ROL8 == 1 ? 1 : 0) + (USE_ROL16 == 1 ? 1 : 0), 4);
        String ROR30_index = Converter.toBinaryString(ROTATE_VARIANTS + 2 + (USE_ROL8 == 1 ? 1 : 0) + (USE_ROL16 == 1 ? 1 : 0), 4);
        String ROL7_index = Converter.toBinaryString(ROTATE_VARIANTS + 3 + (USE_ROL8 == 1 ? 1 : 0) + (USE_ROL16 == 1 ? 1 : 0), 4);
        String ROL9_index = Converter.toBinaryString(ROTATE_VARIANTS + 4 + (USE_ROL8 == 1 ? 1 : 0) + (USE_ROL16 == 1 ? 1 : 0), 4);
        String ROL13_index = Converter.toBinaryString(ROTATE_VARIANTS + 5 + (USE_ROL8 == 1 ? 1 : 0) + (USE_ROL16 == 1 ? 1 : 0), 4);
        String ROL18_index = Converter.toBinaryString(ROTATE_VARIANTS + 6 + (USE_ROL8 == 1 ? 1 : 0) + (USE_ROL16 == 1 ? 1 : 0), 4);
        if (USE_ROL7 == 1) {
            ROTATE_VARIANTS += 6;
        }
        if (USE_ROL8 == 1) {
            ++ROTATE_VARIANTS;
        }
        if (USE_ROL16 == 1) {
            ++ROTATE_VARIANTS;
        }
        if (CALL_TARGETS == 0) {
            CALL_TARGETS = 1;
        }
        if (REPEAT_CONSTANTS == 0) {
            REPEAT_CONSTANTS = 1;
        }
        if (SKIP_CONSTANTS == 0) {
            SKIP_CONSTANTS = 1;
        }
        if (NUM_CONSTANTS == 0) {
            NUM_CONSTANTS = 1;
        }
        if (ADDER_CONSTANTS == 0) {
            ADDER_CONSTANTS = 1;
        }
        if (TEST_INPUTS == 0) {
            TEST_INPUTS = 1;
        }
        if (TEST_OUTPUTS == 0) {
            TEST_OUTPUTS = 1;
        }
        if (START_POINTS == 0) {
            ++START_POINTS;
        }
        PrintWriter writer = new PrintWriter(filename);
        Printer.writeHeader(writer);
        writer.println("");
        writer.println("library ieee;");
        writer.println("use ieee.std_logic_1164.all;");
        writer.println("use ieee.numeric_std.all;");
        writer.println("");
        writer.println("package nacl_constants is");
        writer.println("");
        writer.println("  function log2ceil (n : natural) return natural;");
        writer.println("  function max (a, b : natural) return natural;");
        writer.println("");
        writer.println("  ------------------------------------------------------------------------");
        writer.println("");
        writer.println("  constant WORD_SIZE             : integer := " + Converter.toDecimaleString(WORD_SIZE, w) + "; -- DO NOT CHANGE !! ");
        writer.println("  constant NUM_REGISTERS         : integer := " + Converter.toDecimaleString(NUM_REGISTERS, w) + ";");
        writer.println("  constant MULT_CYCLES           : integer := " + Converter.toDecimaleString(MULT_CYCLES, w) + "; -- must be in {2, 3, 4, 8, 16}");
        writer.println("  constant NUM_CONSTANTS         : integer := " + Converter.toDecimaleString(NUM_CONSTANTS, w) + ";");
        writer.println("  constant ROTATE_VARIANTS       : integer := " + Converter.toDecimaleString(ROTATE_VARIANTS, w) + "; -- maximum 15");
        writer.println("  constant CALL_TARGETS          : integer := " + Converter.toDecimaleString(CALL_TARGETS, w) + "; -- maximum 16");
        writer.println("  constant PROGRAM_SIZE          : integer := " + Converter.toDecimaleString(PROGRAM_SIZE, w) + ";");
        writer.println("  constant ADDRESS_PAGE_SIZE     : integer := " + Converter.toDecimaleString(ADDRESS_PAGE_SIZE / 4, w) + ";");
        writer.println("  constant ADDRESS_PAGES         : integer := " + Converter.toDecimaleString(ADDRESS_PAGES, w) + "; -- maximum 64");
        writer.println("  constant ACCU_EXTENSION        : integer := " + Converter.toDecimaleString(ACCU_EXTENSION, w) + "; -- 32 when MULT_CYCLES=2, otherwise 0");
        writer.println("  constant SKIP_CONSTANTS        : integer := " + Converter.toDecimaleString(SKIP_CONSTANTS, w) + "; -- maximum 4");
        writer.println("  constant ADDER_CONSTANTS       : integer := " + Converter.toDecimaleString(ADDER_CONSTANTS, w) + "; -- maximum 4");
        writer.println("  constant START_POINTS          : integer := " + Converter.toDecimaleString(START_POINTS, w) + ";");
        writer.println("  constant START_POINT_CONSTANTS : integer := " + Converter.toDecimaleString(START_POINT_CONSTANTS, w) + ";");
        writer.println("  constant PUBLIC_ADDRESS_WIDTH  : integer := " + Converter.toDecimaleString(4, w) + "; --should be 4");
        writer.println("  constant PROGRAM_ROMS          : integer := " + Converter.toDecimaleString(PROGRAM_ROMS, w) + "; -- 1 or 2");
        writer.println("  constant LOOP_COUNTER_BITS     : integer := " + Converter.toDecimaleString(LOOP_COUNTER_BITS, w) + "; -- should be 8");
        if (V2 == 0) {
            writer.println("  constant REPEAT_CONSTANTS      : integer := " + Converter.toDecimaleString(REPEAT_CONSTANTS, w) + "; -- maximum 16");
            writer.println("  constant REPEAT_CONSTANT_BITS  : integer := " + Converter.toDecimaleString(REPEAT_CONSTANT_BITS, w) + ";");
            writer.println("  constant COMB_SIZE             : integer := " + Converter.toDecimaleString(COMB_SIZE, w) + "; -- must be in {0, 4, 16}");
            writer.println("  constant NUM_SWAP_REGS         : integer := " + Converter.toDecimaleString(NUM_SWAP_REGS, w) + "; -- must be in {0, 1, 2}");
            writer.println("  constant CALL_STACK_SIZE       : integer := " + Converter.toDecimaleString(CALL_STACK_SIZE, w) + ";");
        }
        writer.println("");
        writer.println("  constant USE_MUL256            : integer := " + USE_MUL256 + "; -- 0 or 1");
        writer.println("  constant USE_SELFTEST          : integer := " + USE_SELFTEST + "; -- 0 or 1");
        writer.println("  constant USE_CSA               : integer := " + USE_CSA + "; -- 0 or 1");
        if (V2 == 0) {
            writer.println("  constant USE_REPEAT            : integer := " + USE_REPEAT + "; -- 0 or 1");
            writer.println("  constant USE_CARRY_IN_AS0      : integer := " + USE_CARRY_IN_AS0 + "; -- 0 or 1");
            writer.println("  constant USE_LOGIC             : integer := " + USE_LOGIC + "; -- 0 or 1");
            writer.println("  constant USE_INCBA             : integer := " + USE_INCBA + "; -- 0 or 1");
            writer.println("  constant USE_SUBACC            : integer := " + USE_SUBACC + "; -- 0 or 1");
            writer.println("  constant USE_SUBIAC            : integer := " + USE_SUBIAC + "; -- 0 or 1");
            writer.println("  constant USE_SUBH              : integer := " + USE_SUBH + "; -- 0 or 1");
            writer.println("  constant USE_MULNEG            : integer := " + USE_MULNEG + "; -- 0 or 1");
            writer.println("  constant USE_SETSGN            : integer := " + USE_SETSGN + "; -- 0 or 1");
            writer.println("  constant USE_LCPOS             : integer := " + USE_LCPOS + "; -- 0 or 1");
            writer.println("  constant USE_LCNEG             : integer := " + USE_LCNEG + "; -- 0 or 1");
            writer.println("  constant USE_OVERFLOW          : integer := " + USE_OVERFLOW + "; -- 0 or 1");
            writer.println("  constant USE_SKIPB             : integer := " + USE_SKIPB + "; -- 0 or 1");
            writer.println("  constant USE_CMPSP             : integer := " + USE_CMPSP + "; -- 0 or 1");
        }
        writer.println("");
        writer.println("  constant ACCU_SIZE            : integer := 2*WORD_SIZE+3;");
        writer.println("  constant NUM_REGISTERS_LD     : integer := log2ceil(NUM_REGISTERS);");
        writer.println("  constant RAM_SIZE             : integer := NUM_REGISTERS * 8;");
        writer.println("  constant ROM_SIZE             : integer := NUM_CONSTANTS * 8;");
        writer.println("  constant ADDRESSES            : integer := RAM_SIZE + ROM_SIZE;");
        writer.println("  constant ADDRESS_WIDTH        : integer := log2ceil(ADDRESSES);");
        writer.println("  constant ADDRESS_WIDTH_RAM    : integer := log2ceil(RAM_SIZE);");
        writer.println("  constant ADDRESS_WIDTH_ROM    : integer := log2ceil(ROM_SIZE);");
        writer.println("  constant MULT_CYCLES_LD       : integer := log2ceil(MULT_CYCLES);");
        writer.println("  constant NUM_ADDERS           : integer := (WORD_SIZE + MULT_CYCLES - 1) / MULT_CYCLES - 1;");
        writer.println("  constant ROTATE_VARIANTS_LD   : integer := log2ceil(ROTATE_VARIANTS+1);");
        writer.println("  constant CALL_TARGETS_LD      : integer := log2ceil(CALL_TARGETS);");
        writer.println("  constant PROGRAM_SIZE_LD      : integer := log2ceil(PROGRAM_SIZE);");
        writer.println("  constant ADDRESS_PAGE_SIZE_LD : integer := log2ceil(ADDRESS_PAGE_SIZE);");
        writer.println("  constant ADDRESS_PAGES_LD     : integer := log2ceil(ADDRESS_PAGES);");
        writer.println("  constant BASE_ADDRESS_SIZE    : integer := ADDRESS_PAGE_SIZE_LD + ADDRESS_PAGES_LD;");
        writer.println("  constant ADDER_CONSTANTS_LD   : integer := log2ceil(ADDER_CONSTANTS);");
        writer.println("  constant SKIP_CONSTANTS_LD    : integer := log2ceil(SKIP_CONSTANTS);");
        writer.println("  constant START_POINTS_LD      : integer := max(1, log2ceil(START_POINTS-1));");
        if (V2 == 0) {
            writer.println("  constant REPEAT_CONSTANTS_LD  : integer := log2ceil(REPEAT_CONSTANTS);");
            writer.println("  constant CALL_STACK_SIZE_LD   : integer := log2ceil(CALL_STACK_SIZE);");
            writer.println("  constant COMB_SIZE_LD         : integer := log2ceil(max(1, COMB_SIZE));");
            writer.println("  constant COMB_INDEX_LD        : integer := log2ceil(WORD_SIZE/COMB_SIZE_LD);");
        }
        writer.println("");
        writer.println("  ------------------------------------------------------------------------");
        writer.println("");
        writer.println("  type call_target_rom_type is array(0 to max(1, CALL_TARGETS-1))");
        writer.println("    of std_logic_vector (PROGRAM_SIZE_LD-1 downto 0);");
        writer.println("  constant call_target_rom : call_target_rom_type := (");
        if (callTargets.size() == 0) {
            writer.println("    (others => '0'), (others => '0')");
        }
        int i2 = 0;
        while (i2 < callTargets.size()) {
            writer.println("    \"" + Converter.toBinaryString(callTargets.get(i2).getFirst(), PROGRAM_SIZE_LD) + "\"" + (i2 < callTargets.size() - 1 || callTargets.size() == 1 ? "," : " ") + " -- " + callTargets.get(i2).getSecond());
            ++i2;
        }
        if (callTargets.size() == 1) {
            writer.println("    \"" + Converter.toBinaryString(callTargets.get(0).getFirst(), PROGRAM_SIZE_LD) + "\"");
        }
        writer.println("  );");
        writer.println("");
        if (V2 == 0) {
            writer.println("  type repeat_constant_rom_type is array(0 to max(1, REPEAT_CONSTANTS-1))");
            writer.println("    of std_logic_vector (REPEAT_CONSTANT_BITS-1 downto 0);");
            writer.println("  constant repeat_constant_rom : repeat_constant_rom_type := (");
            if (repeatConstants.size() == 0) {
                writer.println("    (others => '0'), (others => '0')");
            }
            i2 = 0;
            while (i2 < repeatConstants.size()) {
                writer.println("    \"" + Converter.toBinaryString(repeatConstants.get(i2) - 1, REPEAT_CONSTANT_BITS) + "\"" + (i2 < repeatConstants.size() - 1 || repeatConstants.size() == 1 ? "," : " ") + " -- " + repeatConstants.get(i2) + "-1");
                ++i2;
            }
            if (repeatConstants.size() == 1) {
                writer.println("    \"" + Converter.toBinaryString(repeatConstants.get(0) - 1, REPEAT_CONSTANT_BITS) + "\"");
            }
            writer.println("  );");
            writer.println("");
        }
        writer.println("  type skip_constant_rom_type is array(0 to max(1, SKIP_CONSTANTS-1))");
        writer.println("    of std_logic_vector (LOOP_COUNTER_BITS-1 downto 0);");
        writer.println("  constant skip_constant_rom : skip_constant_rom_type := (");
        if (skipConstants.size() == 0) {
            writer.println("    (others => '0'), (others => '0')");
        }
        i2 = 0;
        while (i2 < skipConstants.size()) {
            writer.println("    \"" + Converter.toBinaryString(skipConstants.get(i2).getFirst() + skipConstants.get(i2).getSecond(), LOOP_COUNTER_BITS) + "\"" + (i2 < skipConstants.size() - 1 || skipConstants.size() == 1 ? "," : " ") + " -- " + skipConstants.get(i2).getFirst());
            ++i2;
        }
        if (skipConstants.size() == 1) {
            writer.println("    \"" + Converter.toBinaryString(skipConstants.get(0).getFirst() + skipConstants.get(0).getSecond(), LOOP_COUNTER_BITS) + "\"");
        }
        writer.println("  );");
        writer.println("");
        writer.println("  type alu_constants_rom is array(0 to max(1, NUM_CONSTANTS*8-1))");
        writer.println("    of std_logic_vector(WORD_SIZE-1 downto 0);");
        writer.println("  constant ALU_CONSTANTS : alu_constants_rom := (");
        LinkedList<Constant> constants = ALUConstants.getList();
        if (constants.size() == 0) {
            writer.println("    (others => '0'), (others => '0'), (others => '0'), (others => '0'),");
            writer.println("    (others => '0'), (others => '0'), (others => '0'), (others => '0')");
        }
        int i3 = 0;
        while (i3 < constants.size()) {
            writer.println("    " + constants.get(i3).toVhdlString() + (i3 < constants.size() - 1 ? "," : " ") + " -- " + constants.get(i3).getName());
            ++i3;
        }
        writer.println("  );");
        writer.println("");
        writer.println("  type rotate_distances_rom is array(0 to ROTATE_VARIANTS) of integer;");
        writer.println("  constant ROTATE_DISTANCES : rotate_distances_rom := (");
        writer.println("      0,                    --   0");
        writer.println("    -32,                    -- -32 ... ROL32");
        writer.println("        NUM_ADDERS+1,       --   8 ... MUL");
        writer.println("     32-NUM_ADDERS-1,       --  24 ... WRSHR");
        if (MULT_CYCLES > 3) {
            writer.println("    -32+NUM_ADDERS+1" + (USE_ROL7 == 1 || USE_ROL8 == 1 || USE_ROL16 == 1 ? "," : " ") + "       -- -24 ... MUL256, SUBACC, ROL24");
        } else {
            writer.println("    -32+NUM_ADDERS+1,       -- -24 ... MUL256, SUBACC, ROL24");
        }
        if (MULT_CYCLES == 3) {
            writer.println("        NUM_ADDERS" + (USE_ROL7 == 1 || USE_ROL8 == 1 || USE_ROL16 == 1 ? "," : " ") + "          --   7 ... MUL256 -- necessary for MUL256, when CYCLES = 3");
        } else if (MULT_CYCLES == 2) {
            writer.println("    -64+NUM_ADDERS+1,       -- -56 ... MUL256 -- necessary for MUL256, when CYCLES = 2\n    WORD_SIZE,              --  32 ... MUL256 -- necessary for MUL256, when CYCLES = 2\n    WORD_SIZE+NUM_ADDERS+1" + (USE_ROL7 == 1 || USE_ROL8 == 1 || USE_ROL16 == 1 ? "," : " ") + " --  40 ... MUL256 -- necessary for MUL256, when CYCLES = 2");
        }
        if (USE_ROL8 == 1) {
            writer.println("       -NUM_ADDERS-1" + (USE_ROL7 == 1 ? "," : " ") + "       --  -8 ... ROL8");
        }
        if (USE_ROL16 == 1) {
            writer.println("    2*(-NUM_ADDERS-1)" + (USE_ROL7 == 1 ? "," : " ") + "       -- -16 ... ROL16");
        }
        if (USE_ROL7 == 1) {
            writer.println("      2,                    --   2 ... ROR2");
            writer.println("     30,                    --  30 ... ROR30");
            writer.println("     -7,                    --  -7 ... ROL7");
            writer.println("     -9,                    --  -9 ... ROL9");
            writer.println("    -13,                    -- -13 ... ROL13");
            writer.println("    -18                     -- -18 ... ROL18");
        }
        writer.println("  );");
        writer.println("");
        writer.println("  type external_adder_settings_rom_type is array(0 to max(1, ADDER_CONSTANTS-1))");
        writer.println("    of std_logic_vector(NUM_ADDERS downto 0);");
        writer.println("  constant external_adder_settings_rom : external_adder_settings_rom_type := (");
        if (adderConstants.size() == 0) {
            writer.println("    (others => '0'), (others => '0')");
        }
        i3 = 0;
        while (i3 < adderConstants.size()) {
            if (i3 == 0 && USE_CARRY_IN_AS0 == 1) {
                writer.println("    \"" + Converter.toBinaryString(adderConstants.get(i3), NUM_ADDERS + 1) + "\"" + (i3 < adderConstants.size() - 1 || adderConstants.size() == 1 ? "," : " ") + " -- C (USE_CARRY_IN_AS0)");
            } else {
                writer.println("    \"" + Converter.toBinaryString(adderConstants.get(i3), NUM_ADDERS + 1) + "\"" + (i3 < adderConstants.size() - 1 || adderConstants.size() == 1 ? "," : " ") + " -- " + adderConstants.get(i3));
            }
            ++i3;
        }
        if (adderConstants.size() == 1 && USE_CARRY_IN_AS0 == 1) {
            writer.println("    (others => '0')");
        } else if (adderConstants.size() == 1) {
            writer.println("    \"" + Converter.toBinaryString(adderConstants.get(0), NUM_ADDERS + 1) + "\"");
        }
        writer.println("  );");
        writer.println("");
        writer.println("  type controller_state_type is (S_WAIT, S_DO, S_MULT);");
        writer.println("");
        writer.println("  ------------------------------------------------------------------------");
        writer.println("");
        if (V2 == 0) {
            writer.println("  constant I_NOP       : std_logic_vector(3 downto 0) := \"0000\";");
            writer.println("  constant I_ROL32     : std_logic_vector(3 downto 0) := \"0001\";");
            writer.println("  constant I_BUFALU    : std_logic_vector(3 downto 0) := \"0010\";");
            writer.println("  constant I_BUF       : std_logic_vector(3 downto 0) := \"0011\";");
            writer.println("  constant I_RSTL      : std_logic_vector(3 downto 0) := \"0100\";");
            writer.println("  constant I_RST       : std_logic_vector(3 downto 0) := \"0101\";");
            writer.println("  constant I_CALC      : std_logic_vector(3 downto 0) := \"0110\";");
            writer.println("     constant I_ADD    : std_logic_vector(6 downto 0) := I_CALC & \"000\";     --inA      + inB[AS]");
            writer.println("     constant I_SUB    : std_logic_vector(6 downto 0) := I_CALC & \"100\";     --inA      - inB[AS]");
            writer.println("     constant I_ADDC   : std_logic_vector(6 downto 0) := I_CALC & \"010\";     --inA      + inB[AS] + c");
            writer.println("     constant I_SUBC   : std_logic_vector(6 downto 0) := I_CALC & \"110\";     --inA      - inB[AS] - c");
            writer.println("     constant I_ADDAE  : std_logic_vector(6 downto 0) := I_CALC & \"001\";     --accu     + inB[AS]");
            writer.println("     constant I_SUBAE  : std_logic_vector(6 downto 0) := I_CALC & \"101\";     --accu     - inB[AS]");
            writer.println("     constant I_SUBH   : std_logic_vector(6 downto 0) := I_CALC & \"111\";     --accu(35) - inB[AS] - c");
            writer.println("     constant I_SUBIAC : std_logic_vector(8 downto 0) := I_CALC & \"11111\";   --inB[1] - (~ carry in accu, when SC = 1)");
            writer.println("  constant I_COND      : std_logic_vector(3 downto 0) := \"0111\";");
            writer.println("     constant I_CALL   : std_logic_vector(4 downto 0) := I_COND & '0';");
            writer.println("     constant I_RET    : std_logic_vector(8 downto 0) := I_COND & \"11111\";   --RETURN");
            writer.println("     constant I_SWAP0  : std_logic_vector(8 downto 0) := I_COND & \"11000\";   --SWAP when selected_bit = 0");
            writer.println("     constant I_SWAP1  : std_logic_vector(8 downto 0) := I_COND & \"11001\";   --SWAP when selected_bit = 1");
            writer.println("     constant I_SWAPLC : std_logic_vector(8 downto 0) := I_COND & \"11100\";   --SWAP depending on V[LC-address]");
            writer.println("     constant I_LDCOMB : std_logic_vector(8 downto 0) := I_COND & \"11101\";   --loads comb-bits");
            writer.println("     constant I_SKIPB  : std_logic_vector(8 downto 0) := I_COND & \"11110\";   --SKIP when LC-Bit = 1");
            writer.println("     constant I_CMPI   : std_logic_vector(6 downto 0) := I_COND & \"100\";     --SKIP when LC = SC[i], INC LC anyway");
            writer.println("     constant I_CMPD   : std_logic_vector(6 downto 0) := I_COND & \"101\";     --SKIP when LC = SC[i], DEC LC anyway");
            writer.println("     constant I_INCLC  : std_logic_vector(8 downto 0) := I_COND & \"11010\";   --LC++");
            writer.println("     constant I_DECLC  : std_logic_vector(8 downto 0) := I_COND & \"11011\";   --LC--");
            writer.println("  constant I_SETSGN    : std_logic_vector(3 downto 0) := \"1000\";             --set sign of low part (without extra)");
            writer.println("  constant I_ROT       : std_logic_vector(4 downto 0) := \"10010\";");
            if (USE_ROL7 == 1) {
                writer.println("     constant I_ROR2   : std_logic_vector(8 downto 0) := I_ROT & \"" + ROR2_index + "\";");
            }
            if (USE_ROR8 == 1) {
                writer.println("     constant I_ROR8   : std_logic_vector(8 downto 0) := I_ROT & \"0010\";");
            }
            if (USE_ROL7 == 1) {
                writer.println("     constant I_ROR30  : std_logic_vector(8 downto 0) := I_ROT & \"" + ROR30_index + "\";");
                writer.println("     constant I_ROL7   : std_logic_vector(8 downto 0) := I_ROT & \"" + ROL7_index + "\";");
            }
            if (USE_ROL8 == 1) {
                writer.println("     constant I_ROL8   : std_logic_vector(8 downto 0) := I_ROT & \"" + ROL8_index + "\";");
            }
            if (USE_ROL7 == 1) {
                writer.println("     constant I_ROL9   : std_logic_vector(8 downto 0) := I_ROT & \"" + ROL9_index + "\";");
                writer.println("     constant I_ROL13  : std_logic_vector(8 downto 0) := I_ROT & \"" + ROL13_index + "\";");
            }
            if (USE_ROL16 == 1) {
                writer.println("     constant I_ROL16  : std_logic_vector(8 downto 0) := I_ROT & \"" + ROL16_index + "\";");
            }
            if (USE_ROL7 == 1) {
                writer.println("     constant I_ROL18  : std_logic_vector(8 downto 0) := I_ROT & \"" + ROL18_index + "\";");
            }
            if (USE_ROR24 == 1) {
                writer.println("     constant I_ROR24  : std_logic_vector(8 downto 0) := I_ROT & \"0011\";");
            }
            writer.println("     constant I_ROL24  : std_logic_vector(8 downto 0) := I_ROT & \"0100\";");
            writer.println("  constant I_MULT      : std_logic_vector(4 downto 0) := \"10011\";");
            writer.println("     constant I_MUL    : std_logic_vector(8 downto 0) := I_MULT & \"0000\";");
            writer.println("     constant I_MULNEG : std_logic_vector(8 downto 0) := I_MULT & \"0001\";");
            writer.println("     constant I_MUL256 : std_logic_vector(8 downto 0) := I_MULT & \"0010\";");
            writer.println("  constant I_WR        : std_logic_vector(3 downto 0) := \"1010\";");
            writer.println("  constant I_WRROR     : std_logic_vector(3 downto 0) := \"1011\";  --rotate in buffer and write into RAM");
            writer.println("  constant I_SETBA     : std_logic_vector(2 downto 0) := \"110\";");
            writer.println("  constant I_FLC       : std_logic_vector(3 downto 0) := \"1110\";  --fetch V[LC-adress] (must be buffered in next cycle)");
            writer.println("  constant I_EXTRA     : std_logic_vector(3 downto 0) := \"1111\";");
            writer.println("     constant I_HLT    : std_logic_vector(8 downto 0) := I_EXTRA & \"00000\";");
            writer.println("     constant I_SAVEC  : std_logic_vector(8 downto 0) := I_EXTRA & \"00001\"; --save carry");
            writer.println("     constant I_SAVECI : std_logic_vector(8 downto 0) := I_EXTRA & \"00010\"; --save carry inverted");
            writer.println("     constant I_SAVECX : std_logic_vector(8 downto 0) := I_EXTRA & \"00011\"; --xor carry to previous carry");
            writer.println("     constant I_SAVEOF : std_logic_vector(8 downto 0) := I_EXTRA & \"01010\"; --saves 3 overflow bits");
            writer.println("     constant I_UPDOF  : std_logic_vector(8 downto 0) := I_EXTRA & \"01011\"; --updates OF");
            writer.println("     constant I_RED    : std_logic_vector(8 downto 0) := I_EXTRA & \"01100\"; --add/sub depending on OF");
            writer.println("     constant I_REDC   : std_logic_vector(8 downto 0) := I_EXTRA & \"01101\"; --add/sub depending on OF + carry");
            writer.println("     constant I_AND    : std_logic_vector(8 downto 0) := I_EXTRA & \"00100\";");
            writer.println("     constant I_OR     : std_logic_vector(8 downto 0) := I_EXTRA & \"00101\";");
            writer.println("     constant I_XOR    : std_logic_vector(8 downto 0) := I_EXTRA & \"00110\";");
            writer.println("     constant I_SUBACC : std_logic_vector(8 downto 0) := I_EXTRA & \"00111\"; --inB[1] - accu");
            writer.println("     constant I_INCBA  : std_logic_vector(8 downto 0) := I_EXTRA & \"01000\";");
            writer.println("     constant I_DECBA  : std_logic_vector(8 downto 0) := I_EXTRA & \"01001\";");
            writer.println("     constant I_CMPSP  : std_logic_vector(7 downto 0) := I_EXTRA & \"0111\";  --skip when SP=sel_starting_point");
            writer.println("     constant I_REPEAT : std_logic_vector(4 downto 0) := I_EXTRA & '1';     --Repeat following instruction");
        } else {
            writer.println("  constant I_NOP        : std_logic_vector(3 downto 0) := \"0000\";");
            writer.println("  constant I_ROL32      : std_logic_vector(3 downto 0) := \"0001\";");
            writer.println("  constant I_LDC        : std_logic_vector(3 downto 0) := \"0010\";");
            writer.println("  constant I_LD         : std_logic_vector(3 downto 0) := \"0011\";");
            writer.println("  constant I_CLRL       : std_logic_vector(3 downto 0) := \"0100\";");
            writer.println("  constant I_CLR        : std_logic_vector(3 downto 0) := \"0101\";");
            writer.println("  constant I_CALC       : std_logic_vector(3 downto 0) := \"0110\";");
            writer.println("     constant I_MULADD  : std_logic_vector(6 downto 0) := I_CALC & \"000\";     --inA      + inB[AS]");
            writer.println("     constant I_MULSUB  : std_logic_vector(6 downto 0) := I_CALC & \"100\";     --inA      - inB[AS]");
            writer.println("     constant I_MULADDC : std_logic_vector(6 downto 0) := I_CALC & \"010\";     --inA      + inB[AS] + c");
            writer.println("     constant I_MULSUBC : std_logic_vector(6 downto 0) := I_CALC & \"110\";     --inA      - inB[AS] - c");
            writer.println("     constant I_MULACC  : std_logic_vector(6 downto 0) := I_CALC & \"001\";     --accu     + inB[AS]");
            writer.println("  constant I_COND      : std_logic_vector(3 downto 0) := \"0111\";");
            writer.println("     constant I_JMP    : std_logic_vector(4 downto 0) := I_COND & '0';");
            writer.println("     constant I_RET    : std_logic_vector(8 downto 0) := I_COND & \"11111\";   --RETURN");
            writer.println("     constant I_SW0    : std_logic_vector(8 downto 0) := I_COND & \"11000\";   --SWAP when selected_bit = 0");
            writer.println("     constant I_SW1    : std_logic_vector(8 downto 0) := I_COND & \"11001\";   --SWAP when selected_bit = 1");
            writer.println("     constant I_SWLC   : std_logic_vector(8 downto 0) := I_COND & \"11100\";   --SWAP depending on V[LC-address]");
            writer.println("     constant I_SLCI   : std_logic_vector(6 downto 0) := I_COND & \"100\";     --SKIP when LC = SC[i], INC LC anyway");
            writer.println("     constant I_SLCD   : std_logic_vector(6 downto 0) := I_COND & \"101\";     --SKIP when LC = SC[i], DEC LC anyway");
            writer.println("     constant I_INCLC  : std_logic_vector(8 downto 0) := I_COND & \"11010\";   --LC++");
            writer.println("     constant I_DECLC  : std_logic_vector(8 downto 0) := I_COND & \"11011\";   --LC--");
            writer.println("  constant I_ROT       : std_logic_vector(4 downto 0) := \"10010\";");
            if (USE_ROL7 == 1) {
                writer.println("     constant I_ROR2   : std_logic_vector(8 downto 0) := I_ROT & \"" + ROR2_index + "\";");
            }
            if (USE_ROR8 == 1) {
                writer.println("     constant I_RORW   : std_logic_vector(8 downto 0) := I_ROT & \"0010\";");
            }
            if (USE_ROL7 == 1) {
                writer.println("     constant I_ROR30  : std_logic_vector(8 downto 0) := I_ROT & \"" + ROR30_index + "\";");
                writer.println("     constant I_ROL7   : std_logic_vector(8 downto 0) := I_ROT & \"" + ROL7_index + "\";");
            }
            if (USE_ROL8 == 1) {
                writer.println("     constant I_ROLW   : std_logic_vector(8 downto 0) := I_ROT & \"" + ROL8_index + "\";");
            }
            if (USE_ROL7 == 1) {
                writer.println("     constant I_ROL9   : std_logic_vector(8 downto 0) := I_ROT & \"" + ROL9_index + "\";");
                writer.println("     constant I_ROL13  : std_logic_vector(8 downto 0) := I_ROT & \"" + ROL13_index + "\";");
            }
            if (USE_ROL16 == 1) {
                writer.println("     constant I_ROL16  : std_logic_vector(8 downto 0) := I_ROT & \"" + ROL16_index + "\";");
            }
            if (USE_ROL7 == 1) {
                writer.println("     constant I_ROL18  : std_logic_vector(8 downto 0) := I_ROT & \"" + ROL18_index + "\";");
            }
            if (USE_ROR24 == 1) {
                writer.println("     constant I_RORIW  : std_logic_vector(8 downto 0) := I_ROT & \"0011\";");
            }
            writer.println("     constant I_ROLIW  : std_logic_vector(8 downto 0) := I_ROT & \"0100\";");
            writer.println("  constant I_MULT      : std_logic_vector(4 downto 0) := \"10011\";");
            writer.println("     constant I_MUL    : std_logic_vector(8 downto 0) := I_MULT & \"0000\";");
            writer.println("     constant I_MUL256 : std_logic_vector(8 downto 0) := I_MULT & \"0010\";");
            writer.println("  constant I_ST        : std_logic_vector(3 downto 0) := \"1010\";");
            writer.println("  constant I_STR       : std_logic_vector(3 downto 0) := \"1011\";  --rotate in buffer and write into RAM");
            writer.println("  constant I_MPS       : std_logic_vector(2 downto 0) := \"110\";");
            writer.println("  constant I_FLC       : std_logic_vector(3 downto 0) := \"1110\";  --fetch V[LC-adress] (must be buffered in next cycle)");
            writer.println("  constant I_EXTRA     : std_logic_vector(3 downto 0) := \"1111\";");
            writer.println("     constant I_HLT    : std_logic_vector(8 downto 0) := I_EXTRA & \"00000\";");
            writer.println("     constant I_STC    : std_logic_vector(8 downto 0) := I_EXTRA & \"00001\"; --save carry");
            writer.println("     constant I_STI    : std_logic_vector(8 downto 0) := I_EXTRA & \"00010\"; --save carry inverted");
            writer.println("     constant I_STX    : std_logic_vector(8 downto 0) := I_EXTRA & \"00011\"; --xor carry to previous carry");
            writer.println("     constant I_AND    : std_logic_vector(8 downto 0) := I_EXTRA & \"00100\";");
            writer.println("     constant I_OR     : std_logic_vector(8 downto 0) := I_EXTRA & \"00101\";");
            writer.println("     constant I_EOR    : std_logic_vector(8 downto 0) := I_EXTRA & \"00110\";");
            writer.println("     constant I_MPI    : std_logic_vector(8 downto 0) := I_EXTRA & \"01000\";");
            writer.println("     constant I_MPD    : std_logic_vector(8 downto 0) := I_EXTRA & \"01001\";");
            writer.println("     constant I_SFID   : std_logic_vector(7 downto 0) := I_EXTRA & \"0111\";  --skip when SP=sel_starting_point");
        }
        writer.println("");
        writer.println("  ------------------------------------------------------------------------");
        writer.println("");
        writer.println("  type base_adress_rom_type is array(0 to ADDRESS_PAGE_SIZE*ADDRESS_PAGES*4-1)");
        writer.println("    of std_logic_vector (ADDRESS_WIDTH-4 downto 0);");
        writer.println("  constant base_adress_rom : base_adress_rom_type := (");
        LinkedList<LinkedList<String>> usageIDS = Registers.getAddressTable();
        int i4 = 0;
        while (i4 < usageIDS.size()) {
            LinkedList<String> currentSet = usageIDS.get(i4);
            int j = 0;
            while (j < currentSet.size()) {
                String currentName = currentSet.get(j);
                if (currentName.equals("*")) {
                    String s = "\"";
                    while (s.length() <= ADDRESS_WIDTH - 3) {
                        s = String.valueOf(s) + "-";
                    }
                    writer.println("    " + s + "\"" + (i4 == usageIDS.size() - 1 && j == currentSet.size() - 1 ? "" : ","));
                } else {
                    writer.println("    \"" + Converter.toBinaryString(Registers.getRegisterID(currentName), ADDRESS_WIDTH - 3) + "\"" + (i4 == usageIDS.size() - 1 && j == currentSet.size() - 1 ? " " : ",") + " -- " + currentName);
                }
                ++j;
            }
            if (i4 < usageIDS.size() - 1) {
                writer.println("");
            }
            ++i4;
        }
        writer.println("  );");
        writer.println("");
        writer.println("  type start_point_rom_type is array(0 to max(2, START_POINTS)-1) of std_logic_vector(PROGRAM_SIZE_LD downto 0);");
        writer.println("  constant start_point_rom : start_point_rom_type := (");
        if (startpoints.size() == 0) {
            writer.println("    (others => '0'), (others => '0')");
        }
        i4 = 0;
        while (i4 < startpoints.size()) {
            if (startpoints.get(i4) == null) {
                writer.println("    (others => '0')" + (i4 < startpoints.size() - 1 ? "," : " "));
            } else {
                Pair<Integer, Integer> entry = functionOffsetList.get(startpoints.get(i4).getText());
                writer.println("    " + (entry.getSecond() == 0 ? "'0' & \"" : "'1' & \"") + Converter.toBinaryString(entry.getFirst(), PROGRAM_SIZE_LD) + (i4 < START_POINTS - 1 ? "\"," : "\" ") + " -- " + startpoints.get(i4).getText());
            }
            ++i4;
        }
        if (startpoints.size() == 1) {
            writer.println("    (others => '0')");
        }
        writer.println("  );");
        writer.println("");
        writer.println("  type start_point_constant_rom_type is array(0 to max(2, START_POINT_CONSTANTS)-1) of std_logic_vector(START_POINTS_LD-1 downto 0);");
        writer.println("  constant start_point_constant_rom : start_point_constant_rom_type := (");
        if (START_POINT_CONSTANTS == 0) {
            writer.println("    (others => '0'), (others => '0')");
        }
        i4 = 0;
        while (i4 < START_POINT_CONSTANTS) {
            writer.println("    \"" + Converter.toBinaryString(startingConstants.get(i4), START_POINTS_LD) + (i4 < START_POINT_CONSTANTS - 1 || START_POINT_CONSTANTS == 1 ? "\"," : "\" "));
            ++i4;
        }
        if (START_POINT_CONSTANTS == 1) {
            writer.println("    (others => '0')");
        }
        writer.println("  );");
        writer.println("");
        writer.println("  ------------------------------------------------------------------------");
        writer.println("  constant TESTCASES        : integer := " + TESTCASES + ";");
        writer.println("  constant TESTCASES_LD     : integer := log2ceil(TESTCASES);");
        writer.println("  constant INPUT_VALUES     : integer := " + TEST_INPUTS + ";");
        writer.println("  constant INPUT_VALUES_LD  : integer := log2ceil(INPUT_VALUES*8);");
        writer.println("  constant OUTPUT_VALUES    : integer := " + TEST_OUTPUTS + ";");
        writer.println("  constant OUTPUT_VALUES_LD : integer := log2ceil(OUTPUT_VALUES*8);");
        writer.println("  constant COUNTER_WIDTH    : integer := max(log2ceil(INPUT_VALUES*8), log2ceil(OUTPUT_VALUES*8+1));");
        writer.println("");
        writer.println("  type test_start_point_rom_type is array(0 to max(2, TESTCASES)-1) of std_logic_vector(START_POINTS_LD-1 downto 0);");
        writer.println("  constant test_start_point_rom : test_start_point_rom_type := (");
        if (TESTCASES == 0) {
            writer.println("    (others => '0'), (others => '0')");
        }
        int j = 0;
        while (j < TESTCASES) {
            writer.println("    \"" + Converter.toBinaryString(ConstantCollection.testcases.get((int)j).start_point, START_POINTS_LD) + (j < TESTCASES - 1 || TESTCASES == 1 ? "\"," : "\""));
            ++j;
        }
        if (TESTCASES == 1) {
            writer.println("    (others => '0')");
        }
        writer.println("  );");
        writer.println("");
        writer.println("  type input_data_rom_type is array(0 to max(1, INPUT_VALUES*TESTCASES)*8-1) of std_logic_vector(WORD_SIZE-1 downto 0);");
        writer.println("  constant input_data_rom : input_data_rom_type := (");
        if (TESTCASES == 0) {
            writer.println("    (others => '0'), (others => '0'), (others => '0'), (others => '0'),");
            writer.println("    (others => '0'), (others => '0'), (others => '0'), (others => '0')");
        }
        j = 0;
        while (j < TESTCASES) {
            testcase = testcases.get(j);
            i = 0;
            while (i < TEST_INPUTS) {
                writer.println("    " + testcase.testInput.get(i).getFirst().toVhdlString() + (i < TEST_INPUTS - 1 || j < TESTCASES - 1 ? "," : " ") + " -- " + testcase.testInput.get(i).getFirst().getName());
                ++i;
            }
            ++j;
        }
        writer.println("  );");
        writer.println("");
        writer.println("  type input_address_rom_type is array(0 to max(2, INPUT_VALUES*TESTCASES)-1) of std_logic_vector(ADDRESS_WIDTH-4 downto 0);");
        writer.println("  constant input_address_rom : input_address_rom_type := (");
        if (TESTCASES == 0) {
            writer.println("    (others => '0'), (others => '0')");
        }
        j = 0;
        while (j < TESTCASES) {
            testcase = testcases.get(j);
            i = 0;
            while (i < TEST_INPUTS) {
                writer.println("    \"" + Converter.toBinaryString(testcase.testInput.get(i).getSecond(), ADDRESS_WIDTH - 3) + "\"" + (j < TESTCASES - 1 || i < TEST_INPUTS - 1 || TESTCASES == 1 && TEST_INPUTS == 1 ? "," : " ") + " -- " + testcase.testInput.get(i).getFirst().getName());
                ++i;
            }
            ++j;
        }
        if (TESTCASES == 1 && TEST_INPUTS == 1) {
            writer.println("    (others => '0')");
        }
        writer.println("  );");
        writer.println("");
        writer.println("  type output_data_rom_type is array(0 to max(1, OUTPUT_VALUES*TESTCASES)*8) of std_logic_vector(WORD_SIZE-1 downto 0);");
        writer.println("  constant output_data_rom : output_data_rom_type := (");
        writer.println("    X\"00000000\", --FETCHING");
        if (TESTCASES == 0) {
            writer.println("    (others => '0'), (others => '0'), (others => '0'), (others => '0'),");
            writer.println("    (others => '0'), (others => '0'), (others => '0'), (others => '0')");
        }
        j = 0;
        while (j < TESTCASES) {
            testcase = testcases.get(j);
            i = 0;
            while (i < TEST_OUTPUTS) {
                writer.println("    " + testcase.testOutput.get(i).getFirst().toVhdlString() + (i < TEST_OUTPUTS - 1 || j < TESTCASES - 1 ? "," : " ") + " -- " + testcase.testOutput.get(i).getFirst().getName());
                ++i;
            }
            ++j;
        }
        writer.println("  );");
        writer.println("");
        writer.println("  type output_address_rom_type is array(0 to max(2, OUTPUT_VALUES*TESTCASES)-1) of std_logic_vector(ADDRESS_WIDTH-4 downto 0);");
        writer.println("  constant output_address_rom : output_address_rom_type := (");
        if (TESTCASES == 0) {
            writer.println("    (others => '0'), (others => '0')");
        }
        j = 0;
        while (j < TESTCASES) {
            testcase = testcases.get(j);
            i = 0;
            while (i < TEST_OUTPUTS) {
                writer.println("    \"" + Converter.toBinaryString(testcase.testOutput.get(i).getSecond(), ADDRESS_WIDTH - 3) + "\"" + (j < TESTCASES - 1 || i < TEST_OUTPUTS - 1 || TEST_OUTPUTS == 1 ? "," : " ") + " -- " + testcase.testOutput.get(i).getFirst().getName());
                ++i;
            }
            ++j;
        }
        if (TESTCASES == 1 && TEST_OUTPUTS == 1) {
            writer.println("    (others => '0')");
        }
        writer.println("  );");
        writer.println("");
        writer.println("end;");
        writer.println("");
        writer.println("package body nacl_constants is");
        writer.println("");
        writer.println("  function log2ceil (n : natural) return natural is");
        writer.println("    variable n_bit : unsigned(31 downto 0);");
        writer.println("  begin");
        writer.println("    if n = 0 then");
        writer.println("      return 0;");
        writer.println("    end if;");
        writer.println("    n_bit := to_unsigned(n-1,32);");
        writer.println("    for i in 31 downto 0 loop");
        writer.println("      if n_bit(i) = '1' then");
        writer.println("        return i+1;");
        writer.println("      end if;");
        writer.println("    end loop;");
        writer.println("    return 1;");
        writer.println("  end log2ceil;");
        writer.println("");
        writer.println("  function max (a, b : natural) return natural is");
        writer.println("  begin");
        writer.println("    if a > b then");
        writer.println("      return a;");
        writer.println("    else");
        writer.println("      return b;");
        writer.println("    end if;");
        writer.println("  end max;");
        writer.println("");
        writer.println("end nacl_constants;");
        writer.println("");
        writer.close();
    }

    private static class TestCase {
        int start_point = 0;
        LinkedList<Pair<Constant, Integer>> testInput = new LinkedList();
        LinkedList<Pair<Constant, Integer>> testOutput = new LinkedList();

        private TestCase() {
        }
    }
}

