/*
 * Decompiled with CFR 0.152.
 */
package tokens.datastructures;

import java.util.LinkedList;
import org.antlr.runtime.Token;
import parser.ErrorList;
import tokens.TokenPosition;
import tokens.datastructures.ConstantCollection;
import utils.Pair;
import utils.Printer;

public class Registers {
    private static LinkedList<Pair<String, Boolean>> registers = new LinkedList();
    private static LinkedList<Pair<LinkedList<String>, Integer>> usageList = new LinkedList();
    private static LinkedList<LinkedList<String>> addressTable = new LinkedList();

    public static void addRegisterFirst(Token name) {
        if (registers.size() == 0) {
            registers.add(new Pair<String, Boolean>(name.getText(), false));
        } else {
            String s = name.getText();
            int i = 1;
            while (i < registers.size()) {
                if (registers.get(i).equals(s)) {
                    ErrorList.addError("@" + new TokenPosition(name) + " - register name duplicated!");
                    return;
                }
                ++i;
            }
            registers.set(0, new Pair<String, Boolean>(s, false));
        }
        ++ConstantCollection.NUM_REGISTERS;
    }

    public static void addRegister(Token name) {
        Registers.addConstantName(name);
        ++ConstantCollection.NUM_REGISTERS;
    }

    public static void addConstantName(Token name) {
        String s = name.getText();
        if (registers.size() == 0) {
            registers.add(new Pair<String, Boolean>("", false));
        }
        int i = 1;
        while (i < registers.size()) {
            if (registers.get(i).equals(s)) {
                ErrorList.addError("@" + new TokenPosition(name) + " - register name duplicated!");
                return;
            }
            ++i;
        }
        registers.add(new Pair<String, Boolean>(s, false));
    }

    public static int addUsage(LinkedList<String> variables, TokenPosition position) {
        LinkedList cpy = (LinkedList)variables.clone();
        usageList.add(new Pair<LinkedList, Integer>(cpy, 0));
        int i = 0;
        while (i < variables.size()) {
            boolean found = false;
            String name = variables.get(i);
            if (!name.equals("*")) {
                int j = 0;
                while (j < registers.size()) {
                    if (registers.get(j).getFirst().equals(name)) {
                        registers.get(j).setSecond(true);
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    ErrorList.addError("@" + position + " - register name \"" + name + "\" unknown!");
                }
            }
            ++i;
        }
        return usageList.size() - 1;
    }

    public static void generateAddressTable() {
        LinkedList<String> entry0 = usageList.get(0).getFirst();
        while (entry0.size() < ConstantCollection.ADDRESS_PAGE_SIZE) {
            entry0.add("*");
        }
        addressTable.add(entry0);
        ++ConstantCollection.ADDRESS_PAGES;
        usageList.get(0).setSecond(0);
        int length = ConstantCollection.ADDRESS_PAGE_SIZE;
        while (length > 0) {
            int i = 1;
            while (i < usageList.size()) {
                LinkedList<String> listNew = usageList.get(i).getFirst();
                if (listNew.size() == length) {
                    if (addressTable.size() == 0) {
                        addressTable.add(listNew);
                        ++ConstantCollection.ADDRESS_PAGES;
                        usageList.get(i).setSecond(0);
                    } else {
                        boolean found = false;
                        int j = 0;
                        while (j < addressTable.size() && !found) {
                            LinkedList<String> listCmp = addressTable.get(j);
                            int diff = ConstantCollection.ADDRESS_PAGE_SIZE - length;
                            int o = 0;
                            while (o <= diff && !found) {
                                String regCmp;
                                String regNew;
                                boolean equal = true;
                                int l = 0;
                                while (l < length && equal) {
                                    regNew = listNew.get(l);
                                    if (!(regNew.equals("*") || (regCmp = listCmp.get(l + o)).equals("*") || regCmp.equals(regNew))) {
                                        equal = false;
                                    }
                                    ++l;
                                }
                                if (equal) {
                                    l = 0;
                                    while (l < length) {
                                        regNew = listNew.get(l);
                                        regCmp = listCmp.get(l + o);
                                        if (regCmp.equals("*")) {
                                            listCmp.set(l + o, regNew);
                                        }
                                        ++l;
                                    }
                                    found = true;
                                    usageList.get(i).setSecond((j * ConstantCollection.ADDRESS_PAGE_SIZE + o) / 4);
                                }
                                o += 4;
                            }
                            ++j;
                        }
                        if (!found) {
                            if (length == ConstantCollection.ADDRESS_PAGE_SIZE) {
                                addressTable.add(listNew);
                                ++ConstantCollection.ADDRESS_PAGES;
                                usageList.get(i).setSecond((addressTable.size() - 1) * ConstantCollection.ADDRESS_PAGE_SIZE / 4);
                            } else {
                                boolean added = false;
                                int j2 = 0;
                                while (j2 < addressTable.size() && !added) {
                                    LinkedList<String> list = addressTable.get(j2);
                                    int diff = ConstantCollection.ADDRESS_PAGE_SIZE - length;
                                    int o = 0;
                                    while (o <= diff && !added) {
                                        int count = 0;
                                        int l = 0;
                                        while (l < length) {
                                            if (!list.get(l + o).equals("*")) break;
                                            ++count;
                                            ++l;
                                        }
                                        if (count == length) {
                                            l = 0;
                                            while (l < length) {
                                                list.set(l + o, listNew.get(l));
                                                ++l;
                                            }
                                            usageList.get(i).setSecond((j2 * ConstantCollection.ADDRESS_PAGE_SIZE + o) / 4);
                                            added = true;
                                        }
                                        o += 4;
                                    }
                                    ++j2;
                                }
                                if (!added) {
                                    while (listNew.size() < ConstantCollection.ADDRESS_PAGE_SIZE) {
                                        listNew.add("*");
                                    }
                                    addressTable.add(listNew);
                                    ++ConstantCollection.ADDRESS_PAGES;
                                    usageList.get(i).setSecond((addressTable.size() - 1) * ConstantCollection.ADDRESS_PAGE_SIZE / 4);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            length -= 4;
        }
        if (ConstantCollection.ADDRESS_PAGES > 64) {
            ErrorList.addError("@0 - ADDRESS_PAGES is too big (" + ConstantCollection.ADDRESS_PAGES + ")!");
        }
    }

    public static int getBaseAddress(int usageID) {
        return usageList.get(usageID).getSecond();
    }

    public static int getRegisterID(String name) {
        int i = 0;
        while (i < registers.size()) {
            if (registers.get(i).getFirst().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static LinkedList<LinkedList<String>> getAddressTable() {
        return addressTable;
    }

    public static void check() {
        int i = 0;
        while (i < registers.size()) {
            if (!registers.get(i).getSecond().booleanValue()) {
                ErrorList.addWarning("register \"" + registers.get(i).getFirst() + "\" is not used!");
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void printList() {
        void var0_1;
        Printer.print("Registers:", 0);
        boolean bl = false;
        while (var0_1 < registers.size()) {
            if (registers.get((int)var0_1).getFirst().length() > 0) {
                Printer.print(String.valueOf(registers.get((int)var0_1).getFirst()) + " = " + (int)var0_1, 1);
            }
            ++var0_1;
        }
        Printer.print("Register Usage:", 0);
        for (LinkedList linkedList : addressTable) {
            String s = "";
            for (String u : linkedList) {
                s = String.valueOf(s) + u + " ";
            }
            Printer.print(s, 1);
        }
    }
}

