/*
 * Decompiled with CFR 0.152.
 */
package tokens.instructions;

import java.io.PrintWriter;
import java.util.LinkedList;
import org.antlr.runtime.Token;
import tokens.Instruction;
import tokens.InstructionList;
import tokens.Program;
import tokens.datastructures.ConstantCollection;
import tokens.datastructures.Macro;
import tokens.instructions.InstructionSpecification;
import tokens.instructions.InstructionUSE;
import tokens.instructions.InstructionWithParameter;
import utils.Converter;

public class InstructionMACRO
extends InstructionSpecification {
    private Token name;
    private LinkedList<Token> parameters = new LinkedList();
    private InstructionUSE instructionUSE;
    private InstructionWithParameter instructionCALL;
    private InstructionList function;
    private boolean hideUse = false;
    private int romID = ConstantCollection.PROGRAM_ROMS - 1;

    public void define(Token name, Token parameter0) {
        this.name = name;
        this.parameters.addFirst(parameter0);
    }

    public void addParameter(Token parameter) {
        this.parameters.add(parameter);
    }

    public void setInstructionList(InstructionList function) {
        this.function = function;
    }

    public void hideUse() {
        this.hideUse = true;
    }

    @Override
    public String toString() {
        if (this.hideUse) {
            return this.instructionUSE.toString();
        }
        return String.valueOf(this.instructionUSE.toString()) + "; " + this.instructionCALL.toString();
    }

    public InstructionUSE getUse() {
        return this.instructionUSE;
    }

    public void resolveMacro(Program program) {
        Macro macro = program.getMacro(this.name);
        if (macro == null) {
            return;
        }
        LinkedList<Token> parameters = macro.getParameters();
        this.instructionUSE = new InstructionUSE();
        for (Token parameter : parameters) {
            String p = parameter.getText();
            if (p.startsWith("#")) {
                int ID = Converter.intFromString(p.substring(1));
                this.instructionUSE.addVariable(this.parameters.get(ID - 1).getText());
                continue;
            }
            this.instructionUSE.addVariable(p);
        }
        this.instructionUSE.completeInitialization(parameters.getFirst());
        this.instructionUSE.setInstructionList(this.function);
        this.instructionCALL = new InstructionWithParameter(Instruction.Type.CALL, macro.getCallTarget());
        this.instructionCALL.setRomID(this.romID);
        if (this.hideUse) {
            this.function.increaseLength(-1);
            if (this.romID == 0) {
                --ConstantCollection.PROGRAM_SIZE0;
            } else {
                --ConstantCollection.PROGRAM_SIZE1;
            }
        }
    }

    @Override
    public void check() {
        if (this.instructionUSE == null) {
            return;
        }
        this.instructionUSE.check();
        this.instructionCALL.check();
    }

    public void prepareForWriting(Program program) {
        if (this.instructionUSE == null) {
            return;
        }
        this.instructionUSE.prepareForWriting();
    }

    @Override
    public void writeVHDLCode(PrintWriter writer, boolean last) {
        if (this.hideUse) {
            writer.println("--  I_SETBA  & \"000000\",");
        } else {
            this.instructionUSE.writeVHDLCode(writer, false);
        }
        this.instructionCALL.writeVHDLCode(writer, last);
    }
}

