/*
 * Decompiled with CFR 0.152.
 */
package tokens.instructions;

import java.io.PrintWriter;
import tokens.Instruction;
import tokens.datastructures.ConstantCollection;

public abstract class InstructionSpecification {
    public abstract String toString();

    public abstract void writeVHDLCode(PrintWriter var1, boolean var2);

    public abstract void check();

    public String typeToString(Instruction.Type type) {
        if (ConstantCollection.V2 == 0) {
            return type.toString();
        }
        switch (type) {
            case BUF: {
                return "LD";
            }
            case RST: {
                return "CLR";
            }
            case RSTL: {
                return "CLRL";
            }
            case BUFALU: {
                return "LDC";
            }
            case WR: {
                return "ST";
            }
            case WRROR: {
                return "STR";
            }
            case ADD: {
                return "MULADD";
            }
            case ADDC: {
                return "MULADDC";
            }
            case SUB: {
                return "MULSUB";
            }
            case SUBC: {
                return "MULSUBC";
            }
            case ADDAE: {
                return "MULACC";
            }
            case XOR: {
                return "EOR";
            }
            case SAVEC: {
                return "STC";
            }
            case SAVECI: {
                return "STI";
            }
            case SAVECX: {
                return "STX";
            }
            case ROR8: {
                return "RORW";
            }
            case ROR24: {
                return "RORIW";
            }
            case ROL8: {
                return "ROLW";
            }
            case ROL24: {
                return "ROLIW";
            }
            case CALL: {
                return "JMP";
            }
            case CMPI: {
                return "SLCI";
            }
            case CMPD: {
                return "SLCD";
            }
            case CMPSP: {
                return "SFID";
            }
            case SWAP0: {
                return "SW0";
            }
            case SWAP1: {
                return "SW1";
            }
            case SWAPLC: {
                return "SWLC";
            }
            case INCBA: {
                return "MPI";
            }
            case DECBA: {
                return "MPD";
            }
        }
        return type.toString();
    }
}

