/*
 * Decompiled with CFR 0.152.
 */
package tokens.instructions;

import java.io.PrintWriter;
import java.util.LinkedList;
import org.antlr.runtime.Token;
import tokens.InstructionList;
import tokens.TokenPosition;
import tokens.datastructures.ConstantCollection;
import tokens.datastructures.Registers;
import tokens.instructions.InstructionSpecification;
import utils.Converter;

public class InstructionUSE
extends InstructionSpecification {
    private LinkedList<String> variables = new LinkedList();
    private Token u01;
    private int usageID;
    private int ID;
    private int PS;
    private InstructionList function;
    private int romID;

    public InstructionUSE() {
        this.romID = ConstantCollection.PROGRAM_ROMS - 1;
    }

    public InstructionUSE(Token u01, Token u02, Token u03, Token u04) {
        this.variables.add(u01.getText());
        this.variables.add(u02.getText());
        this.variables.add(u03.getText());
        this.variables.add(u04.getText());
        this.romID = ConstantCollection.PROGRAM_ROMS - 1;
        this.u01 = u01;
    }

    public InstructionUSE(Token u01, Token u02, Token u03, Token u04, Token u05, Token u06, Token u07, Token u08) {
        this.variables.add(u01.getText());
        this.variables.add(u02.getText());
        this.variables.add(u03.getText());
        this.variables.add(u04.getText());
        this.variables.add(u05.getText());
        this.variables.add(u06.getText());
        this.variables.add(u07.getText());
        this.variables.add(u08.getText());
        this.romID = ConstantCollection.PROGRAM_ROMS - 1;
        this.u01 = u01;
    }

    public InstructionUSE(Token u01, Token u02, Token u03, Token u04, Token u05, Token u06, Token u07, Token u08, Token u09, Token u10, Token u11, Token u12) {
        this.variables.add(u01.getText());
        this.variables.add(u02.getText());
        this.variables.add(u03.getText());
        this.variables.add(u04.getText());
        this.variables.add(u05.getText());
        this.variables.add(u06.getText());
        this.variables.add(u07.getText());
        this.variables.add(u08.getText());
        this.variables.add(u09.getText());
        this.variables.add(u10.getText());
        this.variables.add(u11.getText());
        this.variables.add(u12.getText());
        this.romID = ConstantCollection.PROGRAM_ROMS - 1;
        this.u01 = u01;
    }

    public InstructionUSE(Token u01, Token u02, Token u03, Token u04, Token u05, Token u06, Token u07, Token u08, Token u09, Token u10, Token u11, Token u12, Token u13, Token u14, Token u15, Token u16) {
        this.variables.add(u01.getText());
        this.variables.add(u02.getText());
        this.variables.add(u03.getText());
        this.variables.add(u04.getText());
        this.variables.add(u05.getText());
        this.variables.add(u06.getText());
        this.variables.add(u07.getText());
        this.variables.add(u08.getText());
        this.variables.add(u09.getText());
        this.variables.add(u10.getText());
        this.variables.add(u11.getText());
        this.variables.add(u12.getText());
        this.variables.add(u13.getText());
        this.variables.add(u14.getText());
        this.variables.add(u15.getText());
        this.variables.add(u16.getText());
        this.romID = ConstantCollection.PROGRAM_ROMS - 1;
        this.u01 = u01;
    }

    public void addVariable(String name) {
        this.variables.add(name);
    }

    public void registerUsage() {
        this.usageID = Registers.addUsage(this.variables, new TokenPosition(this.u01));
        if (ConstantCollection.ADDRESS_PAGE_SIZE < this.variables.size()) {
            ConstantCollection.ADDRESS_PAGE_SIZE = this.variables.size();
        }
    }

    public void completeInitialization(Token u01) {
        this.usageID = Registers.addUsage(this.variables, new TokenPosition(u01));
        if (ConstantCollection.ADDRESS_PAGE_SIZE < this.variables.size()) {
            ConstantCollection.ADDRESS_PAGE_SIZE = this.variables.size();
        }
    }

    public void setInstructionList(InstructionList function) {
        this.function = function;
    }

    public int getID() {
        return this.ID;
    }

    @Override
    public String toString() {
        this.ID = Registers.getBaseAddress(this.usageID);
        String s = "USE     " + this.variables.getFirst();
        int i = 1;
        while (i < this.variables.size()) {
            s = String.valueOf(s) + ", " + this.variables.get(i);
            ++i;
        }
        s = String.valueOf(s) + "  ";
        while (s.length() < 25) {
            s = String.valueOf(s) + " ";
        }
        return String.valueOf(s) + "//BA[" + this.ID + "]";
    }

    @Override
    public void check() {
    }

    public void prepareForWriting() {
        this.ID = Registers.getBaseAddress(this.usageID);
        this.PS = ConstantCollection.ADDRESS_PAGE_SIZE / 4;
        if (this.PS == 1) {
            return;
        }
        if (this.ID % this.PS == 3 && this.ID + 1 == ConstantCollection.ADDRESS_PAGES * 4) {
            ConstantCollection.USE_INCBA = 1;
            this.function.increaseLength(3);
            if (this.romID == 0) {
                ConstantCollection.PROGRAM_SIZE0 += 3;
            } else {
                ConstantCollection.PROGRAM_SIZE1 += 3;
            }
        } else if (this.ID % this.PS == 1 || this.ID % this.PS == 3) {
            ConstantCollection.USE_INCBA = 1;
            this.function.increaseLength(1);
            if (this.romID == 0) {
                ++ConstantCollection.PROGRAM_SIZE0;
            } else {
                ++ConstantCollection.PROGRAM_SIZE1;
            }
        } else if (this.ID % this.PS == 2) {
            ConstantCollection.USE_INCBA = 1;
            this.function.increaseLength(2);
            if (this.romID == 0) {
                ConstantCollection.PROGRAM_SIZE0 += 2;
            } else {
                ConstantCollection.PROGRAM_SIZE1 += 2;
            }
        }
    }

    @Override
    public void writeVHDLCode(PrintWriter writer, boolean last) {
        String i_decba;
        String i_setba = ConstantCollection.V2 == 0 ? "I_SETBA" : "I_MPS";
        String i_incba = ConstantCollection.V2 == 0 ? "I_INCBA" : "I_MPI";
        String string = i_decba = ConstantCollection.V2 == 0 ? "I_DECBA" : "I_MPD";
        if (this.ID % this.PS == 0) {
            writer.println("    " + i_setba + "  & \"" + Converter.toBinaryString(this.ID / this.PS, 6) + "\"" + (last ? "" : ","));
        } else if (this.ID % this.PS == 1) {
            writer.println("    " + i_setba + "  & \"" + Converter.toBinaryString(this.ID / this.PS, 6) + "\",");
            writer.println("    " + i_incba + (last ? "" : ","));
        } else if (this.ID % this.PS == 2) {
            writer.println("    " + i_setba + "  & \"" + Converter.toBinaryString(this.ID / this.PS, 6) + "\",");
            writer.println("    " + i_incba + ",");
            writer.println("    " + i_incba + (last ? "" : ","));
        } else if (this.ID % this.PS == 3 && this.ID + 1 == ConstantCollection.ADDRESS_PAGES * 4) {
            writer.println("    " + i_setba + "  & \"" + Converter.toBinaryString(this.ID / this.PS, 6) + "\",");
            writer.println("    " + i_incba + ",");
            writer.println("    " + i_incba + ",");
            writer.println("    " + i_incba + (last ? "" : ","));
        } else {
            int max = (int)Math.pow(2.0, Math.ceil(Math.log(ConstantCollection.ADDRESS_PAGES) / Math.log(2.0)));
            writer.println("    " + i_setba + "  & \"" + Converter.toBinaryString((this.ID / this.PS + 1) % max, 6) + "\",");
            writer.println("    " + i_decba + (last ? "" : ","));
        }
    }
}

