/*
 * Decompiled with CFR 0.152.
 */
package tokens.instructions;

import java.io.PrintWriter;
import tokens.Instruction;
import tokens.Variable;
import tokens.datastructures.ConstantCollection;
import tokens.instructions.InstructionSpecification;

public class InstructionWithFetch
extends InstructionSpecification {
    private Instruction.Type type;
    private Variable variable;

    public InstructionWithFetch(Instruction.Type type, Variable variable) {
        this.type = type;
        this.variable = variable;
        if (type == Instruction.Type.SETSGN) {
            ConstantCollection.USE_SETSGN = 1;
        }
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    @Override
    public String toString() {
        String s = this.typeToString(this.type);
        while (s.length() < 8) {
            s = String.valueOf(s) + " ";
        }
        if (this.variable != null) {
            s = String.valueOf(s) + "& FETCH " + this.variable;
        }
        return s;
    }

    @Override
    public void check() {
    }

    @Override
    public void writeVHDLCode(PrintWriter writer, boolean last) {
        String s = "    I_" + this.typeToString(this.type);
        while (s.length() < 13) {
            s = String.valueOf(s) + " ";
        }
        writer.println(String.valueOf(s) + "& " + this.variable.toVHDLString() + (last ? "" : ","));
    }
}

