/*
 * Decompiled with CFR 0.152.
 */
package tokens.instructions;

import java.io.PrintWriter;
import org.antlr.runtime.Token;
import parser.ErrorList;
import tokens.Instruction;
import tokens.TokenPosition;
import tokens.datastructures.CallTargets;
import tokens.datastructures.ConstantCollection;
import tokens.instructions.InstructionSpecification;
import utils.Converter;

public class InstructionWithParameter
extends InstructionSpecification {
    private Instruction.Type type;
    private Token parameter;
    private int ID;
    private int romID;

    public InstructionWithParameter(Instruction.Type type, Token parameter) {
        this.type = type;
        this.parameter = parameter;
        this.romID = ConstantCollection.PROGRAM_ROMS - 1;
        if (parameter == null) {
            ErrorList.addError("@" + new TokenPosition(parameter) + " - parameter required!");
            return;
        }
        if (type == Instruction.Type.CALL) {
            CallTargets.setCallingToken(parameter);
        } else if (type == Instruction.Type.REPEAT) {
            this.ID = ConstantCollection.addRepeatConstant(Converter.intFromString(parameter.getText()));
            ConstantCollection.USE_REPEAT = 1;
        } else if (type == Instruction.Type.CMPI) {
            this.ID = ConstantCollection.addSkipConstant(Converter.intFromString(parameter.getText()), 0);
            ConstantCollection.USE_LCPOS = 1;
        } else if (type == Instruction.Type.CMPD) {
            this.ID = ConstantCollection.addSkipConstant(Converter.intFromString(parameter.getText()), 0);
            ConstantCollection.USE_LCNEG = 1;
        } else if (type == Instruction.Type.CMPSP) {
            this.ID = ConstantCollection.addStartingConstant(parameter);
            ConstantCollection.USE_CMPSP = 1;
        } else if (type == Instruction.Type.ADD || type == Instruction.Type.SUB || type == Instruction.Type.ADDC || type == Instruction.Type.SUBC || type == Instruction.Type.ADDAE || type == Instruction.Type.SUBAE || type == Instruction.Type.SUBCC || type == Instruction.Type.SUBH) {
            this.ID = ConstantCollection.addAdderConstant(Converter.intFromString(parameter.getText()));
            if (type == Instruction.Type.SUBH) {
                ConstantCollection.USE_SUBH = 1;
            }
        }
    }

    public void setRomID(int romID) {
        this.romID = romID;
    }

    @Override
    public String toString() {
        String s = this.typeToString(this.type);
        while (s.length() < 8) {
            s = String.valueOf(s) + " ";
        }
        if (this.parameter != null) {
            s = String.valueOf(s) + this.parameter.getText();
        }
        if (this.type == Instruction.Type.CALL) {
            this.ID = CallTargets.getTargetID(this.parameter, this.romID);
            if (this.ID >= 0) {
                while (s.length() < 25) {
                    s = String.valueOf(s) + " ";
                }
                s = String.valueOf(s) + "//CT[" + this.ID + "]";
            }
        } else if (this.type == Instruction.Type.REPEAT) {
            if (this.ID >= 0) {
                while (s.length() < 25) {
                    s = String.valueOf(s) + " ";
                }
                s = String.valueOf(s) + "//RC[" + this.ID + "]";
            }
        } else if (this.type == Instruction.Type.CMPI || this.type == Instruction.Type.CMPD) {
            if (this.ID >= 0) {
                while (s.length() < 25) {
                    s = String.valueOf(s) + " ";
                }
                s = String.valueOf(s) + "//SC[" + this.ID + "]";
            }
        } else if ((this.type == Instruction.Type.ADD || this.type == Instruction.Type.SUB || this.type == Instruction.Type.ADDC || this.type == Instruction.Type.SUBC || this.type == Instruction.Type.ADDAE || this.type == Instruction.Type.SUBAE || this.type == Instruction.Type.SUBCC || this.type == Instruction.Type.SUBH) && this.ID >= 0) {
            while (s.length() < 25) {
                s = String.valueOf(s) + " ";
            }
            s = String.valueOf(s) + "//AS[" + this.ID + "]";
        }
        return s;
    }

    @Override
    public void check() {
        if (this.type == Instruction.Type.CALL) {
            this.ID = CallTargets.getTargetID(this.parameter, this.romID);
        }
        switch (this.type) {
            case CMPSP: {
                if (this.ID > 1) {
                    ErrorList.addError("@" + new TokenPosition(this.parameter) + " - Number of same parameters too big (>2)!");
                }
            }
            case ADD: 
            case SUB: 
            case ADDC: 
            case SUBC: 
            case ADDAE: 
            case SUBAE: 
            case SUBCC: 
            case SUBH: 
            case CMPI: 
            case CMPD: {
                if (this.ID <= 3) break;
                ErrorList.addError("@" + new TokenPosition(this.parameter) + " - Number of same parameters too big (>4)!");
                break;
            }
            case REPEAT: {
                if (this.ID <= 15) break;
                ErrorList.addError("@" + new TokenPosition(this.parameter) + " - Number of same parameters too big (>16)!");
                break;
            }
            case CALL: {
                if (ConstantCollection.V2 == 0 && this.ID > 15) {
                    ErrorList.addError("@" + new TokenPosition(this.parameter) + " - Number of same parameters too big (>16)!");
                    break;
                }
                if (this.ID <= 31) break;
                ErrorList.addError("@" + new TokenPosition(this.parameter) + " - Number of same parameters too big (>31)!");
                break;
            }
            default: {
                throw new RuntimeException("Invalid case!");
            }
        }
    }

    @Override
    public void writeVHDLCode(PrintWriter writer, boolean last) {
        String s = "    I_" + this.typeToString(this.type);
        while (s.length() < 13) {
            s = String.valueOf(s) + " ";
        }
        int parameter_length = 0;
        if (this.type == Instruction.Type.CALL) {
            this.ID = CallTargets.getTargetID(this.parameter, this.romID);
        }
        switch (this.type) {
            case CMPSP: {
                parameter_length = 1;
                break;
            }
            case ADD: 
            case SUB: 
            case ADDC: 
            case SUBC: 
            case ADDAE: 
            case SUBAE: 
            case SUBCC: 
            case SUBH: 
            case CMPI: 
            case CMPD: {
                parameter_length = 2;
                break;
            }
            case CALL: 
            case REPEAT: {
                parameter_length = 4;
                break;
            }
            default: {
                throw new RuntimeException("Invalid case!");
            }
        }
        writer.println(String.valueOf(s) + "& \"" + Converter.toBinaryString(this.ID, parameter_length) + "\"" + (last ? "" : ","));
    }
}

