/*
 * Decompiled with CFR 0.152.
 */
package tokens.instructions;

import java.io.PrintWriter;
import tokens.Instruction;
import tokens.datastructures.ConstantCollection;
import tokens.instructions.InstructionSpecification;

public class InstructionWithoutParameter
extends InstructionSpecification {
    private Instruction.Type type;

    public InstructionWithoutParameter(Instruction.Type type) {
        this.type = type;
        if (type == Instruction.Type.XOR || type == Instruction.Type.OR || type == Instruction.Type.AND) {
            ConstantCollection.USE_LOGIC = 1;
        } else if (type == Instruction.Type.MUL256) {
            ConstantCollection.USE_MUL256 = 1;
            if (ConstantCollection.MULT_CYCLES == 2) {
                ConstantCollection.ACCU_EXTENSION = 32;
            }
        } else if (type == Instruction.Type.INCBA || type == Instruction.Type.DECBA) {
            ConstantCollection.USE_INCBA = 1;
        } else if (type == Instruction.Type.SUBACC) {
            ConstantCollection.USE_SUBACC = 1;
        } else if (type == Instruction.Type.SUBIAC) {
            ConstantCollection.USE_SUBIAC = 1;
        } else if (type == Instruction.Type.MULNEG) {
            ConstantCollection.USE_MULNEG = 1;
        } else if (type == Instruction.Type.INCLC) {
            ConstantCollection.USE_LCPOS = 1;
        } else if (type == Instruction.Type.DECLC) {
            ConstantCollection.USE_LCNEG = 1;
        } else if (type == Instruction.Type.ROR2) {
            ConstantCollection.USE_ROL7 = 1;
        } else if (type == Instruction.Type.ROR8) {
            ConstantCollection.USE_ROR8 = 1;
        } else if (type == Instruction.Type.ROR30) {
            ConstantCollection.USE_ROL7 = 1;
        } else if (type == Instruction.Type.ROL7) {
            ConstantCollection.USE_ROL7 = 1;
        } else if (type == Instruction.Type.ROL8) {
            ConstantCollection.USE_ROL8 = 1;
        } else if (type == Instruction.Type.ROL9) {
            ConstantCollection.USE_ROL7 = 1;
        } else if (type == Instruction.Type.ROL13) {
            ConstantCollection.USE_ROL7 = 1;
        } else if (type == Instruction.Type.ROL16) {
            ConstantCollection.USE_ROL16 = 1;
        } else if (type == Instruction.Type.ROL18) {
            ConstantCollection.USE_ROL7 = 1;
        } else if (type == Instruction.Type.ROR24) {
            ConstantCollection.USE_ROR24 = 1;
        } else if (type == Instruction.Type.SAVEOF || type == Instruction.Type.RED || type == Instruction.Type.REDC || type == Instruction.Type.UPDOF) {
            ConstantCollection.USE_OVERFLOW = 1;
        } else if (type == Instruction.Type.SKIPB) {
            ConstantCollection.USE_SKIPB = 1;
        }
    }

    @Override
    public String toString() {
        return this.typeToString(this.type);
    }

    @Override
    public void check() {
    }

    @Override
    public void writeVHDLCode(PrintWriter writer, boolean last) {
        writer.println("    I_" + this.typeToString(this.type) + (last ? "" : ","));
    }
}

