/*
 * Decompiled with CFR 0.152.
 */
package utils;

import org.antlr.runtime.Token;
import parser.ErrorList;
import tokens.TokenPosition;

public class Converter {
    public static int intFromString(String value) {
        if (value.startsWith("0x")) {
            return Integer.parseInt(value.substring(2), 16);
        }
        return Integer.parseInt(value);
    }

    public static long longFromString(Token value) {
        String v = value.getText();
        long tmp = v.startsWith("0x") ? Long.parseLong(v.substring(2), 16) : Long.parseLong(v);
        if (tmp > 0xFFFFFFFFL) {
            ErrorList.addError(String.format("@" + new TokenPosition(value) + " - 0x%X has more than 32 bit!", tmp));
            return 0L;
        }
        return tmp;
    }

    public static String toBinaryString(int value, int length) {
        String s = Integer.toBinaryString(value);
        while (s.length() < length) {
            s = "0" + s;
        }
        return s;
    }

    public static String toDecimaleString(int value, int length) {
        String s = Integer.toString(value);
        while (s.length() < length) {
            s = " " + s;
        }
        return s;
    }
}

