
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_adder is
  generic (
    WIDTH: integer := 8
  );
  port (
    a    :  in std_logic_vector(WIDTH-1 downto 0);
    b    :  in std_logic_vector(WIDTH-1 downto 0);
    sum  : out std_logic_vector(WIDTH-1 downto 0);
    cin  :  in std_logic;
    cout : out std_logic
  );
end nacl_adder;

architecture behaviour of nacl_adder is

  signal carry   : std_logic_vector(WIDTH   downto 0);

  component nacl_fulladder
    port (
      a:     in std_logic;
      b:     in std_logic;
      cin:   in std_logic;
      sum:  out std_logic;
      cout: out std_logic);
  end component;

begin

  carry(0) <= cin;
  cout <= carry(WIDTH);

  adders: for i in 0 to WIDTH-1 generate
    adder: nacl_fulladder
       port map (
         a    => a(i),
         b    => b(i),
         cin  => carry(i),
         sum  => sum(i),
         cout => carry(i+1));
  end generate;

end;
