
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_adder_chain_adder is
  generic (
    WIDTH           : integer
  );
  port (
    en_adder        :  in std_logic;
    cout_prev       :  in std_logic;
    sum_prev        :  in std_logic_vector(WIDTH-1 downto 0);
    inB             :  in std_logic_vector(WIDTH-1 downto 0);
    sum             : out std_logic_vector(WIDTH-1 downto 0);
    sum0            : out std_logic;
    cout            : out std_logic
  );
end nacl_adder_chain_adder;

architecture behaviour of nacl_adder_chain_adder is

  signal a       : std_logic_vector(WIDTH-1 downto 0);
  signal b       : std_logic_vector(WIDTH-1 downto 0);
  signal b0      : std_logic_vector(WIDTH-1 downto 0);
  signal sum_int : std_logic_vector(WIDTH-1 downto 0);

begin

  b0 <= (others => en_adder);
  a  <= cout_prev & sum_prev(WIDTH-1 downto 1);
  b  <= inB and b0;

  adder: entity work.nacl_adder
    generic map (
      WIDTH => WIDTH
    )
    port map (
      a    => a,
      b    => b,
      cin  => '0',
      sum  => sum_int,
      cout => cout
    );

  sum0 <= sum_int(0);
  sum  <= sum_int;

end;
