
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_adder_dynamic is
  generic (
    WIDTH: integer := 8
  );
  port (
    a        :  in std_logic_vector(WIDTH-1 downto 0);
    b        :  in std_logic_vector(WIDTH-1 downto 0);
    sum      : out std_logic_vector(WIDTH-1 downto 0);
    cin      :  in std_logic;
    cout     : out std_logic;
    xor_en   :  in std_logic;
    or_en    :  in std_logic;
    adder_en :  in std_logic
  );
end nacl_adder_dynamic;

architecture behaviour of nacl_adder_dynamic is

  signal carry   : std_logic_vector(WIDTH   downto 0);

  component nacl_fulladder_dynamic
    port (
      a        :  in std_logic;
      b        :  in std_logic;
      cin      :  in std_logic;
      sum      : out std_logic;
      cout     : out std_logic;
      xor_en   :  in std_logic;
      or_en    :  in std_logic;
      adder_en :  in std_logic);
  end component;

begin

  carry(0) <= cin;
  cout <= carry(WIDTH);

  adders: for i in 0 to WIDTH-1 generate
    adder: nacl_fulladder_dynamic
       port map (
         a        => a(i),
         b        => b(i),
         cin      => carry(i),
         sum      => sum(i),
         cout     => carry(i+1),
         xor_en   => xor_en,
         or_en    => or_en,
         adder_en => adder_en);
  end generate;

end;
