
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

use work.nacl_constants.all;

entity nacl_address_limitation is
  generic (
    LIMIT         : integer;
    ADDRESS_WIDTH : integer
  );
  port (
    address_in  :  in std_logic_vector(ADDRESS_WIDTH-1 downto 0);
    address_out : out std_logic_vector(ADDRESS_WIDTH-1 downto 0)
  );
end nacl_address_limitation;

architecture behaviour of nacl_address_limitation is 

begin

  limitation : process(address_in) begin
    if LIMIT = 2 ** ADDRESS_WIDTH then
      address_out <= address_in;
    elsif address_in >= LIMIT then
      address_out <= (others => '0');
    else
      address_out <= address_in;
    end if;
  end process;

end;
