
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

use work.nacl_constants.all;

entity nacl_alu_register is
  port(
    clk           :  in std_logic;
    rst           :  in std_logic;
    en_registerA0 :  in std_logic;
    en_registerA1 :  in std_logic;
    en_registerB1 :  in std_logic;
    rst_registerA :  in std_logic;
    data_in       :  in std_logic_vector(WORD_SIZE-1 downto 0);
    data_A        : out std_logic_vector(WORD_SIZE-1 downto 0);
    data_B        : out std_logic_vector(WORD_SIZE-1 downto 0)
  );
end nacl_alu_register;

architecture behaviour of nacl_alu_register is

  signal rst_registerA0  : std_logic;
  signal registerA0_dout  : std_logic_vector(WORD_SIZE-1 downto 0);
  signal registerA0_dout0 : std_logic_vector(WORD_SIZE-1 downto 0);
  signal registerA1_dout0 : std_logic_vector(WORD_SIZE-1 downto 0);

begin

  registerA0 : entity work.nacl_register
    generic map(
      WIDTH => WORD_SIZE
    )
    port map(
      clk  => clk,
      rst  => rst,
      en   => en_registerA0,
      din  => data_in,
      dout => registerA0_dout0
    );

  registerA1 : entity work.nacl_register
    generic map(
      WIDTH => WORD_SIZE
    )
    port map(
      clk  => clk,
      rst  => rst,
      en   => en_registerA1,
      din  => registerA0_dout,
      dout => registerA1_dout0
    );

  registerB1 : entity work.nacl_register
    generic map(
      WIDTH => WORD_SIZE
    )
    port map(
      clk  => clk,
      rst  => rst,
      en   => en_registerB1,
      din  => data_in,
      dout => data_B
    );

  muxA0 : entity work.nacl_mux2
    generic map(
      WIDTH => WORD_SIZE
    )
    port map(
      in0  => registerA0_dout0,
      in1  => data_in,
      outp => registerA0_dout,
      sel  => en_registerA0
    );

  muxA1 : entity work.nacl_mux2
    generic map(
       WIDTH => WORD_SIZE
     )
    port map(
      in0  => registerA1_dout0,
      in1  => registerA0_dout,
      outp => data_A,
      sel  => en_registerA1
    );

  rst_registerA0 <= rst_registerA or rst;

end;