
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

use work.nacl_constants.all;

entity nacl_alu_rotation_logic is
  generic (
    WIDTH : integer
  );
  port(
    inp :  in std_logic_vector(WIDTH-1 downto 0);
    oup : out std_logic_vector(WIDTH-1 downto 0);
    sel :  in std_logic_vector(ROTATE_VARIANTS_LD-1 downto 0)
  );
end nacl_alu_rotation_logic;

architecture behaviour of nacl_alu_rotation_logic is

  type rotate_matrix_type is array(0 to ROTATE_VARIANTS) of std_logic_vector (WIDTH-1 downto 0);
  signal rotate_matrix : rotate_matrix_type;

  signal sel_limited : std_logic_vector(ROTATE_VARIANTS_LD-1 downto 0);

begin

  limiterIndex : entity work.nacl_address_limitation
    generic map(
      LIMIT         => ROTATE_VARIANTS+1,
      ADDRESS_WIDTH => ROTATE_VARIANTS_LD
    )
    port map(
      address_in  => sel,
      address_out => sel_limited
    );

  rotationMatrix : process(inp) begin
    for i in 0 to ROTATE_VARIANTS loop
      if ROTATE_DISTANCES(i) > 0 then
        rotate_matrix(i) <= inp(ROTATE_DISTANCES(i)-1 downto 0) & inp(WIDTH-1 downto ROTATE_DISTANCES(i));
      elsif ROTATE_DISTANCES(i) = 0 then
        rotate_matrix(i) <= inp;
      else
        rotate_matrix(i) <= inp(WIDTH+ROTATE_DISTANCES(i)-1 downto 0) & inp(WIDTH-1 downto WIDTH+ROTATE_DISTANCES(i));
      end if;
    end loop;
  end process;

  muxRotation : process(rotate_matrix, sel_limited) begin
    if ROTATE_VARIANTS = 0 then
      oup <= rotate_matrix(0);
    else
      oup <= rotate_matrix(conv_integer(sel_limited));
   end if;
  end process;

end;
