
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_carry_save_adder is
  generic(
    WIDTH: integer
  );
  port(
    a     :  in std_logic_vector(WIDTH-1 downto 0);
    b     :  in std_logic_vector(WIDTH-1 downto 0);
    c     :  in std_logic_vector(WIDTH-1 downto 0);
    sum   : out std_logic_vector(WIDTH-1 downto 0);
    carry : out std_logic_vector(WIDTH-1 downto 0);
    cin   :  in std_logic;
    cout  : out std_logic
  );
end nacl_carry_save_adder;

architecture behaviour of nacl_carry_save_adder is

  component nacl_fulladder
    port (
      a:     in std_logic;
      b:     in std_logic;
      cin:   in std_logic;
      sum:  out std_logic;
      cout: out std_logic);
  end component;

  signal carry_int : std_logic_vector(WIDTH-1 downto 0);

begin

  adders: for i in 0 to WIDTH-1 generate
    adder: nacl_fulladder
      port map(
        a    => a(i),
        b    => b(i),
        cin  => c(i),
        sum  => sum(i),
        cout => carry_int(i)
      );
  end generate;

  carry <= carry_int(WIDTH-2 downto 0) & cin;
  cout  <= carry_int(WIDTH-1);

end;
