
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

entity nacl_carry_save_adder_tree04 is
  generic( 
    WIDTH: integer
  );
  port( 
    inp  :  in std_logic_vector(WIDTH-1 downto 0);
    en   :  in std_logic_vector(3 downto 0);		
    sum  : out std_logic_vector(WIDTH+2 downto 0);
    cin  :  in std_logic;
    cout : out std_logic       
  );
end nacl_carry_save_adder_tree04;

architecture behaviour of nacl_carry_save_adder_tree04 is 
 
  signal en0          : std_logic_vector(WIDTH-1 downto 0);
  signal en1          : std_logic_vector(WIDTH-1 downto 0);
  signal en2          : std_logic_vector(WIDTH-1 downto 0);
  signal en3          : std_logic_vector(WIDTH-1 downto 0);
 
  signal adder0_a     : std_logic_vector(WIDTH+1 downto 0);
  signal adder0_b     : std_logic_vector(WIDTH+1 downto 0);
  signal adder0_c     : std_logic_vector(WIDTH+1 downto 0);
  signal adder0_sum   : std_logic_vector(WIDTH+1 downto 0);
  signal adder0_carry : std_logic_vector(WIDTH+1 downto 0);
  
  signal adder1_a     : std_logic_vector(WIDTH-1 downto 0);
  signal adder1_b     : std_logic_vector(WIDTH-1 downto 0);
  signal adder1_c     : std_logic_vector(WIDTH-1 downto 0);
  signal adder1_sum   : std_logic_vector(WIDTH-1 downto 0);
  signal adder1_carry : std_logic_vector(WIDTH-1 downto 0);
  
  signal adder2a_a     : std_logic_vector(2 downto 0);
  signal adder2a_b     : std_logic_vector(2 downto 0);
  signal adder2a_sum   : std_logic_vector(2 downto 0);
  signal adder2a_cout  : std_logic;
  
  signal adder2b_a     : std_logic_vector(WIDTH-1 downto 0);
  signal adder2b_b     : std_logic_vector(WIDTH-1 downto 0);
  signal adder2b_sum   : std_logic_vector(WIDTH-1 downto 0);
  signal adder2b_cin   : std_logic;
  signal adder2b_cout  : std_logic;
  
  
begin
  
  adder0 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH+2
  )
  port map( 
    a     => adder0_a,
    b     => adder0_b,
    c     => adder0_c,
    sum   => adder0_sum,
    carry => adder0_carry,
    cin   => '0',
    cout  => open
  );
  
  adder1 : entity work.nacl_carry_save_adder
  generic map( 
    WIDTH => WIDTH
  )
  port map( 
    a     => adder1_a,
    b     => adder1_b,
    c     => adder1_c,
    sum   => adder1_sum,
    carry => adder1_carry,
    cin   => '0',
    cout  => open
  );
  
  adder2a : entity work.nacl_adder
  generic map( 
    WIDTH => 3
  )
  port map( 
    a     => adder2a_a,
    b     => adder2a_b,
    sum   => adder2a_sum,
    cin   => cin,
    cout  => adder2a_cout
  );
  
  adder2b : entity work.nacl_adder
  generic map( 
    WIDTH => WIDTH
  )
  port map( 
    a     => adder2b_a,
    b     => adder2b_b,
    sum   => adder2b_sum,
    cin   => adder2b_cin,
    cout  => adder2b_cout
  );
  
  en0 <= (others => en(0));
  en1 <= (others => en(1));
  en2 <= (others => en(2));
  en3 <= (others => en(3));

  adder0_a    <= "00" & (inp and en0);
  adder0_b    <= '0'  & (inp and en1) & '0';
  adder0_c    <=        (inp and en2) & "00";

  adder1_a    <= '0' & adder0_sum(WIDTH+1 downto 3);
  adder1_b    <= '0' & adder0_carry(WIDTH+1 downto 3);
  adder1_c    <= inp and en3;
  
  adder2a_a   <= adder0_sum(2 downto 0);
  adder2a_b   <= adder0_carry(2 downto 0);
  
  adder2b_a   <= adder1_sum;
  adder2b_b   <= adder1_carry;
  adder2b_cin <= adder2a_cout;
  
  
  sum  <= adder2b_sum & adder2a_sum;
  cout <= adder2b_cout;
  
end;
